/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.io.File;
import java.util.List;
import java.util.TimerTask;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;

public abstract class DataModelerChangesTimerTask
extends TimerTask {
    protected DataModelerChangeList changeList;
    protected boolean containsConflicts = false;

    public DataModelerChangesTimerTask(DataModelerChangeList changeList) {
        this.changeList = changeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (SVNClientInteraction.getInstance().isClientInUse() || this.changeList == null || this.changeList.isBusy() || !this.changeList.getWindow().isVisible()) {
            return;
        }
        List<StorableObjectStatus> statuses = null;
        this.changeList.setBusy(true);
        try {
            statuses = this.findChanges(this.changeList.isVersionedOnly());
        }
        finally {
            this.changeList.setBusy(false);
        }
        this.updateUI(statuses);
        if (this.changeList.isAutoRefreshDependantChangeList() && this.changeList.getDependantChangeList() != null) {
            this.changeList.getDependantChangeList().refresh();
        }
        if (this.changeList.isAutoRefreshSecondDependantChangeList() && this.changeList.getSecondDependantChangeList() != null) {
            this.changeList.getSecondDependantChangeList().refresh();
        }
    }

    public void updateUI(List<StorableObjectStatus> statuses) {
        IChangeListPanel dependantChangeListPanel;
        DataModelerChangeList dependantChangeList = this.changeList.getDependantChangeList();
        if (dependantChangeList != null && this.markConflictedStatuses(statuses, (dependantChangeListPanel = dependantChangeList.getPanel()).getStatuses())) {
            dependantChangeListPanel.update();
        }
        this.changeList.updateUI(statuses);
    }

    protected boolean markConflictedStatuses(List<StorableObjectStatus> statuses, List<StorableObjectStatus> dependantStatuses) {
        this.containsConflicts = false;
        if (statuses != null && dependantStatuses != null && !statuses.isEmpty() && !dependantStatuses.isEmpty()) {
            for (StorableObjectStatus status : statuses) {
                StorableObjectStatus sameFileStatus = this.findStatusForFile(status.getFilePath(), dependantStatuses);
                if (sameFileStatus == null) continue;
                status.setTextStatus("C");
                sameFileStatus.setTextStatus("C");
                this.containsConflicts = true;
            }
        }
        return this.containsConflicts;
    }

    protected StorableObjectStatus findStatusForFile(File file, List<StorableObjectStatus> statuses) {
        for (StorableObjectStatus status : statuses) {
            if (!status.getFilePath().equals(file)) continue;
            return status;
        }
        return null;
    }

    protected List<StorableObjectStatus> findChanges(boolean versionedOnly) {
        String designFilePath;
        Design design = DataModelerChangeList.getSelectedDesign();
        if (design != null && !design.isNewDesign() && StringUtilities.isNotEmpty(designFilePath = design.getDesignPath())) {
            return this.getVCSClientHelper().getStatuses(design, this.checkRemoteStatus(), this.acceptAll(), versionedOnly);
        }
        return null;
    }

    protected abstract VCSClientHelper getVCSClientHelper();

    protected abstract boolean checkRemoteStatus();

    protected boolean acceptAll() {
        return false;
    }

    public boolean containsConflicts() {
        return this.containsConflicts;
    }
}

