/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.ViewId;
import oracle.ide.view.View;

public abstract class VCSHistoryWindow<L>
extends DockableWindow {
    public static final String WINDOW_ID = "VCSHistoryWindow";
    public static final ViewId VIEW_ID = new ViewId("EXTDockable", "VCSHistoryWindow");
    public static final String LOCAL_SAVED = Messages.getString("VCSHistoryWindow.LocalSaved");
    protected Map<L, List<StorableObjectStatus>> storableObjectStatusesMap;
    protected StorableObjectStatus storableObjectStatus;
    protected File[] filePaths;
    protected Design design;
    private JSplitPane gui = new JSplitPane(0);
    protected VCSHistoryTableModel historyTableModel;
    protected ChangedObjectsTableModel changedObjectsTableModel;
    protected JTable historyTable;
    protected JTable changedObjectsTable;
    protected Toolbar toolbar;
    protected JLabel designLabel = new JLabel();
    protected JLabel fileLabel = new JLabel();
    protected Long lastMergedRevision;
    protected Long lastCopiedRevision;

    public VCSHistoryWindow() {
        this.historyTableModel = new VCSHistoryTableModel();
        this.changedObjectsTableModel = new ChangedObjectsTableModel();
        this.historyTable = new JTable(this.historyTableModel);
        this.changedObjectsTable = new JTable(this.changedObjectsTableModel);
        JPanel topPanel = new JPanel(new BorderLayout());
        JSplitPane bottomPane = new JSplitPane(1);
        JScrollPane historyTableScrollPane = new JScrollPane(this.historyTable);
        JScrollPane changedFilesTableScrollPane = new JScrollPane(this.changedObjectsTable);
        final JTextArea commentTextArea = new JTextArea();
        JScrollPane commentTextAreaScrollPane = new JScrollPane(commentTextArea);
        this.historyTable.setSelectionMode(2);
        this.historyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] selectedRows = VCSHistoryWindow.this.historyTable.getSelectedRows();
                    int selectedRowsCount = selectedRows.length;
                    String comment = null;
                    VCSHistoryWindow.this.changedObjectsTableModel.clear();
                    for (int i = 0; i < selectedRowsCount; ++i) {
                        int selectedRow = selectedRows[i];
                        Object logMessage = null;
                        if (selectedRow > -1) {
                            logMessage = VCSHistoryWindow.this.historyTableModel.getRows().get(selectedRow);
                            if (selectedRowsCount == 1) {
                                comment = VCSHistoryWindow.this.getComment(logMessage);
                            }
                        }
                        VCSHistoryWindow.this.changedObjectsTableModel.addLogMessage(logMessage);
                    }
                    commentTextArea.setText(comment);
                    VCSHistoryWindow.this.changedObjectsTable.updateUI();
                }
                VCSHistoryWindow.this.design.getAppView().setChangedObjectsList(VCSHistoryWindow.this.changedObjectsTableModel.getChangedObjects());
            }
        });
        TableColumnModel historyTableColumnModel = this.historyTable.getColumnModel();
        TableColumn column = historyTableColumnModel.getColumn(0);
        column.setMinWidth(50);
        column.setPreferredWidth(70);
        column.setMaxWidth(70);
        column = historyTableColumnModel.getColumn(1);
        column.setMinWidth(70);
        column.setPreferredWidth(120);
        column.setMaxWidth(200);
        column = historyTableColumnModel.getColumn(2);
        column.setMinWidth(50);
        column.setPreferredWidth(100);
        column.setMaxWidth(200);
        TableColumnModel changedFilesTableColumnModel = this.changedObjectsTable.getColumnModel();
        column = changedFilesTableColumnModel.getColumn(0);
        column.setMinWidth(20);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column = changedFilesTableColumnModel.getColumn(3);
        column.setMinWidth(20);
        column.setPreferredWidth(60);
        column.setMaxWidth(100);
        column = changedFilesTableColumnModel.getColumn(1);
        column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                StorableObjectStatus storableObjectStatus = (StorableObjectStatus)value;
                this.setIcon(VCSClientHelper.getIcon(storableObjectStatus.getObjectClass()));
                this.setText(storableObjectStatus.getStorableObjectName());
                return this;
            }
        });
        commentTextArea.setRows(3);
        commentTextArea.setEditable(false);
        topPanel.add((Component)this.getToolbar(), "North");
        topPanel.add((Component)historyTableScrollPane, "Center");
        bottomPane.add(changedFilesTableScrollPane);
        bottomPane.add(commentTextAreaScrollPane);
        this.gui.add(topPanel);
        this.gui.add(bottomPane);
        bottomPane.setDividerLocation(0.5);
        this.gui.setDividerLocation(150);
        this.installPopupMenus();
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    protected void installPopupMenus() {
        this.installPopupMenu(this.historyTable, this.createCompareAction(), this.createCompareAsTextAction());
        this.installPopupMenu(this.changedObjectsTable, new AbstractAction[]{new ComparePreviousAction(Messages.getString("VCSHistoryWindow.Compare")), new ComparePreviousAsTextAction(Messages.getString("VCSHistoryWindow.CompareAsText")), new RestoreAction(), SVNViewPropertiesCommand.getAction()});
    }

    public abstract VCSClientHelper getVCSClientHelper();

    protected abstract List<L> getLogMessages(String var1, Long var2, Long var3, boolean var4, boolean var5);

    protected abstract List<L> getLogMessages(File[] var1, Long var2, Long var3, boolean var4, boolean var5);

    protected abstract Long getRevision(L var1);

    protected abstract InputStream getRevision(String var1, Long var2);

    protected abstract InputStream getRevision(File var1, Long var2);

    protected abstract Date getDate(L var1);

    protected abstract String getAuthor(L var1);

    protected abstract String getComment(L var1);

    protected void installPopupMenu(final JTable table, final AbstractAction ... popupMenuActions) {
        final JPopupMenu popupMenu = new JPopupMenu();
        for (AbstractAction action : popupMenuActions) {
            popupMenu.add(action);
        }
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.selectRow(e);
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.selectRow(e);
                    this.showPopupMenu(e);
                }
            }

            private void selectRow(MouseEvent e) {
                Point p = e.getPoint();
                int rowNumber = table.rowAtPoint(p);
                ListSelectionModel selectionModel = table.getSelectionModel();
                if (!selectionModel.isSelectedIndex(rowNumber)) {
                    selectionModel.setSelectionInterval(rowNumber, rowNumber);
                }
            }

            private void showPopupMenu(MouseEvent e) {
                for (AbstractAction action : popupMenuActions) {
                    if (action instanceof UpdateableAction) {
                        ((UpdateableAction)action).update();
                        continue;
                    }
                    if (!(action instanceof IdeAction)) continue;
                    ((IdeAction)action).updateAction();
                }
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private UpdateableAction createCompareAction() {
        return new CompareAction(Messages.getString("VCSHistoryWindow.Compare")){

            @Override
            protected void compare(InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle, File localFile) {
                String storableObjectID = VCSHistoryWindow.this.storableObjectStatus.getStorableObjectID();
                StorageDesign storageDesign = VCSHistoryWindow.this.getVCSClientHelper().findStorageDesign(VCSHistoryWindow.this.design, storableObjectID);
                XMLMetadataComparator comparator = new XMLMetadataComparator(VCSHistoryWindow.this.design, storageDesign, leftText, leftTextTitle, rightText, rightTextTitle, LOCAL_SAVED.equals(rightTextTitle));
                Map mergedMap = comparator.showModal();
                if (mergedMap != null) {
                    VCSHistoryWindow.this.getVCSClientHelper().merge(VCSHistoryWindow.this.storableObjectStatus, localFile, mergedMap);
                }
            }
        };
    }

    private UpdateableAction createCompareAsTextAction() {
        return new CompareAction(Messages.getString("VCSHistoryWindow.CompareAsText")){

            @Override
            protected void compare(InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle, File localFile) {
                VCSTextCompareFrame textCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), localFile, leftText, leftTextTitle, rightText, rightTextTitle, true, !LOCAL_SAVED.equals(rightTextTitle), VCSHistoryWindow.this.storableObjectStatus);
                textCompareFrame.showModal();
            }
        };
    }

    public void setStorableObjectStatus(StorableObjectStatus storableObjectStatus) {
        this.storableObjectStatus = storableObjectStatus;
        if (storableObjectStatus != null) {
            this.filePaths = new File[]{storableObjectStatus.getFilePath()};
            this.fileLabel.setText(storableObjectStatus.getStorableObjectName());
            this.init(new File[]{storableObjectStatus.getFilePath()}, storableObjectStatus.getDesign());
        }
        this.refresh();
    }

    public void setFilePaths(File[] filePaths) {
        this.fileLabel.setText(filePaths[0].getPath());
        this.init(filePaths, ApplicationView.getInstance().getCurrentDesign());
        this.refresh();
    }

    protected void init(File[] filePaths, Design design) {
        this.filePaths = filePaths;
        this.design = design;
        this.updateDesignLabel(design);
    }

    protected void updateDesignLabel(Design design) {
        this.designLabel.setText(design.getName() + " (" + design.getDesignPath() + ")");
    }

    public void clear() {
        this.storableObjectStatus = null;
        this.filePaths = null;
        this.designLabel.setText(null);
        this.fileLabel.setText(null);
        this.historyTableModel.clear();
        this.historyTable.updateUI();
        this.changedObjectsTableModel.clear();
        this.changedObjectsTable.updateUI();
    }

    public void clearForDesign(Design design) {
        if (this.storableObjectStatus != null) {
            if (this.storableObjectStatus.getStorableObject().getDesign().equals(design)) {
                this.clear();
            }
        } else if (design.equals(this.design)) {
            this.clear();
        }
    }

    protected void refresh() {
        List rows = this.historyTableModel.getRows();
        List<L> logMessages = null;
        this.historyTable.clearSelection();
        rows.clear();
        logMessages = this.getLogMessages();
        if (logMessages != null && !logMessages.isEmpty()) {
            this.storableObjectStatusesMap = this.parseChangedObjects(logMessages);
            rows.addAll(logMessages);
        }
        this.lastMergedRevision = this.findLastMergedRevision();
        this.lastCopiedRevision = this.findLastCopiedRevision();
        this.historyTable.updateUI();
        this.changedObjectsTable.updateUI();
    }

    protected Long findLastMergedRevision() {
        return null;
    }

    protected Long findLastCopiedRevision() {
        return null;
    }

    protected List<L> getLogMessages() {
        if (this.filePaths != null && this.filePaths.length > 0) {
            return this.getLogMessages(this.filePaths, null, null, true, this.storableObjectStatus != null);
        }
        return null;
    }

    public String getTitleName() {
        return Messages.getString("VCSHistoryWindow.Title");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Component getGUI() {
        return this.gui;
    }

    public Toolbar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
            this.toolbar.add((ToggleAction)this.createRefreshAction());
            this.toolbar.addSeparator();
            this.addToolbarActions();
            this.toolbar.add((Component)this.designLabel);
            this.toolbar.addSeparator();
            this.toolbar.add((Component)this.fileLabel);
        }
        return this.toolbar;
    }

    protected void addToolbarActions() {
    }

    protected IdeAction createRefreshAction() {
        IdeAction refreshAction = IdeAction.find((int)51);
        if (refreshAction != null) {
            IdeAction localRefreshAction = refreshAction.newLocalAction((View)this);
            localRefreshAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    VCSHistoryWindow.this.refresh();
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    return true;
                }
            });
            localRefreshAction.setEnabled(true);
            return localRefreshAction;
        }
        return null;
    }

    protected abstract Map<L, List<StorableObjectStatus>> parseChangedObjects(List<L> var1);

    public StorableObjectStatus getSelectedStorableObjectStatus() {
        int selectedRow = this.changedObjectsTable.getSelectedRow();
        return selectedRow > -1 ? (StorableObjectStatus)this.changedObjectsTableModel.getValueAt(selectedRow, 1) : null;
    }

    public List<StorableObjectStatus> getSelectedStorableObjectsStatuses() {
        int[] selectedRows;
        ArrayList<StorableObjectStatus> result = new ArrayList<StorableObjectStatus>(this.changedObjectsTable.getSelectedRowCount());
        for (int selectedRow : selectedRows = this.changedObjectsTable.getSelectedRows()) {
            result.add((StorableObjectStatus)this.changedObjectsTableModel.getValueAt(selectedRow, 1));
        }
        return result;
    }

    protected class RestoreAction
    extends CopyAction {
        protected RestoreAction() {
            super(Messages.getString("VCSHistoryWindow.Restore"));
        }

        protected RestoreAction(String name) {
            super(name);
        }

        @Override
        public void update() {
            int[] selectedRows;
            for (int selectedRow : selectedRows = VCSHistoryWindow.this.changedObjectsTable.getSelectedRows()) {
                if ("D".equals(VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(selectedRow, 0))) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public Long getRevisionToCopy(StorableObjectStatus selectedStorableObject) {
            return selectedStorableObject.getRevision() - 1L;
        }

        @Override
        protected void refresh(List<VersioningTreeNode> versioningTreeNodes) {
            VersioningTreeNode.refresh(versioningTreeNodes, true, true);
        }
    }

    protected class CopyAction
    extends UpdateableAction {
        public CopyAction() {
            super(Messages.getString("VCSHistoryWindow.Copy"));
        }

        protected CopyAction(String name) {
            super(name);
        }

        @Override
        public void update() {
            int[] selectedRows;
            for (int selectedRow : selectedRows = VCSHistoryWindow.this.changedObjectsTable.getSelectedRows()) {
                if (!"D".equals(VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(selectedRow, 0))) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performAction(VCSHistoryWindow.this.getSelectedStorableObjectsStatuses());
        }

        public void performAction(List<StorableObjectStatus> storableObjectStatuses) {
            ArrayList<VersioningTreeNode> versioningTreeNodes = new ArrayList<VersioningTreeNode>();
            for (StorableObjectStatus storableObjectStatus : storableObjectStatuses) {
                VCSHistoryWindow.this.getVCSClientHelper().doCopy(storableObjectStatus.getURL(), storableObjectStatus.getFilePath(), this.getRevisionToCopy(storableObjectStatus));
                versioningTreeNodes.add(new VersioningTreeNode(storableObjectStatus));
            }
            this.refresh(versioningTreeNodes);
        }

        protected Long getRevisionToCopy(StorableObjectStatus selectedStorableObject) {
            return selectedStorableObject.getRevision();
        }

        protected void refresh(List<VersioningTreeNode> versioningTreeNodes) {
            VersioningTreeNode.refresh(versioningTreeNodes, false, true);
        }
    }

    protected class ComparePreviousAsTextAction
    extends AbstractComparePreviousAction {
        public ComparePreviousAsTextAction(String name) {
            super(name);
        }

        @Override
        protected void compare(InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle) {
            new VCSTextCompareFrame((Window)Ide.getMainWindow(), null, leftText, leftTextTitle, rightText, rightTextTitle, true, true, null).showModal();
        }
    }

    protected class ComparePreviousAction
    extends AbstractComparePreviousAction {
        public ComparePreviousAction(String name) {
            super(name);
        }

        @Override
        protected void compare(InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle) {
            StorageDesign storageDesign = null;
            if (VCSHistoryWindow.this.storableObjectStatus != null) {
                storageDesign = VCSHistoryWindow.this.getVCSClientHelper().findStorageDesign(VCSHistoryWindow.this.design, VCSHistoryWindow.this.storableObjectStatus.getStorableObjectID());
            }
            new XMLMetadataComparator(VCSHistoryWindow.this.design, storageDesign, leftText, leftTextTitle, rightText, rightTextTitle, false).showModal();
        }
    }

    protected abstract class AbstractComparePreviousAction
    extends UpdateableAction {
        protected String url;
        protected Long leftFileRevision;
        protected Long rightFileRevision;

        protected AbstractComparePreviousAction(String name) {
            super(name);
        }

        @Override
        public void update() {
            this.setEnabled(VCSHistoryWindow.this.changedObjectsTable.getSelectedRowCount() == 1 && "M".equals(VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(VCSHistoryWindow.this.changedObjectsTable.getSelectedRow(), 0)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.init();
            InputStream leftText = this.getLeftText();
            InputStream rightText = this.getRightText();
            this.compare(leftText, String.valueOf(this.leftFileRevision), rightText, this.rightFileRevision == null ? Messages.getString("SVNAbstractCompareCommand.LastLocalRevision") : String.valueOf(this.rightFileRevision));
        }

        protected void init() {
            StorableObjectStatus storableObjectStatus = (StorableObjectStatus)VCSHistoryWindow.this.changedObjectsTableModel.getValueAt(VCSHistoryWindow.this.changedObjectsTable.getSelectedRow(), 1);
            this.url = storableObjectStatus.getURL();
        }

        protected InputStream getLeftText() {
            Object leftFileLogMessage = VCSHistoryWindow.this.changedObjectsTableModel.getLogMessage();
            this.leftFileRevision = VCSHistoryWindow.this.getRevision(leftFileLogMessage);
            return VCSHistoryWindow.this.getRevision(this.url, this.leftFileRevision);
        }

        protected InputStream getRightText() {
            List rightFileLogMessages = VCSHistoryWindow.this.getLogMessages(this.url, null, (Long)(this.leftFileRevision - 1L), false, false);
            Object rightFileLogMessage = rightFileLogMessages.get(0);
            this.rightFileRevision = VCSHistoryWindow.this.getRevision(rightFileLogMessage);
            return VCSHistoryWindow.this.getRevision(this.url, this.rightFileRevision);
        }

        protected abstract void compare(InputStream var1, String var2, InputStream var3, String var4);
    }

    private abstract class CompareAction
    extends UpdateableAction {
        private CompareAction(String name) {
            super(name);
        }

        @Override
        public void update() {
            this.setEnabled(VCSHistoryWindow.this.historyTable.getSelectedRowCount() == 2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Long rightFileRevision;
            Long leftFileRevision;
            File localFile = VCSHistoryWindow.this.storableObjectStatus.getFilePath();
            List logMessages = VCSHistoryWindow.this.historyTableModel.getRows();
            Long firstFileRevision = VCSHistoryWindow.this.getRevision(logMessages.get(VCSHistoryWindow.this.historyTable.getSelectedRows()[0]));
            Long secondFileRevision = VCSHistoryWindow.this.getRevision(logMessages.get(VCSHistoryWindow.this.historyTable.getSelectedRows()[1]));
            if (firstFileRevision == null) {
                leftFileRevision = secondFileRevision;
                rightFileRevision = firstFileRevision;
            } else {
                leftFileRevision = firstFileRevision;
                rightFileRevision = secondFileRevision;
            }
            this.compare(VCSHistoryWindow.this.getRevision(localFile, leftFileRevision), leftFileRevision == null ? LOCAL_SAVED : String.valueOf(leftFileRevision), VCSHistoryWindow.this.getRevision(localFile, rightFileRevision), rightFileRevision == null ? LOCAL_SAVED : String.valueOf(rightFileRevision), localFile);
        }

        protected abstract void compare(InputStream var1, String var2, InputStream var3, String var4, File var5);
    }

    protected static abstract class UpdateableAction
    extends AbstractAction {
        protected UpdateableAction(String name) {
            super(name);
        }

        public abstract void update();
    }

    protected class ChangedObjectsTableModel
    extends VCSDefaultTableModel {
        private List<StorableObjectStatus> changedObjects;
        protected List<L> logMessages;

        protected ChangedObjectsTableModel() {
            this.changedObjects = new ArrayList<StorableObjectStatus>();
            this.logMessages = new ArrayList();
        }

        public L getLogMessage() {
            return this.logMessages.get(0);
        }

        public List<StorableObjectStatus> getChangedObjects() {
            return this.changedObjects;
        }

        public void addLogMessage(L logMessage) {
            this.logMessages.add(logMessage);
            for (StorableObjectStatus storableObjectStatus : VCSHistoryWindow.this.storableObjectStatusesMap.get(logMessage)) {
                if (this.changedObjects.contains(storableObjectStatus)) continue;
                this.changedObjects.add(storableObjectStatus);
            }
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("VCSHistoryWindow.Action");
            }
            if (column == 1) {
                return Messages.getString("VCSHistoryWindow.ChangedObjects");
            }
            if (column == 2) {
                return Messages.getString("VCSHistoryWindow.Location");
            }
            if (column == 3) {
                return Messages.getString("VCSHistoryWindow.CopyRevision");
            }
            if (column == 4) {
                return Messages.getString("VCSHistoryWindow.CopyPath");
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.changedObjects == null ? 0 : this.changedObjects.size();
        }

        @Override
        public void clear() {
            this.logMessages.clear();
            this.changedObjects.clear();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.logMessages.size() == 1 ? this.changedObjects.get(row).getTextStatus() : null;
            }
            if (column == 1) {
                return this.changedObjects.get(row);
            }
            if (column == 2) {
                return this.changedObjects.get(row).getPathString();
            }
            if (column == 3) {
                return this.changedObjects.get(row).getCopyRevision();
            }
            if (column == 4) {
                return this.changedObjects.get(row).getCopyPath();
            }
            return null;
        }
    }

    protected class VCSHistoryTableModel
    extends VCSDefaultTableModel {
        protected VCSHistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.rows == null ? 0 : this.rows.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("VCSHistoryWindow.Revision");
            }
            if (column == 1) {
                return Messages.getString("VCSHistoryWindow.Date");
            }
            if (column == 2) {
                return Messages.getString("VCSHistoryWindow.Author");
            }
            if (column == 3) {
                return Messages.getString("VCSHistoryWindow.Comment");
            }
            return super.getColumnName(column);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                Long revision = VCSHistoryWindow.this.getRevision(this.rows.get(row));
                return revision == null ? LOCAL_SAVED : revision;
            }
            if (column == 1) {
                return VCSHistoryWindow.this.getDate(this.rows.get(row));
            }
            if (column == 2) {
                return VCSHistoryWindow.this.getAuthor(this.rows.get(row));
            }
            if (column == 3) {
                return VCSHistoryWindow.this.getComment(this.rows.get(row));
            }
            return null;
        }

        @Override
        public void clear() {
            this.rows.clear();
        }
    }

    protected abstract class VCSDefaultTableModel
    extends DefaultTableModel {
        protected List rows = new ArrayList();

        protected VCSDefaultTableModel() {
        }

        public abstract void clear();

        public List getRows() {
            return this.rows;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

