/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.dbtools.crest.fcp.vcs.TextCompareEditor;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class VCSTextComparePanel
extends JPanel {
    private static final Logger LOGGER = new Logger(VCSTextComparePanel.class);
    private boolean isOk = false;
    private TextCompareEditor editor;
    private File localFile;

    public VCSTextComparePanel(File localFile, InputStream leftText, String leftTextTitle, InputStream rightText, String rightTextTitle, boolean leftTextReadOnly, boolean rightTextReadOnly) throws HeadlessException {
        this.localFile = localFile;
        this.editor = new TextCompareEditor(leftText, rightText, leftTextTitle, rightTextTitle, leftTextReadOnly, rightTextReadOnly);
        Component gui = this.editor.getGUI();
        JPanel buttonRow = new JPanel(new FlowLayout(2, 12, 12));
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setMnemonic(79);
        okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSTextComparePanel.this.isOk = true;
                VCSTextComparePanel.this.save();
                VCSTextComparePanel.this.closeParent();
            }
        });
        buttonRow.add(okButton);
        cancelButton.setMnemonic(67);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSTextComparePanel.this.isOk = false;
                VCSTextComparePanel.this.closeParent();
            }
        });
        buttonRow.add(cancelButton);
        this.setLayout(new BorderLayout());
        this.add(gui, "Center");
        this.add((Component)buttonRow, "South");
    }

    public abstract void closeParent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        if (this.localFile != null) {
            try {
                FileWriter writer = new FileWriter(this.localFile);
                try {
                    writer.write(this.editor.getRightText());
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(e);
            }
        }
    }

    public TextCompareEditor getEditor() {
        return this.editor;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

