/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class SVNObjectHelper {
    public String propID;
    public String propName;
    public String parentID = null;
    public String fileName = null;
    public String className;

    public static SVNObjectHelper getSVNObjectHelperFor(Design design, String objectID) {
        if (objectID != null && objectID.length() > 0) {
            if (objectID.equalsIgnoreCase(design.getProcessModel().getObjectID())) {
                ProcessModel pm = design.getProcessModel();
                SVNObjectHelper svnOH = new SVNObjectHelper();
                svnOH.propID = pm.getObjectID();
                svnOH.propName = pm.getName();
                svnOH.className = pm.getClass().getName();
                svnOH.parentID = null;
                svnOH.fileName = pm.getStorageName();
                return svnOH;
            }
            DataFlowDesign dfd = (DataFlowDesign)design.getProcessModel().getDataFlowDesigns().getById(objectID);
            if (dfd != null) {
                SVNObjectHelper svnOH = new SVNObjectHelper();
                svnOH.propID = dfd.getObjectID();
                svnOH.propName = dfd.getName();
                svnOH.className = dfd.getClass().getName();
                svnOH.parentID = dfd.getProcess() != null ? dfd.getProcess().getObjectID() : design.getProcessModel().getObjectID();
                svnOH.fileName = dfd.getStorageName();
                return svnOH;
            }
            DesignObject desObj = design.getDesignObject(objectID);
            if (desObj != null) {
                SVNObjectHelper svnOH = new SVNObjectHelper();
                svnOH.propID = desObj.getObjectID();
                svnOH.propName = desObj.getName();
                svnOH.className = desObj.getClass().getName();
                svnOH.parentID = desObj.getDesignPartId();
                svnOH.fileName = desObj.getSegmentedStorageName();
                return svnOH;
            }
            return SVNClientHelper.svnOHMap.get(objectID);
        }
        return null;
    }
}

