/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.io.File;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNStorableObjectStatus
extends StorableObjectStatus {
    private ISVNStatus svnStatus;
    private Long revision;

    public SVNStorableObjectStatus(StorableObject storableObject) {
        super(storableObject);
    }

    public SVNStorableObjectStatus(Design design, File file, String textStatus, String propertyStatus, Long revision) {
        this.design = design;
        this.filePath = file;
        this.textStatus = textStatus;
        this.propertyStatus = propertyStatus;
        this.revision = revision;
        this.parse(file, null);
    }

    public SVNStorableObjectStatus(Design design, ISVNStatus svnStatus, boolean remoteStatus, boolean deletedDir) {
        this.design = design;
        this.svnStatus = svnStatus;
        this.remoteStatus = remoteStatus;
        this.filePath = svnStatus.getFile();
        this.extractStatuses(svnStatus, remoteStatus, deletedDir);
        this.parse(this.filePath, (SVNUrl)(!remoteStatus && "A".equals(this.textStatus) ? null : svnStatus.getUrl()));
    }

    protected void extractStatuses(ISVNStatus svnStatus, boolean remoteStatus, boolean deletedDir) {
        SVNStatusKind propStatusKind;
        SVNStatusKind textStatusKind;
        if (remoteStatus) {
            textStatusKind = svnStatus.getRepositoryTextStatus();
            propStatusKind = svnStatus.getRepositoryPropStatus();
            if (deletedDir && svnStatus.getRevision() != null) {
                this.textStatus = "D";
                return;
            }
        } else {
            textStatusKind = svnStatus.getTextStatus();
            propStatusKind = svnStatus.getPropStatus();
        }
        this.textStatus = this.extractStatus(textStatusKind, svnStatus.getRevision(), remoteStatus);
        this.propertyStatus = this.extractStatus(propStatusKind, svnStatus.getRevision(), remoteStatus);
    }

    protected String extractStatus(SVNStatusKind statusKind) {
        if (statusKind == SVNStatusKind.UNVERSIONED) {
            return "?";
        }
        if (statusKind == SVNStatusKind.MISSING) {
            return "MI";
        }
        if (statusKind == SVNStatusKind.ADDED) {
            return "A";
        }
        if (statusKind == SVNStatusKind.MODIFIED) {
            return "M";
        }
        if (statusKind == SVNStatusKind.DELETED) {
            return "D";
        }
        if (statusKind == SVNStatusKind.CONFLICTED) {
            return "C";
        }
        if (statusKind == SVNStatusKind.NORMAL) {
            return "";
        }
        return "?";
    }

    protected String extractStatus(SVNStatusKind statusKind, SVNRevision.Number revNumber, boolean remote) {
        if (remote) {
            if (statusKind == SVNStatusKind.NONE && revNumber != null && revNumber.getNumber() > 0L) {
                return "D";
            }
            String s = this.extractStatus(statusKind);
            if (s.compareTo("") == 0) {
                s = "D";
            }
            return s;
        }
        if (statusKind == SVNStatusKind.MODIFIED && revNumber == null) {
            return "A";
        }
        String s = this.extractStatus(statusKind);
        if (s.compareTo("") == 0) {
            s = "D";
        }
        return s;
    }

    @Override
    public Long getRevision() {
        if (this.revision != null) {
            return this.revision;
        }
        SVNRevision.Number svnStatusRevision = this.svnStatus.getRevision();
        return svnStatusRevision != null ? Long.valueOf(svnStatusRevision.getNumber()) : null;
    }

    public ISVNStatus getSVNStatus() {
        return this.svnStatus;
    }
}

