/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChangeListTablePanel;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangesTimerTask;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.UpdateableAction;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNOutgoingChangesChangeList;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;

public class SVNUnversionedFilesChangeList
extends SVNOutgoingChangesChangeList {
    private DeleteAction deleteAction;
    private AddToVersionControlAction addToVersionControlAction;

    public SVNUnversionedFilesChangeList() {
        super(Messages.getString("SVNUnversionedFilesChangeList.UnversionedFiles"));
    }

    @Override
    protected TimerTask createStatusTask(VCSThreadPool threadPool) {
        this.timerTask = new DataModelerChangesTimerTask(this){

            @Override
            protected VCSClientHelper getVCSClientHelper() {
                return SVNClientHelper.getInstance();
            }

            @Override
            protected boolean checkRemoteStatus() {
                return false;
            }

            @Override
            protected boolean acceptAll() {
                return true;
            }
        };
        return this.timerTask;
    }

    private DeleteAction getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    private AddToVersionControlAction getAddToVersionControlAction() {
        if (this.addToVersionControlAction == null) {
            this.addToVersionControlAction = new AddToVersionControlAction();
        }
        return this.addToVersionControlAction;
    }

    @Override
    protected IChangeListPanel createChangeListPanel() {
        this.panel = new ChangeListTablePanel();
        return this.panel;
    }

    @Override
    protected void addActions() {
        this.popupMenu.add(new JMenuItem(this.getDeleteAction()));
        this.popupMenu.add(new JMenuItem(this.getAddToVersionControlAction()));
    }

    @Override
    protected IdeAction addCompareActions() {
        return null;
    }

    @Override
    protected void addAdditionalActions() {
    }

    @Override
    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        this.addScopeComboBox(toolbar);
        Action[] toolbarActions = toolbar.getActions();
        if (toolbarActions.length > 0) {
            for (int i = 0; i < toolbarActions.length; ++i) {
                IdeAction action = (IdeAction)toolbarActions[i];
                action.setEnabled(true);
            }
        }
        toolbar.add((Action)this.getDeleteAction());
        toolbar.add((Action)this.getAddToVersionControlAction());
    }

    private class AddToVersionControlAction
    extends UpdateableAction {
        private AddToVersionControlAction() {
            super(Messages.getString("SVNUnversionedFilesChangeList.AddToVersionControl"));
            this.putValue("SmallIcon", GUIConfiguration.getInstance().getIcon("ADD_ICON"));
            this.putValue("ShortDescription", Messages.getString("SVNUnversionedFilesChangeList.AddSelectedItemToVersionControl"));
            this.update();
        }

        @Override
        public void update() {
            this.setEnabled(SVNUnversionedFilesChangeList.this.panel.hasSelection());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<File> selectedFilePaths = SVNUnversionedFilesChangeList.this.panel.getSelectedFilePaths(null, true, true);
            for (File selectedFilePath : selectedFilePaths) {
                this.AddToVersionControl(selectedFilePath);
            }
            SVNUnversionedFilesChangeList.this.refresh();
        }

        private void AddToVersionControl(File filePath) {
            SVNClientHelper.getInstance().doAdd(filePath, true);
            if (filePath.isDirectory() && filePath.list().length == 0) {
                SVNClientHelper.getInstance().doCommit(new File[]{filePath}, Messages.getString("SVNUnversionedFilesChangeList.ManuallyAddedToVersionControl"), true, true);
            }
        }
    }

    private class DeleteAction
    extends UpdateableAction {
        private DeleteAction() {
            super(Messages.getString("SVNUnversionedFilesChangeList.Delete"));
            this.putValue("SmallIcon", GUIConfiguration.getInstance().getIcon("DELETE_ICON"));
            this.putValue("ShortDescription", Messages.getString("SVNUnversionedFilesChangeList.DeleteSelectedItem"));
            this.update();
        }

        @Override
        public void update() {
            this.setEnabled(SVNUnversionedFilesChangeList.this.panel.hasSelection());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<File> selectedFilePaths = SVNUnversionedFilesChangeList.this.panel.getSelectedFilePaths(null, true, true);
            for (File selectedFilePath : selectedFilePaths) {
                this.delete(selectedFilePath);
            }
            SVNUnversionedFilesChangeList.this.refresh();
        }

        private void delete(File filePath) {
            if (filePath.isDirectory()) {
                File[] files;
                for (File file : files = filePath.listFiles()) {
                    if (file.isDirectory()) {
                        this.delete(file);
                        continue;
                    }
                    file.delete();
                }
            }
            filePath.delete();
        }
    }
}

