/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.RestoreDeletedFilesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNAddCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNAddPropertyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCleanupCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCommitCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNCommitDesignCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNDesignHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNImportCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNLockCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeDesignCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNResolveConflictsCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNRevertAllCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNRevertCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNRevertWorkingCopyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNStatusCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNSystemTypesHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUnlockCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateAllCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateDesignCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionHistoryCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNVersionTreeCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNViewPropertiesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareLastLocalCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareLatestCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLastLocalCommand;
import oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLatestCommand;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.jdeveloper.vcs.spi.VCSController;
import oracle.jdevimpl.vcs.generic.changelist.ViewPendingChangesAction;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;

public class DMSVNOSGiController
extends VCSController {
    private static DMSVNOSGiController instance;
    private Map<String, Command> commandsMap;
    private Map commandsIDMap = new HashMap();
    private Command command = null;
    private static final int SVN_RESTORE_DELETED_FILES;
    private static final int SVN_REVERT_ALL;
    private static final int SVN_COMMIT;
    private static final int SVN_COMMIT_TEAM_MENU;
    private static final int SVN_REVERT;
    private static final int SVN_REVERT_TEAM_MENU;
    private static final int SVN_STORABLE_OBJECT_PROPERTIES;
    private static final int SVN_VIEW_SUBVERSION_PROPERTIES;
    private static final int SVN_VIEW_SUBVERSION_PROPERTIES_TEAM_MENU;
    private static final int SVN_VERSION_HISTORY;
    private static final int SVN_VERSION_HISTORY_TEAM_MENU;
    private static final int SVN_ADD_SUBVERSION_PROPERTY;
    private static final int SVN_ADD_SUBVERSION_PROPERTY_TEAM_MENU;
    private static final int SVN_COMPARE_LAST_LOCAL;
    private static final int SVN_TEXT_COMPARE_LAST_LOCAL;
    private static final int SVN_COMPARE_LATEST;
    private static final int SVN_TEXT_COMPARE_LATEST;
    private static final int SVN_UPDATE;
    private static final int SVN_UPDATE_ALL;
    private static final int SVN_UPDATE_ALL_TOOLBAR_MENU;
    private static final int SVN_UPDATE_WORKING_COPY_TOOLBAR_MENU;
    private static final int SVN_COMPARE_CURRENT;
    private static final int SVN_TEXT_COMPARE_CURRENT;
    private static final int SVN_LOCK_C;
    private static final int SVN_LOCK;
    private static final int SVN_UNLOCK_C;
    private static final int SVN_UNLOCK;
    private static final int SVN_VERSION_TREE;
    private static final int SVN_VERSION_TREE_TEAM_MENU;
    private static final int SVN_COMMIT_DESIGN;
    private static final int SVN_UPDATE_DESIGN;
    private static final int SVN_CLEANUP;
    private static final int SVN_PENDING_CHANGES;
    private static final int SVN_STATUS_COMMAND;
    private static final int SVN_RESOLVE_CONFLICTS;
    private static final int SVN_MERGE_DESIGN;
    private static final int SVN_IMPORT;
    private static final int SVN_SYSTEM_TYPES_HISTORY;
    private static final int SVN_DESIGN_HISTORY;
    private static final int SVN_REVERT_WORKING_COPY;
    private static final int SVN_OPERATION_UPDATE;
    private static final int SVN_OPERATION_ADD;

    private DMSVNOSGiController() {
        super(AbstractSVNOperation.class.getPackage());
        this.commandsMap = new HashMap<String, Command>();
    }

    public static DMSVNOSGiController getInstance() {
        if (instance == null) {
            instance = new DMSVNOSGiController();
        }
        return instance;
    }

    public void register(IdeAction action, Command command) {
        this.commandsMap.put(action.getCommand(), command);
        this.commandsIDMap.put(action.getCommandId(), command);
        action.addController((Controller)this);
    }

    protected boolean isHandledAction(IdeAction action) {
        int commandId = action.getCommandId();
        if (commandId == SVN_RESTORE_DELETED_FILES || commandId == SVN_REVERT_ALL || commandId == SVN_COMMIT || commandId == SVN_COMMIT_TEAM_MENU || commandId == SVN_REVERT || commandId == SVN_REVERT_TEAM_MENU || commandId == SVN_STORABLE_OBJECT_PROPERTIES || commandId == SVN_VIEW_SUBVERSION_PROPERTIES || commandId == SVN_VIEW_SUBVERSION_PROPERTIES_TEAM_MENU || commandId == SVN_VERSION_HISTORY || commandId == SVN_VERSION_HISTORY_TEAM_MENU || commandId == SVN_ADD_SUBVERSION_PROPERTY || commandId == SVN_ADD_SUBVERSION_PROPERTY_TEAM_MENU || commandId == SVN_COMPARE_LAST_LOCAL || commandId == SVN_TEXT_COMPARE_LAST_LOCAL || commandId == SVN_COMPARE_LATEST || commandId == SVN_TEXT_COMPARE_LATEST || commandId == SVN_UPDATE || commandId == SVN_UPDATE_ALL || commandId == SVN_UPDATE_ALL_TOOLBAR_MENU || commandId == SVN_UPDATE_WORKING_COPY_TOOLBAR_MENU || commandId == SVN_COMPARE_CURRENT || commandId == SVN_TEXT_COMPARE_CURRENT || commandId == SVN_LOCK || commandId == SVN_LOCK_C || commandId == SVN_UNLOCK || commandId == SVN_UNLOCK_C || commandId == SVN_VERSION_TREE || commandId == SVN_VERSION_TREE_TEAM_MENU || commandId == SVN_COMMIT_DESIGN || commandId == SVN_UPDATE_DESIGN || commandId == SVN_CLEANUP || commandId == SVN_PENDING_CHANGES || commandId == SVN_RESOLVE_CONFLICTS || commandId == SVN_MERGE_DESIGN || commandId == SVN_IMPORT || commandId == SVN_SYSTEM_TYPES_HISTORY || commandId == SVN_DESIGN_HISTORY || commandId == SVN_REVERT_WORKING_COPY || commandId == SVN_OPERATION_ADD) {
            return true;
        }
        return this.commandsIDMap.get(commandId) != null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        WaitCursor waitCursor = Ide.getWaitCursor();
        if (commandId == SVN_REVERT_ALL) {
            this.command = new SVNRevertAllCommand();
        } else if (commandId == SVN_COMMIT || commandId == SVN_COMMIT_TEAM_MENU) {
            this.command = new SVNCommitCommand();
        } else if (commandId == SVN_REVERT || commandId == SVN_REVERT_TEAM_MENU) {
            this.command = new SVNRevertCommand();
        } else if (commandId == SVN_STORABLE_OBJECT_PROPERTIES) {
            this.command = new StorableObjectPropertiesCommand();
        } else if (commandId == SVN_VIEW_SUBVERSION_PROPERTIES || commandId == SVN_VIEW_SUBVERSION_PROPERTIES_TEAM_MENU) {
            this.command = new SVNViewPropertiesCommand();
        } else if (commandId == SVN_VERSION_HISTORY || commandId == SVN_VERSION_HISTORY_TEAM_MENU) {
            this.command = new SVNVersionHistoryCommand();
        } else if (commandId == SVN_ADD_SUBVERSION_PROPERTY || commandId == SVN_ADD_SUBVERSION_PROPERTY_TEAM_MENU) {
            this.command = new SVNAddPropertyCommand();
        } else if (commandId == SVN_COMPARE_LAST_LOCAL) {
            this.command = new SVNCompareLastLocalCommand();
        } else if (commandId == SVN_TEXT_COMPARE_LAST_LOCAL) {
            this.command = new SVNTextCompareLastLocalCommand();
        } else if (commandId == SVN_COMPARE_LATEST) {
            this.command = new SVNCompareLatestCommand();
        } else if (commandId == SVN_TEXT_COMPARE_LATEST) {
            this.command = new SVNTextCompareLatestCommand();
        } else if (commandId == SVN_UPDATE) {
            this.command = new SVNUpdateCommand();
        } else if (commandId == SVN_UPDATE_ALL || commandId == SVN_UPDATE_ALL_TOOLBAR_MENU) {
            this.command = new SVNUpdateAllCommand();
        } else if (commandId == SVN_UPDATE_WORKING_COPY_TOOLBAR_MENU) {
            this.command = new SVNUpdateWorkingCopyCommand();
        } else if (commandId == SVN_COMPARE_CURRENT) {
            this.command = new SVNCompareCurrentCommand();
        } else if (commandId == SVN_TEXT_COMPARE_CURRENT) {
            this.command = new SVNTextCompareCurrentCommand();
        } else if (commandId == SVN_LOCK || commandId == SVN_LOCK_C) {
            this.command = new SVNLockCommand();
        } else if (commandId == SVN_UNLOCK || commandId == SVN_UNLOCK_C) {
            this.command = new SVNUnlockCommand();
        } else if (commandId == SVN_VERSION_TREE || commandId == SVN_VERSION_TREE_TEAM_MENU) {
            this.command = new SVNVersionTreeCommand();
        } else if (commandId == SVN_COMMIT_DESIGN) {
            this.command = new SVNCommitDesignCommand();
        } else if (commandId == SVN_UPDATE_DESIGN) {
            this.command = new SVNUpdateDesignCommand();
        } else if (commandId == SVN_CLEANUP) {
            this.command = new SVNCleanupCommand();
        } else if (commandId == SVN_PENDING_CHANGES || commandId == SVN_STATUS_COMMAND) {
            this.command = new SVNStatusCommand();
            SVNStatusCommand.showSvnChangeListWindow();
        } else if (commandId == SVN_RESOLVE_CONFLICTS) {
            this.command = new SVNResolveConflictsCommand();
        } else if (commandId == SVN_MERGE_DESIGN) {
            this.command = new SVNMergeDesignCommand();
        } else if (commandId == SVN_IMPORT) {
            this.command = new SVNImportCommand();
        } else if (commandId == SVN_SYSTEM_TYPES_HISTORY) {
            this.command = new SVNSystemTypesHistoryCommand();
        } else if (commandId == SVN_DESIGN_HISTORY) {
            this.command = new SVNDesignHistoryCommand();
        } else if (commandId == SVN_RESTORE_DELETED_FILES) {
            this.command = new RestoreDeletedFilesCommand();
        } else if (commandId == SVN_REVERT_WORKING_COPY) {
            this.command = new SVNRevertWorkingCopyCommand();
        } else if (commandId == SVN_OPERATION_ADD) {
            this.command = new SVNAddCommand();
        }
        if (this.command == null) {
            this.command = (Command)this.commandsIDMap.get(commandId);
        }
        if (!ApplicationView.getInstance().getCurrentDesign().isVersioned() && !ApplicationView.getInstance().getCurrentDesign().isVersionedSystemTypes() && commandId != SVN_IMPORT) {
            return true;
        }
        if (this.command != null) {
            try {
                waitCursor.show();
                this.command.setContext(context);
                this.command.doit();
                waitCursor.hide();
                return true;
            }
            catch (Exception e) {
                waitCursor.hide();
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return false;
    }

    private Command getCommand(String command_ID) {
        Set<Map.Entry<String, Command>> ces = this.commandsMap.entrySet();
        for (Map.Entry<String, Command> m : ces) {
            String key = m.getKey();
            if (key.compareTo(command_ID) != 0) continue;
            return m.getValue();
        }
        return null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == null) {
            return false;
        }
        if (context.getView() != null && context.getView() instanceof SVNChangeListWindow) {
            DataModelerChangeList changeList = (DataModelerChangeList)((SVNChangeListWindow)context.getView()).getContextChangeList();
            VersioningTreeNode selectedNode = changeList.getPanel().getSelectedNode();
            int commandID = ideAction.getCommandId();
            SVNChangeListWindow svnChangeListWindow = (SVNChangeListWindow)context.getView();
            svnChangeListWindow.getContextChangeList().firePropertyChange("changeListCount", changeList.getCount() == 0 ? 1 : 0, changeList.getCount());
            svnChangeListWindow.getContextChangeList().setToolTipText("");
            if (selectedNode != null) {
                File currentFile = selectedNode.getFilePath();
                StorableObjectStatus storableObjectStatus = selectedNode.getStorableObjectStatus();
                commandID = ideAction.getCommandId();
                if (currentFile.isDirectory() || storableObjectStatus == null) {
                    if (commandID == SVN_COMPARE_LAST_LOCAL || commandID == SVN_TEXT_COMPARE_LAST_LOCAL || commandID == SVN_COMPARE_LATEST || commandID == SVN_TEXT_COMPARE_LATEST || commandID == SVN_COMPARE_CURRENT || commandID == SVN_TEXT_COMPARE_CURRENT || commandID == SVN_VERSION_HISTORY || commandID == SVN_VERSION_HISTORY || commandID == SVN_VERSION_HISTORY_TEAM_MENU || commandID == SVN_VERSION_TREE || commandID == SVN_VERSION_TREE_TEAM_MENU) {
                        ideAction.setEnabled(false);
                        return true;
                    }
                } else if (commandID == SVN_COMPARE_LAST_LOCAL || commandID == SVN_TEXT_COMPARE_LAST_LOCAL || commandID == SVN_COMPARE_LATEST || commandID == SVN_TEXT_COMPARE_LATEST || commandID == SVN_COMPARE_CURRENT || commandID == SVN_TEXT_COMPARE_CURRENT || commandID == SVN_VERSION_HISTORY || commandID == SVN_VERSION_HISTORY || commandID == SVN_VERSION_HISTORY_TEAM_MENU || commandID == SVN_VERSION_TREE || commandID == SVN_VERSION_TREE_TEAM_MENU) {
                    ideAction.setEnabled(true);
                    return true;
                }
            }
            if (commandID == SVN_IMPORT) {
                return true;
            }
            if (ApplicationView.getInstance().getCurrentDesign().isVersioned() || ApplicationView.getInstance().getCurrentDesign().isVersionedSystemTypes()) {
                ideAction.setEnabled(true);
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    static {
        SVN_RESTORE_DELETED_FILES = Ide.findOrCreateCmdID((String)RestoreDeletedFilesCommand.COMMAND_ID);
        SVN_REVERT_ALL = Ide.findOrCreateCmdID((String)"DataModelingAddin.RevertAll");
        SVN_COMMIT = Ide.findOrCreateCmdID((String)"DataModelingAddin.Commit");
        SVN_COMMIT_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNCommitCommand.COMMAND_ID);
        SVN_REVERT = Ide.findOrCreateCmdID((String)"DataModelingAddin.Revert");
        SVN_REVERT_TEAM_MENU = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.revert");
        SVN_STORABLE_OBJECT_PROPERTIES = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.StorableObjectPropertiesCommand");
        SVN_VIEW_SUBVERSION_PROPERTIES = Ide.findOrCreateCmdID((String)"DataModelingAddin.ViewSubversionProperties");
        SVN_VIEW_SUBVERSION_PROPERTIES_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNViewPropertiesCommand.COMMAND_ID);
        SVN_VERSION_HISTORY = Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionHistory");
        SVN_VERSION_HISTORY_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNVersionHistoryCommand.COMMAND_ID);
        SVN_ADD_SUBVERSION_PROPERTY = Ide.findOrCreateCmdID((String)"DataModelingAddin.AddSubversionProperty");
        SVN_ADD_SUBVERSION_PROPERTY_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNAddPropertyCommand.COMMAND_ID);
        SVN_COMPARE_LAST_LOCAL = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareLastLocalCommand");
        SVN_TEXT_COMPARE_LAST_LOCAL = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLastLocalCommand");
        SVN_COMPARE_LATEST = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.compare-latest");
        SVN_TEXT_COMPARE_LATEST = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareLatestCommand");
        SVN_UPDATE = Ide.findOrCreateCmdID((String)SVNUpdateCommand.COMMAND_ID);
        SVN_UPDATE_ALL = Ide.findOrCreateCmdID((String)"DataModelingAddin.UpdateAll");
        SVN_UPDATE_ALL_TOOLBAR_MENU = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateAllCommand");
        SVN_UPDATE_WORKING_COPY_TOOLBAR_MENU = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.SVNUpdateWorkingCopyCommand");
        SVN_COMPARE_CURRENT = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNCompareCurrentCommand");
        SVN_TEXT_COMPARE_CURRENT = Ide.findOrCreateCmdID((String)"oracle.dbtools.crest.fcp.vcs.svn.commands.compare.SVNTextCompareCurrentCommand");
        SVN_LOCK_C = Ide.findOrCreateCmdID((String)SVNLockCommand.COMMAND_ID);
        SVN_LOCK = Ide.findOrCreateCmdID((String)"DataModelingAddin.Lock");
        SVN_UNLOCK_C = Ide.findOrCreateCmdID((String)SVNUnlockCommand.COMMAND_ID);
        SVN_UNLOCK = Ide.findOrCreateCmdID((String)"DataModelingAddin.Unlock");
        SVN_VERSION_TREE = Ide.findOrCreateCmdID((String)"DataModelingAddin.VersionTree");
        SVN_VERSION_TREE_TEAM_MENU = Ide.findOrCreateCmdID((String)SVNVersionTreeCommand.COMMAND_ID);
        SVN_COMMIT_DESIGN = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.commit-workingcopy");
        SVN_UPDATE_DESIGN = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.update-workingcopy");
        SVN_CLEANUP = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.cleanup");
        SVN_PENDING_CHANGES = ViewPendingChangesAction.getCommandId((String)"oracle.jdeveloper.subversion");
        SVN_STATUS_COMMAND = Ide.findOrCreateCmdID((String)SVNStatusCommand.COMMAND_ID);
        SVN_RESOLVE_CONFLICTS = Ide.findOrCreateCmdID((String)SVNResolveConflictsCommand.COMMAND_ID);
        SVN_MERGE_DESIGN = Ide.findOrCreateCmdID((String)SVNMergeDesignCommand.COMMAND_ID);
        SVN_IMPORT = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.import");
        SVN_SYSTEM_TYPES_HISTORY = Ide.findOrCreateCmdID((String)SVNSystemTypesHistoryCommand.COMMAND_ID);
        SVN_DESIGN_HISTORY = Ide.findOrCreateCmdID((String)SVNDesignHistoryCommand.COMMAND_ID);
        SVN_REVERT_WORKING_COPY = Ide.findOrCreateCmdID((String)SVNRevertWorkingCopyCommand.COMMAND_ID);
        SVN_OPERATION_UPDATE = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.update");
        SVN_OPERATION_ADD = Ide.findOrCreateCmdID((String)SVNAddCommand.class.getName());
    }
}

