/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.log.LogManager;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.SVNOperationMerge;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowser;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNMergeDesignCommand
extends SVNOperationMerge {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.mergewc" : SVNMergeDesignCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.mergewc", SVNMergeDesignCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNMergeDesignCommand() {
        super(COMMAND_ID);
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected boolean isAvailableImpl() throws Exception {
        return ApplicationView.getInstance().getCurrentDesign().isVersioned();
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        SVNUrl mergeUrl = SVNMergeDesignCommand.showMergeDialog();
        if (mergeUrl != null) {
            DockStation dockStation = DockStation.getDockStation();
            SVNMergeWindow svnMergeWindow = (SVNMergeWindow)dockStation.getDockable(SVNMergeWindow.VIEW_ID);
            if (svnMergeWindow == null) {
                svnMergeWindow = SVNMergeWindow.getInstance();
                DockingParam dockingParam = new DockingParam();
                dockingParam.setPosition((Dockable)LogManager.getIdeLogWindow(), 4);
                dockStation.dock((Dockable)svnMergeWindow, dockingParam);
            }
            svnMergeWindow.setMergeUrl(mergeUrl);
            svnMergeWindow.show();
            dockStation.activateDockable((Dockable)svnMergeWindow);
            return 0;
        }
        return 1;
    }

    public static SVNUrl showMergeDialog() throws MalformedURLException {
        JPanel pnContents = new JPanel(new BorderLayout(12, 12));
        JPanel pnInner = new JPanel(new BorderLayout(12, 12));
        JTextField tfMergeUrl = new JTextField();
        JButton btnBrowse = new JButton(Messages.getString("SVNMergeDesignCommand.Browse"));
        File designStoragePath = new File(ApplicationView.getInstance().getCurrentDesign().getStoragePath());
        ISVNInfo designSVNInfo = SVN_CLIENT_HELPER.doInfo(designStoragePath);
        SVNUrl designUrl = designSVNInfo.getUrl().getParent();
        BrowseActionListener browseActionListener = new BrowseActionListener(designUrl, tfMergeUrl);
        tfMergeUrl.setText(designUrl.toString());
        tfMergeUrl.setPreferredSize(new Dimension(250, (int)tfMergeUrl.getPreferredSize().getHeight()));
        btnBrowse.addActionListener(browseActionListener);
        pnInner.add(tfMergeUrl);
        pnInner.add((Component)new JLabel(Messages.getString("SVNMergeDesignCommand.MergeFromURL")), "West");
        pnInner.add((Component)btnBrowse, "East");
        pnContents.add((Component)pnInner, "North");
        if (OnePageWizardDialogFactory.runDialog((Component)pnContents, (Component)tfMergeUrl, (String)Messages.getString("SVNMergeDesignCommand.MergeDesign"), (int)7)) {
            StringBuilder url = new StringBuilder(tfMergeUrl.getText());
            String designName = ApplicationView.getInstance().getCurrentDesign().getName() + ".dmd";
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            String urlString = url.toString();
            return new SVNUrl(urlString);
        }
        return null;
    }

    private static final class RepoBrowserObserver
    implements Observer {
        private JTextField tfMergeUrl;

        private RepoBrowserObserver(JTextField tfMergeUrl) {
            this.tfMergeUrl = tfMergeUrl;
        }

        @Override
        public void update(Observable o, Object arg) {
            this.tfMergeUrl.setText(arg.toString());
        }
    }

    private static class BrowseActionListener
    implements ActionListener {
        private SVNUrl url;
        private JTextField tfMergeUrl;

        private BrowseActionListener(SVNUrl url, JTextField tfMergeUrl) {
            this.url = url;
            this.tfMergeUrl = tfMergeUrl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository((SVNUrl)this.url);
            SVNUrl selectedUrl = null;
            RepoBrowserObserver repoBrowserObserver = new RepoBrowserObserver(this.tfMergeUrl);
            String mergeUrl = this.tfMergeUrl.getText();
            SVNRepositoryBrowser repoBrowser = null;
            if (StringUtilities.isNotEmpty(mergeUrl)) {
                try {
                    selectedUrl = new SVNUrl(mergeUrl);
                }
                catch (MalformedURLException e1) {
                    MessageDialogs.showWarningMessage(Messages.getString("SVNMergeDesignCommand.InvalidURL"));
                }
            }
            repoBrowser = selectedUrl == null ? new SVNRepositoryBrowser(repoInfo) : new SVNRepositoryBrowser(repoInfo, selectedUrl);
            repoBrowser.addObserver((Observer)repoBrowserObserver);
            repoBrowser.showBrowser();
        }
    }
}

