/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.DisplayableLocatableNode;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.util.Extension;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.UnLockOptionsCustomizer;

public class SVNUnlockCommand
extends AbstractSVNOperation {
    public static final String COMMAND_ID = Extension.isDataModeler() ? "oracle.jdeveloper.subversion.unlock" : SVNUnlockCommand.class.getName();
    private static final IdeAction ACTION = DataModelerAddin.overrideAction("oracle.jdeveloper.subversion.unlock", SVNUnlockCommand.class.getName());
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    public SVNUnlockCommand() {
        super(COMMAND_ID);
        this.setProfile(VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public static IdeAction getAction() {
        return ACTION;
    }

    protected boolean isAvailableImpl() throws Exception {
        return SVN_CLIENT_HELPER.actionsEnabled(null, this.getContext(), true, true, false, false, false, true, false, true);
    }

    protected int doitImpl() throws Exception {
        CommandState commandState = VCSClientHelper.createCommandState(this.context.getView(), true, true);
        if (commandState.getLocatables() != null && commandState.getLocatables().length > 0) {
            this.invokeCommand(this.getProfile(), commandState);
            return 0;
        }
        return 1;
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        if (!this.prepareStateForUI(commandState)) {
            return false;
        }
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(nodes);
        JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                boolean result = true;
                try {
                    result = SVNUnlockCommand.this.invokeDMCommandImpl(profile, commandState);
                }
                catch (Exception ex) {
                    throw SVNExceptionWrapper.wrapException((Exception)ex);
                }
                return result;
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    protected VCSActionInfo getActionInfo() {
        return this.getProfile().getActionInfo("oracle.jdeveloper.subversion.unlock");
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables.length > 0) {
            List<File> files = DisplayableLocatableNode.convertToFileList(locatables, true);
            for (int i = files.size() - 1; i >= 0; --i) {
                File file = files.get(i);
                if (SVN_CLIENT_HELPER.getRevision(file) <= 0L) {
                    files.remove(i);
                    continue;
                }
                if (SVN_CLIENT_HELPER.isLockedInWC(file)) continue;
                files.remove(i);
            }
            if (files.size() > 0) {
                SVN_CLIENT_HELPER.doUnlock(files.toArray(new File[0]), (Boolean)options.get("oracle.jdeveloper.subversion.STEAL_LOCKS"));
            }
        }
        return true;
    }

    private boolean invokeDMCommandImpl(VCSProfile profile, CommandState commandState) throws Exception {
        Locatable[] locatables = commandState.getLocatables();
        if (locatables.length > 0) {
            List<File> files = DisplayableLocatableNode.convertToFileList(locatables, true);
            for (int i = files.size() - 1; i >= 0; --i) {
                File file = files.get(i);
                if (SVN_CLIENT_HELPER.getRevision(file) <= 0L) {
                    files.remove(i);
                    continue;
                }
                if (SVN_CLIENT_HELPER.isLockedInWC(file)) continue;
                files.remove(i);
            }
            if (files.size() > 0) {
                SVN_CLIENT_HELPER.doUnlock(files.toArray(new File[0]), true);
            }
        }
        return true;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        VersionOperationSelectTablePanel versionOperationPanel = SVN_CLIENT_HELPER.createVersionOperationTablePanel((List)nodes);
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)versionOperationPanel, (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        UnLockOptionsCustomizer customizer = new UnLockOptionsCustomizer();
        return customizer;
    }
}

