/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn.commands.compare;

import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.DataModelerChangeList;
import oracle.dbtools.crest.fcp.vcs.IChangeListPanel;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSTextCompareFrame;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;

public abstract class SVNAbstractCompareCommand
extends AbstractSVNOperation {
    protected static final String CURRENT_REVISION = Messages.getString("SVNAbstractCompareCommand.CurrentRevision");
    protected static final String HEAD_REVISION = Messages.getString("SVNAbstractCompareCommand.HeadRevision");
    protected static final String LAST_LOCAL_REVISION = Messages.getString("SVNAbstractCompareCommand.LastLocalRevision");
    private static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();

    protected SVNAbstractCompareCommand(String commandId) {
        super(commandId);
    }

    protected abstract InputStream getLeftText(File var1) throws FileNotFoundException;

    protected abstract String getLeftTextTitle();

    protected boolean isCompareAsText() {
        return false;
    }

    public XMLMetadataComparator getComparator(VersioningTreeNode selectedNode) throws FileNotFoundException {
        File currentFile = selectedNode.getFilePath();
        if (currentFile != null && currentFile.exists()) {
            InputStream leftText = this.getLeftText(currentFile);
            FileInputStream rightText = new FileInputStream(currentFile);
            if (leftText != null) {
                StorableObjectStatus storableObjectStatus = selectedNode.getStorableObjectStatus();
                Design design = storableObjectStatus.getDesign();
                String storableObjectID = storableObjectStatus.getStorableObjectID();
                StorageDesign storageDesign = SVN_CLIENT_HELPER.findStorageDesign(design, storableObjectID);
                return new XMLMetadataComparator(storableObjectStatus.getDesign(), storageDesign, leftText, this.getLeftTextTitle(), rightText, CURRENT_REVISION, true);
            }
        }
        return null;
    }

    public boolean isAvailable() {
        String shortStatus;
        DataModelerChangeList dataModelerChangeList;
        StorableObjectStatus objectStatus;
        return SVN_CLIENT_HELPER.actionsEnabled(null, this.context, true, true, true, false, false, true, false, true) && (objectStatus = (dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)this.context.getView()).getContextChangeList()).getPanel().getSelectedNode().getStorableObjectStatus()) != null && ("M".equals(shortStatus = objectStatus.getTextStatus()) || "C".equals(shortStatus));
    }

    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        DataModelerChangeList dataModelerChangeList = (DataModelerChangeList)((SVNChangeListWindow)this.context.getView()).getContextChangeList();
        VersioningTreeNode selectedNode = dataModelerChangeList.getPanel().getSelectedNode();
        if (selectedNode != null) {
            File currentFile = selectedNode.getFilePath();
            StorableObjectStatus storableObjectStatus = selectedNode.getStorableObjectStatus();
            if (currentFile.isDirectory() || storableObjectStatus == null || !currentFile.exists()) {
                return 0;
            }
        }
        this.compare(selectedNode);
        return 0;
    }

    protected void compare(VersioningTreeNode selectedNode) throws FileNotFoundException {
        if (this.isCompareAsText()) {
            this.compareAsText(selectedNode);
        } else {
            this.compareAsObject(selectedNode);
        }
    }

    protected void compareAsText(final VersioningTreeNode selectedNode) throws FileNotFoundException {
        final File localFile = selectedNode.getFilePath();
        InputStream leftText = this.getLeftText(localFile);
        if (leftText != null) {
            FileInputStream rightText = new FileInputStream(localFile);
            StorableObjectStatus storableObjectStatus = selectedNode.getStorableObjectStatus();
            VCSTextCompareFrame textCompareFrame = new VCSTextCompareFrame((Window)Ide.getMainWindow(), localFile, leftText, this.getLeftTextTitle(), rightText, CURRENT_REVISION, true, false, storableObjectStatus){

                @Override
                public void beforeSave() {
                    SVNAbstractCompareCommand.this.resolveConflict(localFile);
                    SVNAbstractCompareCommand.reloadIfSystemFile(selectedNode);
                }
            };
            textCompareFrame.showModal();
        }
    }

    protected void compareAsObject(VersioningTreeNode selectedNode) throws FileNotFoundException {
        Map mergedMap;
        File localFile = selectedNode.getFilePath();
        StorableObjectStatus objectStatus = selectedNode.getStorableObjectStatus();
        XMLMetadataComparator comparator = this.getComparator(selectedNode);
        if (comparator != null && (mergedMap = comparator.showModal()) != null) {
            this.resolveConflict(localFile);
            SVN_CLIENT_HELPER.merge(objectStatus, localFile, mergedMap);
            SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
            SVNAbstractCompareCommand.reloadIfSystemFile(selectedNode);
        }
    }

    protected void resolveConflict(File localFile) {
        SVN_CLIENT_HELPER.doUpdate(new File[]{localFile}, true);
        SVN_CLIENT_HELPER.doResolved(localFile);
        this.updateChangeLists(localFile);
    }

    private void updateChangeLists(File localFile) {
        IChangeListPanel incomingChangesPanel = SVNChangeListWindow.getSVNIncomingChangesChangeList().getPanel();
        List<StorableObjectStatus> incomingStatuses = incomingChangesPanel.getStatuses();
        if (incomingStatuses != null) {
            boolean updateIncomingChangesPanel = false;
            for (int i = incomingStatuses.size() - 1; i >= 0; --i) {
                StorableObjectStatus storableObjectStatus = incomingStatuses.get(i);
                if (!storableObjectStatus.getFilePath().equals(localFile)) continue;
                incomingStatuses.remove(storableObjectStatus);
                updateIncomingChangesPanel = true;
            }
            if (updateIncomingChangesPanel) {
                incomingChangesPanel.update(incomingStatuses);
            }
        }
    }

    private static void reloadIfSystemFile(VersioningTreeNode selectedNode) {
        Settings SETTINGS = ApplicationView.getInstance().getSettings();
        File localFile = selectedNode.getFilePath();
        if (localFile.getAbsolutePath().startsWith(SETTINGS.getDefaultSystemTypesPath())) {
            if (localFile.getName().equalsIgnoreCase("defaultdomains.xml")) {
                SETTINGS.refreshDefaultDomains();
            }
            if (localFile.getName().equalsIgnoreCase("defaultRDBMSSites.xml")) {
                SETTINGS.refreshDefaultRDBMSSites();
            }
            if (localFile.getName().equalsIgnoreCase("types.xml")) {
                SETTINGS.refreshDefaultTypes();
            }
        }
    }
}

