/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.cwddesigner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.cwddesigner.CWDBusinessInfoDesign;
import oracle.dbtools.crest.imports.cwddesigner.CWDDataTypeDesign;
import oracle.dbtools.crest.imports.cwddesigner.CWDLogicalDesign;
import oracle.dbtools.crest.imports.cwddesigner.CWDRelationalDesign;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class CWDExtractionHandler {
    private static CWDExtractionHandler cwdExtractionHandler;
    private ApplicationView view;
    private List cwdHObjects = null;
    private Design oldDesign;
    private Map importedObjects = new TreeMap();
    private static final Logger LOGGER;

    protected CWDExtractionHandler(ApplicationView view, Design oldDesign) {
        this.view = view;
        this.oldDesign = oldDesign;
    }

    public static CWDExtractionHandler getInstance(ApplicationView view, Design oldDesign) {
        if (cwdExtractionHandler == null) {
            cwdExtractionHandler = new CWDExtractionHandler(view, oldDesign);
        }
        return cwdExtractionHandler;
    }

    public List getCWDHObjects() {
        if (this.cwdHObjects == null) {
            this.cwdHObjects = new ArrayList();
            this.cwdHObjects.add(new CWDBusinessInfoDesign(this, this.view));
            this.cwdHObjects.add(new CWDDataTypeDesign(this, this.view));
            this.cwdHObjects.add(new CWDLogicalDesign(this, this.view));
            this.cwdHObjects.add(new CWDRelationalDesign(this, this.view));
        }
        return this.cwdHObjects;
    }

    public void clearCWDHObjects() {
        if (this.cwdHObjects != null) {
            this.cwdHObjects.clear();
            this.cwdHObjects = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getODObjects(List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        List mhoList = this.getCWDHObjects();
        if (mhoList.size() > 0) {
            for (AbstractObjectHandler objectHandler : mhoList) {
                List extracted = objectHandler.extract(appSystems);
                list.addAll(extracted);
            }
        }
        return list;
    }

    public void generateDesign(List selectedObjects, ImportLogger importLog) {
        try {
            this.clearImportedObjects();
            List mhoList = this.getCWDHObjects();
            for (AbstractObjectHandler objectHandler : mhoList) {
                objectHandler.generate(selectedObjects, importLog);
            }
        }
        catch (Exception e) {
            LOGGER.error("CWDExtractionHandler.insertDesign()", e);
        }
    }

    public Design getOldDesign() {
        return this.oldDesign;
    }

    public void addToImportedObjects(String id, ModelIDObject object) {
        this.importedObjects.put(id, object);
    }

    public void clearImportedObjects() {
        this.importedObjects.clear();
    }

    public Object getImportedObject(String id) {
        return this.importedObjects.get(id);
    }

    public Object getElementByImportID(ContainerObject object, String importId) {
        ContainedObject[] elements = object.getElements();
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj = elements[i];
            if (!obj.getImportedId().equalsIgnoreCase(importId)) continue;
            return obj;
        }
        return null;
    }

    static {
        LOGGER = new Logger(CWDExtractionHandler.class);
    }
}

