/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.cwddesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.ddl.AbstractDDLObjectHandler;
import oracle.dbtools.crest.imports.ddl.DDLRelationalDesign;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class DDLExtractionHandler {
    private static DDLExtractionHandler ddlExtractionHandler;
    private ApplicationView view;
    private List ddlHObjects = null;
    private Design oldDesign;
    private Map importedObjects = new TreeMap();
    private static final Logger LOGGER;

    protected DDLExtractionHandler(ApplicationView view, Design oldDesign) {
        this.view = view;
        this.oldDesign = oldDesign;
    }

    public static DDLExtractionHandler getInstance(ApplicationView view, Design oldDesign) {
        if (ddlExtractionHandler == null) {
            ddlExtractionHandler = new DDLExtractionHandler(view, oldDesign);
        }
        return ddlExtractionHandler;
    }

    public List getDDLHObjects() {
        if (this.ddlHObjects == null) {
            this.ddlHObjects = new ArrayList();
            this.ddlHObjects.add(new DDLRelationalDesign(this, this.view));
        }
        return this.ddlHObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getODObjects(List appSystems) throws Exception {
        ArrayList list = new ArrayList();
        List mhoList = this.getDDLHObjects();
        if (mhoList.size() > 0) {
            for (AbstractObjectHandler objectHandler : mhoList) {
                List extracted = objectHandler.extract(appSystems);
                list.addAll(extracted);
            }
        }
        return list;
    }

    public void generateDesign(List selectedObjects, ImportLogger importLog) {
        try {
            this.clearImportedObjects();
            List mhoList = this.getDDLHObjects();
            for (AbstractDDLObjectHandler objectHandler : mhoList) {
                objectHandler.generate(selectedObjects, importLog);
            }
        }
        catch (Exception e) {
            LOGGER.error("DDLExtractionHandler.insertDesign()", e);
        }
    }

    public Design getOldDesign() {
        return this.oldDesign;
    }

    public void addToImportedObjects(String id, ModelIDObject object) {
        this.importedObjects.put(id, object);
    }

    public void clearImportedObjects() {
        this.importedObjects.clear();
    }

    public Object getImportedObject(String id) {
        return this.importedObjects.get(id);
    }

    public Object getElementByImportID(ContainerObject object, String importId) {
        ContainedObject[] elements = object.getElements();
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj = elements[i];
            if (!obj.getImportedId().equalsIgnoreCase(importId)) continue;
            return obj;
        }
        return null;
    }

    static {
        LOGGER = new Logger(DDLExtractionHandler.class);
    }
}

