/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Iterator;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateAUXIndex
extends DDLStatementHandler
implements StatementsConstants {
    private AUXTableIndexDB2 index;
    private AUXTableDB2 table;
    private String tableName;
    private String indexName = "";
    private AbstractStorageDesignDB2 stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateAUXIndex.class);

    public SHCreateAUXIndex(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        this.statement = SHCreateAUXIndex.clearCR(line);
        if (Token.startsWithString(this.statement, "create index") || Token.startsWithString(this.statement, "create unique index")) {
            if (this.isAUXIndex()) {
                try {
                    this.createIndex(this.statement);
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    this.importLog.addFailedStatement(SHCreateAUXIndex.FormatCR(line, "\n"));
                }
            } else {
                this.nextHandler(line.replaceAll("\"", ""));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createIndex(String statement) {
        this.indexName = this.initIndexName();
        this.index = this.stoDesign.getAUXTableIndexSet().createAUXTableIndex();
        this.index.setAuxTable(this.table);
        this.index.setName(this.indexName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.index);
        this.initOwner(this.index);
        StorageTemplateDB2 st = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
        this.design.getRelationalDesign().stampModelObjectDDL(st);
        this.index.setStorageTemplate(st);
        this.initUsingBlock(this.index, statement);
        this.initFreeBlock(this.index, statement);
        this.initGbpcacheBlock(this.index, statement);
        this.initBufferpool(this.index);
        this.initClose(this.index);
        this.initCopy(this.index);
        this.initPieceSize(this.index);
        StorageTemplateDB2 realst = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(this.index.getStorageTemplate());
        if (realst != this.index.getStorageTemplate()) {
            this.index.setStorageTemplate(realst);
        }
    }

    private String getTableName() {
        int posPoint;
        String name = Token.getNameAfterToken(this.statement, "ON", '\"', '\"');
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40));
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private boolean isAUXIndex() {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            this.tableName = this.getTableName();
            this.table = (AUXTableDB2)this.stoDesign.getAUXTableSet().getByName(this.tableName);
            if (this.table != null) {
                return true;
            }
        }
        return false;
    }

    private String initIndexName() {
        String name = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        if (name.indexOf(46) > -1) {
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void initOwner(AUXTableIndexDB2 index) {
        String ownerName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "INDEX").trim(), '.');
        if (!ownerName.equalsIgnoreCase("")) {
            Owner owner = (Owner)this.stoDesign.getOwnerSet().getByName(ownerName);
            if (owner == null) {
                owner = (Owner)this.stoDesign.getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            index.setOwner(owner);
        } else if (this.getOwner() != null) {
            index.setOwner(this.getOwner());
        } else {
            index.setOwner(this.stoDesign.getOwnerSet().getDefaultOwner());
        }
    }

    private void initUsingBlock(AUXTableIndexDB2 index, String usingStatement) {
        boolean hasUsing = Token.hasToken(usingStatement, "USING");
        if (hasUsing) {
            String using = Token.getTokenAfter(usingStatement, "USING").trim();
            if (using.equalsIgnoreCase("VCAT")) {
                String vcatName = Token.getTokenAfter(usingStatement, "VCAT").trim();
                Iterator itVcat = this.stoDesign.getVCatSet().iterator();
                while (itVcat.hasNext()) {
                    VCatDB2 vcat = (VCatDB2)itVcat.next();
                    if (!vcat.getName().equalsIgnoreCase(vcatName)) continue;
                    index.getStorageTemplate().setVCat(vcat);
                    break;
                }
            } else if (using.equalsIgnoreCase("STOGROUP")) {
                String stogroupName = Token.getTokenAfter(usingStatement, "STOGROUP").trim();
                StorageGroupSetDB2 stoGroupSet = this.stoDesign.getStorageGroupSet();
                index.getStorageTemplate().setStorageGroup(stoGroupSet.getOrCreateStorageGroup(stogroupName));
                try {
                    String secqtyString;
                    String priqtyString = Token.getTokenAfter(usingStatement, "PRIQTY").trim();
                    if (!priqtyString.equals("")) {
                        int priqty = Integer.parseInt(priqtyString);
                        index.getStorageTemplate().setSgPriqty(priqty);
                    }
                    if (!(secqtyString = Token.getTokenAfter(usingStatement, "SECQTY").trim()).equals("")) {
                        int secqty = Integer.parseInt(secqtyString);
                        index.getStorageTemplate().setSgSeqty(secqty);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Wrong format in SHCreateAUXIndex.initUsingBlock()", e);
                    this.importLog.addWarning("Unknown using block for storage template of aux index" + index.getName());
                }
                String erase = Token.getTokenAfter(this.statement, "ERASE").trim();
                if (erase.equalsIgnoreCase("YES")) {
                    index.getStorageTemplate().setSgErase(true);
                }
            }
        }
    }

    private void initFreeBlock(AUXTableIndexDB2 index, String freeString) {
        boolean hasFree = Token.hasToken(freeString, "FREEPAGE");
        if (hasFree) {
            try {
                String pctfreeString;
                String freepageString = Token.getTokenAfter(freeString, "FREEPAGE").trim();
                if (!freepageString.equals("")) {
                    int freepage = Integer.parseInt(freepageString);
                    index.getStorageTemplate().setFreePage(freepage);
                }
                if (!(pctfreeString = Token.getTokenAfter(freeString, "PCTFREE").trim()).equals("")) {
                    int pctfree = Integer.parseInt(pctfreeString);
                    index.getStorageTemplate().setPctFree(pctfree);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format in SHCreateAUXIndex.initFreeBlock:", e);
                this.importLog.addWarning("Unknown free block for storage template of aux index" + index.getName());
            }
        }
    }

    private void initGbpcacheBlock(AUXTableIndexDB2 index, String gbpCacheString) {
        boolean hasGpb = Token.hasToken(gbpCacheString, "GBPCACHE");
        if (hasGpb) {
            String gbpcache = Token.getTokenAfter(gbpCacheString, "GBPCACHE").trim().toUpperCase();
            String[] choises = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < choises.length; ++i) {
                if (!gbpcache.equalsIgnoreCase(choises[i])) continue;
                index.getStorageTemplate().setGbCache(choises[i]);
            }
        }
    }

    private void initBufferpool(AUXTableIndexDB2 index) {
        String nameBP = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        BufferPoolSetDB2 bpSet = this.stoDesign.getBufferPoolSet();
        Iterator itBpSet = bpSet.iterator();
        while (itBpSet.hasNext()) {
            BufferPoolDB2 bufferPool = (BufferPoolDB2)itBpSet.next();
            if (!bufferPool.getName().equalsIgnoreCase(nameBP)) continue;
            index.setBufferPool(bufferPool);
        }
    }

    private void initClose(AUXTableIndexDB2 index) {
        String close = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (close.equalsIgnoreCase("NO")) {
            index.setClose(false);
        }
    }

    private void initCopy(AUXTableIndexDB2 index) {
        String copy = Token.getTokenAfter(this.statement, "COPY").trim();
        if (copy.equalsIgnoreCase("YES")) {
            index.setCopy(true);
        }
    }

    private void initPieceSize(AUXTableIndexDB2 index) {
        String pieceSize = Token.getStringAfter(this.statement, "PIECESIZE").trim();
        if (!pieceSize.equals("")) {
            index.setPieceSize(pieceSize);
        }
    }
}

