/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.Iterator;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.ColumnProxySet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxySet;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceSetDB2;

public class SHCreateAUXTable
extends DDLStatementHandler {
    private AUXTableDB2 auxTable;
    private AbstractStorageDesignDB2 stoDesign = null;
    private String ownerName = null;

    public SHCreateAUXTable(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateAUXTable.clearCR(line);
        if (Token.startsWithString(statement, "create aux table") || Token.startsWithString(statement, "create auxiliary table")) {
            try {
                this.parseAUXTable(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateAUXTable.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseAUXTable(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            this.auxTable = this.stoDesign.getAUXTableSet().createAUXTable();
            String name = this.initName();
            this.auxTable.setName(name);
            this.design.getRelationalDesign().stampModelObjectDDL(this.auxTable);
            this.initOwner();
            this.initIN();
            TableProxyDB2 table = this.initStores();
            if (table != null) {
                this.auxTable.setTable(table);
                this.initColumn();
                this.initPart();
            }
        }
    }

    private String initName() {
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.ownerName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void initIN() {
        String name;
        if (Token.hasToken(this.statement, "IN") && !(name = Token.getTokenAfter(this.statement, "IN").trim()).equals("")) {
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                name = Token.getValAfterCharacter(name, '.');
            }
            TableSpaceSetDB2 tsSet = this.stoDesign.getTableSpaceSet();
            Iterator it = tsSet.iterator();
            while (it.hasNext()) {
                TableSpaceDB2 ts = (TableSpaceDB2)it.next();
                if (!ts.getName().equalsIgnoreCase(name)) continue;
                this.auxTable.setTableSpace(ts);
                break;
            }
        }
    }

    private TableProxyDB2 initStores() {
        String name;
        if (Token.hasToken(this.statement, "STORES") && !(name = Token.getTokenAfter(this.statement, "STORES").trim()).equals("")) {
            int posPoint = name.indexOf(46);
            if (posPoint > 0) {
                name = Token.getValAfterCharacter(name, '.');
            }
            TableProxySet tableSet = this.stoDesign.getTableProxySet();
            Iterator it = tableSet.iterator();
            while (it.hasNext()) {
                TableProxyDB2 table = (TableProxyDB2)it.next();
                if (!table.getName().equalsIgnoreCase(name)) continue;
                return table;
            }
        }
        return null;
    }

    private void initColumn() {
        String name;
        if (Token.hasToken(this.statement, "COLUMN") && !(name = Token.getTokenAfter(this.statement, "COLUMN").trim()).equals("")) {
            ColumnProxySet columnSet = this.stoDesign.getColumnProxySet();
            Iterator it = columnSet.iterator();
            while (it.hasNext()) {
                ColumnProxyDB2 column = (ColumnProxyDB2)it.next();
                if (!column.getName().equalsIgnoreCase(name)) continue;
                this.auxTable.setColumn(column);
                break;
            }
        }
    }

    private void initPart() {
        String partStr;
        if (Token.hasToken(this.statement, "PART") && !(partStr = Token.getTokenAfter(this.statement, "PART").trim()).equals("")) {
            try {
                int partNumber = Integer.parseInt(partStr);
                this.auxTable.setPartNumber(partNumber);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Invalid part for aux table " + this.auxTable);
            }
        }
    }

    private void initOwner() {
        if (this.ownerName != null && !this.ownerName.equalsIgnoreCase("")) {
            Owner owner = (Owner)this.stoDesign.getOwnerSet().getByName(this.ownerName);
            if (owner == null) {
                owner = (Owner)this.stoDesign.getOwnerSet().createElement(null);
                owner.setName(this.ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            this.auxTable.setOwner(owner);
        } else if (this.getOwner() != null) {
            this.auxTable.setOwner(this.getOwner());
        } else {
            this.auxTable.setOwner(this.stoDesign.getOwnerSet().getDefaultOwner());
        }
    }
}

