/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;

public class SHCreateStoragegroup
extends DDLStatementHandler {
    private StorageGroupDB2 stoGroup;
    private AbstractStorageDesignDB2 stoDesign = null;

    public SHCreateStoragegroup(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateStoragegroup.clearCR(line);
        if (Token.startsWithString(statement, "create stogroup")) {
            try {
                this.parseStorageGroup(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addError("Parsing " + statement + " for DB2 failed");
                this.importLog.addFailedStatement(SHCreateStoragegroup.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseStorageGroup(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            String nameVCat;
            this.stoGroup = this.stoDesign.getStorageGroupSet().createStorageGroup();
            String nameStogroup = this.initName();
            this.stoGroup.setName(nameStogroup);
            String volumes = this.initVolumes();
            if (!volumes.equalsIgnoreCase("")) {
                this.stoGroup.recreateVolumeSet(volumes);
            }
            if (!(nameVCat = this.initVCat()).equalsIgnoreCase("")) {
                VCatDB2 vcat = this.stoDesign.getVCatSet().getOrCreateVCat(nameVCat);
                this.stoGroup.setVCat(vcat);
            }
        }
    }

    private String initName() {
        return Token.getNameAfterToken(this.statement, "STOGROUP", '\"', '\"').trim();
    }

    private String initVolumes() {
        String volumesStr = Token.getValBetweenBrackets(this.statement);
        volumesStr = Token.getValBetweenDoubleQuotes(volumesStr);
        StringBuffer result = new StringBuffer();
        if (!volumesStr.equalsIgnoreCase("")) {
            StringTokenizer tokens = new StringTokenizer(volumesStr, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                VolumesDB2 volumes = this.stoDesign.getVolumesSet().getOrCreateVolumes(token);
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(volumes.getName());
            }
        }
        return result.toString();
    }

    private String initVCat() {
        return Token.getTokenAfter(this.statement, "VCAT").trim();
    }

    public StorageGroupDB2 getStorageGroup() {
        return this.stoGroup;
    }
}

