/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.db2.SHColumnElements;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.ColumnProxyDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTable
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    protected LogicalDatatypeFactory factoryLogicalDatatype = new LogicalDatatypeFactory();
    protected Table table = null;
    protected RDBMSSite site = null;
    protected StorageDesignDB2v70 storageDesign = null;
    protected TableProxyDB2 tableProxy = null;
    private boolean createDomainsDuringImport;
    protected String tableName;
    protected String ownerName = null;
    protected ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    protected String inTablespace;
    protected String inDatabase;
    protected String editproc;
    protected String validproc;
    protected String audit;
    protected String obid;
    protected boolean dataCapture;
    protected boolean restrict;
    protected String ccsid;
    protected String outSideBrackets;
    protected String inSideBrackets;
    private boolean failed = false;
    protected static final Logger LOGGER = new Logger(SHCreateTable.class);

    public SHCreateTable(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        block7: {
            String statement = SHCreateTable.clearCR(line);
            if (!Token.startsWithString(statement, "create aux")) {
                if (Token.startsWithString(statement, "create table") || Token.startsWithString(statement, "create or replace table")) {
                    try {
                        this.failed = false;
                        this.fkList = new ArrayList();
                        this.refAtColumnList = new ArrayList();
                        this.parseTable(statement);
                        FKRefNode fkNode = new FKRefNode();
                        fkNode.processedTable = this.table;
                        fkNode.fkStatements = this.fkList;
                        fkNode.refAtColumns = this.refAtColumnList;
                        this.tableNodeList.add(fkNode);
                        if (this.failed) {
                            this.importLog.addFailedStatement(SHCreateTable.FormatCR(line, "\n"));
                            break block7;
                        }
                        this.importLog.incrementImportedStatements();
                    }
                    catch (Exception e) {
                        LOGGER.error(" Parsing " + statement + " for DB2 failed!", e);
                        this.importLog.addFailedStatement(SHCreateTable.FormatCR(line, "\n"));
                    }
                } else {
                    this.nextHandler(line);
                }
            } else {
                this.nextHandler(line);
            }
        }
    }

    protected void parseTable(String statement) {
        this.setStatement(statement);
        this.outSideBrackets = Token.getValOutsideBrackets(this.statement);
        this.inSideBrackets = Token.getValBetweenBrackets(this.statement);
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignDB2v70)this.design.getStorageDesign(this.site);
        if (this.storageDesign.importStorageObjectsOnly()) {
            this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(this.tableName);
        } else {
            this.table = this.design.getRelationalDesign().createTable();
            this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        }
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.tableProxy = (TableProxyDB2)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.storageDesign.getDesign().getAppView().getSettings().isCreateDomainsDuringImport();
        this.columns = this.initColumns();
        for (int col = 0; col < this.columns.size(); ++col) {
            Owner owner;
            IndexProxyDB2 proxy;
            Map oneColumnMap = (Map)this.columns.get(col);
            boolean isConstraint = (Boolean)oneColumnMap.get("IS_CONSTRAINT");
            if (!isConstraint) {
                String reference;
                StringBuffer message;
                Column column;
                String columnName = (String)oneColumnMap.get("columnname");
                if (this.storageDesign.importStorageObjectsOnly()) {
                    column = (Column)this.table.getElementByName(columnName);
                } else {
                    column = this.table.createColumn(columnName);
                    this.design.getRelationalDesign().stampModelObjectDDL(column);
                    String datatype = (String)oneColumnMap.get("datatype");
                    String scale = (String)oneColumnMap.get("scale");
                    String size = (String)oneColumnMap.get("size");
                    String precision = (String)oneColumnMap.get("precision");
                    String[] parameters = new String[]{precision, scale, size};
                    String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                    LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                    if (this.createDomainsDuringImport) {
                        Domain domain = null;
                        String typeName = (String)oneColumnMap.get("typename");
                        if (typeName != null) {
                            DomainSet domains = this.design.getDomainSet();
                            domain = (Domain)domains.getByName(typeName);
                        }
                        String domainName = "";
                        if (domain == null) {
                            domainName = DomainFactory.createDomainName(logicalDT, parameters);
                            domain = this.getCorrespondingDomain(domainName);
                        }
                        if (domain != null) {
                            column.setDomain(domain);
                        } else {
                            message = new StringBuffer("domain is null in SHCreateTable.parseTable: ");
                            message.append(domainName);
                            LOGGER.error(message.toString());
                            this.importLog.addError("Null domain occurred while creating " + this.tableName);
                        }
                    } else {
                        column.setLogicalDatatype(logicalDT);
                        column.setUse((short)1);
                        column.setDataTypeParameter("scale", scale);
                        column.setDataTypeParameter("precision", precision);
                        column.setDataTypeParameter("size", size);
                    }
                    boolean notNull = (Boolean)oneColumnMap.get("NOT NULL");
                    column.setNullsAllowed(!notNull);
                    boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
                    if (isPK) {
                        Index pk = this.table.createIndex();
                        pk.add(column);
                        pk.makePK();
                        this.design.getRelationalDesign().stampModelObjectDDL(pk);
                    } else {
                        boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
                        if (isUnique) {
                            Index unique = this.table.createIndex();
                            unique.add(column);
                            unique.setIndexState("Unique Constraint");
                            this.design.getRelationalDesign().stampModelObjectDDL(unique);
                        }
                    }
                }
                if (this.storageDesign != null) {
                    String identity;
                    String fieldProc;
                    String forElement = (String)oneColumnMap.get("FOR");
                    String defaultElement = (String)oneColumnMap.get("DEFAULT");
                    ColumnProxyDB2v70 columnProxy = (ColumnProxyDB2v70)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                    columnProxy.setBitData(forElement);
                    String[] defaultChoises = ColumnProxyDB2.getDefaultValueChoices();
                    if (defaultElement != null) {
                        boolean def = (Boolean)oneColumnMap.get("IS DEFAULT");
                        columnProxy.setDefault(def);
                        if (defaultElement.equalsIgnoreCase(defaultChoises[2]) || defaultElement.equalsIgnoreCase(defaultChoises[3])) {
                            columnProxy.setDefaultValue(defaultElement);
                        } else if (Token.hasCloseAndOpenBrackets(defaultElement)) {
                            columnProxy.setDefaultValue(defaultChoises[4]);
                            columnProxy.setDefaultValueConstant(defaultElement);
                        } else {
                            columnProxy.setDefaultValue(defaultChoises[1]);
                            columnProxy.setDefaultValueConstant(defaultElement);
                            column.setDefaultValue(defaultElement);
                        }
                    }
                    if ((fieldProc = (String)oneColumnMap.get("FIELDPROC")) != null) {
                        if (Token.hasCloseAndOpenBrackets(fieldProc)) {
                            String constant = Token.getValBetweenBrackets(fieldProc).trim();
                            columnProxy.setConstant(constant);
                            fieldProc = Token.getValBeforeBrackets(fieldProc).trim();
                        }
                        columnProxy.setProgram(fieldProc);
                    }
                    if ((identity = (String)oneColumnMap.get("GENERATED")) != null) {
                        String min;
                        String max;
                        Object ob;
                        String cache;
                        String incrementBy;
                        String startWith;
                        ColumnIdentityDB2 columnIdentity = this.storageDesign.getColumnIdentitySet().createColumnIdentity();
                        this.design.getRelationalDesign().stampModelObjectDDL(columnIdentity);
                        columnIdentity.setColumn(columnProxy);
                        for (int i = 0; i < ColumnIdentityDB2.getGenerateValues().length; ++i) {
                            String value = ColumnIdentityDB2.getGenerateValues()[i];
                            if (!identity.equalsIgnoreCase(value)) continue;
                            columnIdentity.setGenerate(value);
                            break;
                        }
                        if ((startWith = (String)oneColumnMap.get("START")) != null) {
                            columnIdentity.setStartWith(startWith);
                        }
                        if ((incrementBy = (String)oneColumnMap.get("INCREMENT")) != null) {
                            try {
                                int incrementByValue = Integer.parseInt(incrementBy);
                                columnIdentity.setIncrementBy(incrementByValue);
                            }
                            catch (NumberFormatException e) {
                                message = new StringBuffer("wrong Format for Increment value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(message.toString(), e);
                                this.importLog.addWarning("Wrong format for Increment value of table " + this.tableName);
                            }
                        }
                        if ((cache = (String)oneColumnMap.get("CACHE")) != null) {
                            try {
                                int cacheValue = Integer.parseInt(cache);
                                columnIdentity.setCache(cacheValue);
                            }
                            catch (NumberFormatException e) {
                                StringBuffer message2 = new StringBuffer("wrong Format for Cache value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(message2.toString(), e);
                                this.importLog.addWarning("Wrong format for Cache value of table " + this.tableName);
                            }
                        }
                        if ((ob = oneColumnMap.get("CYCLE")) != null) {
                            boolean cycle = (Boolean)oneColumnMap.get("CYCLE");
                            columnIdentity.setCycle(cycle);
                        }
                        if ((max = (String)oneColumnMap.get("MAXVALUE")) != null) {
                            try {
                                Integer.parseInt(max);
                                columnIdentity.setMaxValue(max);
                            }
                            catch (NumberFormatException e) {
                                StringBuffer message3 = new StringBuffer("wrong Format for MAXVALUE value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(message3.toString(), e);
                                this.importLog.addWarning("Wrong format for maxvalue value of table " + this.tableName);
                            }
                        }
                        if ((min = (String)oneColumnMap.get("MINVALUE")) != null) {
                            try {
                                Integer.parseInt(min);
                                columnIdentity.setMinValue(min);
                            }
                            catch (NumberFormatException e) {
                                StringBuffer message4 = new StringBuffer("wrong Format for MINVALUE value in SHCreateTable -> Init Identity: ");
                                LOGGER.error(message4.toString(), e);
                                this.importLog.addWarning("Wrong format for minvalue value of table " + this.tableName);
                            }
                        }
                        columnProxy.setColumnIdentity(columnIdentity);
                    }
                }
                if ((reference = (String)oneColumnMap.get("REFERENCES")) != null) {
                    RefAtColNode refNode = new RefAtColNode();
                    int posPoint = reference.indexOf(46);
                    if (posPoint > 0) {
                        reference = Token.getValAfterCharacter(reference, '.');
                    }
                    refNode.onDelete = (String)oneColumnMap.get("ON DELETE");
                    refNode.columnName = (String)oneColumnMap.get("columnname");
                    refNode.refColumn = (String)oneColumnMap.get("REFERENCED_COLUMN");
                    refNode.referencedTable = reference;
                    this.refAtColumnList.add(refNode);
                }
                String constr = (String)oneColumnMap.get("CONSTRAINT");
                String check = (String)oneColumnMap.get("CHECK");
                if (check == null) continue;
                this.initCheckConstraint(check, constr, column);
                continue;
            }
            String name = (String)oneColumnMap.get("CONSTRAINT_NAME");
            boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
            if (isPK) {
                Index pk;
                if (this.storageDesign.importStorageObjectsOnly()) {
                    pk = (Index)this.table.getPK();
                } else {
                    pk = this.table.createIndex();
                    this.design.getRelationalDesign().stampModelObjectDDL(pk);
                }
                String pkOwner = null;
                if (!"".equalsIgnoreCase(name)) {
                    int posPoint = name.indexOf(46);
                    if (posPoint > 0) {
                        pkOwner = Token.getValBeforeCharacter(name, '.');
                        name = Token.getValAfterCharacter(name, '.');
                    }
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        pk.setName(name);
                    }
                } else {
                    if (this.tableName.length() > 15) {
                        this.tableName = this.tableName.substring(0, 15);
                    }
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        pk.setName(this.tableName + "_PK");
                    }
                }
                String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                try {
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        SHCreateTable.setColumnsForIndexPK(pk, elements, this.importLog);
                        pk.makePK();
                    }
                    if ((proxy = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(pk.getObjectID())) == null) continue;
                    proxy.setName(pk.getName());
                    if (pkOwner == null) continue;
                    owner = (Owner)this.storageDesign.getOwnerSet().getByName(pkOwner);
                    if (owner == null) {
                        owner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                        owner.setName(pkOwner);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    proxy.setOwner(owner);
                }
                catch (ObjectDoesNotExistException e) {
                    StringBuffer message = new StringBuffer(e.getMessage());
                    message.append(" in SHCreateTable.parseTable: PRIMARY KEY");
                    LOGGER.error(message.toString(), e);
                    this.importLog.addError("Columns for primary key " + pk.getName() + " don't exist.");
                    this.failed = true;
                }
                continue;
            }
            boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
            if (isUnique) {
                Index unique;
                String pkOwner = null;
                if (!"".equalsIgnoreCase(name)) {
                    int posPoint = name.indexOf(46);
                    if (posPoint > 0) {
                        pkOwner = Token.getValBeforeCharacter(name, '.');
                        name = Token.getValAfterCharacter(name, '.');
                    }
                } else {
                    if (this.tableName.length() > 13) {
                        this.tableName = this.tableName.substring(0, 13);
                    }
                    name = this.tableName + "_UK" + this.table.getUKeys().size();
                }
                if (this.storageDesign.importStorageObjectsOnly()) {
                    unique = this.table.getIndexByName(name);
                } else {
                    unique = this.table.createIndex();
                    unique.setName(name);
                    this.design.getRelationalDesign().stampModelObjectDDL(unique);
                }
                if (!this.storageDesign.importStorageObjectsOnly()) {
                    String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                    try {
                        SHCreateTable.setColumnsForIndexPK(unique, elements, this.importLog);
                        unique.setIndexState("Unique Constraint");
                    }
                    catch (ObjectDoesNotExistException e) {
                        StringBuffer message = new StringBuffer(e.getMessage());
                        message.append(" in SHCreateTable.parseTable:UNIQUE");
                        LOGGER.error(message.toString(), e);
                        this.importLog.addError("Columns for unique key " + unique.getName() + " don't exist.");
                        this.failed = true;
                    }
                    unique.setIndexState("Unique Constraint");
                }
                if ((proxy = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(unique.getObjectID())) == null) continue;
                proxy.setName(unique.getName());
                if (pkOwner == null) continue;
                owner = (Owner)this.storageDesign.getOwnerSet().getByName(pkOwner);
                if (owner == null) {
                    owner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                    owner.setName(pkOwner);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                proxy.setOwner(owner);
                continue;
            }
            boolean isTableConstraint = (Boolean)oneColumnMap.get("CHECK");
            if (!isTableConstraint) continue;
            String rule = (String)oneColumnMap.get("CONSTRAINT_VALUE");
            if (this.tableName.length() > 13) {
                this.tableName = this.tableName.substring(0, 13);
            }
            TableLevelConstraint constraint = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), rule);
            if (!"".equalsIgnoreCase(name)) {
                constraint.setName(name);
            }
            this.table.addCheckConstraint(constraint);
            this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        }
        this.initDatabaseTablespace();
        if (this.tableProxy != null) {
            TableSpaceSetDB2 tablespaceSet = this.storageDesign.getTableSpaceSet();
            TableSpaceDB2 ts = tablespaceSet.getOrCreateTablespace(this.inDatabase, this.inTablespace);
            this.tableProxy.setTableSpace(ts);
            if (this.ownerName != null) {
                Owner owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().getByName(this.ownerName);
                if (owner == null) {
                    owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                this.tableProxy.setOwner(owner);
            } else if (this.getOwner() != null) {
                this.tableProxy.setOwner(this.getOwner());
            } else {
                this.tableProxy.setOwner(this.storageDesign.getOwnerSet().getDefaultOwner());
            }
        }
        this.editproc = this.initEditProc();
        if (this.tableProxy != null && !this.editproc.equals(" ") && this.editproc != null && !this.editproc.equals("")) {
            this.tableProxy.setEditProc(this.editproc);
        }
        this.validproc = this.initValidProc();
        if (this.tableProxy != null && !this.validproc.equals(" ") && this.validproc != null && !this.validproc.equals("")) {
            this.tableProxy.setValidProc(this.validproc);
        }
        this.audit = this.initAudit();
        if (this.tableProxy != null && !this.audit.equals(" ") && this.audit != null && !this.audit.equals("")) {
            this.tableProxy.setAudit(this.audit);
        }
        this.obid = this.initObid();
        if (this.tableProxy != null) {
            try {
                if (!this.obid.equals(" ") && this.obid != null && !this.obid.equals("")) {
                    this.tableProxy.setObid(Integer.parseInt(this.obid));
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format for Obid in SHCreateTable.parseTable : ");
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong format in Obid in statement " + statement);
            }
        }
        this.dataCapture = this.initDataCapture();
        if (this.tableProxy != null) {
            this.tableProxy.setDataCapture(this.dataCapture);
        }
        this.restrict = this.initWithRestrictOnDrop();
        if (this.tableProxy != null) {
            this.tableProxy.setDropRestrict(this.restrict);
        }
        this.ccsid = this.initCcsid();
        if (this.tableProxy != null) {
            for (int i = 0; i < TableProxyDB2.getCcsidValues().length; ++i) {
                String ccsID = TableProxyDB2.getCcsidValues()[i];
                if (!this.ccsid.equalsIgnoreCase(ccsID)) continue;
                this.tableProxy.setCcsid(ccsID);
                break;
            }
        }
    }

    private String initTableName() {
        String name = Token.getNameAfterToken(this.outSideBrackets, "TABLE", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.ownerName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    public static void setColumnsForIndexPK(Index index, String elementsPK, ImportLogger importLog) throws ObjectDoesNotExistException {
        if (index != null) {
            StringTokenizer elemPK = new StringTokenizer(elementsPK, ",");
            ArrayList<String> pkColNames = new ArrayList<String>();
            while (elemPK.hasMoreElements()) {
                String columnNamePK = elemPK.nextToken().trim();
                pkColNames.add(columnNamePK);
            }
            for (String colName : pkColNames) {
                Column column = (Column)index.getTable().getElementByName(colName);
                if (column != null) {
                    index.add(column);
                    continue;
                }
                importLog.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException(colName);
            }
        }
    }

    private void initDatabaseTablespace() {
        String database = Token.getTokenAfter(this.outSideBrackets, "IN");
        if (database.equalsIgnoreCase("DATABASE")) {
            this.inTablespace = "";
            this.inDatabase = "";
        } else if (database.indexOf(46) > 0) {
            this.inTablespace = Token.getValAfterCharacter(database, '.');
            this.inDatabase = Token.getValBeforeCharacter(database, '.');
        } else {
            this.inTablespace = database;
            this.inDatabase = "";
        }
    }

    private ArrayList initColumns() {
        ArrayList<Map> tableColumns = new ArrayList<Map>();
        String columnStatement = this.inSideBrackets;
        SHColumnElements elements = new SHColumnElements();
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            Map elementsColumn;
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            if (Boolean.TRUE.equals((elementsColumn = elements.getElementsColumn(oneColumn.trim())).get("IS_CONSTRAINT")) && oneColumn.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(oneColumn);
                continue;
            }
            tableColumns.add(elementsColumn);
        }
        return tableColumns;
    }

    private String initEditProc() {
        return Token.getTokenAfter(this.outSideBrackets, "EDITPROC").trim();
    }

    private String initValidProc() {
        return Token.getTokenAfter(this.outSideBrackets, "VALIDPROC").trim();
    }

    private String initAudit() {
        return Token.getTokenAfter(this.outSideBrackets, "AUDIT").trim();
    }

    private String initObid() {
        return Token.getTokenAfter(this.outSideBrackets, "OBID").trim();
    }

    private boolean initDataCapture() {
        String dataCapture = Token.getTokenAfter(this.outSideBrackets, "CAPTURE");
        return dataCapture.equalsIgnoreCase("CHANGES");
    }

    private boolean initWithRestrictOnDrop() {
        return Token.hasToken(this.outSideBrackets, "RESTRICT");
    }

    private String initCcsid() {
        return Token.getTokenAfter(this.outSideBrackets, "CCSID").trim();
    }

    private void initCheckConstraint(String check, String name, Column column) {
        CheckConstraint constraint = new CheckConstraint();
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        RDBMSTypeSet rdbmsTypeSet = this.design.getRDBMSTypeSet();
        Iterator itRdbms = rdbmsTypeSet.iterator();
        while (itRdbms.hasNext()) {
            RDBMSType type = (RDBMSType)itRdbms.next();
            if (type != StorageDesignDB2v70.RDBMS_TYPE) continue;
            constraint.add(type, check);
        }
        if (!"".equalsIgnoreCase(name) && name != null) {
            constraint.setName(name);
            column.setConstraintName(name);
        } else {
            String columnName = column.getName();
            if (columnName.length() > 13) {
                columnName = columnName.substring(0, 13);
            }
            name = columnName + "_CHCK";
            constraint.setName(name);
            column.setConstraintName(name);
        }
        constraint.setDesign(column.getDesign());
        column.setUseDomainConstraints(false);
        column.setCheck(constraint);
    }

    private Table getReferencedTable(String reference) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table tableReferenced = (Table)tableSet.getByName(reference);
        if (tableReferenced != null) {
            return tableReferenced;
        }
        this.importLog.addError("Table with name " + reference + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + reference);
    }

    public Table getTable() {
        return this.table;
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }

    private void addForeignKey(String line, Table processedTable) {
        block17: {
            Table tableRef;
            ArrayList<Column> columnsRef;
            String nameFK;
            block18: {
                nameFK = null;
                if (Token.hasToken(line, "CONSTRAINT")) {
                    nameFK = Token.getTokenAfter(line, "CONSTRAINT");
                } else {
                    nameFK = Token.getTokenAfter(line, "KEY");
                    int brpos = nameFK.indexOf("(");
                    if (brpos > 0) {
                        nameFK = nameFK.substring(0, brpos);
                    } else if (brpos == 0) {
                        nameFK = null;
                    }
                }
                int positionBracket = line.indexOf(41);
                String firstBrackets = line.substring(0, positionBracket + 1).trim();
                String columns = Token.getValBetweenBrackets(firstBrackets);
                List columnNames = this.getColumnNames(columns);
                columnsRef = new ArrayList<Column>();
                Column[] columnSet = (Column[])processedTable.getElements();
                for (String name : columnNames) {
                    for (int ci = 0; ci < columnSet.length; ++ci) {
                        String colname = columnSet[ci].getName().trim();
                        if (!name.equalsIgnoreCase(colname)) continue;
                        columnsRef.add(columnSet[ci]);
                    }
                }
                int positionReference = line.toUpperCase().indexOf("REFERENCES");
                line = line.substring(positionReference);
                String nameReferenced = Token.getTokenAfter(line, "REFERENCES");
                String nameRef = this.getNameFor(nameReferenced);
                tableRef = this.getTableFor(nameRef = Token.removeQuotes(nameRef));
                if (tableRef == null) break block17;
                boolean hasBrackets = Token.hasString(line, "(");
                if (!hasBrackets) break block18;
                String columnsReferenced = Token.getValBetweenBrackets(line);
                List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                if (index == null) break block17;
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (!hasOnDelete) break block17;
                String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                String[] choisesDelete = fkass.getDeleteRuleChoices();
                for (int choise = 0; choise < choisesDelete.length; ++choise) {
                    if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                    fkass.setDeleteRule(choisesDelete[choise]);
                    break block17;
                }
                break block17;
            }
            FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)tableRef.getPK();
            if (index != null) {
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (hasOnDelete) {
                    String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                    String[] choisesDelete = fkass.getDeleteRuleChoices();
                    for (int choise = 0; choise < choisesDelete.length; ++choise) {
                        if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                        fkass.setDeleteRule(choisesDelete[choise]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            token = Token.removeQuotes(token);
            columns.add(token.trim());
        }
        return columns;
    }

    private String getNameFor(String name) {
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        Index index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = (Column)index.getElements()[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        Index index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    Column getColumnByName(Table processedTable, String columnName) {
        Column[] cols = (Column[])processedTable.getElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getName().equalsIgnoreCase(columnName)) continue;
            return cols[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refNode, Table processedTable) {
        String reference = this.getNameFor(refNode.referencedTable);
        Table referencedtable = null;
        try {
            referencedtable = this.getReferencedTable(reference);
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error(e);
            this.importLog.addError("Referenced table " + reference + " of fereign key does not exist.");
            this.failed = true;
        }
        if (referencedtable != null) {
            Index indexOfreference;
            ArrayList<String> refColName = new ArrayList<String>();
            if (refNode.refColumn != null) {
                refColName.add(refNode.refColumn);
                indexOfreference = this.getUniqueIndexForColumnNames(referencedtable, refColName);
            } else {
                indexOfreference = (Index)referencedtable.getPK();
            }
            if (indexOfreference != null) {
                FKIndexAssociation fk = processedTable.addFK(indexOfreference);
                this.design.getRelationalDesign().stampModelObjectDDL(fk);
                ArrayList<Column> columnsRef = new ArrayList<Column>();
                Column column = this.getColumnByName(processedTable, refNode.columnName);
                if (column != null) {
                    columnsRef.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fk, columnsRef, indexOfreference);
                    } else {
                        this.fixFKColumns(fk, columnsRef, indexOfreference);
                    }
                    if (refNode.onDelete != null) {
                        String[] choisesDelete = fk.getDeleteRuleChoices();
                        for (int choise = 0; choise < choisesDelete.length; ++choise) {
                            if (!refNode.onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                            fk.setDeleteRule(choisesDelete[choise]);
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode node : this.tableNodeList) {
            for (String line : node.fkStatements) {
                this.addForeignKey(line, node.processedTable);
            }
            Iterator itcolref = node.refAtColumns.iterator();
            while (itcolref.hasNext()) {
                this.processRefAtColumn((RefAtColNode)itcolref.next(), node.processedTable);
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

