/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateView
extends DDLStatementHandler {
    private boolean allColumnsAreMade;
    private AbstractView view;
    private String userDefined;
    private static final Logger LOGGER = new Logger(SHCreateView.class);

    public SHCreateView(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateView.clearCR(line);
        if (Token.startsWithString(statement, "create view") || Token.startsWithString(statement, "create or replace view")) {
            try {
                this.userDefined = SHCreateView.FormatCR(line, "\n");
                this.parseView(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for DB2 failed!", e);
                this.importLog.addFailedStatement(SHCreateView.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseView(String statement) {
        this.statement = statement;
        this.allColumnsAreMade = true;
        if (this.allColumnsAreMade) {
            TableViewProxyDB2 viewProxy;
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            String nameView = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
            String viewName = this.getNameOnly(nameView);
            String ownerName = Token.getValBeforeCharacter(nameView, '.');
            if (storageDesign.importStorageObjectsOnly()) {
                this.view = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName(viewName);
            } else {
                this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
                if (ownerName != null && !"".equals(ownerName)) {
                    this.view.setSchema(ownerName);
                }
                this.view.setName(viewName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.view);
                if (!this.initCols()) {
                    this.initCol();
                }
                this.initUserDefinedSql();
            }
            if (storageDesign != null && (viewProxy = (TableViewProxyDB2)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                viewProxy.setDefinition(this.userDefined);
                this.initCheckOption(viewProxy);
                this.initOwner(viewProxy);
            }
        }
    }

    public boolean initCols() {
        String beforeSelect = Token.getStringBefore(this.statement, " as select ");
        if (Token.hasCloseAndOpenBrackets(beforeSelect)) {
            String cols = Token.getValBetweenBrackets(beforeSelect, 1);
            if (!"".equalsIgnoreCase(cols)) {
                StringTokenizer tokenizer = new StringTokenizer(cols, ",");
                String column = "";
                while (tokenizer.hasMoreTokens()) {
                    column = Token.removeQuotes(tokenizer.nextToken());
                    AbstractViewElement cvExp = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    cvExp.setName(column);
                    cvExp.setAlias(column);
                    cvExp.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                    this.view.add(cvExp);
                }
            }
            return true;
        }
        return false;
    }

    private void initCheckOption(TableViewProxyDB2 viewProxy) {
        String check = Token.getTokenAfter(this.statement, "WITH");
        if (check.equalsIgnoreCase("LOCAL")) {
            viewProxy.setCheckOptionScope("LOCAL");
        } else {
            viewProxy.setCheckOptionScope("CASCADED");
        }
        if (!check.equalsIgnoreCase("")) {
            viewProxy.setCheckOption(true);
        } else {
            viewProxy.setCheckOption(false);
        }
    }

    public void initCol() {
        String stmt = Token.getStringAfter(this.statement, "AS SELECT").trim();
        if (stmt.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            stmt = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!stmt.equalsIgnoreCase("")) {
            if (Token.hasToken(this.statement, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.toUpperCase().indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getNameAfterToken(column, "AS", '\"', '\"');
                    column = Token.getStringBeforeToken(column, "AS");
                }
                if ((column = Token.encodeQuotedString(column)).indexOf(" ") > -1) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else if (column.charAt(column.length() - 1) == '\'') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(39);
                        columnAlias = columnAlias.substring(lastIndex) + "'";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                if (!Token.hasCloseAndOpenBrackets(column) && column.indexOf(43) == -1 && column.indexOf(45) == -1 && column.indexOf(42) == -1 && column.indexOf(47) == -1 && column.indexOf("||") == -1 && column.indexOf(58) == -1 && !Token.hasToken(column, "CONCAT") && column.indexOf(46) > -1 && (column = column.substring(column.indexOf(46) + 1)).indexOf(46) > -1) {
                    column = column.substring(column.indexOf(46) + 1);
                }
                if ((column = Token.removeQuotes(Token.decodeQuotedString(column))).equalsIgnoreCase("") || column.equalsIgnoreCase("*")) continue;
                AbstractViewElement cvExp = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                cvExp.setName(column);
                cvExp.setExpression(column);
                cvExp.setAlias(column);
                cvExp.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                this.view.add(cvExp);
                if (columnAlias != null) {
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString(columnAlias));
                    cvExp.setAlias(columnAlias);
                    cvExp.setHeaderAlias(columnAlias);
                    continue;
                }
                cvExp.setAlias(cvExp.getName());
            }
        }
    }

    private void initUserDefinedSql() {
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("DB2");
    }

    private void initOwner(TableViewProxyDB2 tableViewProxy) {
        String ownerName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "VIEW").trim(), '.');
        if (!"".equalsIgnoreCase(ownerName)) {
            Owner owner = (Owner)((AbstractStorageDesignDB2)tableViewProxy.getStorageDesign()).getOwnerSet().getByName(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)tableViewProxy.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            tableViewProxy.setOwner(owner);
        } else if (this.getOwner() != null) {
            tableViewProxy.setOwner(this.getOwner());
        } else {
            tableViewProxy.setOwner(((AbstractStorageDesignDB2)tableViewProxy.getStorageDesign()).getOwnerSet().getDefaultOwner());
        }
    }

    public void setView(AbstractView view) {
        this.view = view;
    }
}

