/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.db2.AggregateFunctionsDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTable;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHColumnElementsDB2v80;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnIdentityDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.ColumnProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TablePartitionDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceSetDB2v80;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTableDB2v80
extends DDLStatementHandler
implements SectionConstants,
CreateTableHandler {
    protected LogicalDatatypeFactory factoryLogicalDatatype = new LogicalDatatypeFactory();
    protected Table table = null;
    protected RDBMSSite site = null;
    protected StorageDesignDB2v80 storageDesign = null;
    protected TableProxyDB2v80 tableProxy = null;
    private boolean createDomainsDuringImport;
    protected String tableName;
    protected String ownerName = null;
    protected ArrayList columns;
    protected List fkList;
    protected List refAtColumnList;
    protected List tableNodeList = new ArrayList();
    protected String inTablespace;
    private String inDatabase;
    protected String editproc;
    protected String validproc;
    protected String audit;
    protected String obid;
    protected boolean dataCapture;
    protected boolean restrict;
    protected String ccsid;
    protected String outSideBrackets;
    protected String inSideBrackets;
    protected String afterColumns;
    private boolean failed = false;
    protected static final Logger LOGGER = new Logger(SHCreateTableDB2v80.class);

    public SHCreateTableDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        block7: {
            String statement = SHCreateTableDB2v80.clearCR(line);
            if (!Token.startsWithString(statement, "create aux")) {
                if (Token.startsWithString(statement, "create table") || Token.startsWithString(statement, "create or replace table")) {
                    try {
                        this.failed = false;
                        this.fkList = new ArrayList();
                        this.refAtColumnList = new ArrayList();
                        this.parseTable(statement);
                        FKRefNode fkNode = new FKRefNode();
                        fkNode.processedTable = this.table;
                        fkNode.fkStatements = this.fkList;
                        fkNode.refAtColumns = this.refAtColumnList;
                        this.tableNodeList.add(fkNode);
                        if (this.failed) {
                            this.importLog.addFailedStatement(SHCreateTableDB2v80.FormatCR(line, "\n"));
                            break block7;
                        }
                        this.importLog.incrementImportedStatements();
                    }
                    catch (Exception e) {
                        LOGGER.error(" Parsing " + statement + " for DB2 8.0 failed!", e);
                        this.importLog.addFailedStatement(SHCreateTableDB2v80.FormatCR(line, "\n"));
                    }
                } else {
                    this.nextHandler(line);
                }
            } else {
                this.nextHandler(line);
            }
        }
    }

    protected void parseTable(String statement) {
        String tableAccess;
        this.setStatement(statement);
        this.outSideBrackets = SHCreateTableDB2v80.getValOutsideFirstBrackets(this.statement);
        this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1);
        this.afterColumns = statement.substring(statement.indexOf(41) + 1).trim();
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignDB2v80)this.design.getStorageDesign(this.site);
        if (this.storageDesign.importStorageObjectsOnly()) {
            this.table = this.ownerName != null && !"".equals(this.ownerName) ? this.design.getRelationalDesign().getTableSet().getBySchemaAndName(this.ownerName, this.tableName) : (Table)this.design.getRelationalDesign().getTableSet().getByName(this.tableName);
        } else {
            this.table = this.design.getRelationalDesign().createTable();
            this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        }
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.tableProxy = (TableProxyDB2v80)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.design.getAppView().getSettings().isCreateDomainsDuringImport();
        if (statement.toUpperCase().indexOf("AS (SELECT") > -1 || statement.toUpperCase().indexOf("AS ( SELECT") > -1) {
            if (statement.toUpperCase().indexOf("AS (SELECT") > -1) {
                this.inSideBrackets = Token.getStringBefore(statement, "AS (SELECT");
            } else if (statement.toUpperCase().indexOf("AS ( SELECT") > -1) {
                this.inSideBrackets = Token.getStringBefore(statement, "AS ( SELECT");
            }
            this.inSideBrackets = Token.getValBetweenBrackets(this.inSideBrackets);
            if (!this.storageDesign.importStorageObjectsOnly() && !this.initCols()) {
                this.initCol();
            }
            this.processMaterializedQuery();
        } else {
            this.columns = this.initColumns();
            for (int col = 0; col < this.columns.size(); ++col) {
                Owner owner;
                IndexProxyDB2 proxy;
                Map oneColumnMap = (Map)this.columns.get(col);
                boolean isConstraint = (Boolean)oneColumnMap.get("IS_CONSTRAINT");
                if (!isConstraint) {
                    String reference;
                    StringBuffer message;
                    Column column;
                    String columnName = (String)oneColumnMap.get("columnname");
                    if (this.storageDesign.importStorageObjectsOnly()) {
                        column = (Column)this.table.getElementByName(columnName);
                    } else {
                        column = this.table.createColumn(columnName);
                        this.design.getRelationalDesign().stampModelObjectDDL(column);
                        String datatype = (String)oneColumnMap.get("datatype");
                        String scale = (String)oneColumnMap.get("scale");
                        String size = (String)oneColumnMap.get("size");
                        String precision = (String)oneColumnMap.get("precision");
                        String[] parameters = new String[]{precision, scale, size};
                        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                        LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                        if (this.createDomainsDuringImport) {
                            Domain domain = null;
                            String typeName = (String)oneColumnMap.get("typename");
                            if (typeName != null) {
                                DomainSet domains = this.design.getDomainSet();
                                domain = (Domain)domains.getByName(typeName);
                            }
                            String domainName = "";
                            if (domain == null) {
                                domainName = DomainFactory.createDomainName(logicalDT, parameters);
                                domain = this.getCorrespondingDomain(domainName);
                            }
                            if (domain != null) {
                                column.setDomain(domain);
                            } else {
                                message = new StringBuffer("domain is null in SHCreateTableDB2v80.parseTable : ");
                                message.append(domainName);
                                LOGGER.error(message.toString());
                                this.importLog.addError("Null domain occurred while creating " + this.tableName);
                            }
                        } else {
                            column.setLogicalDatatype(logicalDT);
                            column.setUse((short)1);
                            column.setDataTypeParameter("scale", scale);
                            column.setDataTypeParameter("precision", precision);
                            column.setDataTypeParameter("size", size);
                        }
                        boolean notNull = (Boolean)oneColumnMap.get("NOT NULL");
                        column.setNullsAllowed(!notNull);
                        boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
                        if (isPK) {
                            Index pk = this.table.createIndex();
                            pk.add(column);
                            pk.makePK();
                            this.design.getRelationalDesign().stampModelObjectDDL(pk);
                        } else {
                            boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
                            if (isUnique) {
                                Index unique = this.table.createIndex();
                                unique.add(column);
                                unique.setIndexState("Unique Constraint");
                                this.design.getRelationalDesign().stampModelObjectDDL(unique);
                            }
                        }
                    }
                    if (this.storageDesign != null) {
                        String identity;
                        String fieldProc;
                        String forElement = (String)oneColumnMap.get("FOR");
                        String defaultElement = (String)oneColumnMap.get("DEFAULT");
                        ColumnProxyDB2v80 columnProxy = (ColumnProxyDB2v80)this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                        columnProxy.setBitData(forElement);
                        String[] defaultChoises = ColumnProxyDB2.getDefaultValueChoices();
                        if (defaultElement != null) {
                            boolean def = (Boolean)oneColumnMap.get("IS DEFAULT");
                            columnProxy.setDefault(def);
                            if (defaultElement.equalsIgnoreCase(defaultChoises[2]) || defaultElement.equalsIgnoreCase(defaultChoises[3])) {
                                columnProxy.setDefaultValue(defaultElement);
                            } else if (Token.hasCloseAndOpenBrackets(defaultElement)) {
                                columnProxy.setDefaultValue(defaultChoises[4]);
                                columnProxy.setDefaultValueConstant(defaultElement);
                            } else {
                                columnProxy.setDefaultValue(defaultChoises[1]);
                                columnProxy.setDefaultValueConstant(defaultElement);
                                column.setDefaultValue(defaultElement);
                            }
                        }
                        if ((fieldProc = (String)oneColumnMap.get("FIELDPROC")) != null) {
                            if (Token.hasCloseAndOpenBrackets(fieldProc)) {
                                String constant = Token.getValBetweenBrackets(fieldProc).trim();
                                columnProxy.setConstant(constant);
                                fieldProc = Token.getValBeforeBrackets(fieldProc).trim();
                            }
                            columnProxy.setProgram(fieldProc);
                        }
                        if ((identity = (String)oneColumnMap.get("GENERATED")) != null) {
                            String min;
                            String max;
                            Object ob;
                            String cache;
                            String incrementBy;
                            String startWith;
                            ColumnIdentityDB2v80 columnIdentity = (ColumnIdentityDB2v80)this.storageDesign.getColumnIdentitySet().createColumnIdentity();
                            this.design.getRelationalDesign().stampModelObjectDDL(columnIdentity);
                            columnIdentity.setColumn(columnProxy);
                            for (int i = 0; i < ColumnIdentityDB2.getGenerateValues().length; ++i) {
                                String value = ColumnIdentityDB2.getGenerateValues()[i];
                                if (!identity.equalsIgnoreCase(value)) continue;
                                columnIdentity.setGenerate(value);
                                break;
                            }
                            if ((startWith = (String)oneColumnMap.get("START")) != null) {
                                columnIdentity.setStartWith(startWith);
                            }
                            if ((incrementBy = (String)oneColumnMap.get("INCREMENT")) != null) {
                                try {
                                    int incrementByValue = Integer.parseInt(incrementBy);
                                    columnIdentity.setIncrementBy(incrementByValue);
                                }
                                catch (NumberFormatException e) {
                                    message = new StringBuffer("wrong Format for Increment value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(message.toString(), e);
                                    this.importLog.addWarning("Wrong INCREMENT format in statement " + statement);
                                }
                            }
                            if ((cache = (String)oneColumnMap.get("CACHE")) != null) {
                                try {
                                    int cacheValue = Integer.parseInt(cache);
                                    columnIdentity.setCache(cacheValue);
                                }
                                catch (NumberFormatException e) {
                                    StringBuffer message2 = new StringBuffer("wrong Format for Cache value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(message2.toString(), e);
                                    this.importLog.addWarning("Wrong CACHE format in statement " + statement);
                                }
                            }
                            if ((ob = oneColumnMap.get("CYCLE")) != null) {
                                boolean cycle = (Boolean)oneColumnMap.get("CYCLE");
                                columnIdentity.setCycle(cycle);
                            }
                            if ((ob = oneColumnMap.get("ORDER")) != null) {
                                String order = (String)oneColumnMap.get("ORDER");
                                columnIdentity.setOrder(order);
                            }
                            if ((max = (String)oneColumnMap.get("MAXVALUE")) != null) {
                                try {
                                    Integer.parseInt(max);
                                    columnIdentity.setMaxValue(max);
                                }
                                catch (NumberFormatException e) {
                                    StringBuffer message3 = new StringBuffer("wrong Format for MAXVALUE value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(message3.toString(), e);
                                    this.importLog.addWarning("Wrong MAXVALUE format in statement " + statement);
                                }
                            }
                            if ((min = (String)oneColumnMap.get("MINVALUE")) != null) {
                                try {
                                    Integer.parseInt(min);
                                    columnIdentity.setMinValue(min);
                                }
                                catch (NumberFormatException e) {
                                    StringBuffer message4 = new StringBuffer("wrong Format for MINVALUE value in SHCreateTable -> Init Identity: ");
                                    LOGGER.error(message4.toString(), e);
                                    this.importLog.addWarning("Wrong MINVALUE format in statement " + statement);
                                }
                            }
                            columnProxy.setColumnIdentity(columnIdentity);
                        }
                    }
                    if ((reference = (String)oneColumnMap.get("REFERENCES")) != null) {
                        RefAtColNode refNode = new RefAtColNode();
                        int posPoint = reference.indexOf(46);
                        if (posPoint > 0) {
                            reference = Token.getValAfterCharacter(reference, '.');
                        }
                        refNode.onDelete = (String)oneColumnMap.get("ON DELETE");
                        refNode.columnName = (String)oneColumnMap.get("columnname");
                        refNode.refColumn = (String)oneColumnMap.get("REFERENCED_COLUMN");
                        refNode.referencedTable = reference;
                        this.refAtColumnList.add(refNode);
                    }
                    String constr = (String)oneColumnMap.get("CONSTRAINT");
                    String check = (String)oneColumnMap.get("CHECK");
                    if (check == null) continue;
                    this.initCheckConstraint(check, constr, column);
                    continue;
                }
                String name = (String)oneColumnMap.get("CONSTRAINT_NAME");
                boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
                if (isPK) {
                    Index pk;
                    if (this.storageDesign.importStorageObjectsOnly()) {
                        pk = (Index)this.table.getPK();
                    } else {
                        pk = this.table.createIndex();
                        this.design.getRelationalDesign().stampModelObjectDDL(pk);
                    }
                    String pkOwner = null;
                    if (!"".equalsIgnoreCase(name)) {
                        int posPoint = name.indexOf(46);
                        if (posPoint > 0) {
                            pkOwner = Token.getValBeforeCharacter(name, '.');
                            name = Token.getValAfterCharacter(name, '.');
                        }
                        if (!this.storageDesign.importStorageObjectsOnly()) {
                            pk.setName(name);
                        }
                    } else {
                        if (this.tableName.length() > 125) {
                            this.tableName = this.tableName.substring(0, 125);
                        }
                        if (!this.storageDesign.importStorageObjectsOnly()) {
                            pk.setName(this.tableName + "_PK");
                        }
                    }
                    String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                    try {
                        if (!this.storageDesign.importStorageObjectsOnly()) {
                            SHCreateTable.setColumnsForIndexPK(pk, elements, this.importLog);
                            pk.makePK();
                        }
                        if ((proxy = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(pk.getObjectID())) == null) continue;
                        proxy.setName(pk.getName());
                        if (pkOwner == null) continue;
                        owner = (Owner)this.storageDesign.getOwnerSet().getByName(pkOwner);
                        if (owner == null) {
                            owner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                            owner.setName(pkOwner);
                            this.design.getRelationalDesign().stampModelObjectDDL(owner);
                        }
                        proxy.setOwner(owner);
                    }
                    catch (ObjectDoesNotExistException e) {
                        StringBuffer message = new StringBuffer(e.getMessage());
                        message.append(" in SHCreateTable.parseTable:PRIMARY KEY");
                        LOGGER.error(message.toString(), e);
                        this.importLog.addError("Columns for primary key " + pk.getName() + " don't exist.");
                        this.failed = true;
                    }
                    continue;
                }
                boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
                if (isUnique) {
                    Index unique;
                    String pkOwner = null;
                    if (!"".equalsIgnoreCase(name)) {
                        int posPoint = name.indexOf(46);
                        if (posPoint > 0) {
                            pkOwner = Token.getValBeforeCharacter(name, '.');
                            name = Token.getValAfterCharacter(name, '.');
                        }
                    } else {
                        if (this.tableName.length() > 123) {
                            this.tableName = this.tableName.substring(0, 123);
                        }
                        name = this.tableName + "_UK" + this.table.getUKeys().size();
                    }
                    if (this.storageDesign.importStorageObjectsOnly()) {
                        unique = this.table.getIndexByName(name);
                    } else {
                        unique = this.table.createIndex();
                        unique.setName(name);
                        this.design.getRelationalDesign().stampModelObjectDDL(unique);
                    }
                    if (!this.storageDesign.importStorageObjectsOnly()) {
                        String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                        try {
                            SHCreateTable.setColumnsForIndexPK(unique, elements, this.importLog);
                            unique.setIndexState("Unique Constraint");
                        }
                        catch (ObjectDoesNotExistException e) {
                            StringBuffer message = new StringBuffer(e.getMessage());
                            message.append(" in SHCreateTable.parseTable:UNIQUE");
                            LOGGER.error(message.toString(), e);
                            this.importLog.addError("Columns for unique key " + unique.getName() + " don't exist.");
                            this.failed = true;
                        }
                        unique.setIndexState("Unique Constraint");
                    }
                    if ((proxy = (IndexProxyDB2)this.storageDesign.getIndexProxySet().getProxy(unique.getObjectID())) == null) continue;
                    proxy.setName(unique.getName());
                    if (pkOwner == null) continue;
                    owner = (Owner)this.storageDesign.getOwnerSet().getByName(pkOwner);
                    if (owner == null) {
                        owner = (Owner)this.storageDesign.getOwnerSet().createElement(null);
                        owner.setName(pkOwner);
                        this.design.getRelationalDesign().stampModelObjectDDL(owner);
                    }
                    proxy.setOwner(owner);
                    continue;
                }
                boolean isTableConstraint = (Boolean)oneColumnMap.get("CHECK");
                if (!isTableConstraint) continue;
                String rule = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                if (this.tableName.length() > 123) {
                    this.tableName = this.tableName.substring(0, 123);
                }
                TableLevelConstraint constraint = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), rule);
                if (!"".equalsIgnoreCase(name)) {
                    constraint.setName(name);
                }
                this.table.addCheckConstraint(constraint);
                this.design.getRelationalDesign().stampModelObjectDDL(constraint);
            }
        }
        this.initDatabaseTablespace();
        this.processPartitioningClause();
        if (this.tableProxy != null) {
            TableSpaceSetDB2v80 tablespaceSet = (TableSpaceSetDB2v80)this.storageDesign.getTableSpaceSet();
            TableSpaceDB2 ts = tablespaceSet.getOrCreateTablespace(this.inDatabase, this.inTablespace);
            this.tableProxy.setTableSpace(ts);
            if (this.ownerName != null) {
                Owner owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().getByName(this.ownerName);
                if (owner == null) {
                    owner = (Owner)((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.ownerName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                this.tableProxy.setOwner(owner);
            } else if (this.getOwner() != null) {
                this.tableProxy.setOwner(this.getOwner());
            } else {
                this.tableProxy.setOwner(((AbstractStorageDesignDB2)this.tableProxy.getStorageDesign()).getOwnerSet().getDefaultOwner());
            }
        }
        this.editproc = this.initEditProc();
        if (this.tableProxy != null && !this.editproc.equals(" ") && this.editproc != null && !this.editproc.equals("")) {
            this.tableProxy.setEditProc(this.editproc);
        }
        this.validproc = this.initValidProc();
        if (this.tableProxy != null && !this.validproc.equals(" ") && this.validproc != null && !this.validproc.equals("")) {
            this.tableProxy.setValidProc(this.validproc);
        }
        this.audit = this.initAudit();
        if (this.tableProxy != null && !this.audit.equals(" ") && this.audit != null && !this.audit.equals("")) {
            this.tableProxy.setAudit(this.audit);
        }
        this.obid = this.initObid();
        if (this.tableProxy != null) {
            try {
                if (!this.obid.equals(" ") && this.obid != null && !this.obid.equals("")) {
                    this.tableProxy.setObid(Integer.parseInt(this.obid));
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format for Obid in SHCreateTable.parseTable : ");
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong OBID format in statement " + statement);
            }
        }
        this.dataCapture = this.initDataCapture();
        if (this.tableProxy != null) {
            this.tableProxy.setDataCapture(this.dataCapture);
        }
        this.restrict = this.initWithRestrictOnDrop();
        if (this.tableProxy != null) {
            this.tableProxy.setDropRestrict(this.restrict);
        }
        this.ccsid = this.initCcsid();
        if (this.tableProxy != null) {
            for (int i = 0; i < TableProxyDB2.getCcsidValues().length; ++i) {
                String ccsID = TableProxyDB2.getCcsidValues()[i];
                if (!this.ccsid.equalsIgnoreCase(ccsID)) continue;
                this.tableProxy.setCcsid(ccsID);
                break;
            }
        }
        if ((tableAccess = this.initVolatile()) != null) {
            this.tableProxy.setTableAccess(tableAccess);
        }
    }

    private void processPartitioningClause() {
        if (Token.hasToken(this.outSideBrackets, "PARTITION")) {
            this.tableProxy.setPartitioned("YES");
            String afterPartition = Token.getStringAfter(this.outSideBrackets, "PARTITION").trim();
            afterPartition = Token.getStringAfter(afterPartition, "BY");
            if (Token.getFirstToken(afterPartition).equalsIgnoreCase("RANGE")) {
                Token.cutFirstToken(afterPartition);
            }
            String partitionExpr = Token.getValBetweenBrackets(afterPartition, 1).trim();
            this.processPartitionExpr(partitionExpr);
            int bracketIndex = afterPartition.indexOf(41);
            String partitionElement = afterPartition.substring(bracketIndex + 1).trim();
            partitionElement = Token.getValBetweenBrackets(partitionElement);
            this.processPartitionElement(partitionElement);
        }
    }

    private void processPartitionElement(String partitionElement) {
        StringTokenizer tokenizer = new StringTokenizer(partitionElement, ",");
        String partition = "";
        int partNumber = 1;
        while (tokenizer.hasMoreTokens()) {
            partition = tokenizer.nextToken().trim();
            if (!partition.startsWith("PARTITION")) continue;
            TablePartitionDB2v80 part = (TablePartitionDB2v80)((StorageDesignDB2v80)this.tableProxy.getStorageDesign()).getTablePartitionSet().createElement(null);
            part.setTable(this.tableProxy);
            this.design.getRelationalDesign().stampModelObjectDDL(part);
            partition = Token.cutFirstToken(partition);
            try {
                partNumber = new Integer(Token.getFirstToken(partition));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            part.setPartNumber(partNumber);
            if (!Token.hasCloseAndOpenBrackets(partition)) continue;
            part.setPartConstants(Token.getValBetweenBrackets(partition));
        }
    }

    private void processPartitionExpr(String partitionExpr) {
        StringTokenizer tokenizer = new StringTokenizer(partitionExpr, ",");
        String col = "";
        while (tokenizer.hasMoreTokens()) {
            col = tokenizer.nextToken().trim();
            this.tableProxy.setPartitioningKey(Token.getFirstToken(col));
            this.tableProxy.setPartitioningKey(Token.getLastToken(col));
        }
    }

    private void processMaterializedQuery() {
        String materialized = Token.getStringAfter(this.afterColumns, "AS ( SELECT");
        if (materialized.equalsIgnoreCase("")) {
            materialized = Token.getStringAfter(this.afterColumns, "AS (SELECT");
        }
        if (!materialized.equalsIgnoreCase("")) {
            this.tableProxy.setMaterializedQuery("YES");
            materialized = Token.getStringAfterToken(this.afterColumns, "AS");
            String fullselect = Token.getValBetweenBrackets(materialized, 1);
            this.tableProxy.setMqQueryDefinition(fullselect);
            materialized = Token.getStringAfter(materialized, fullselect).trim();
            materialized = Token.cutFirstToken(materialized);
            if (materialized.toUpperCase().startsWith("WITH NO DATA")) {
                this.processCopyOption(materialized.substring(12).trim());
            } else {
                this.processRefreshableOptions(materialized);
            }
        }
    }

    private void processRefreshableOptions(String materialized) {
        if (materialized.toUpperCase().startsWith("DATA INITIALLY DEFERRED")) {
            if (Token.hasString(materialized, "BY USER")) {
                this.tableProxy.setMqMaintenance("BY USER");
            } else {
                this.tableProxy.setMqMaintenance("BY SYSTEM");
            }
            if (Token.hasString(materialized, "ENABLE")) {
                this.tableProxy.setMqQueryOptimization("ENABLE");
            } else {
                this.tableProxy.setMqQueryOptimization("DISABLE");
            }
        }
    }

    private void processCopyOption(String materialized) {
        if (materialized.toUpperCase().startsWith("INCLUDING IDENTITY")) {
            this.tableProxy.setMqIdentityColumnAttr("INCLUDE");
        } else {
            this.tableProxy.setMqIdentityColumnAttr("EXCLUDE");
        }
        if (Token.hasString(materialized, "INCLUDING COLUMN DEFAULTS") || Token.hasString(materialized, "INCLUDING DEFAULTS")) {
            this.tableProxy.setMqColumnDefaults("INCLUDING");
        } else if (Token.hasString(materialized, "USING TYPE DEFAULTS")) {
            this.tableProxy.setMqColumnDefaults("USING TYPE DEFAULTS");
        } else {
            this.tableProxy.setMqColumnDefaults("EXCLUDING");
        }
    }

    private String initTableName() {
        String name = Token.getNameAfterToken(this.outSideBrackets, "TABLE", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.ownerName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void initDatabaseTablespace() {
        String database = Token.getTokenAfter(this.outSideBrackets, "IN");
        if (database.equalsIgnoreCase("DATABASE")) {
            this.inTablespace = "";
            this.inDatabase = "";
        } else if (database.indexOf(46) > 0) {
            this.inTablespace = Token.getValAfterCharacter(database, '.');
            this.inDatabase = Token.getValBeforeCharacter(database, '.');
        } else {
            this.inTablespace = database;
            this.inDatabase = "";
        }
    }

    private boolean initCols() {
        String columnStatement = this.inSideBrackets;
        columnStatement = Token.getNamesOnly(columnStatement);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            if (this.storageDesign.importStorageObjectsOnly()) continue;
            Column col = this.table.createColumn(oneColumn);
            this.design.getRelationalDesign().stampModelObjectDDL(col);
        }
        return false;
    }

    public void initCol() {
        if (Token.hasToken(this.statement, "AS")) {
            this.table.setTypeID("4");
            String stmt = Token.getStringAfter(this.statement, "SELECT").trim();
            if (Token.hasToken(this.statement, "FROM")) {
                int fromInd = stmt.indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            block1: while (tokenizer.hasMoreTokens()) {
                Column col2;
                Table tbl;
                String tableName;
                StringTokenizer st;
                int pos;
                Column col;
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    int asIndex = column.lastIndexOf(" AS ");
                    columnAlias = column.substring(asIndex);
                    columnAlias = Token.cutFirstToken(columnAlias);
                    columnAlias = Token.removeQuotes(columnAlias);
                    column = column.substring(0, asIndex);
                    Token.removeQuotes(column);
                }
                if ((column = Token.encodeQuotedString(column)).indexOf(" ") > -1) {
                    int lastIndex;
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else if (column.charAt(column.length() - 1) == '\'') {
                        columnAlias = column.substring(0, column.length() - 1);
                        lastIndex = columnAlias.lastIndexOf(39);
                        columnAlias = columnAlias.substring(lastIndex) + "'";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                column = Token.removeQuotes(Token.decodeQuotedString(column));
                String function = null;
                String tblName = null;
                if (!Token.hasCloseAndOpenBrackets(column) && column.indexOf(43) == -1 && column.indexOf(45) == -1 && column.indexOf(42) == -1 && column.indexOf(47) == -1 && column.indexOf(58) == -1 && column.indexOf("||") == -1 && !Token.hasToken(column, "CONCAT") && column.indexOf(46) > -1) {
                    if (column.indexOf(46) > -1) {
                        tblName = column.substring(0, column.indexOf(46));
                        column = column.substring(column.lastIndexOf(46) + 1);
                        if (tblName.indexOf(46) > -1) {
                            tblName = tblName.substring(tblName.lastIndexOf(46) + 1);
                        }
                    }
                } else {
                    function = column;
                }
                if (columnAlias != null && !columnAlias.equalsIgnoreCase("")) {
                    col = this.table.createColumn(Token.getNamesOnly(columnAlias));
                    this.design.getRelationalDesign().stampModelObjectDDL(col);
                    if (function != null) {
                        if (this.isAggregateFunction(function)) {
                            col.setSourceType("Aggregate");
                        } else {
                            col.setSourceType("Derived");
                        }
                        col.setFormulaDesc(function);
                        continue;
                    }
                    if (!Token.hasToken(this.statement, "FROM")) continue;
                    stmt = Token.getStringAfter(this.statement, "FROM").trim();
                    pos = -1;
                    if (Token.hasToken(stmt, "WHERE")) {
                        pos = stmt.indexOf("WHERE");
                    } else if (Token.hasToken(stmt, "GROUP")) {
                        pos = stmt.indexOf("GROUP");
                    }
                    if (pos > -1) {
                        stmt = stmt.substring(0, pos);
                    }
                    st = new StringTokenizer(stmt, ",");
                    while (st.hasMoreTokens()) {
                        tableName = st.nextToken().trim();
                        if (tableName.indexOf(46) > -1) {
                            tableName = tableName.substring(tableName.lastIndexOf(46) + 1);
                        }
                        if (!Token.hasToken(tableName, tblName)) continue;
                        tableName = tableName.startsWith("\"") ? Token.getValBetweenDoubleQuotes(tableName).trim() : Token.getFirstToken(tableName);
                        tbl = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(tableName);
                        if (tbl == null || (col2 = (Column)tbl.getElementByName(column)) == null) continue;
                        col.setDomain(col2.getDomain());
                        continue block1;
                    }
                    continue;
                }
                if (column.equalsIgnoreCase("") || column.equalsIgnoreCase("*")) continue;
                col = this.table.createColumn(column);
                this.design.getRelationalDesign().stampModelObjectDDL(col);
                if (!Token.hasToken(this.statement, "FROM")) continue;
                stmt = Token.getStringAfter(this.statement, "FROM").trim();
                pos = -1;
                if (Token.hasToken(stmt, "WHERE")) {
                    pos = stmt.indexOf("WHERE");
                } else if (Token.hasToken(stmt, "GROUP")) {
                    pos = stmt.indexOf("GROUP");
                }
                if (pos > -1) {
                    stmt = stmt.substring(0, pos);
                }
                st = new StringTokenizer(stmt, ",");
                while (st.hasMoreTokens()) {
                    tableName = st.nextToken().trim();
                    if (tableName.indexOf(46) > -1) {
                        tableName = tableName.substring(tableName.lastIndexOf(46) + 1);
                    }
                    if (!Token.hasToken(tableName, tblName)) continue;
                    tableName = tableName.startsWith("\"") ? Token.getValBetweenDoubleQuotes(tableName).trim() : Token.getFirstToken(tableName);
                    tbl = (Table)this.storageDesign.getPhysicalDesign().getTableSet().getByName(tableName);
                    if (tbl == null || (col2 = (Column)tbl.getElementByName(column)) == null) continue;
                    col.setDomain(col2.getDomain());
                    continue block1;
                }
            }
        }
    }

    private boolean isAggregateFunction(String function) {
        String[] functions = AggregateFunctionsDB2.FUNCTIONS_V8;
        for (int i = 0; i < functions.length; ++i) {
            String token = functions[i];
            if (!function.toUpperCase().startsWith(token.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private ArrayList initColumns() {
        ArrayList<Map> tableColumns = new ArrayList<Map>();
        String columnStatement = this.inSideBrackets;
        SHColumnElementsDB2v80 elements = new SHColumnElementsDB2v80();
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            Map elementsColumn;
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            if (Boolean.TRUE.equals((elementsColumn = elements.getElementsColumn(oneColumn.trim(), Token.hasToken(this.statement, "AS") && Token.hasToken(this.statement, "SELECT"))).get("IS_CONSTRAINT")) && oneColumn.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(oneColumn);
                continue;
            }
            tableColumns.add(elementsColumn);
        }
        return tableColumns;
    }

    private String initEditProc() {
        return Token.getTokenAfter(this.outSideBrackets, "EDITPROC").trim();
    }

    private String initValidProc() {
        return Token.getTokenAfter(this.outSideBrackets, "VALIDPROC").trim();
    }

    private String initAudit() {
        return Token.getTokenAfter(this.outSideBrackets, "AUDIT").trim();
    }

    private String initObid() {
        return Token.getTokenAfter(this.outSideBrackets, "OBID").trim();
    }

    private boolean initDataCapture() {
        String dataCapture = Token.getTokenAfter(this.outSideBrackets, "CAPTURE");
        return dataCapture.equalsIgnoreCase("CHANGES");
    }

    private boolean initWithRestrictOnDrop() {
        return Token.hasToken(this.outSideBrackets, "RESTRICT");
    }

    private String initCcsid() {
        return Token.getTokenAfter(this.outSideBrackets, "CCSID").trim();
    }

    private String initVolatile() {
        return Token.getTokenAfter(this.outSideBrackets, "VOLATILE").trim();
    }

    private void initCheckConstraint(String check, String name, Column column) {
        CheckConstraint constraint = new CheckConstraint();
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        constraint.add(this.storageDesign.getRDBMSType(), check);
        if (!"".equalsIgnoreCase(name) && name != null) {
            constraint.setName(name);
            column.setConstraintName(name);
        } else {
            String columnName = column.getName();
            if (columnName.length() > 25) {
                columnName = columnName.substring(0, 25);
            }
            name = columnName + "_CHCK";
            constraint.setName(name);
            column.setConstraintName(name);
        }
        column.setUseDomainConstraints(false);
        column.setCheck(constraint);
    }

    private Table getReferencedTable(String reference) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Table tableReferenced = (Table)tableSet.getByName(reference);
        if (tableReferenced != null) {
            return tableReferenced;
        }
        throw new ObjectDoesNotExistException("Table with name " + reference);
    }

    public Table getTable() {
        return this.table;
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.design.getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }

    private void addForeignKey(String line, Table processedTable) {
        block17: {
            Table tableRef;
            ArrayList<Column> columnsRef;
            String nameFK;
            block18: {
                nameFK = null;
                if (Token.hasToken(line, "CONSTRAINT")) {
                    nameFK = Token.getTokenAfter(line, "CONSTRAINT");
                } else {
                    nameFK = Token.getTokenAfter(line, "KEY");
                    int brpos = nameFK.indexOf("(");
                    if (brpos > 0) {
                        nameFK = nameFK.substring(0, brpos);
                    } else if (brpos == 0) {
                        nameFK = null;
                    }
                }
                int positionBracket = line.indexOf(41);
                String firstBrackets = line.substring(0, positionBracket + 1).trim();
                String columns = Token.getValBetweenBrackets(firstBrackets);
                List columnNames = this.getColumnNames(columns);
                columnsRef = new ArrayList<Column>();
                Column[] columnSet = (Column[])processedTable.getElements();
                for (String name : columnNames) {
                    for (int ci = 0; ci < columnSet.length; ++ci) {
                        String colname = columnSet[ci].getName().trim();
                        if (!name.equalsIgnoreCase(colname)) continue;
                        columnsRef.add(columnSet[ci]);
                    }
                }
                int positionReference = line.toUpperCase().indexOf("REFERENCES");
                line = line.substring(positionReference);
                String nameReferenced = Token.getTokenAfter(line, "REFERENCES");
                String nameRef = this.getNameFor(nameReferenced);
                tableRef = this.getTableFor(nameRef = Token.removeQuotes(nameRef));
                if (tableRef == null) break block17;
                boolean hasBrackets = Token.hasString(line, "(");
                if (!hasBrackets) break block18;
                String columnsReferenced = Token.getValBetweenBrackets(line);
                List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                if (index == null) break block17;
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (!hasOnDelete) break block17;
                String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                String[] choisesDelete = fkass.getDeleteRuleChoices();
                for (int choise = 0; choise < choisesDelete.length; ++choise) {
                    if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                    fkass.setDeleteRule(choisesDelete[choise]);
                    break block17;
                }
                break block17;
            }
            FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            Index index = (Index)tableRef.getPK();
            if (index != null) {
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (hasOnDelete) {
                    String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                    String[] choisesDelete = fkass.getDeleteRuleChoices();
                    for (int choise = 0; choise < choisesDelete.length; ++choise) {
                        if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                        fkass.setDeleteRule(choisesDelete[choise]);
                        break;
                    }
                }
            }
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            token = Token.removeQuotes(token);
            columns.add(token.trim());
        }
        return columns;
    }

    private String getNameFor(String name) {
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        Index index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = (Column)index.getElements()[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        Index index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    Column getColumnByName(Table processedTable, String columnName) {
        Column[] cols = (Column[])processedTable.getElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getName().equalsIgnoreCase(columnName)) continue;
            return cols[i];
        }
        return null;
    }

    private void processRefAtColumn(RefAtColNode refNode, Table processedTable) {
        String reference = this.getNameFor(refNode.referencedTable);
        Table referencedtable = null;
        try {
            referencedtable = this.getReferencedTable(reference);
        }
        catch (ObjectDoesNotExistException e) {
            // empty catch block
        }
        if (referencedtable != null) {
            Index indexOfreference;
            ArrayList<String> refColName = new ArrayList<String>();
            if (refNode.refColumn != null) {
                refColName.add(refNode.refColumn);
                indexOfreference = this.getUniqueIndexForColumnNames(referencedtable, refColName);
            } else {
                indexOfreference = (Index)referencedtable.getPK();
            }
            if (indexOfreference != null) {
                FKIndexAssociation fk = processedTable.addFK(indexOfreference);
                this.design.getRelationalDesign().stampModelObjectDDL(fk);
                ArrayList<Column> columnsRef = new ArrayList<Column>();
                Column column = this.getColumnByName(processedTable, refNode.columnName);
                if (column != null) {
                    columnsRef.add(column);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fk, columnsRef, indexOfreference);
                    } else {
                        this.fixFKColumns(fk, columnsRef, indexOfreference);
                    }
                    if (refNode.onDelete != null) {
                        String[] choisesDelete = fk.getDeleteRuleChoices();
                        for (int choise = 0; choise < choisesDelete.length; ++choise) {
                            if (!refNode.onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                            fk.setDeleteRule(choisesDelete[choise]);
                            break;
                        }
                    }
                }
            }
        }
    }

    public static String getValOutsideFirstBrackets(String string) {
        try {
            if (string != null) {
                StringBuffer value = new StringBuffer();
                int firstOpen = string.indexOf(40);
                int firstClose = string.indexOf(41);
                if (firstOpen != -1 && firstClose != -1) {
                    value.append(string.substring(0, firstOpen));
                    value.append(' ');
                    value.append(string.substring(firstClose + 1, string.length()));
                }
                return value.toString();
            }
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error in getValOutsideBrackets:", e);
            return "";
        }
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode node : this.tableNodeList) {
            for (String line : node.fkStatements) {
                this.addForeignKey(line, node.processedTable);
            }
            Iterator itcolref = node.refAtColumns.iterator();
            while (itcolref.hasNext()) {
                this.processRefAtColumn((RefAtColNode)itcolref.next(), node.processedTable);
            }
        }
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

