/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDirectoryOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateDirectoryOracle.class);

    public SHCreateDirectoryOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDirectoryOracle.clearCR(line);
        if (Token.startsWithString(statement, "CREATE DIRECTORY") || Token.startsWithString(statement, "CREATE OR REPLACE DIRECTORY")) {
            try {
                this.parseDirectory(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateDirectoryOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseDirectory(String statement) {
        DirectoryOracle dir;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (stoDesign != null && (dir = stoDesign.getDirectorySet().createDirectory()) != null) {
            this.initName(dir);
            this.initDirPath(dir);
            this.design.getRelationalDesign().stampModelObjectDDL(dir);
        }
    }

    private void initName(DirectoryOracle dir) {
        String startOfName = Token.getStringAfterToken(this.statement, "DIRECTORY");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        dir.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            dir.setNameHasQuotes(true);
        }
    }

    private void initDirPath(DirectoryOracle dir) {
        String path = Token.getStringAfterToken(this.statement, "AS").trim();
        if (path.startsWith("'")) {
            path = Token.getValBetweenQuotationMarks(path);
        }
        dir.setDirPath(path);
    }
}

