/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSynonymOracle
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateSynonymOracle.class);
    private String userName;

    public SHCreateSynonymOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        boolean canHandle = false;
        String statement = SHCreateSynonymOracle.clearCR(line);
        if (Token.getFirstToken(statement).equalsIgnoreCase("CREATE")) {
            String firstToken;
            String restOfText = Token.cutTokenFromFront(statement, "CREATE");
            if (Token.startsWithString(restOfText, "OR REPLACE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "OR REPLACE");
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("EDITIONABLE") || firstToken.equalsIgnoreCase("NONEDITIONABLE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("PUBLIC")) {
                restOfText = Token.cutTokenFromFront(restOfText, "PUBLIC");
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("SYNONYM")) {
                canHandle = true;
            }
        }
        if (canHandle) {
            try {
                this.parseSynonym(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateSynonymOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSynonym(String statement) {
        SynonymOracle synonym;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOracle stoDesign = (StorageDesignOracle)this.design.getStorageDesign(site);
        if (stoDesign != null && (synonym = stoDesign.getSynonymSet().createSynonym()) != null) {
            this.initName(synonym);
            this.initUser(synonym, stoDesign);
            this.initPublic(synonym);
            this.initFor(synonym, stoDesign);
            this.design.getRelationalDesign().stampModelObjectDDL(synonym);
        }
    }

    private void initName(SynonymOracle synonym) {
        String startOfName = Token.getStringAfterToken(this.statement, "SYNONYM");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.userName = name.substring(0, posPoint);
            name = name.substring(posPoint + 1);
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        synonym.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            synonym.setNameHasQuotes(true);
        }
    }

    private void initUser(SynonymOracle synonym, StorageDesignOracle storageDesign) {
        if (this.userName != null) {
            UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(this.userName);
            if (user == null) {
                user = storageDesign.getUserSet().createUser();
                user.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            synonym.setUser(user);
        }
    }

    private void initPublic(SynonymOracle synonym) {
        String temp = this.statement;
        String token = null;
        while (temp.length() > 0) {
            token = Token.getFirstToken(temp);
            temp = Token.cutTokenFromFront(temp, token);
            if (token.equalsIgnoreCase("SYNONYM")) break;
            if (!token.equalsIgnoreCase("PUBLIC")) continue;
            synonym.setPublic("YES");
        }
    }

    private void initFor(SynonymOracle synonym, StorageDesignOracle storageDesign) {
        if (Token.hasToken(this.statement, "FOR")) {
            int pos;
            int posPoint;
            String forString = Token.getStringAfterToken(this.statement, "FOR");
            String object = Token.getFirstName(forString, '\"', '\"');
            int atPos = object.indexOf(64);
            if (atPos > -1) {
                object = Token.getValBeforeCharacter(object, '@');
            }
            if ((posPoint = object.indexOf(46)) > 0) {
                String objectUser = Token.getValBeforeCharacter(object, '.');
                object = Token.getValAfterCharacter(object, '.');
                UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(objectUser);
                if (user == null) {
                    user = storageDesign.getUserSet().createUser();
                    user.setName(objectUser);
                    this.design.getRelationalDesign().stampModelObjectDDL(user);
                }
                synonym.setObjectUser(user);
                forString = forString.substring(forString.indexOf(46) + 1);
            }
            synonym.setObject(object);
            if (forString.startsWith("\"") && !object.equals(object.toUpperCase())) {
                synonym.setObjNameHasQuotes(true);
            }
            if ((pos = forString.indexOf(64)) > -1) {
                String dbLink = forString.substring(pos + 1).trim();
                synonym.setDBLink(dbLink);
            }
        }
    }
}

