/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewOracle
extends DDLStatementHandler
implements StatementsConstants {
    private static final Logger LOGGER = new Logger(SHCreateViewOracle.class);
    private AbstractView view;

    public SHCreateViewOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        boolean canHandle = false;
        String statement = SHCreateViewOracle.clearCR(line);
        if (Token.getFirstToken(statement).equalsIgnoreCase("CREATE")) {
            String firstToken;
            String restOfText = Token.cutTokenFromFront(statement, "CREATE");
            if (Token.startsWithString(restOfText, "OR REPLACE")) {
                restOfText = Token.cutTokenFromFront(restOfText, "OR REPLACE");
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("FORCE") || firstToken.equalsIgnoreCase("NOFORCE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if ((firstToken = Token.getFirstToken(restOfText)).equalsIgnoreCase("EDITIONABLE") || firstToken.equalsIgnoreCase("NONEDITIONABLE")) {
                restOfText = Token.cutTokenFromFront(restOfText, firstToken);
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("EDITIONING")) {
                restOfText = Token.cutTokenFromFront(restOfText, "EDITIONING");
            }
            if (Token.getFirstToken(restOfText).equalsIgnoreCase("VIEW")) {
                canHandle = true;
            }
        }
        if (canHandle) {
            try {
                this.parseView(statement, line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateViewOracle.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseView(String statement, String line) {
        TableViewProxyOracle viewProxy;
        RDBMSSite site;
        StorageDesignOracle storageDesign;
        String viewName;
        this.statement = statement;
        this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
        String viewLongName = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"');
        int bracketIndex = viewLongName.indexOf("(");
        if (bracketIndex > -1) {
            viewLongName = viewLongName.substring(0, bracketIndex);
        }
        if (!(viewName = this.getNameOnly(viewLongName)).equals(viewName.toUpperCase())) {
            this.view.setNameHasQuotes(this.nameHasQuotes());
        }
        this.initStructuredType();
        this.initUserDefinedSql(statement);
        if (this.view.getBasedOnStructuredType() == null) {
            this.initCols();
        }
        if ((storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())) != null && (viewProxy = (TableViewProxyOracle)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
            viewProxy.setDefinition(line);
            String createType = Token.getStringBeforeToken(this.statement, "VIEW");
            if (Token.hasToken(createType, "FORCE")) {
                viewProxy.setForce("YES");
            }
            if (Token.hasToken(createType, "EDITIONING") && storageDesign instanceof StorageDesignOraclev11g) {
                ((TableViewProxyOraclev10g)viewProxy).setEditioning("YES");
            }
            String withStmt = Token.getStringAfter(this.statement, "WITH");
            this.initCheckOption(viewProxy, withStmt);
            this.initReadOnly(viewProxy, withStmt);
            this.initConstraint(viewProxy, withStmt);
            this.initOwner(viewProxy);
        }
        this.view.setName(viewName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.view);
    }

    private boolean nameHasQuotes() {
        String startOfName = Token.getStringAfter(this.statement, "VIEW");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        if (name.indexOf(46) > 0) {
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        return startOfName.startsWith("\"");
    }

    private void initStructuredType() {
        String beforeAsSelect = Token.getStringBefore(this.statement, "AS SELECT ");
        String stName = Token.getNameAfterToken(beforeAsSelect, "OF", '\"', '\"');
        if (!stName.equals("")) {
            TableViewProxyOracle viewProxy;
            RDBMSSite site;
            StorageDesignOracle storageDesign;
            StructuredType stType;
            int posPoint = stName.indexOf(46);
            if (posPoint > 0) {
                stName = Token.getValAfterCharacter(stName, '.');
            }
            if ((stType = (StructuredType)this.design.getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                this.view.setBasedOnStructuredType(stType);
            } else {
                LOGGER.error("Unable to find required Structured Type: " + stName);
            }
            if (Token.hasToken(beforeAsSelect, "UNDER")) {
                String superViewUserName = "";
                String superViewName = Token.getNameAfterToken(beforeAsSelect, "UNDER", '\"', '\"');
                posPoint = superViewName.indexOf(46);
                if (posPoint > 0) {
                    superViewUserName = superViewName.substring(0, posPoint);
                    superViewName = Token.getValAfterCharacter(superViewName, '.');
                }
                MultiShapedDesignObject superView = null;
                if (!"".equals(superViewUserName)) {
                    superView = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(superViewUserName, superViewName);
                }
                if (superView == null) {
                    superView = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName(superViewName);
                }
                if (superView != null) {
                    ContainerView parentTV = (ContainerView)superView.getTopView();
                    ContainerView childTV = (ContainerView)this.view.getTopView();
                    if (parentTV != null && childTV != null) {
                        TypeSubstitution ts = this.design.getRelationalDesign().createTypeSubstitution();
                        this.design.getRelationalDesign().stampModelObjectDDL(ts);
                        ts.setChildCV(childTV);
                        ts.setParentCV(parentTV);
                        ts.addToAllDPVs();
                    }
                }
            }
            if (stName.equalsIgnoreCase("XMLTYPE") && (Token.hasString(beforeAsSelect, "WITH OBJECT IDENTIFIER") || Token.hasString(beforeAsSelect, "WITH OBJECT ID")) && (storageDesign = (StorageDesignOracle)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())) != null && (viewProxy = (TableViewProxyOracle)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                String oid;
                String schemaSpec = Token.getStringAfterToken(Token.getStringBefore(beforeAsSelect, "WITH OBJECT"), "XMLTYPE").trim();
                if (!"".equals(schemaSpec) && Token.hasToken(schemaSpec, "ELEMENT")) {
                    String schemaUrl = Token.getStringBeforeToken(schemaSpec, "ELEMENT").trim();
                    if (!"".equals(schemaUrl) && Token.hasToken(schemaUrl, "XMLSCHEMA")) {
                        schemaUrl = Token.getQuotedNameAfterToken(schemaSpec, "XMLSCHEMA").trim();
                        viewProxy.setXmlSchemaUrl(schemaUrl);
                    }
                    String schemaElement = Token.getQuotedNameAfterToken(schemaSpec, "ELEMENT").trim();
                    viewProxy.setXmlSchemaElement(schemaElement);
                }
                if ((oid = Token.getStringAfter(beforeAsSelect, "WITH OBJECT IDENTIFIER")).equals("")) {
                    oid = Token.getStringAfter(beforeAsSelect, "WITH OBJECT ID");
                }
                if (oid.toUpperCase().startsWith("DEFAULT")) {
                    viewProxy.setUseOID("DEFAULT");
                } else {
                    viewProxy.setUseOID("LIST OF ATTRIBUTES");
                    oid = Token.getValBetweenBrackets(oid);
                    oid = oid.replaceAll("\"", "");
                    viewProxy.setOidAttributes(oid);
                    ((TableView)this.view).setOidText(oid);
                }
            }
        }
    }

    private void initCheckOption(TableViewProxyOracle viewProxy, String withStmt) {
        if (withStmt.toUpperCase().indexOf("CHECK OPTION") > -1) {
            viewProxy.setCheckOption(true);
        } else {
            viewProxy.setCheckOption(false);
        }
    }

    private void initReadOnly(TableViewProxyOracle viewProxy, String withStmt) {
        if (withStmt.toUpperCase().indexOf("READ ONLY") > -1) {
            viewProxy.setReadOnly("YES");
        } else {
            viewProxy.setReadOnly("NO");
        }
    }

    private void initConstraint(TableViewProxyOracle viewProxy, String withStmt) {
        if (withStmt.toUpperCase().indexOf("CONSTRAINT") > -1) {
            viewProxy.setCheckOptionName(Token.getStringAfterToken(withStmt, "CONSTRAINT"));
        }
    }

    private void initUserDefinedSql(String statement) {
        String afterAsSelect = Token.getStringAfter(statement, "AS SELECT").trim();
        this.view.setUserDefinedSQL("SELECT " + afterAsSelect);
        this.view.setUserDefined(true);
    }

    public void initCols() {
        String stmt;
        String cols;
        ArrayList<String> columnList = null;
        this.statement = this.removeClosingBrackets(this.statement);
        String beforeSelect = Token.getStringBefore(this.statement, "AS SELECT ");
        if (!Token.hasToken(beforeSelect, "OF") && Token.hasCloseAndOpenBrackets(beforeSelect) && !"".equalsIgnoreCase(cols = Token.getValBetweenBrackets(beforeSelect, 1))) {
            columnList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(cols, ",");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken().trim();
                String entryUC = entry.toUpperCase();
                if (entryUC.startsWith("CONSTRAINT ") || entryUC.startsWith("UNIQUE ") || entryUC.startsWith("PRIMARY ") || entryUC.startsWith("FOREIGN ") || entryUC.startsWith("CHECK ")) continue;
                columnList.add(Token.getFirstName(entry, '\"', '\"'));
            }
        }
        if ((stmt = Token.getStringAfter(this.statement, "AS SELECT").trim()).equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            stmt = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!stmt.equals("")) {
            String afterFrom = "";
            if (Token.hasToken(stmt, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf(" FROM ");
                String beforeFrom = stmt.substring(0, fromInd);
                afterFrom = stmt.substring(fromInd + 6);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")") && (fromInd = stmt.toUpperCase().indexOf(" FROM ", fromInd + 1)) > -1) {
                    beforeFrom = stmt.substring(0, fromInd);
                    afterFrom = stmt.substring(fromInd + 6);
                }
                stmt = beforeFrom;
            }
            if (Token.hasToken(afterFrom, "WHERE")) {
                afterFrom = Token.getStringBeforeToken(afterFrom, "WHERE");
            }
            String[] match = new String[]{"CONNECT", "START", "GROUP", "HAVING", "MODEL", "UNION", "INTERSECT", "MINUS", "ORDER"};
            String afterFromUC = Token.getStringToFirstMatch(afterFrom.toUpperCase(), match);
            afterFrom = afterFrom.substring(0, afterFromUC.length());
            afterFrom = Token.replaceAll(Token.replaceAll(afterFrom, " INNER ", " "), " inner ", " ");
            afterFrom = Token.replaceAll(Token.replaceAll(afterFrom, " OUTER ", " "), " outer ", " ");
            afterFrom = Token.replaceAll(Token.replaceAll(afterFrom, " JOIN ", ","), " join ", ",");
            StringTokenizer fromTokenizer = new StringTokenizer(afterFrom, ",");
            while (fromTokenizer.hasMoreTokens()) {
                ContainerObject tableOrView = null;
                String fromEntry = fromTokenizer.nextToken();
                String objectName = Token.getFirstName(fromEntry, '\"', '\"');
                String userName = "";
                int dotIndex = objectName.indexOf(46);
                if (dotIndex > -1) {
                    userName = objectName.substring(0, dotIndex);
                    userName = Token.removeQuotes(userName);
                    objectName = objectName.substring(dotIndex + 1);
                }
                objectName = Token.removeQuotes(objectName);
                if (!"".equals(userName) && (tableOrView = this.design.getRelationalDesign().getTableSet().getBySchemaAndName(userName, objectName)) == null) {
                    tableOrView = (TableView)this.design.getRelationalDesign().getTableViewSet().getBySchemaAndName(userName, objectName);
                }
                if (tableOrView == null && (tableOrView = (Table)this.design.getRelationalDesign().getTableSet().getByName(objectName)) == null) {
                    tableOrView = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(objectName);
                }
                if (tableOrView == null) continue;
                String aliasName = "";
                int objectNameIndex = fromEntry.indexOf(objectName);
                if (objectNameIndex > -1) {
                    String afterObject = fromEntry.substring(objectNameIndex + objectName.length());
                    if (afterObject.startsWith("\"")) {
                        afterObject = afterObject.substring(1);
                    }
                    aliasName = Token.getFirstName(afterObject, '\"', '\"');
                }
                if (aliasName.equals("")) {
                    aliasName = objectName;
                }
                this.view.addToContainers(tableOrView, aliasName);
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("UNIQUE")) {
                stmt = Token.getStringAfterToken(stmt, "UNIQUE").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            int columnNumber = 0;
            while (tokenizer.hasMoreTokens()) {
                int dotIndex;
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (tokenizer.hasMoreTokens() && Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")")) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                boolean isExpression = false;
                if (!column.endsWith("*") && (Token.hasCloseAndOpenBrackets(column) || column.indexOf(43) > -1 || column.indexOf(45) > -1 || column.indexOf(42) > -1 || column.indexOf(47) > -1 || column.indexOf("||") > -1 || Token.hasToken(column, "PRIOR"))) {
                    isExpression = true;
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getNameAfterToken(column, "AS", '\"', '\"');
                    column = Token.getStringBeforeToken(column, "AS");
                    column = Token.encodeQuotedString(column);
                } else if (!((column = Token.encodeQuotedString(column)).indexOf(32) <= -1 || columnList != null && isExpression)) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                String columnQualifier = "";
                if (!isExpression && (dotIndex = column.lastIndexOf(46)) > -1) {
                    columnQualifier = column.substring(0, dotIndex);
                    int anotherDotIndex = columnQualifier.lastIndexOf(46);
                    if (anotherDotIndex > -1) {
                        columnQualifier = columnQualifier.substring(anotherDotIndex + 1);
                    }
                    columnQualifier = Token.removeQuotes(Token.decodeQuotedString(columnQualifier)).trim();
                    column = column.substring(dotIndex + 1);
                }
                if ((column = Token.removeQuotes(Token.decodeQuotedString(column))).equalsIgnoreCase("*")) {
                    for (AbstractView.ContainerHolder refContainerHolder : this.view.getUsedContainers()) {
                        String containerAlias = refContainerHolder.getAlias();
                        if (!columnQualifier.equals("") && !columnQualifier.equalsIgnoreCase(containerAlias)) continue;
                        ContainerObject containerObject = refContainerHolder.getContainer();
                        if (containerObject instanceof Table) {
                            for (Column tableColumn : containerObject.getElementsCollection()) {
                                ColumnView viewCol = new ColumnView(this.view.getDesignPart());
                                viewCol.setReferencedColumn(tableColumn);
                                viewCol.setName(tableColumn.getName());
                                viewCol.setDesign(this.design);
                                viewCol.setTable((Table)containerObject);
                                viewCol.setTableAlias(containerAlias);
                                viewCol.setDataType(tableColumn.getDataType().toString());
                                viewCol.setContainer(this.view);
                                this.view.add(viewCol);
                                ++columnNumber;
                            }
                            continue;
                        }
                        if (!(containerObject instanceof TableView)) continue;
                        ContainedObject[] refViewCols = ((TableView)containerObject).getColumns();
                        for (int i = 0; i < refViewCols.length; ++i) {
                            ColumnView refColumn = (ColumnView)refViewCols[i];
                            ColumnView viewCol = new ColumnView(this.view.getDesignPart());
                            viewCol.setReferencedColumnView(refColumn);
                            viewCol.setName(refColumn.getName());
                            viewCol.setDesign(this.design);
                            viewCol.setView((TableView)containerObject);
                            viewCol.setTableAlias(containerAlias);
                            viewCol.setDataType(refColumn.getDataType());
                            viewCol.setContainer(this.view);
                            this.view.add(viewCol);
                            ++columnNumber;
                        }
                    }
                    continue;
                }
                if (column.equalsIgnoreCase("")) continue;
                AbstractViewElement cvExp = this.view.createViewElement(this.view.getDesignPart());
                cvExp.setDesign(this.design);
                cvExp.setExpression(column);
                cvExp.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                this.view.add(cvExp);
                if (!isExpression) {
                    for (AbstractView.ContainerHolder refContainerHolder : this.view.getUsedContainers()) {
                        ContainerObject container;
                        ContainedObject refObject;
                        String containerAlias = refContainerHolder.getAlias();
                        if (!columnQualifier.equals("") && !columnQualifier.equalsIgnoreCase(containerAlias) || (refObject = (container = refContainerHolder.getContainer()).getElementByName(column)) == null) continue;
                        if (refObject instanceof Column) {
                            cvExp.setReferencedColumn((Column)refObject);
                            cvExp.setTable((Table)container);
                            break;
                        }
                        if (!(refObject instanceof ColumnView)) break;
                        cvExp.setReferencedColumnView(refObject);
                        cvExp.setView((TableView)container);
                        break;
                    }
                }
                if (columnList != null && columnNumber < columnList.size()) {
                    columnAlias = (String)columnList.get(columnNumber);
                }
                if (columnAlias != null) {
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString(columnAlias));
                    cvExp.setName(columnAlias);
                    cvExp.setAlias(columnAlias);
                    cvExp.setHeaderAlias(columnAlias);
                } else {
                    cvExp.setName(column);
                    cvExp.setAlias(column);
                    cvExp.setTableAlias(columnQualifier);
                }
                ++columnNumber;
            }
        }
    }

    private void initOwner(TableViewProxyOracle tableViewProxy) {
        String userName = Token.getValBeforeCharacter(Token.getQuotedNameAfterToken(this.statement, "VIEW").trim(), '.');
        if (userName != null && !"".equals(userName.trim())) {
            SchemaObjectSet schemaSet;
            SchemaObject so;
            UserOracle user = (UserOracle)((StorageDesignOracle)tableViewProxy.getStorageDesign()).getUserSet().getByName(userName);
            if (user == null) {
                user = (UserOracle)((StorageDesignOracle)tableViewProxy.getStorageDesign()).getUserSet().createElement(null);
                user.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)this.view.getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null && !userName.trim().equalsIgnoreCase("")) {
                so = schemaSet.createSchemaObject(null);
                so.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(so);
            }
            if (user != null) {
                if (user.getSchemaObject() == null) {
                    user.setSchemaObject(so);
                }
                if (user.getSchemaObject() != so) {
                    tableViewProxy.setUser(user);
                }
            }
            this.view.setSchemaObject(so);
        }
    }

    public void setView(AbstractView view) {
        this.view = view;
    }

    private String removeClosingBrackets(String statement) {
        int ind = statement.toLowerCase().indexOf(" as ");
        String stb = "";
        String stmt = statement;
        if (ind > -1) {
            stb = statement.substring(0, ind + 4);
            stmt = statement.substring(ind + 4).trim();
            if (stmt.charAt(0) == '(') {
                stmt = Token.getValBetweenBrackets(stmt);
            }
            stmt = stb + stmt;
        }
        return stmt;
    }
}

