/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceOraclev10g
extends DDLStatementHandler {
    private TableSpaceOraclev10g tableSpace;
    private RDBMSSite site;
    private StorageDesignOraclev10g stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceOraclev10g.class);

    public SHCreateTablespaceOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTablespaceOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "CREATE TABLESPACE") || Token.startsWithString(statement, "CREATE SMALLFILE TABLESPACE") || Token.startsWithString(statement, "CREATE BIGFILE TABLESPACE")) {
            try {
                this.parseTablespace(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for Oracle 10g failed!", e);
                this.importLog.addFailedStatement(SHCreateTablespaceOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = (TableSpaceOraclev10g)this.stoDesign.getTableSpaceSet().createTableSpace();
            if (this.tableSpace != null) {
                this.initFileType();
                this.initName();
                this.initDataFiles();
                this.initMinimumExtent();
                this.initBlockSize();
                this.initLogging();
                this.initForceLogging();
                this.initStatus();
                this.initContents();
                this.initDefaultStorage();
                this.initExtManagement();
                this.initSegmentManagement();
                this.initFlashBack();
                this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            }
        }
    }

    private void initFlashBack() {
        int ind = this.statement.toUpperCase().indexOf("FLASHBACK");
        if (ind > -1) {
            String line = this.statement.substring(ind + 9).trim();
            this.tableSpace.setFlashBack(Token.getFirstToken(line).toUpperCase());
        }
    }

    private void initFileType() {
        String fileType = Token.getTokenAfter(this.statement, "CREATE");
        if (fileType.equalsIgnoreCase("BIGFILE")) {
            this.tableSpace.setFileType("BIGFILE");
        } else if (fileType.equalsIgnoreCase("SMALLFILE")) {
            this.tableSpace.setFileType("SMALLFILE");
        } else {
            this.tableSpace.setFileType("");
        }
    }

    private void initBlockSize() {
        if (Token.hasToken(this.statement, "BLOCKSIZE")) {
            String blockSize = this.getNumberOnly(Token.getTokenAfter(this.statement, "BLOCKSIZE").trim());
            try {
                int size = Integer.parseInt(blockSize);
                this.tableSpace.setBlockSize(size);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initBlockSize() : " + e.getMessage());
            }
        }
    }

    private void initName() {
        String name = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        this.tableSpace.setName(name);
    }

    public TableSpaceOraclev10g getTablespace() {
        return this.tableSpace;
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.initDataFile(token);
            }
        }
    }

    private void initDataFile(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            DataFileOraclev10g dataFile = (DataFileOraclev10g)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFile);
            dataFile.setTableSpace(this.tableSpace);
            String fileName = Token.getValBetweenQuotes(dfInfo);
            dataFile.setFileName(fileName);
            if (Token.hasToken(dfInfo, "SIZE")) {
                String sizeStr = Token.getTokenAfter(dfInfo, "SIZE");
                try {
                    long size = Long.parseLong(this.removeMeasureUnit(sizeStr));
                    dataFile.setSize(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", e);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, dfInfo);
                dataFile.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                dataFile.setReuse("YES");
            } else {
                dataFile.setReuse("NO");
            }
            if (Token.hasToken(dfInfo, "AUTOEXTEND")) {
                String autoextend = Token.getTokenAfter(dfInfo, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("ON");
                    if (Token.hasToken(dfInfo, "NEXT")) {
                        String nextStr = Token.getTokenAfter(dfInfo, "NEXT").trim();
                        try {
                            int size = Integer.parseInt(this.getNumberOnly(nextStr));
                            dataFile.setNextBlockSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", e);
                        }
                    }
                    if (Token.hasToken(dfInfo, "MAXSIZE")) {
                        dataFile.setMaxSize(this.getNumberOnly(Token.getTokenAfter(dfInfo, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("OFF");
                }
            }
        }
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            return sizeStr.substring(sizeStr.length() - 1);
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase();
        if (sizeStr.equals("K") || sizeStr.equals("M") || sizeStr.equals("G") || sizeStr.equals("T") || sizeStr.equals("P") || sizeStr.equals("E")) {
            return sizeStr;
        }
        return "";
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void initMinimumExtent() {
        String line;
        if (Token.hasToken(this.statement, "MINIMUM") && "EXTENT".equalsIgnoreCase(Token.getFirstToken(line = Token.getStringAfter(this.statement, "MINIMUM")).trim())) {
            String minExtLen = this.getNumberOnly(Token.getTokenAfter(line, "EXTENT").trim());
            try {
                int minExtent = Integer.parseInt(minExtLen);
                this.tableSpace.setMinExtLen(minExtent);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinimumExtent : " + e.getMessage());
            }
        }
    }

    private void initLogging() {
        if (Token.hasToken(this.statement, "NOLOGGING")) {
            this.tableSpace.setLogging("NOLOGGING");
        } else {
            this.tableSpace.setLogging("LOGGING");
        }
    }

    private void initForceLogging() {
        if (this.statement.toUpperCase().indexOf("FORCE LOGGING") > -1) {
            this.tableSpace.setForceLogging("YES");
        }
    }

    private void initStatus() {
        if (Token.hasToken(this.statement, "OFFLINE")) {
            this.tableSpace.setStatus("OFFLINE");
        } else {
            this.tableSpace.setStatus("ONLINE");
        }
    }

    private void initContents() {
        if (Token.hasToken(this.statement, "TEMPORARY")) {
            this.tableSpace.setContents("TEMPORARY");
        }
    }

    private void initDefaultStorage() {
        if (Token.hasToken(this.statement, "DEFAULT")) {
            String line;
            String compression = Token.getTokenAfter(this.statement, "DEFAULT");
            if (compression.equalsIgnoreCase("COMPRESS")) {
                this.tableSpace.setDSCompression("COMPRESS");
            } else if (compression.equalsIgnoreCase("NOCOMPRESS")) {
                this.tableSpace.setDSCompression("NOCOMPRESS");
            }
            if (Token.hasToken(this.statement, "STORAGE") && Token.hasCloseAndOpenBrackets(line = Token.getStringAfter(this.statement, "STORAGE"))) {
                line = Token.getValBetweenBrackets(line, 1).trim();
                this.initInitialExtent(line);
                this.initMinExtents(line);
                this.initNextExtents(line);
                this.initMaxExtents(line);
                this.initPctIncrease(line);
            }
        }
    }

    private void initInitialExtent(String line) {
        if (Token.hasToken(line, "INITIAL")) {
            String initExtentStr = this.getNumberOnly(Token.getTokenAfter(line, "INITIAL").trim());
            try {
                long initExtent = Long.parseLong(initExtentStr);
                this.tableSpace.setDSInitialExtent(initExtent);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initInitialExtent : " + e.getMessage());
            }
        }
    }

    private void initMinExtents(String line) {
        if (Token.hasToken(line, "MINEXTENTS")) {
            String initMinExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "MINEXTENTS").trim());
            try {
                int initMinExtents = Integer.parseInt(initMinExtentsStr);
                this.tableSpace.setDSMinExtents(initMinExtents);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initMinExtents : " + e.getMessage());
            }
        }
    }

    private void initNextExtents(String line) {
        if (Token.hasToken(line, "NEXT")) {
            String initNextExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "NEXT").trim());
            try {
                long initNextExtents = Long.parseLong(initNextExtentsStr);
                this.tableSpace.setDSNextExtent(initNextExtents);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initNextExtents : " + e.getMessage());
            }
        }
    }

    private void initMaxExtents(String line) {
        if (Token.hasToken(line, "MAXEXTENTS")) {
            String initMaxExtentsStr = this.getNumberOnly(Token.getTokenAfter(line, "MAXEXTENTS").trim());
            this.tableSpace.setDSMaxExtents(initMaxExtentsStr);
        }
    }

    private void initPctIncrease(String line) {
        if (Token.hasToken(line, "PCTINCREASE")) {
            String initPctIncStr = this.getNumberOnly(Token.getTokenAfter(line, "PCTINCREASE").trim());
            try {
                int initPctInc = Integer.parseInt(initPctIncStr);
                this.tableSpace.setDSPctIncrease(initPctInc);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateTablespaceOracle.initPctIncrease : " + e.getMessage());
            }
        }
    }

    private void initExtManagement() {
        int ind = this.statement.toUpperCase().indexOf("EXTENT MANAGEMENT");
        if (ind > -1) {
            String line = this.statement.substring(ind + 17).trim();
            if (Token.getFirstToken(line).equalsIgnoreCase("LOCAL")) {
                this.tableSpace.setExtentManagement("LOCAL");
                String localSubType = Token.getTokenAfter(line, "LOCAL").trim();
                if (localSubType.equalsIgnoreCase("UNIFORM")) {
                    this.tableSpace.setEMLocalSubtype("UNIFORM");
                    String sizeStr = this.getNumberOnly(Token.getTokenAfter(line, "SIZE").trim());
                    if (!sizeStr.equals("")) {
                        try {
                            int size = Integer.parseInt(sizeStr);
                            this.tableSpace.setEMUniformSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initExtManagement : " + e.getMessage());
                            this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                        }
                    }
                }
            } else if (Token.getFirstToken(line).equalsIgnoreCase("DICTIONARY")) {
                this.tableSpace.setExtentManagement("DICTIONARY");
            }
        }
    }

    private void initSegmentManagement() {
        int ind = this.statement.toUpperCase().indexOf("SEGMENT SPACE MANAGEMENT");
        if (ind > -1) {
            String line = this.statement.substring(ind + 24).trim();
            this.tableSpace.setSegmentManagement(Token.getFirstToken(line));
        }
    }
}

