/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTemporaryTablespaceOraclev10g
extends DDLStatementHandler {
    private TemporaryTablespaceOraclev10g tempTS;
    private StorageDesignOraclev10g stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTemporaryTablespaceOraclev10g.class);

    public SHCreateTemporaryTablespaceOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTemporaryTablespaceOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "CREATE TEMPORARY TABLESPACE") || Token.startsWithString(statement, "CREATE BIGFILE TEMPORARY TABLESPACE") || Token.startsWithString(statement, "CREATE SMALLFILE TEMPORARY TABLESPACE")) {
            try {
                this.parseTemporaryTablespace(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHCreateTemporaryTablespaceOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseTemporaryTablespace(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(site);
        if (this.stoDesign != null) {
            this.tempTS = (TemporaryTablespaceOraclev10g)this.stoDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
            if (this.tempTS != null) {
                this.initName(this.tempTS);
                this.initTempFiles();
                this.initTableSpaceGroup(this.tempTS);
                this.initExtent(this.tempTS);
                this.initFileType(this.tempTS);
                this.design.getRelationalDesign().stampModelObjectDDL(this.tempTS);
            }
        }
    }

    private void initTableSpaceGroup(TemporaryTablespaceOraclev10g ts) {
        if (Token.hasString(this.statement, "TABLESPACE GROUP")) {
            String tableSpaceGroup = Token.getTokenAfter(this.statement, "GROUP").trim();
            tableSpaceGroup = Token.getName(tableSpaceGroup);
            ts.setTableSpaceGroup(tableSpaceGroup);
        }
    }

    private void initName(TemporaryTablespaceOraclev10g ts) {
        String name = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        ts.setName(name);
    }

    private void initTempFiles() {
        if (Token.hasToken(this.statement, "TEMPFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "BLOCKSIZE", "LOGGING", "NOLOGGING", "FORCE", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "DEFAULT", "EXTENT MANAGEMENT", "SEGMENT"};
            String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "TEMPFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.initTempFile(token);
            }
        }
    }

    private void initTempFile(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            DataFileOraclev10g dataFile = (DataFileOraclev10g)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFile);
            dataFile.setTemporaryTablespace(this.tempTS);
            if (dfInfo.startsWith("'")) {
                dataFile.setFileName(Token.getFirstName(dfInfo, '\'', '\''));
                this.tempTS.setOracleManagedFiles("NO");
            }
            if (Token.hasToken(dfInfo, "SIZE")) {
                String sizeStr = Token.getTokenAfter(dfInfo, "SIZE");
                try {
                    dataFile.setSize(Long.parseLong(this.removeMeasureUnit(sizeStr)));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", e);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, dfInfo);
                dataFile.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                dataFile.setReuse("YES");
            } else {
                dataFile.setReuse("NO");
            }
            if (Token.hasToken(dfInfo, "AUTOEXTEND")) {
                String autoextend = Token.getTokenAfter(dfInfo, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("ON");
                    if (Token.hasToken(dfInfo, "NEXT")) {
                        String nextStr = Token.getTokenAfter(dfInfo, "NEXT").trim();
                        try {
                            int size = Integer.parseInt(this.getNumberOnly(nextStr));
                            dataFile.setNextBlockSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", e);
                        }
                    }
                    if (Token.hasToken(dfInfo, "MAXSIZE")) {
                        dataFile.setMaxSize(this.getNumberOnly(Token.getTokenAfter(dfInfo, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("OFF");
                }
            }
        }
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            return sizeStr.substring(sizeStr.length() - 1);
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase();
        if (sizeStr.equals("K") || sizeStr.equals("M") || sizeStr.equals("G") || sizeStr.equals("T") || sizeStr.equals("P") || sizeStr.equals("E")) {
            return sizeStr;
        }
        return "";
    }

    private void initExtent(TemporaryTablespaceOraclev10g ts) {
        if (Token.hasToken(this.statement, "UNIFORM")) {
            String extent = Token.getStringAfterToken(this.statement, "UNIFORM");
            String size = Token.getTokenAfter(extent, "SIZE");
            try {
                ts.setUniformSize(Long.parseLong(this.removeMeasureUnit(size)));
                ts.setMeasureUnitUniformSize(this.getMeasureUnit(size, extent));
            }
            catch (NumberFormatException e) {
                LOGGER.error(" Wrong syntax near " + size);
            }
        }
    }

    private void initFileType(TemporaryTablespaceOraclev10g ts) {
        String fileType = Token.getTokenAfter(this.statement, "CREATE");
        ts.setFileType(fileType.toUpperCase());
    }
}

