/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateUndoTablespaceOraclev10g
extends DDLStatementHandler {
    private UndoTablespaceOracle tableSpace;
    private RDBMSSite site;
    private StorageDesignOraclev10g stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateUndoTablespaceOraclev10g.class);

    public SHCreateUndoTablespaceOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateUndoTablespaceOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "CREATE UNDO TABLESPACE") || Token.startsWithString(statement, "CREATE SMALLFILE UNDO TABLESPACE") || Token.startsWithString(statement, "CREATE BIGFILE UNDO TABLESPACE")) {
            try {
                this.parseTablespace(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for Oracle 10g failed!", e);
                this.importLog.addFailedStatement(SHCreateUndoTablespaceOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getUndoTablespaceSet().createTablespace();
            if (this.tableSpace != null) {
                this.initName();
                this.initFileType();
                this.initDataFiles();
                this.initRetention();
                this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
            }
        }
    }

    private void initFileType() {
        String afterCreate = Token.getTokenAfter(this.statement, "CREATE");
        if (!afterCreate.equalsIgnoreCase("UNDO")) {
            this.tableSpace.setFileType(afterCreate.toUpperCase());
        }
    }

    private void initName() {
        String name = Token.getQuotedNameAfterToken(this.statement, "TABLESPACE").trim();
        this.tableSpace.setName(name);
    }

    private void initDataFiles() {
        if (Token.hasToken(this.statement, "DATAFILE")) {
            String[] match = new String[]{"MINIMUM EXTENT", "LOGGING", "NOLOGGING", "DEFAULT", "ONLINE", "OFFLINE", "PERMANENT", "TEMPORARY", "EXTENT MANAGEMENT"};
            String dataFiles = Token.getStringToFirstMatch(Token.getStringAfter(this.statement, "DATAFILE"), match);
            StringTokenizer tokenizer = new StringTokenizer(dataFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                this.initDataFile(token);
            }
        }
    }

    private void initDataFile(String dfInfo) {
        if (!"".equalsIgnoreCase(dfInfo)) {
            DataFileOraclev10g dataFile = (DataFileOraclev10g)this.stoDesign.getDataFileSet().createDataFile();
            this.design.getRelationalDesign().stampModelObjectDDL(dataFile);
            dataFile.setUndoTablespace(this.tableSpace);
            String fileName = Token.getValBetweenQuotes(dfInfo);
            if (fileName != "") {
                dataFile.setFileName(fileName);
                this.tableSpace.setOracleManagesFiles("NO");
            } else {
                this.tableSpace.setOracleManagesFiles("YES");
            }
            if (Token.hasToken(dfInfo, "SIZE")) {
                String sizeStr = Token.getTokenAfter(dfInfo, "SIZE");
                try {
                    long size = Long.parseLong(this.removeMeasureUnit(sizeStr));
                    dataFile.setSize(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", e);
                }
                String measureUnit = this.getMeasureUnit(sizeStr, dfInfo);
                dataFile.setMeasureUnit(measureUnit);
            }
            if (Token.hasToken(dfInfo, "REUSE")) {
                dataFile.setReuse("YES");
            } else {
                dataFile.setReuse("NO");
            }
            if (Token.hasToken(dfInfo, "AUTOEXTEND")) {
                String autoextend = Token.getTokenAfter(dfInfo, "AUTOEXTEND").trim();
                if ("ON".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("ON");
                    if (Token.hasToken(dfInfo, "NEXT")) {
                        String nextStr = Token.getTokenAfter(dfInfo, "NEXT").trim();
                        try {
                            int size = Integer.parseInt(this.getNumberOnly(nextStr));
                            dataFile.setNextBlockSize(size);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("wrong format in SHCreateTablespaceOracle.initDataFile!", e);
                        }
                    }
                    if (Token.hasToken(dfInfo, "MAXSIZE")) {
                        dataFile.setMaxSize(this.getNumberOnly(Token.getTokenAfter(dfInfo, "MAXSIZE").trim()));
                    }
                } else if ("OFF".equalsIgnoreCase(autoextend)) {
                    dataFile.setAutoextend("OFF");
                }
            }
        }
    }

    private String removeMeasureUnit(String value) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String getMeasureUnit(String value, String dfInfo) {
        String sizeStr = value.toUpperCase();
        if (sizeStr.endsWith("K") || sizeStr.endsWith("M") || sizeStr.endsWith("G") || sizeStr.endsWith("T") || sizeStr.endsWith("P") || sizeStr.endsWith("E")) {
            return sizeStr.substring(sizeStr.length() - 1);
        }
        sizeStr = Token.getTokenAfter(dfInfo, value).toUpperCase();
        if (sizeStr.equals("K") || sizeStr.equals("M") || sizeStr.equals("G") || sizeStr.equals("T") || sizeStr.equals("P") || sizeStr.equals("E")) {
            return sizeStr;
        }
        return "";
    }

    private void initRetention() {
        if (Token.hasToken(this.statement, "RETENTION")) {
            this.tableSpace.setRetention(Token.getTokenAfter(this.statement, "RETENTION").toUpperCase());
        }
    }
}

