/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPermissionsOraclev10g
extends DDLStatementHandler {
    private PermissionsOraclev10g permissions;
    private StorageDesignOraclev10g storageDesign;
    private TableProxyOraclev10g table = null;
    private TableViewProxyOraclev10g view = null;
    private static final Logger LOGGER = new Logger(SHGrantPermissionsOraclev10g.class);

    public SHGrantPermissionsOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantPermissionsOraclev10g.clearCR(line);
        if (statement.toUpperCase().startsWith("GRANT") && Token.hasToken(statement, "TO")) {
            try {
                this.statement = statement.replaceAll("\"", "");
                this.grantPermissions();
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
                this.importLog.addFailedStatement(SHGrantPermissionsOraclev10g.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void grantPermissions() throws ObjectDoesNotExistException {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            ArrayList users = this.initUsersOrRoles();
            Object proxy = this.initOn();
            if (proxy != null) {
                for (int i = 0; i < users.size(); ++i) {
                    this.permissions = this.getPermissionForUser((StorageObject)users.get(i), proxy);
                    if (this.permissions == null) {
                        this.permissions = (PermissionsOraclev10g)this.storageDesign.getPermissionsSet().createPermissions();
                    }
                    if (this.permissions == null) continue;
                    this.initPrivileges(null);
                    this.initOnObject(proxy);
                    this.initTo(users.get(i));
                    this.initHierarchyOption();
                }
            } else {
                for (int i = 0; i < users.size(); ++i) {
                    this.initPrivileges(users.get(i));
                }
            }
        }
        this.permissions = null;
        this.table = null;
        this.view = null;
    }

    private void initPrivileges(Object object) {
        boolean hasGrantOption;
        String priv = Token.getStringAfterToken(this.statement, "GRANT");
        boolean bl = hasGrantOption = this.statement.toUpperCase().indexOf("WITH GRANT OPTION") > -1;
        if (object != null) {
            priv = Token.getStringBeforeToken(priv, "TO");
        } else {
            int onCommitIndex;
            String privUpper = priv.toUpperCase();
            int onIndex = privUpper.indexOf(" ON ", (onCommitIndex = privUpper.indexOf("ON COMMIT REFRESH")) + 1);
            if (onIndex >= 0) {
                priv = priv.substring(0, onIndex);
            }
            if (Token.hasCloseAndOpenBrackets(priv)) {
                String columns = Token.getValBetweenBrackets(priv).trim();
                priv = Token.getStringBefore(priv, "(");
                this.initColumns(columns, priv, hasGrantOption);
            }
        }
        priv = priv.trim().toUpperCase();
        StringTokenizer tokenizer = new StringTokenizer(priv, ",");
        while (tokenizer.hasMoreTokens()) {
            String pr = tokenizer.nextToken().trim();
            if (object != null) {
                this.addPrivileges(object, pr);
                continue;
            }
            if (hasGrantOption) {
                this.permissions.setPrivilegesWithGrantOption(pr);
                continue;
            }
            this.permissions.setPrivileges(pr);
        }
    }

    private void addPrivileges(Object object, String privileges) {
        boolean withAdminOption = this.statement.toUpperCase().indexOf("WITH ADMIN OPTION") > -1;
        RoleOracle grantedRole = (RoleOracle)this.storageDesign.getRoleSet().getByName(privileges);
        if (object instanceof UserOracle) {
            if (grantedRole != null) {
                if (withAdminOption) {
                    ((UserOracle)object).setRolesWithAdminOption(privileges);
                } else {
                    ((UserOracle)object).setRoles(privileges);
                }
            } else if (withAdminOption) {
                ((UserOracle)object).setPrivilegesWithAdminOption(privileges);
            } else {
                ((UserOracle)object).setPrivileges(privileges);
            }
        } else if (object instanceof RoleOracle) {
            if (grantedRole != null) {
                if (withAdminOption) {
                    ((RoleOracle)object).setRolesWithAdminOption(privileges);
                } else {
                    ((RoleOracle)object).setRoles(privileges);
                }
            } else if (withAdminOption) {
                ((RoleOracle)object).setPrivilegesWithAdminOption(privileges);
            } else {
                ((RoleOracle)object).setPrivileges(privileges);
            }
        }
    }

    private void initColumns(String columns, String priv, boolean hasGrantOption) {
        StringTokenizer tokenizer = new StringTokenizer(columns, ",");
        String column = null;
        while (tokenizer.hasMoreTokens()) {
            column = tokenizer.nextToken().trim();
            if ((column.equalsIgnoreCase("") || this.table == null || this.table.getColumnProxyByName(column) == null) && (this.view == null || this.view.getColumnProxyByName(column) == null)) continue;
            column = column + ", " + priv;
            if (hasGrantOption) {
                this.permissions.setColumnListWithGrantOption(column);
                continue;
            }
            this.permissions.setColumnList(column);
        }
    }

    private void initOnObject(Object proxy) {
        if (proxy instanceof TableProxyOracle) {
            this.permissions.setTable((TableProxyOracle)proxy);
        } else if (proxy instanceof TableViewProxyOracle) {
            this.permissions.setView((TableViewProxyOracle)proxy);
        } else if (proxy instanceof SnapshotOracle) {
            this.permissions.setSnapshot((SnapshotOracle)proxy);
        } else if (proxy instanceof SequenceOracle) {
            this.permissions.setSequence((SequenceOracle)proxy);
        } else if (proxy instanceof StoredProcedureOracle) {
            this.permissions.setProc((StoredProcedureOracle)proxy);
        } else if (proxy instanceof FunctionOracle) {
            this.permissions.setFunctionOracle((FunctionOracle)proxy);
        } else if (proxy instanceof PackageOracle) {
            this.permissions.setPackage((PackageOracle)proxy);
        } else if (proxy instanceof DirectoryOracle) {
            this.permissions.setDirectoryOracle((DirectoryOracle)proxy);
        } else if (proxy instanceof StructuredTypeProxyOracle) {
            this.permissions.setStructuredTypeOracle((StructuredTypeProxyOracle)proxy);
        } else if (proxy instanceof CollectionTypeProxyOracle) {
            this.permissions.setCollectionTypeOracle((CollectionTypeProxyOracle)proxy);
        } else if (proxy instanceof ExternalTableOracle) {
            this.permissions.setExternalTableOracle((ExternalTableOracle)proxy);
        } else if (proxy instanceof ColumnProxyOracle) {
            this.permissions.setColumnsTable(((ColumnProxyOracle)proxy).getTableProxy());
        }
    }

    private PermissionsOraclev10g getPermissionForUser(StorageObject user, Object proxy) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        ColumnProxyOracle column = null;
        if (proxy instanceof ColumnProxyOracle) {
            column = (ColumnProxyOracle)proxy;
        }
        PermissionsOraclev10g perm = null;
        while (it.hasNext()) {
            perm = (PermissionsOraclev10g)it.next();
            if (perm.getUser() != user && perm.getRole() != user || perm.getTable() != proxy && perm.getView() != proxy && perm.getSnapshot() != proxy && perm.getSequence() != proxy && perm.getProc() != proxy && perm.getFunctionOracle() != proxy && perm.getPackage() != proxy && perm.getDirectoryOracle() != proxy && perm.getStructuredTypeOracle() != proxy && perm.getCollectionTypeOracle() != proxy && perm.getExternalTableOracle() != proxy && (column == null || perm.getColumnsTable() == null || !perm.getColumnsTable().getObjectID().equals(column.getTableProxy().getObjectID()) || !perm.getColumns().contains(column.getName()) && !perm.getColumnsWithGrantOption().contains(column.getName()))) continue;
            return perm;
        }
        return null;
    }

    private Object initOn() throws ObjectDoesNotExistException {
        String on = Token.getStringAfterToken(this.statement, "ON");
        if (on.toUpperCase().startsWith("COMMIT REFRESH")) {
            on = Token.getStringAfterToken(on, "ON");
        }
        if (on.toUpperCase().startsWith("DIRECTORY ")) {
            String dirName = Token.getQuotedNameAfterToken(on, "DIRECTORY");
            DirectoryOracle doR = (DirectoryOracle)this.storageDesign.getDirectorySet().getByName(dirName);
            if (doR != null) {
                return doR;
            }
            throw new ObjectDoesNotExistException(dirName);
        }
        if (!(on = Token.getFirstName(on, '\"', '\"')).equalsIgnoreCase("")) {
            RelationalDesign relationalDesign = this.storageDesign.getPhysicalDesign();
            Table relationalTable = (Table)relationalDesign.getTableSet().getByName(on);
            if (relationalTable != null) {
                this.table = (TableProxyOraclev10g)this.storageDesign.getProxy(relationalTable);
                if (this.table != null) {
                    String columns = Token.getValBetweenBrackets(Token.getStringBefore(this.statement, "ON"));
                    if (!columns.equals("")) {
                        return this.table.getColumnProxyByName(columns);
                    }
                    if (this.table.getSnapshot() != null) {
                        return this.table.getSnapshot();
                    }
                    return this.table;
                }
            } else {
                SequenceOracle sequence;
                TableView relationalView = (TableView)relationalDesign.getTableViewSet().getByName(on);
                if (relationalView != null) {
                    this.view = (TableViewProxyOraclev10g)this.storageDesign.getProxy(relationalView);
                    return this.view;
                }
                String userName = "";
                String objName = on;
                int dotIndex = on.indexOf(46);
                if (dotIndex > -1) {
                    userName = on.substring(0, dotIndex);
                    objName = on.substring(dotIndex + 1);
                }
                if ((sequence = userName.equals("") ? (SequenceOracle)this.storageDesign.getSequenceSet().getByName(objName) : (SequenceOracle)this.storageDesign.getSequenceSet().getByUserSchemaAndName(userName, objName)) != null) {
                    return sequence;
                }
                StoredProcedureOracle proc = userName.equals("") ? (StoredProcedureOracle)this.storageDesign.getStoredProcedureSet().getByName(objName) : this.storageDesign.getStoredProcedureSet().getByOwnerAndName(userName, objName);
                if (proc != null) {
                    return proc;
                }
                FunctionOracle func = userName.equals("") ? (FunctionOracle)this.storageDesign.getFunctionSet().getByName(objName) : this.storageDesign.getFunctionSet().getByOwnerAndName(userName, objName);
                if (func != null) {
                    return func;
                }
                PackageOracle pack = userName.equals("") ? (PackageOracle)this.storageDesign.getPackageSet().getByName(objName) : this.storageDesign.getPackageSet().getByOwnerAndName(userName, objName);
                if (pack != null) {
                    return pack;
                }
                ExternalTableOracle extTable = userName.equals("") ? (ExternalTableOracle)this.storageDesign.getExternalTableSet().getByName(objName) : this.storageDesign.getExternalTableSet().getByOwnerAndName(userName, objName);
                if (extTable != null) {
                    return extTable;
                }
                CollectionTypeProxy ct = userName.equals("") ? this.storageDesign.getCollectionTypeProxySet().getByName(objName) : this.storageDesign.getCollectionTypeProxySet().getByOwnerAndName(userName, objName);
                if (ct != null) {
                    return ct;
                }
                StructuredTypeProxy st = userName.equals("") ? this.storageDesign.getStructuredTypeProxySet().getByName(objName) : this.storageDesign.getStructuredTypeProxySet().getBySchemaAndName(userName, objName);
                if (st != null) {
                    return st;
                }
            }
        }
        return null;
    }

    private void initTo(Object object) {
        String to = Token.getStringAfterToken(this.statement, "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            if (object instanceof UserOracle) {
                this.permissions.setUser((UserOracle)object);
            } else if (object instanceof RoleOracle) {
                this.permissions.setRole((RoleOracle)object);
            }
        } else {
            LOGGER.error("SHGrantPermissionsOracle.initTo(): wrong syntax!");
        }
    }

    private ArrayList initUsersOrRoles() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        String to = Token.getStringAfterToken(this.statement, "TO").trim();
        if (Token.hasToken(to, "WITH")) {
            to = Token.getStringBeforeToken(to, "WITH");
        }
        if (!to.equalsIgnoreCase("")) {
            UserSetOracle users = this.storageDesign.getUserSet();
            RoleSetOracle roles = this.storageDesign.getRoleSet();
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrRole = null;
            while (tokenizer.hasMoreTokens()) {
                userOrRole = tokenizer.nextToken().trim();
                ModelObject user = users.getByName(userOrRole = Token.getValBetweenSquareBrackets(userOrRole));
                if (user != null) {
                    list.add(user);
                    continue;
                }
                ModelObject role = roles.getByName(userOrRole);
                if (role != null) {
                    list.add(role);
                    continue;
                }
                user = users.createUser();
                user.setName(userOrRole);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
                list.add(user);
            }
        } else {
            LOGGER.error("SHGrantPermissionsOracle.initTo(): wrong syntax!");
        }
        return list;
    }

    private void initHierarchyOption() {
        if (this.statement.toUpperCase().indexOf("WITH_HIERARCHY_OPTION") > -1) {
            this.permissions.setHierarchyOption("YES");
        } else {
            this.permissions.setHierarchyOption("NO");
        }
    }
}

