/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHColumnElementsSqlServer;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTableSqlServer
extends DDLStatementHandlerSqlServer
implements SectionConstants,
CreateTableHandler {
    private RDBMSSite site = null;
    private Table table = null;
    private String tableName;
    private String dataBase;
    private String ownerName;
    private String inSideBrackets;
    private ArrayList columns;
    private StorageDesignSqlServer storageDesign = null;
    private TableProxySqlServer tableProxy = null;
    private boolean createDomainsDuringImport;
    private String fileGroup;
    private String textImageOn;
    private List fkList;
    private List refAtColumnList;
    private List tableNodeList = new ArrayList();
    private String outSideBrackets;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateTableSqlServer.class);

    public SHCreateTableSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        block5: {
            String statement = SHCreateTableSqlServer.clearCR(line);
            if (Token.startsWithString(statement, "create table")) {
                try {
                    this.failed = false;
                    this.fkList = new ArrayList();
                    this.refAtColumnList = new ArrayList();
                    this.parseTable(statement);
                    FKRefNode fkNode = new FKRefNode();
                    fkNode.processedTable = this.table;
                    fkNode.fkStatements = this.fkList;
                    fkNode.refAtColumns = this.refAtColumnList;
                    this.tableNodeList.add(fkNode);
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateTableSqlServer.FormatCR(line, "\n"));
                        break block5;
                    }
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    LOGGER.error(e);
                    this.importLog.addFailedStatement(SHCreateTableSqlServer.FormatCR(line, "\n"));
                }
            } else {
                this.nextHandler(line);
            }
        }
    }

    public void parseTable(String statement) {
        this.setStatement(statement);
        this.outSideBrackets = Token.getValOutsideBrackets(this.statement);
        this.inSideBrackets = Token.getValBetweenBrackets(this.statement, 1).trim();
        this.ownerName = null;
        this.tableName = this.initTableName();
        this.table = this.design.getDesign().getRelationalDesign().createTable();
        this.design.getRelationalDesign().stampModelObjectDDL(this.table);
        if (this.ownerName != null && !"".equals(this.ownerName)) {
            this.table.setSchema(this.ownerName);
        }
        this.table.setName(this.tableName);
        this.site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServer)this.design.getStorageDesign(this.site);
        this.tableProxy = (TableProxySqlServer)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.createDomainsDuringImport = this.storageDesign.getDesign().getAppView().getSettings().isCreateDomainsDuringImport();
        this.statement = statement;
        this.columns = this.initColumns();
        this.fileGroup = this.initFileGroup();
        this.textImageOn = this.initTextImageOn();
        this.tableProxy.setDatabase((DataBaseSqlServer)this.storageDesign.getDataBaseSet().getByName(this.dataBase));
        this.tableProxy.setUser((UserSqlServer)this.storageDesign.getUserSet().getByName(this.ownerName));
        this.tableProxy.setFilegroup((FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(this.fileGroup));
        this.tableProxy.setTextImageFG((FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(this.textImageOn));
        for (int col = 0; col < this.columns.size(); ++col) {
            Map oneColumnMap = (Map)this.columns.get(col);
            boolean isConstraint = (Boolean)oneColumnMap.get("IS_CONSTRAINT");
            if (!isConstraint) {
                boolean isPK;
                Boolean identity;
                boolean hasIdentity;
                Column columnplain = this.table.createColumn((String)oneColumnMap.get("columnname"));
                this.design.getRelationalDesign().stampModelObjectDDL(columnplain);
                String datatype = (String)oneColumnMap.get("datatype");
                String scale = (String)oneColumnMap.get("scale");
                String size = (String)oneColumnMap.get("size");
                String precision = (String)oneColumnMap.get("precision");
                String[] parameters = new String[]{precision, scale, size};
                String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                if (this.createDomainsDuringImport) {
                    Domain domain = null;
                    String typeName = (String)oneColumnMap.get("typename");
                    if (typeName != null) {
                        DomainSet domains = this.design.getDesign().getDomainSet();
                        domain = (Domain)domains.getByName(typeName);
                    }
                    String domainName = "";
                    if (domain == null) {
                        domainName = DomainFactory.createDomainName(logicalDT, parameters);
                        domain = this.getCorrespondingDomain(domainName);
                    }
                    if (domain != null) {
                        columnplain.setDomain(domain);
                    } else {
                        StringBuffer message = new StringBuffer("domain is null in SHCreateTableSqlServer.parseTable, TABLE=" + this.tableName + ": ");
                        message.append(domainName);
                        LOGGER.error(message.toString());
                        this.importLog.addError("Null domain occurred while creating " + this.tableName);
                    }
                } else {
                    columnplain.setLogicalDatatype(logicalDT);
                    columnplain.setUse((short)1);
                    columnplain.setDataTypeParameter("scale", scale);
                    columnplain.setDataTypeParameter("precision", precision);
                    columnplain.setDataTypeParameter("size", size);
                }
                Boolean nulls = (Boolean)oneColumnMap.get("nulls");
                if (nulls != null) {
                    boolean notNull = nulls;
                    columnplain.setNullsAllowed(notNull);
                }
                ColumnProxySqlServer columnProxy = (ColumnProxySqlServer)this.storageDesign.getColumnProxySet().getProxy(columnplain.getObjectID());
                if (oneColumnMap.containsKey("collate")) {
                    String collationName = (String)oneColumnMap.get("collate");
                    columnProxy.setCollation(collationName);
                }
                if (oneColumnMap.containsKey(NameElements.COL_DEFAULT)) {
                    String defaultValue = (String)oneColumnMap.get(NameElements.COL_DEFAULT);
                    columnplain.setUsesDefaultValue(true);
                    columnplain.setDefaultValue(defaultValue);
                }
                if (hasIdentity = (identity = (Boolean)oneColumnMap.get("IDENTITY")).booleanValue()) {
                    Object incStr;
                    columnplain.setIdentityColumn(true);
                    String seedStr = (String)oneColumnMap.get("SEED");
                    if (seedStr != null) {
                        columnProxy.setIdentitySeed(seedStr);
                    }
                    if ((incStr = oneColumnMap.get("INCREMENT")) != null) {
                        try {
                            int increment = Integer.parseInt((String)incStr);
                            columnProxy.setIdentityIncrement(increment);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (oneColumnMap.containsKey("NOT FOR REPLICATION")) {
                        boolean notForReplication = (Boolean)oneColumnMap.get("NOT FOR REPLICATION");
                        if (notForReplication) {
                            columnProxy.setIdentityForReplication("NO");
                        } else {
                            columnProxy.setIdentityForReplication("YES");
                        }
                    }
                }
                if (oneColumnMap.containsKey("COMPUTED")) {
                    columnplain.setComputed((boolean)((Boolean)oneColumnMap.get("COMPUTED")));
                }
                if (oneColumnMap.containsKey("FORMULA")) {
                    String formula = (String)oneColumnMap.get("FORMULA");
                    columnplain.setFormulaDesc(formula);
                }
                if (oneColumnMap.containsKey("ROWGUIDCOL")) {
                    boolean hasRowguidcol = (Boolean)oneColumnMap.get("ROWGUIDCOL");
                    if (hasRowguidcol) {
                        columnProxy.setRowGuidCol("YES");
                    } else {
                        columnProxy.setRowGuidCol("NO");
                    }
                }
                if (isPK = ((Boolean)oneColumnMap.get("PRIMARY KEY")).booleanValue()) {
                    String fileGroupName;
                    Index pk = this.table.createIndex();
                    this.design.getRelationalDesign().stampModelObjectDDL(pk);
                    pk.add(columnplain);
                    pk.makePK();
                    PKProxySqlServer pkProxy = (PKProxySqlServer)this.storageDesign.getPKProxySet().getProxy(pk.getObjectID());
                    if (oneColumnMap.containsKey("CLUSTERED")) {
                        pkProxy.setClustered(true);
                    } else if (oneColumnMap.containsKey("NONCLUSTERED")) {
                        pkProxy.setClustered(false);
                    }
                    if (oneColumnMap.containsKey("FILLFACTOR")) {
                        try {
                            int fillFactorValue = Integer.parseInt((String)oneColumnMap.get("FILLFACTOR"));
                            pkProxy.setFillFactor(fillFactorValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (oneColumnMap.containsKey("FILEGROUP") && !(fileGroupName = (String)oneColumnMap.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) {
                        FileGroupSqlServer fileGroup = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(fileGroupName);
                        pkProxy.setFilegroup(fileGroup);
                    }
                } else {
                    boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
                    if (isUnique) {
                        String fileGroupName;
                        Index unique = this.table.createIndex();
                        this.design.getRelationalDesign().stampModelObjectDDL(unique);
                        unique.add(columnplain);
                        unique.setIndexState("Unique Constraint");
                        UniqueProxySqlServer ukProxy = (UniqueProxySqlServer)this.storageDesign.getUniqueProxySet().getProxy(unique.getObjectID());
                        if (oneColumnMap.containsKey("CLUSTERED")) {
                            ukProxy.setClustered(true);
                        } else if (oneColumnMap.containsKey("NONCLUSTERED")) {
                            ukProxy.setClustered(false);
                        }
                        if (oneColumnMap.containsKey("FILLFACTOR")) {
                            try {
                                int fillFactorValue = Integer.parseInt((String)oneColumnMap.get("FILLFACTOR"));
                                ukProxy.setFillFactor(fillFactorValue);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (oneColumnMap.containsKey("FILEGROUP") && !(fileGroupName = (String)oneColumnMap.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) {
                            FileGroupSqlServer fileGroup = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(fileGroupName);
                            ukProxy.setFilegroup(fileGroup);
                        }
                    } else {
                        boolean isFK = (Boolean)oneColumnMap.get("FOREIGN");
                        if (isFK) {
                            String columnLine = this.getColumnLine((String)oneColumnMap.get("columnname"));
                            this.addForeignKey(columnLine, this.table);
                        }
                    }
                }
                String reference = (String)oneColumnMap.get("REFERENCES");
                if (reference != null) {
                    RefAtColNode refNode = new RefAtColNode();
                    int posPoint = reference.indexOf(46);
                    if (posPoint > 0) {
                        reference = Token.getValAfterCharacter(reference, '.');
                    }
                    refNode.onDelete = (String)oneColumnMap.get("ON DELETE");
                    refNode.columnName = (String)oneColumnMap.get("columnname");
                    refNode.refColumn = (String)oneColumnMap.get("REFERENCED_COLUMN");
                    refNode.referencedTable = reference;
                    this.refAtColumnList.add(refNode);
                }
                String constr = (String)oneColumnMap.get("CONSTRAINT");
                String check = (String)oneColumnMap.get("CHECK");
                if (check == null) continue;
                this.initCheckConstraint(check, constr, columnplain);
                continue;
            }
            String name = (String)oneColumnMap.get("CONSTRAINT_NAME");
            boolean isPK = (Boolean)oneColumnMap.get("PRIMARY KEY");
            if (isPK) {
                Index pk = this.table.createIndex();
                this.design.getRelationalDesign().stampModelObjectDDL(pk);
                if (!"".equalsIgnoreCase(name)) {
                    pk.setName(name);
                } else {
                    if (this.tableName.length() > 125) {
                        this.tableName = this.tableName.substring(0, 125);
                    }
                    pk.setName(this.tableName + "_PK");
                }
                String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                try {
                    String fileGroupName;
                    this.setColumnsForIndexPK(pk, elements);
                    pk.makePK();
                    PKProxySqlServer pkProxy = (PKProxySqlServer)this.storageDesign.getPKProxySet().getProxy(pk.getObjectID());
                    if (oneColumnMap.containsKey("CLUSTERED")) {
                        pkProxy.setClustered(true);
                    } else if (oneColumnMap.containsKey("NONCLUSTERED")) {
                        pkProxy.setClustered(false);
                    }
                    if (oneColumnMap.containsKey("FILLFACTOR")) {
                        try {
                            int fillFactorValue = Integer.parseInt((String)oneColumnMap.get("FILLFACTOR"));
                            pkProxy.setFillFactor(fillFactorValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (!oneColumnMap.containsKey("FILEGROUP") || (fileGroupName = (String)oneColumnMap.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) continue;
                    FileGroupSqlServer fileGroup = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(fileGroupName);
                    pkProxy.setFilegroup(fileGroup);
                }
                catch (ObjectDoesNotExistException e) {
                    LOGGER.error("", e);
                    this.importLog.addError("Columns for primary key " + pk.getName() + " don't exist.");
                    this.failed = true;
                }
                continue;
            }
            boolean isUnique = (Boolean)oneColumnMap.get("UNIQUE");
            if (isUnique) {
                Index unique = this.table.createIndex();
                this.design.getRelationalDesign().stampModelObjectDDL(unique);
                if (!"".equalsIgnoreCase(name)) {
                    unique.setName(name);
                } else {
                    if (this.tableName.length() > 123) {
                        this.tableName = this.tableName.substring(0, 123);
                    }
                    unique.setName(this.tableName + "_UK" + this.table.getUKeys().size());
                }
                String elements = (String)oneColumnMap.get("CONSTRAINT_VALUE");
                try {
                    String fileGroupName;
                    this.setColumnsForIndexPK(unique, elements);
                    unique.setIndexState("Unique Constraint");
                    UniqueProxySqlServer ukProxy = (UniqueProxySqlServer)this.storageDesign.getUniqueProxySet().getProxy(unique.getObjectID());
                    if (oneColumnMap.containsKey("CLUSTERED")) {
                        ukProxy.setClustered(true);
                    } else if (oneColumnMap.containsKey("NONCLUSTERED")) {
                        ukProxy.setClustered(false);
                    }
                    if (oneColumnMap.containsKey("FILLFACTOR")) {
                        try {
                            int fillFactorValue = Integer.parseInt((String)oneColumnMap.get("FILLFACTOR"));
                            ukProxy.setFillFactor(fillFactorValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (!oneColumnMap.containsKey("FILEGROUP") || (fileGroupName = (String)oneColumnMap.get("FILEGROUP")).equalsIgnoreCase("DEFAULT")) continue;
                    FileGroupSqlServer fileGroup = (FileGroupSqlServer)this.storageDesign.getFileGroupSet().getByName(fileGroupName);
                    ukProxy.setFilegroup(fileGroup);
                }
                catch (ObjectDoesNotExistException e) {
                    LOGGER.error("", e);
                    this.importLog.addError("Columns for unique key " + unique.getName() + " don't exist.");
                    this.failed = true;
                }
                continue;
            }
            boolean isTableConstraint = (Boolean)oneColumnMap.get("CHECK");
            if (!isTableConstraint) continue;
            String rule = (String)oneColumnMap.get("CONSTRAINT_VALUE");
            if (this.tableName.length() > 123) {
                this.tableName = this.tableName.substring(0, 123);
            }
            TableLevelConstraint constraint = this.table.createCheckConstraint(this.tableName + "_CK" + this.table.getCheckConstraints().size(), rule);
            if (!"".equalsIgnoreCase(name)) {
                constraint.setName(name);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(constraint);
            this.table.addCheckConstraint(constraint);
        }
    }

    private String getColumnLine(String columnName) {
        String columnStatement = this.inSideBrackets;
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        String oneColumn = "";
        while (columns.hasMoreTokens()) {
            oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            if (!Token.isTokenEqualTo(oneColumn, 1, columnName)) continue;
            return oneColumn;
        }
        return oneColumn;
    }

    private void initCheckConstraint(String check, String name, Column column) {
        CheckConstraint constraint = new CheckConstraint();
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        RDBMSTypeSet rdbmsTypeSet = this.design.getRDBMSTypeSet();
        Iterator itRdbms = rdbmsTypeSet.iterator();
        while (itRdbms.hasNext()) {
            RDBMSType type = (RDBMSType)itRdbms.next();
            if (type != StorageDesignSqlServerv2k.RDBMS_TYPE) continue;
            constraint.add(type, check);
        }
        if (!"".equalsIgnoreCase(name) && name != null) {
            constraint.setName(name);
            column.setConstraintName(name);
        } else {
            String columnName = column.getName();
            if (columnName.length() > 123) {
                columnName = columnName.substring(0, 123);
            }
            name = columnName + "_CHCK";
            constraint.setName(name);
            column.setConstraintName(name);
        }
        column.setUseDomainConstraints(false);
        column.setCheck(constraint);
    }

    private String initTableName() {
        String temp = Token.getTokenAfter(this.statement, "TABLE", " ").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "TABLE", '[', ']').trim() : (temp.startsWith("\"") ? Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim() : temp);
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer st = new StringTokenizer(name, ".");
            String[] values = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                values[i] = st.nextToken().toString();
                ++i;
            }
            if (values.length == 3) {
                this.dataBase = values[0];
                this.ownerName = values[1];
                name = values[2];
                name = Token.getValBetweenSquareBrackets(name);
                name = Token.removeQuotes(name);
                return name;
            }
            if (values.length == 2) {
                this.ownerName = values[0];
                name = values[1];
                name = Token.getValBetweenSquareBrackets(name);
                name = Token.removeQuotes(name);
                this.dataBase = this.getCurrentDB().getName();
                return name;
            }
        }
        if (this.getCurrentDB() != null) {
            this.dataBase = this.getCurrentDB().getName();
        }
        this.ownerName = "";
        return name;
    }

    private ArrayList initColumns() {
        ArrayList<Map> tableColumns = new ArrayList<Map>();
        String columnStatement = this.inSideBrackets;
        SHColumnElementsSqlServer elements = new SHColumnElementsSqlServer(this.design);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            Map elementsColumn;
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracketNoClose(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracketNoClose(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString().trim();
                }
            }
            if (Boolean.TRUE.equals((elementsColumn = elements.getElementsColumn(oneColumn.trim())).get("IS_CONSTRAINT")) && oneColumn.toUpperCase().indexOf("FOREIGN") > -1) {
                this.fkList.add(oneColumn);
                continue;
            }
            tableColumns.add(elementsColumn);
        }
        return tableColumns;
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.design.getDesign().getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }

    public void setColumnsForIndexPK(Index index, String elementsPK) throws ObjectDoesNotExistException {
        if (index != null) {
            StringTokenizer elemPK = new StringTokenizer(elementsPK, ",");
            HashMap<String, String> sortOrderMap = new HashMap<String, String>();
            ArrayList<String> pkColNames = new ArrayList<String>();
            while (elemPK.hasMoreElements()) {
                String columnRef = elemPK.nextToken().trim();
                String columnNamePK = Token.getFirstName(columnRef, '[', ']').trim();
                String sortOrder = "ASC";
                if (columnRef.toUpperCase().indexOf("DESC", columnNamePK.length()) > -1) {
                    sortOrder = "DESC";
                }
                pkColNames.add(columnNamePK);
                sortOrderMap.put(columnNamePK, sortOrder);
            }
            for (String colName : pkColNames) {
                Column column = (Column)index.getTable().getElementByName(colName);
                if (column != null) {
                    index.add(column);
                    String sortOrder = (String)sortOrderMap.get(colName);
                    index.setColumnSortOrder(column, sortOrder);
                    continue;
                }
                this.importLog.addError("Column for index " + index.getName() + " doesn't exist.");
                throw new ObjectDoesNotExistException(colName);
            }
        }
    }

    private String initFileGroup() {
        String name = Token.getTokenAfter(this.outSideBrackets, "ON").trim();
        name = Token.getValBetweenQuotationMarks(name).trim();
        name = Token.getValBetweenSquareBrackets(name).trim();
        return name;
    }

    private String initTextImageOn() {
        String name = Token.getTokenAfter(this.outSideBrackets, "TEXTIMAGE_ON").trim();
        name = Token.getValBetweenQuotationMarks(name).trim();
        name = Token.getValBetweenSquareBrackets(name).trim();
        return name;
    }

    private void replaceAllColumns(FKIndexAssociation association, List columnsRef, Index pk) {
        Index index = association.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(association)) continue;
            Column indexColumn = (Column)index.getElements()[p];
            association.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        Index index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private String getNameFor(String name) {
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            if (Token.hasString(token, "[") && Token.hasString(token, "]")) {
                token = Token.getValBetweenSquareBrackets(token);
            }
            token = Token.removeQuotes(token);
            columns.add(token.trim());
        }
        return columns;
    }

    @Override
    public void processForeignKeys() {
        for (FKRefNode node : this.tableNodeList) {
            for (String line : node.fkStatements) {
                this.addForeignKey(line, node.processedTable);
            }
            Iterator itcolref = node.refAtColumns.iterator();
            while (itcolref.hasNext()) {
                this.processRefAtColumn((RefAtColNode)itcolref.next(), node.processedTable);
            }
        }
    }

    private void addForeignKey(String line, Table processedTable) {
        block17: {
            Table tableRef;
            List columnNames;
            String nameFK;
            block18: {
                nameFK = null;
                if (Token.hasToken(line, "CONSTRAINT")) {
                    nameFK = Token.getTokenAfter(line, "CONSTRAINT");
                } else {
                    if (this.tableName.length() > 123) {
                        this.tableName = this.tableName.substring(0, 123);
                    }
                    nameFK = this.tableName + "_FK" + this.table.getFKAssociationsCount();
                }
                int positionBracket = line.indexOf(41);
                String firstBrackets = line.substring(0, positionBracket + 1).trim();
                String columns = Token.getValBetweenBrackets(firstBrackets);
                columnNames = this.getColumnNames(columns);
                int positionReference = line.toUpperCase().indexOf("REFERENCES");
                line = line.substring(positionReference);
                String nameReferenced = Token.getTokenAfter(line, "REFERENCES");
                String nameRef = this.getNameFor(nameReferenced);
                nameRef = Token.removeQuotes(nameRef);
                tableRef = this.getTableFor(nameRef);
                if (tableRef == null) break block17;
                boolean hasBrackets = Token.hasString(line, "(");
                if (!hasBrackets) break block18;
                String columnsReferenced = Token.getValBetweenBrackets(line);
                List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                ArrayList<Column> columnsRef = new ArrayList<Column>();
                Column[] columnSet = (Column[])processedTable.getElements();
                for (int numberColumns = 0; numberColumns < columnSet.length; ++numberColumns) {
                    Column referencedColumn = columnSet[numberColumns];
                    String name = referencedColumn.getName().trim();
                    for (int numberColumnsTable = 0; numberColumnsTable < columnNames.size(); ++numberColumnsTable) {
                        String nameColumn = (String)columnNames.get(numberColumnsTable);
                        if (!name.equals(nameColumn)) continue;
                        columnsRef.add(referencedColumn);
                    }
                }
                Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                if (index == null) break block17;
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (!hasOnDelete) break block17;
                String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                String[] choisesDelete = fkass.getDeleteRuleChoices();
                for (int choise = 0; choise < choisesDelete.length; ++choise) {
                    if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                    fkass.setDeleteRule(choisesDelete[choise]);
                    break block17;
                }
                break block17;
            }
            Column[] columnSet = (Column[])processedTable.getElements();
            FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
            ArrayList<Column> columnsRef = new ArrayList<Column>();
            for (int numberColumns = 0; numberColumns < columnSet.length; ++numberColumns) {
                Column referencedColumn = columnSet[numberColumns];
                String name = referencedColumn.getName().trim();
                for (int numberColumnsTable = 0; numberColumnsTable < columnNames.size(); ++numberColumnsTable) {
                    String nameColumn = (String)columnNames.get(numberColumnsTable);
                    if (!name.equals(nameColumn)) continue;
                    columnsRef.add(referencedColumn);
                }
            }
            Index index = (Index)tableRef.getPK();
            if (index != null) {
                FKIndexAssociation fkass = processedTable.addFK(index, null, reference);
                this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                if (nameFK != null) {
                    fkass.setName(nameFK);
                    fkass.getLocalFKIndex().setName(nameFK);
                }
                if (this.design.isPropagatePKChahges()) {
                    this.replaceAllColumns(fkass, columnsRef, index);
                } else {
                    this.fixFKColumns(fkass, columnsRef, index);
                }
                boolean hasOnDelete = Token.hasToken(line, "DELETE");
                if (hasOnDelete) {
                    String onDelete = Token.getTokenAfter(line, "DELETE").trim();
                    String[] choisesDelete = fkass.getDeleteRuleChoices();
                    for (int choise = 0; choise < choisesDelete.length; ++choise) {
                        if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                        fkass.setDeleteRule(choisesDelete[choise]);
                        break;
                    }
                }
            }
        }
    }

    private void processRefAtColumn(RefAtColNode refNode, Table processedTable) {
        String reference = refNode.referencedTable;
        Table referencedtable = null;
        try {
            referencedtable = this.getReferencedTable(reference);
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.error(e);
            this.importLog.addError("Referenced table " + reference + " of fereign key does not exist.");
            this.failed = true;
        }
        if (referencedtable != null) {
            ArrayList<String> refColName = new ArrayList<String>();
            refColName.add(refNode.refColumn);
            Index indexOfreference = this.getUniqueIndexForColumnNames(referencedtable, refColName);
            if (indexOfreference != null) {
                FKIndexAssociation fk = processedTable.addFK(indexOfreference);
                this.design.getRelationalDesign().stampModelObjectDDL(fk);
                ArrayList<Column> columnsRef = new ArrayList<Column>();
                Column column = this.getColumnByName(processedTable, refNode.columnName);
                if (column != null) {
                    columnsRef.add(column);
                    if (this.design.getDesign().isPropagatePKChahges()) {
                        this.replaceAllColumns(fk, columnsRef, indexOfreference);
                    } else {
                        this.fixFKColumns(fk, columnsRef, indexOfreference);
                    }
                    if (refNode.onDelete != null) {
                        String[] choisesDelete = fk.getDeleteRuleChoices();
                        for (int choise = 0; choise < choisesDelete.length; ++choise) {
                            if (!refNode.onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                            fk.setDeleteRule(choisesDelete[choise]);
                            break;
                        }
                    }
                }
            }
        }
    }

    private Table getReferencedTable(String reference) throws ObjectDoesNotExistException {
        TableSet tableSet = this.design.getDesign().getRelationalDesign().getTableSet();
        Table tableReferenced = (Table)tableSet.getByName(reference);
        if (tableReferenced != null) {
            return tableReferenced;
        }
        this.importLog.addError("Table with name " + reference + " does not exist.");
        throw new ObjectDoesNotExistException("Table with name " + reference);
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private Column getColumnByName(Table processedTable, String columnName) {
        Column[] cols = (Column[])processedTable.getElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].getName().equalsIgnoreCase(columnName)) continue;
            return cols[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    class FKRefNode {
        Table processedTable;
        List fkStatements;
        List refAtColumns;

        FKRefNode() {
        }
    }

    class RefAtColNode {
        String columnName;
        String referencedTable;
        String refColumn;
        String onDelete;

        RefAtColNode() {
        }
    }
}

