/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAlterDatabaseSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterDatabaseSqlServerv2k5
extends SHAlterDatabaseSqlServer {
    private static final String ADD_FILE = "ADD FILE";
    private static final Logger LOGGER = new Logger(SHAlterDatabaseSqlServer.class);
    private DataBaseSqlServerv2k5 db;
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHAlterDatabaseSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterDatabaseSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "alter database")) {
            try {
                this.parseAlterDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHAlterDatabaseSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseAlterDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String dbName = this.initDatabaseName();
            this.db = (DataBaseSqlServerv2k5)this.storageDesign.getDataBaseSet().getByName(dbName);
            if (this.db != null) {
                this.initFileGroup();
                this.initAddFile();
                this.initAddLogFile();
                this.initUserState();
                this.initCursorClose();
                this.initCursorDefault();
                this.initAutoClose();
                this.initAutoCreateStatistics();
                this.initAutoShrink();
                this.initAutoUpdateStatistics();
                this.initAutoUpdateStatisticsAsync();
                this.initDateCorrelationOptimization();
                this.initTrustworthy();
                this.initAllowSnapshotIsolation();
                this.initReadCommittedSnapshot();
                this.initDbChaining();
                this.initEnableBroker();
                this.initDisableBroker();
                this.initNewBroker();
                this.initErrorBrokerConversations();
                this.initReadWrite();
                this.initReadOnly();
                this.initParameterization();
                this.initPageVerify();
                this.initHonorBrokerPriority();
                this.initCompatibilityLevel();
                this.initRollbackAfter();
                this.initRollbackImmediate();
                this.initNoWait();
                this.initChangeTracking();
                this.initAutoCleanup();
                this.initEncryption();
                this.initAnsiNulls();
                this.initAnsiNullDefault();
                this.initAnsiPadding();
                this.initAnsiWarnings();
                this.initArithabort();
                this.initConcatNullYieldsNull();
                this.initNumericRoundAbort();
                this.initQuotedId();
                this.initRecursiveTriggers();
                this.initRecovery();
                this.initTornPageDetection();
            }
        }
    }

    private void initAddFile() {
        if (this.statement.toUpperCase().indexOf(ADD_FILE) > -1 && !this.statement.toLowerCase().substring(this.statement.toUpperCase().indexOf(ADD_FILE) + 8).startsWith("group")) {
            FileGroupSqlServerv2k5 fgroup;
            String files = Token.getStringAfter(this.statement, ADD_FILE);
            String groupName = "";
            if (Token.hasString(files.toLowerCase(), "to filegroup ")) {
                groupName = Token.getStringAfter(files.toLowerCase(), "to filegroup");
                files = files.substring(0, files.toLowerCase().indexOf("to filegroup "));
            }
            if (groupName.equalsIgnoreCase("")) {
                groupName = "PRIMARY";
            }
            if ((fgroup = (FileGroupSqlServerv2k5)((StorageObjectCollection)this.db.getChild(0)).getByName(groupName)) != null) {
                DataFileSqlServerv2k5 datafile = null;
                while (!files.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(files) && !Token.getValBetweenBrackets(files, 1).trim().equalsIgnoreCase("")) {
                    String file = Token.getValBetweenBrackets(files, 1);
                    StringTokenizer tokens = new StringTokenizer(file, ",");
                    String token = "";
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        if (token.trim().toUpperCase().startsWith("NAME")) {
                            String name = Token.getStringAfter(token, "NAME").trim();
                            if ((name = Token.getStringAfter(name, "=").trim()).startsWith("N'")) {
                                name = name.substring(1);
                            }
                            if (name.startsWith("'")) {
                                name = Token.getValBetweenQuotationMarks(name);
                            }
                            if ((datafile = (DataFileSqlServerv2k5)((StorageObjectCollection)fgroup.getChild(0)).getByName(name)) == null) {
                                datafile = (DataFileSqlServerv2k5)this.storageDesign.getDataFileSet().createDataFile();
                                this.design.getRelationalDesign().stampModelObjectDDL(datafile);
                                datafile.setFileGroup(fgroup);
                            }
                            datafile.setName(Token.getValBetweenSquareBrackets(name));
                            if (tokens.hasMoreTokens()) {
                                token = tokens.nextToken();
                            }
                        }
                        token = this.initLogFileName(datafile, tokens, token);
                        token = this.initLogSize(datafile, tokens, token);
                        token = this.initLogMaxSize(datafile, tokens, token);
                        this.initLogFileGrowth(datafile, token);
                    }
                    files = files.trim().substring(file.length() + 2);
                }
            }
        }
    }

    private void initAddLogFile() {
        if (this.statement.toLowerCase().indexOf("add log file ") > -1) {
            String logs = Token.getStringAfter(this.statement.toLowerCase(), "add log file");
            DataFileSqlServerv2k5 logfile = null;
            while (!logs.equalsIgnoreCase("") && !Token.getValBetweenBrackets(logs, 1).trim().equalsIgnoreCase("")) {
                String log = Token.getValBetweenBrackets(logs, 1);
                StringTokenizer tokens = new StringTokenizer(log, ",");
                String token = "";
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (token.trim().toUpperCase().startsWith("NAME")) {
                        String name = Token.getStringAfter(token, "NAME").trim();
                        if ((name = Token.getStringAfter(name, "=").trim()).startsWith("N'")) {
                            name = name.substring(1);
                        }
                        if (name.startsWith("'")) {
                            name = Token.getValBetweenQuotationMarks(name);
                        }
                        if ((logfile = (DataFileSqlServerv2k5)((StorageObjectCollection)this.db.getChild(1)).getByName(name)) == null) {
                            logfile = (DataFileSqlServerv2k5)this.storageDesign.getDataFileSet().createDataFile();
                            this.design.getRelationalDesign().stampModelObjectDDL(logfile);
                            logfile.setDataBase(this.db);
                        }
                        logfile.setName(Token.getValBetweenSquareBrackets(name));
                        if (tokens.hasMoreTokens()) {
                            token = tokens.nextToken();
                        }
                    }
                    token = this.initLogFileName(logfile, tokens, token);
                    token = this.initLogSize(logfile, tokens, token);
                    token = this.initLogMaxSize(logfile, tokens, token);
                    this.initLogFileGrowth(logfile, token);
                }
                logs = logs.trim().substring(log.length() + 2);
            }
        }
    }

    private void initFileGroup() {
        String fgroup = "";
        if (this.statement.toLowerCase().indexOf("add filegroup ") > -1 && !(fgroup = Token.getStringAfter(this.statement.toLowerCase(), "add filegroup")).equalsIgnoreCase("")) {
            FileGroupSqlServerv2k5 fg = (FileGroupSqlServerv2k5)this.storageDesign.getFileGroupSet().createFileGroup();
            fg.setName(fgroup);
            this.design.getRelationalDesign().stampModelObjectDDL(fg);
            fg.setDataBase(this.db);
        }
    }

    private void initUserState() {
        if (Token.hasToken(this.statement, "SINGLE_USER")) {
            this.db.setUserState("SINGLE_USER");
        } else if (Token.hasToken(this.statement, "RESTRICTED_USER")) {
            this.db.setUserState("RESTRICTED_USER");
        } else if (Token.hasToken(this.statement, "MULTI_USER")) {
            this.db.setUserState("MULTI_USER");
        }
    }

    private void initCursorClose() {
        if (Token.hasToken(this.statement, "CURSOR_CLOSE_ON_COMMIT")) {
            String cursorClose = Token.getTokenAfter(this.statement, "CURSOR_CLOSE_ON_COMMIT");
            this.db.setCursorCloseOnCommit(cursorClose);
        }
    }

    private void initCursorDefault() {
        if (Token.hasToken(this.statement, "CURSOR_DEFAULT")) {
            String cursorDefault = Token.getTokenAfter(this.statement, "CURSOR_DEFAULT");
            this.db.setCursorDefault(cursorDefault);
        }
    }

    private void initAutoClose() {
        if (Token.hasToken(this.statement, "AUTO_CLOSE")) {
            String autoClose = Token.getTokenAfter(this.statement, "AUTO_CLOSE");
            this.db.setAutoClose(autoClose);
        }
    }

    private void initAutoCreateStatistics() {
        if (Token.hasToken(this.statement, "AUTO_CREATE_STATISTICS")) {
            String autoCreateStatistics = Token.getTokenAfter(this.statement, "AUTO_CREATE_STATISTICS");
            this.db.setAutoCreateStatistics(autoCreateStatistics);
        }
    }

    private void initAutoShrink() {
        if (Token.hasToken(this.statement, "AUTO_SHRINK")) {
            String autoShrink = Token.getTokenAfter(this.statement, "AUTO_SHRINK");
            this.db.setAutoShrink(autoShrink);
        }
    }

    private void initAutoUpdateStatistics() {
        if (Token.hasToken(this.statement, "AUTO_UPDATE_STATISTICS")) {
            String autoUpdateStatistics = Token.getTokenAfter(this.statement, "AUTO_UPDATE_STATISTICS");
            this.db.setAutoUpdateStatistics(autoUpdateStatistics);
        }
    }

    private void initAnsiNulls() {
        if (Token.hasToken(this.statement, "ANSI_NULLS")) {
            String ansiNulls = Token.getTokenAfter(this.statement, "ANSI_NULLS");
            this.db.setAnsiNulls(ansiNulls);
        }
    }

    private void initAnsiPadding() {
        if (Token.hasToken(this.statement, "ANSI_PADDING")) {
            String ansiPadding = Token.getTokenAfter(this.statement, "ANSI_PADDING");
            this.db.setAnsiPadding(ansiPadding);
        }
    }

    private void initAnsiWarnings() {
        if (Token.hasToken(this.statement, "ANSI_WARNINGS")) {
            String ansiWarnings = Token.getTokenAfter(this.statement, "ANSI_WARNINGS");
            this.db.setAnsiWarnings(ansiWarnings);
        }
    }

    private void initArithabort() {
        if (Token.hasToken(this.statement, "ARITHABORT")) {
            String arithabort = Token.getTokenAfter(this.statement, "ARITHABORT");
            this.db.setArithabort(arithabort);
        }
    }

    private void initConcatNullYieldsNull() {
        if (Token.hasToken(this.statement, "CONCAT_NULL_YIELDS_NULL")) {
            String concatNull = Token.getTokenAfter(this.statement, "CONCAT_NULL_YIELDS_NULL");
            this.db.setConcatNullYieldsNull(concatNull);
        }
    }

    private void initNumericRoundAbort() {
        if (Token.hasToken(this.statement, "NUMERIC_ROUNDABORT")) {
            String num = Token.getTokenAfter(this.statement, "NUMERIC_ROUNDABORT");
            this.db.setNumericRoundabort(num);
        }
    }

    private void initQuotedId() {
        if (Token.hasToken(this.statement, "QUOTED_IDENTIFIER")) {
            String quotedId = Token.getTokenAfter(this.statement, "QUOTED_IDENTIFIER");
            this.db.setQuotedIdentifier(quotedId);
        }
    }

    private void initRecursiveTriggers() {
        if (Token.hasToken(this.statement, "RECURSIVE_TRIGGERS")) {
            String recTriggers = Token.getTokenAfter(this.statement, "RECURSIVE_TRIGGERS");
            this.db.setRecursiveTriggers(recTriggers);
        }
    }

    private void initRecovery() {
        if (Token.hasToken(this.statement, "RECOVERY")) {
            String recovery = Token.getTokenAfter(this.statement, "RECOVERY");
            this.db.setRecovery(recovery);
        }
    }

    private void initTornPageDetection() {
        if (Token.hasToken(this.statement, "TORN_PAGE_DETECTION")) {
            String tornPage = Token.getTokenAfter(this.statement, "TORN_PAGE_DETECTION");
            this.db.setTornPageDetection(tornPage);
        }
    }

    private String initDatabaseName() {
        String temp = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return name;
    }

    private String initLogFileName(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("FILENAME")) {
            String fname = Token.getStringAfter(token.toUpperCase(), "FILENAME").trim();
            if ((fname = Token.getStringAfter(fname, "=").trim()).startsWith("N'")) {
                fname = fname.substring(1);
            }
            if (fname.startsWith("'")) {
                fname = Token.getValBetweenQuotationMarks(fname);
            }
            logfile.setFileName(Token.getValBetweenSquareBrackets(fname));
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogSize(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("SIZE")) {
            String size = Token.getStringAfter(token, "SIZE");
            size = Token.getStringAfter(size, "=").trim();
            try {
                String unit = this.parseForUnit(size);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setInitialSizeInUnit(inUnit);
                    }
                    size = size.substring(0, size.length() - 2).trim();
                }
                logfile.setInitialSize(Integer.parseInt(size));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogMaxSize(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("MAXSIZE")) {
            String maxsize = Token.getStringAfter(token, "MAXSIZE");
            if ((maxsize = Token.getStringAfter(maxsize, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                logfile.setIsUnlimited(true);
            } else {
                try {
                    String unit = this.parseForUnit(maxsize);
                    if (!unit.equals("")) {
                        String inUnit = logfile.getSizeInUnitFromUnit(unit);
                        if (!inUnit.equals("")) {
                            logfile.setMaxSizeInUnit(inUnit);
                        }
                        maxsize = maxsize.substring(0, maxsize.length() - 2).trim();
                    }
                    logfile.setMaxSize(Integer.parseInt(maxsize));
                    logfile.setIsUnlimited(false);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("", e);
                    this.importLog.addWarning("Max size of file " + logfile.getName() + " is unknown");
                }
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private void initLogFileGrowth(DataFileSqlServerv2k5 logfile, String token) {
        if (token.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String filegrowth = Token.getStringAfter(token, "FILEGROWTH").trim();
            filegrowth = Token.getStringAfter(token, "=").trim();
            if (Token.hasString(filegrowth, "%")) {
                logfile.setGrowthMethod("By Percent");
                filegrowth = filegrowth.substring(0, filegrowth.length() - 1).trim();
            } else {
                logfile.setGrowthMethod("In MegaBytes");
            }
            try {
                String unit = this.parseForUnit(filegrowth);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setGrowthMethod(inUnit);
                    }
                    filegrowth = filegrowth.substring(0, filegrowth.length() - 2).trim();
                }
                logfile.setGrowthValue(Integer.parseInt(filegrowth));
            }
            catch (NumberFormatException e) {
                LOGGER.error("", e);
                this.importLog.addWarning("Growth value of file " + logfile.getName() + " is unknown");
            }
        }
    }

    private String parseForUnit(String spec) {
        String unit;
        if (spec.length() > 2 && ((unit = spec.substring(spec.length() - 2)).equalsIgnoreCase("KB") || unit.equalsIgnoreCase("MB") || unit.equalsIgnoreCase("GB") || unit.equalsIgnoreCase("TB"))) {
            return unit;
        }
        return "";
    }

    private void initAnsiNullDefault() {
        if (Token.hasToken(this.statement, "ANSI_NULL_DEFAULT")) {
            String ansiNullDefault = Token.getTokenAfter(this.statement, "ANSI_NULL_DEFAULT");
            this.db.setAnsiNullDefault(ansiNullDefault);
        }
    }

    private void initAutoUpdateStatisticsAsync() {
        if (Token.hasToken(this.statement, "AUTO_UPDATE_STATISTICS_ASYNC")) {
            String autoUpdateStatisticsAsync = Token.getTokenAfter(this.statement, "AUTO_UPDATE_STATISTICS_ASYNC");
            this.db.setAutoUpdateStatisticsAsync(autoUpdateStatisticsAsync);
        }
    }

    private void initDateCorrelationOptimization() {
        if (Token.hasToken(this.statement, "DATE_CORRELATION_OPTIMIZATION")) {
            String dateCorrelationOptimization = Token.getTokenAfter(this.statement, "DATE_CORRELATION_OPTIMIZATION");
            this.db.setDateCorrelationOptimization(dateCorrelationOptimization);
        }
    }

    private void initTrustworthy() {
        if (Token.hasToken(this.statement, "TRUSTWORTHY")) {
            String trustworthy = Token.getTokenAfter(this.statement, "TRUSTWORTHY");
            this.db.setTrustworthy(trustworthy);
        }
    }

    private void initAllowSnapshotIsolation() {
        if (Token.hasToken(this.statement, "ALLOW_SNAPSHOT_ISOLATION")) {
            String allowSnapshotIsolation = Token.getTokenAfter(this.statement, "ALLOW_SNAPSHOT_ISOLATION");
            this.db.setAllowSnapshotIsolation(allowSnapshotIsolation);
        }
    }

    private void initReadCommittedSnapshot() {
        if (Token.hasToken(this.statement, "READ_COMMITTED_SNAPSHOT")) {
            String readCommittedSnapshot = Token.getTokenAfter(this.statement, "READ_COMMITTED_SNAPSHOT");
            this.db.setReadCommittedSnapshot(readCommittedSnapshot);
        }
    }

    private void initDbChaining() {
        if (Token.hasToken(this.statement, "DB_CHAINING")) {
            String dbChaining = Token.getTokenAfter(this.statement, "DB_CHAINING");
            this.db.setDbChaining(dbChaining);
        }
    }

    private void initEnableBroker() {
        if (Token.hasToken(this.statement, "ENABLE_BROKER")) {
            this.db.setEnableBroker(true);
        }
    }

    private void initDisableBroker() {
        if (Token.hasToken(this.statement, "DISABLE_BROKER")) {
            this.db.setDisableBroker(true);
        }
    }

    private void initNewBroker() {
        if (Token.hasToken(this.statement, "NEW_BROKER")) {
            this.db.setNewBroker(true);
        }
    }

    private void initErrorBrokerConversations() {
        if (Token.hasToken(this.statement, "ERROR_BROKER_CONVERSATIONS")) {
            this.db.setErrorBrokerConversations(true);
        }
    }

    private void initReadWrite() {
        if (Token.hasToken(this.statement, "READ_WRITE")) {
            this.db.setReadWrite(true);
        }
    }

    private void initReadOnly() {
        if (Token.hasToken(this.statement, "READ_ONLY")) {
            this.db.setReadOnly(true);
        }
    }

    private void initParameterization() {
        if (Token.hasToken(this.statement, "PARAMETERIZATION")) {
            String parameterization = Token.getTokenAfter(this.statement, "PARAMETERIZATION");
            this.db.setParameterization(parameterization);
        }
    }

    private void initPageVerify() {
        if (Token.hasToken(this.statement, "PAGE_VERIFY")) {
            String pageVerify = Token.getTokenAfter(this.statement, "PAGE_VERIFY");
            this.db.setPageVerify(pageVerify);
        }
    }

    private void initHonorBrokerPriority() {
        if (Token.hasToken(this.statement, "HONOR_BROKER_PRIORITY")) {
            String honorBrokerPriority = Token.getTokenAfter(this.statement, "HONOR_BROKER_PRIORITY");
            this.db.setHonorBrokerPriority(honorBrokerPriority);
        }
    }

    private void initCompatibilityLevel() {
        if (Token.hasToken(this.statement, "COMPATIBILITY_LEVEL")) {
            String compatibilityLevel = Token.getTokenAfter(this.statement, "=");
            this.db.setCompatibilityLevel(compatibilityLevel);
        }
    }

    private void initRollbackAfter() {
        if (Token.hasToken(this.statement, "ROLLBACK") && Token.hasToken(this.statement, "AFTER")) {
            String rollbackAfter = Token.getTokenAfter(this.statement, "AFTER");
            this.db.setRollbackAfter(rollbackAfter);
        }
    }

    private void initRollbackImmediate() {
        if (Token.hasToken(this.statement, "ROLLBACK") && Token.hasToken(this.statement, "IMMEDIATE")) {
            this.db.setRollbackImmediate(true);
        }
    }

    private void initNoWait() {
        if (Token.hasToken(this.statement, "NO_WAIT")) {
            this.db.setNoWait(true);
        }
    }

    private void initChangeTracking() {
        if (Token.hasToken(this.statement, "CHANGE_TRACKING")) {
            String changeTracking = Token.getTokenAfter(this.statement, "=");
            this.db.setChangeTracking(changeTracking);
        }
    }

    private void initAutoCleanup() {
        if (Token.hasToken(this.statement, "AUTO_CLEANUP")) {
            String autoCleanup = Token.getTokenAfter(this.statement, "=");
            this.db.setAutoCleanup(autoCleanup);
        }
    }

    private void initEncryption() {
        if (Token.hasToken(this.statement, "ENCRYPTION")) {
            String encryption = Token.getTokenAfter(this.statement, "ENCRYPTION");
            this.db.setEncryption(encryption);
        }
    }
}

