/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDefaultSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDefaultSqlServerv2k5
extends SHCreateDefaultSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDefaultSqlServer.class);

    public SHCreateDefaultSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDefaultSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create default ")) {
            try {
                this.createDefault(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addError("Parsing " + statement + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_bindefault ")) {
            try {
                this.bindDefault(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addError("Parsing " + statement + " for SQL Server failed");
                this.importLog.addFailedStatement(SHCreateDefaultSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createDefault(String statement) {
        DefaultSqlServerv2k5 def;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (stoDesign != null && (def = (DefaultSqlServerv2k5)stoDesign.getDefaultSet().createDefault()) != null) {
            this.design.getRelationalDesign().stampModelObjectDDL(def);
            String name = Token.getStringAfter(this.statement, "CREATE DEFAULT").trim();
            name = Token.getValBetweenSquareBrackets(Token.getStringBefore(name, "AS").trim());
            if (name.indexOf(46) > -1) {
                String schemaName = Token.getValBetweenSquareBrackets(name.substring(0, name.indexOf(46)));
                StorageObjectCollection schemas = this.getCurrentDB().getSchemas();
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)schemas.getByName(schemaName);
                if (schema != null) {
                    def.setSchema(schema);
                }
                name = name.substring(name.indexOf(46) + 1);
            }
            def.setName(name);
            String exp = Token.getStringAfterToken(this.statement, " AS ").trim();
            if (exp.toUpperCase().startsWith("N'")) {
                exp = exp.substring(1);
            }
            if (exp.startsWith("'")) {
                exp = Token.getValBetweenQuotationMarks(exp);
            }
            def.setConstant(exp);
            def.setDataBase(this.getCurrentDB());
        }
    }

    private void bindDefault(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 stoDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (stoDesign != null) {
            String exp = Token.getStringAfter(this.statement.toLowerCase(), "sp_bindefault ").trim();
            StringTokenizer tokenizer = new StringTokenizer(exp, ",");
            if (tokenizer.countTokens() == 2) {
                String defName = tokenizer.nextToken().trim();
                String objName = tokenizer.nextToken().trim();
                if ((defName = Token.getValBetweenSquareBrackets(defName).trim()).startsWith("'")) {
                    defName = Token.getValBetweenQuotationMarks(defName);
                }
                if (objName.startsWith("'")) {
                    objName = Token.getValBetweenQuotationMarks(objName);
                }
                if (objName.indexOf(46) > -1) {
                    objName = objName.substring(objName.indexOf(46) + 1);
                }
                objName = Token.getValBetweenSquareBrackets(objName).trim();
                if (defName.indexOf(46) > -1) {
                    defName = defName.substring(defName.indexOf(46) + 1);
                }
                DefaultSqlServerv2k5 def = (DefaultSqlServerv2k5)stoDesign.getDefaultSet().getByName(defName);
                ColumnProxySqlServerv2k5 column = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)stoDesign.getColumnProxySet()).getByName(objName);
                if (def != null && column != null) {
                    column.setDefaultObject(def);
                    column.setDefineDefault(true);
                } else if (def != null && column == null) {
                    UsedUserDefinedDatav2k5 type = (UsedUserDefinedDatav2k5)stoDesign.getUsedUserDefinedDataSet().getByName(objName);
                    type.setDefaultObject(def);
                }
            } else {
                LOGGER.error("DefaultSqlServer.bindDefault(): wrong syntax!");
                this.importLog.addError("Wrong syntax near " + statement);
            }
        }
    }
}

