/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRuleSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RuleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateRuleSqlServerv2k5
extends SHCreateRuleSqlServer {
    private static final String RULENAME = "@rulename";
    private static final Logger LOGGER = new Logger(SHCreateRuleSqlServer.class);
    private RuleSqlServerv2k5 rule;
    private StorageDesignSqlServerv2k5 storageDesign;

    public SHCreateRuleSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateRuleSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create rule ")) {
            try {
                this.parseRule(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRuleSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "exec sp_bindrule ")) {
            try {
                this.bindRule(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateRuleSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseRule(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.rule = (RuleSqlServerv2k5)this.storageDesign.getRuleSet().createRule();
            if (this.rule != null) {
                this.initRuleName();
                this.initExpression();
                this.design.getRelationalDesign().stampModelObjectDDL(this.rule);
                if (this.rule.getDatabase() == null) {
                    this.rule.setDatabase(this.getCurrentDB());
                }
            }
        }
    }

    private void initRuleName() {
        String name = Token.getStringAfter(this.statement, "RULE").trim();
        if ((name = Token.getStringBefore(name, "AS").trim()).indexOf(46) > -1) {
            String schemaName = name.substring(0, name.indexOf(46));
            schemaName = Token.getValBetweenSquareBrackets(schemaName);
            SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().getByName(schemaName);
            if (schema != null) {
                this.rule.setSchema(schema);
                this.rule.setDatabase(schema.getDatabase());
            }
            name = name.substring(name.indexOf(46) + 1);
        }
        this.rule.setName(name);
    }

    private void initExpression() {
        String exp = Token.getStringAfter(this.statement, "AS").trim();
        this.rule.setExpression(exp);
    }

    private void bindRule(String statement) {
        String bind;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null && (bind = Token.getStringAfter(this.statement, "sp_bindrule").trim()).indexOf(44) > -1) {
            RuleSqlServerv2k5 rule;
            String name = bind.substring(0, bind.indexOf(44)).trim();
            String column = bind.substring(bind.indexOf(44) + 1).trim();
            if (name.startsWith(RULENAME)) {
                name = Token.getStringAfter(name, "=").trim();
            }
            if (name.toUpperCase().startsWith("N'")) {
                name = name.substring(1);
            }
            if (name.startsWith("'")) {
                name = Token.getValBetweenQuotationMarks(name);
            }
            if (column.startsWith("@")) {
                column = Token.getStringAfter(column, "=").trim();
            }
            if (column.toUpperCase().startsWith("N'")) {
                column = column.substring(1);
            }
            if (column.startsWith("'")) {
                column = Token.getValBetweenQuotationMarks(column);
            }
            if (name.indexOf(46) > -1) {
                name = name.substring(name.indexOf(46) + 1);
            }
            if ((rule = (RuleSqlServerv2k5)this.storageDesign.getRuleSet().getByName(name)) != null) {
                this.bindColumn(rule, column);
            }
        }
    }

    private void bindColumn(RuleSqlServerv2k5 rule, String columnString) {
        StringTokenizer tokenizer = new StringTokenizer(columnString, ".");
        String userName = null;
        String tableName = null;
        String col = null;
        String columnName = null;
        if (tokenizer.countTokens() == 2) {
            col = columnString;
            tableName = tokenizer.nextToken().trim();
            columnName = tokenizer.nextToken().trim();
        } else if (tokenizer.countTokens() == 3) {
            userName = tokenizer.nextToken().trim();
            col = columnString.substring(columnString.indexOf(".")).trim();
            tableName = tokenizer.nextToken().trim();
            columnName = tokenizer.nextToken().trim();
        } else {
            LOGGER.error("RuleSqlServer " + rule.getName() + ": wrong column syntax!");
            this.importLog.addWarning("Wrong column syntax for rule " + rule.getName());
        }
        if (userName != null) {
            userName = Token.getValBetweenSquareBrackets(userName);
            UserSqlServerv2k5 user = (UserSqlServerv2k5)this.storageDesign.getUserSet().getByName(userName);
            if (user != null) {
                rule.setOwner(user);
            }
        }
        if (col != null) {
            tableName = Token.getValBetweenSquareBrackets(tableName);
            TableProxySqlServerv2k5 table = (TableProxySqlServerv2k5)((TableProxySetSqlServerv2k5)this.storageDesign.getTableProxySet()).getByName(tableName);
            if (table != null) {
                rule.setColumns(columnName);
                rule.setDatabase(table.getDatabase());
            }
        }
    }
}

