/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateViewSqlServer;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewSqlServerv2k5
extends SHCreateViewSqlServer {
    private static final String VIEW_METADATA = "VIEW_METADATA";
    private static final Logger LOGGER = new Logger(SHCreateViewSqlServer.class);
    private AbstractView view;
    private TableViewProxySqlServerv2k5 viewProxy;
    private StorageDesignSqlServerv2k5 storageDesign;
    private String schemaName = "";
    private String userDefined;

    public SHCreateViewSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateViewSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create view")) {
            try {
                this.userDefined = SHCreateViewSqlServerv2k5.FormatCR(statement, "\n");
                this.createView(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHCreateViewSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createView(String statement) {
        this.statement = statement;
        this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
        String viewName = this.initName();
        if (this.schemaName != null && !"".equals(this.schemaName)) {
            this.view.setSchema(this.schemaName);
        }
        this.view.setName(viewName);
        this.design.getRelationalDesign().stampModelObjectDDL(this.view);
        this.initUserDefinedSql();
        if (!this.initCols()) {
            this.initCol();
        }
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.viewProxy = (TableViewProxySqlServerv2k5)this.storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID());
            if (this.viewProxy != null) {
                this.initUserAndDB();
                this.initEncription();
                this.initSchemaBinding();
                this.initViewMetadata();
                this.initCheckOptions();
                this.viewProxy.setDefinition(this.userDefined);
            }
        }
    }

    private String removeViewOptions(String sqlStatement) {
        int opt;
        String options;
        String sqlDef = sqlStatement;
        if ((Token.hasToken(sqlDef, "ENCRYPTION") || Token.hasToken(sqlDef, "SCHEMABINDING") || Token.hasToken(sqlDef, VIEW_METADATA)) && (options = Token.getStringBeforeToken(sqlDef, "AS")).length() > 0) {
            sqlDef = sqlDef.substring(options.length()).trim();
        }
        if (Token.hasToken(sqlDef, "AS")) {
            sqlDef = Token.getStringAfterToken(sqlDef, "AS").trim();
        }
        if ((opt = sqlDef.indexOf("WITH CHECK OPTION")) > 0) {
            sqlDef.substring(0, opt).trim();
        }
        return sqlDef;
    }

    private void initUserDefinedSql() {
        this.userDefined = this.removeViewOptions(this.userDefined);
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("MSSQL");
    }

    private String initName() {
        String temp = Token.getTokenAfter(this.statement, "VIEW").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "VIEW", '[', ']').trim() : Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        if (tokenizer.countTokens() == 2) {
            this.schemaName = tokenizer.nextToken().trim();
            name = tokenizer.nextToken().trim();
        }
        return name;
    }

    @Override
    public boolean initCols() {
        String beforeSelect = Token.getStringBefore(this.statement, " as select ");
        if (!Token.hasToken(beforeSelect, "OF") && Token.hasCloseAndOpenBrackets(beforeSelect)) {
            String cols = Token.getValBetweenBrackets(beforeSelect, 1);
            if (!"".equalsIgnoreCase(cols)) {
                StringTokenizer tokenizer = new StringTokenizer(cols, ",");
                String column = "";
                while (tokenizer.hasMoreTokens()) {
                    column = Token.removeQuotes(tokenizer.nextToken());
                    AbstractViewElement cvExp = this.view.createViewElement(this.design.getDesign().getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    cvExp.setName(column);
                    cvExp.setDesign(this.design);
                    cvExp.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                    this.view.add(cvExp);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void initCol() {
        if (this.statement.toLowerCase().trim().indexOf(" as select ") > -1) {
            String stmt = Token.getStringAfter(this.statement, "as select").trim();
            if (Token.hasToken(this.statement, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.toUpperCase().indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("TOP")) {
                stmt = Token.cutFirstToken(stmt);
                stmt = Token.cutFirstToken(stmt);
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("PERCENT")) {
                stmt = Token.cutFirstToken(stmt);
            }
            if (stmt.toUpperCase().startsWith("WITH TIES")) {
                stmt = stmt.substring(9).trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getNameAfterToken(column, "AS", '[', ']');
                    column = Token.getStringBeforeToken(column, "AS");
                }
                column = Token.encodeQuotedString(column);
                if ((column = Token.encodeSquareBracketsString(column)).indexOf(" ") > -1) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else if (column.charAt(column.length() - 1) == '\'') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(39);
                        columnAlias = columnAlias.substring(lastIndex) + "'";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                if (!(Token.hasCloseAndOpenBrackets(column) || column.indexOf(43) != -1 || column.indexOf(45) != -1 || column.indexOf(42) != -1 || column.indexOf(47) != -1 || column.indexOf(37) != -1 || column.indexOf(38) != -1 || column.indexOf(124) != -1 || column.indexOf(94) != -1 || Token.hasToken(column, "OR") || Token.hasToken(column, "BETWEEN") || Token.hasToken(column, "AND") || column.indexOf(46) <= -1 || (column = column.substring(column.indexOf(46) + 1)).indexOf(46) <= -1)) {
                    column = column.substring(column.indexOf(46) + 1);
                }
                if ((column = Token.removeQuotes(Token.decodeQuotedString(column))).equalsIgnoreCase("") || column.equalsIgnoreCase("*")) continue;
                AbstractViewElement cvExp = this.view.createViewElement(this.design.getDesign().getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                cvExp.setName(column);
                cvExp.setDesign(this.design);
                cvExp.setExpression(column);
                cvExp.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                this.view.add(cvExp);
                if (columnAlias != null) {
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString(columnAlias));
                    cvExp.setAlias(columnAlias);
                    cvExp.setHeaderAlias(columnAlias);
                    continue;
                }
                cvExp.setAlias(cvExp.getName());
            }
        }
    }

    private void initUserAndDB() {
        DataBaseSqlServerv2k5 db = null;
        if (!this.schemaName.equalsIgnoreCase("")) {
            SchemaSqlServerv2k5 user = (SchemaSqlServerv2k5)this.storageDesign.getSchemaSet().getByName(this.schemaName);
            if (user != null) {
                this.viewProxy.setSchema(user);
                db = (DataBaseSqlServerv2k5)user.getDatabase();
            } else {
                db = (DataBaseSqlServerv2k5)this.storageDesign.getDataBaseSet().getByName(this.schemaName);
            }
        }
        if (db == null) {
            db = (DataBaseSqlServerv2k5)this.getCurrentDB();
        }
        this.viewProxy.setDataBase(db);
    }

    private void initEncription() {
        if (this.statement.toUpperCase().indexOf("ENCRYPTION") > -1) {
            this.viewProxy.setEncryption("YES");
        } else {
            this.viewProxy.setEncryption("NO");
        }
    }

    private void initSchemaBinding() {
        if (this.statement.toUpperCase().indexOf("SCHEMABINDING") > -1) {
            this.viewProxy.setSchemaBinding("YES");
        } else {
            this.viewProxy.setSchemaBinding("NO");
        }
    }

    private void initViewMetadata() {
        if (this.statement.toUpperCase().indexOf(VIEW_METADATA) > -1) {
            this.viewProxy.setViewMetaData("YES");
        } else {
            this.viewProxy.setViewMetaData("NO");
        }
    }

    private void initCheckOptions() {
        if (this.statement.toUpperCase().indexOf("WITH CHECK OPTION") > -1) {
            this.viewProxy.setCheckOption(true);
        } else {
            this.viewProxy.setCheckOption(false);
        }
    }

    @Override
    public void setView(AbstractView view) {
        this.view = view;
    }
}

