/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCommentOnUDB
extends DDLStatementHandler {
    protected static final Logger LOGGER = new Logger(SHCommentOnUDB.class);

    public SHCommentOnUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCommentOnUDB.clearCR(line);
        if (Token.startsWithString(statement, "comment on")) {
            try {
                this.parseCommentOn(statement, line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCommentOnUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseCommentOn(String statement, String line) {
        String onObject = this.getNameOnly(Token.getTokenAfter(statement, "ON").trim());
        String comment = Token.getStringAfter(line, "IS");
        comment = Token.getValBetweenQuotationMarks(comment);
        if (onObject.trim().equalsIgnoreCase("ALIAS")) {
            onObject = Token.getStringAfter(statement, "ALIAS");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            AliasUDB alias = (AliasUDB)storageDesign.getAliasSet().getByName(onObject);
            if (alias != null) {
                alias.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("COLUMN")) {
            onObject = Token.getStringAfter(statement, "COLUMN");
            onObject = Token.getStringBefore(onObject, "IS");
            StringTokenizer tokenizer = new StringTokenizer(onObject, ".");
            String tbName = null;
            if (tokenizer.countTokens() == 3) {
                tokenizer.nextToken();
                tbName = tokenizer.nextToken();
                onObject = tokenizer.nextToken();
            } else if (tokenizer.countTokens() == 2) {
                tbName = tokenizer.nextToken();
                onObject = tokenizer.nextToken();
            }
            DesignObject column = null;
            TableView view = null;
            if (tbName != null) {
                Table table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tbName);
                if (table != null) {
                    column = table.getElementByName(onObject);
                } else {
                    view = (TableView)this.design.getRelationalDesign().getTableViewSet().getByName(tbName);
                    if (view != null) {
                        column = view.getElementByName(onObject);
                    }
                }
                if (column == null) {
                    column = this.design.getRelationalDesign().getColumnSet().getByName(onObject);
                }
            } else {
                column = this.design.getRelationalDesign().getColumnSet().getByName(onObject);
            }
            if (column != null) {
                if (view != null) {
                    column.setCommentInRDBMS(comment);
                } else {
                    RDBMSSite site = this.design.getSelectedRDBMSSite();
                    StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
                    ColumnProxyUDB columnProxy = (ColumnProxyUDB)storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                    if (columnProxy != null) {
                        column.setCommentInRDBMS(comment);
                        columnProxy.setCommentInRDBMS(comment);
                    }
                }
            }
        } else if (onObject.trim().equalsIgnoreCase("PROCEDURE")) {
            onObject = Token.getStringAfter(statement, "PROCEDURE");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            StoredProcedureUDB proc = (StoredProcedureUDB)storageDesign.getStoredProcedureSet().getByName(onObject);
            if (proc != null) {
                proc.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("TABLE")) {
            onObject = Token.getStringAfter(statement, "TABLE");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            Table table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(onObject);
            TableView view = (TableView)this.design.getDesign().getRelationalDesign().getTableViewSet().getByName(onObject);
            if (table != null) {
                table.setCommentInRDBMS(comment);
            } else if (view != null) {
                view.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("TABLESPACE")) {
            onObject = Token.getStringAfter(statement, "TABLESPACE");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            TableSpaceUDB tspace = (TableSpaceUDB)storageDesign.getTableSpaceSet().getByName(onObject);
            if (tspace != null) {
                tspace.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("TRIGGER")) {
            onObject = Token.getStringAfter(statement, "TRIGGER");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            TriggerUDB tr = (TriggerUDB)storageDesign.getTriggerSet().getByName(onObject);
            if (tr != null) {
                tr.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("NODEGROUP")) {
            onObject = Token.getStringAfter(statement, "NODEGROUP");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            NodeGroupUDB nodegroup = (NodeGroupUDB)storageDesign.getNodeGroupSet().getByName(onObject);
            if (nodegroup != null) {
                nodegroup.setCommentInRDBMS(comment);
            }
        } else if (onObject.trim().equalsIgnoreCase("SCHEMA")) {
            onObject = Token.getStringAfter(statement, "SCHEMA");
            onObject = Token.getStringBefore(onObject, "IS");
            onObject = this.getNameOnly(onObject.trim());
            onObject = Token.getName(onObject);
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(onObject);
            if (schema != null) {
                schema.setCommentInRDBMS(comment);
            }
        }
    }
}

