/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTriggerUDB;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerUDB.class);

    public SHCreateStoredProcedureUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateStoredProcedureUDB.clearCR(line);
        if (Token.startsWithString(statement, "create procedure")) {
            try {
                this.parseStoredProcedure(statement, line);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateStoredProcedureUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseStoredProcedure(String statement, String line) {
        StoredProcedureUDB proc;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (storageDesign != null && (proc = storageDesign.getStoredProcedureSet().createStoredProcedure()) != null) {
            this.initStoredProcedureName(storageDesign, proc, statement);
            this.initBody(proc, line, statement);
            this.design.getRelationalDesign().stampModelObjectDDL(proc);
        }
    }

    private void initStoredProcedureName(StorageDesignUDB storageDesign, StoredProcedureUDB proc, String statement) {
        String name = Token.getQuotedNameAfterToken(statement, "PROCEDURE").trim();
        if (name.indexOf(46) > -1) {
            String schemaName = name.substring(0, name.indexOf(46)).trim();
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(schemaName);
            if (schema == null) {
                schema = storageDesign.getSchemaSet().createSchema();
                schema.setName(schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            proc.setSchema(schema);
            proc.setOwner(schema.getOwner());
            name = name.substring(name.indexOf(46) + 1);
        }
        proc.setName(name);
    }

    private void initBody(StoredProcedureUDB proc, String line, String statement) {
        String procName;
        int endNameIndex;
        String body;
        String afterProc = Token.getStringAfter(line, "PROCEDURE");
        int startIndex = 0;
        if (proc.getSchema() != null) {
            String schemaName = proc.getSchema().getName();
            startIndex = afterProc.indexOf(schemaName) + schemaName.length();
        }
        if ((body = afterProc.substring(endNameIndex = afterProc.indexOf(procName = proc.getName(), startIndex) + procName.length()).trim()).startsWith("\"")) {
            body = body.substring(1).trim();
        }
        proc.setBody(body);
    }
}

