/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTriggerUDB
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateTriggerUDB.class);
    private TriggerUDB trigger;
    private StorageDesignUDB storageDesign;
    private String line;

    public SHCreateTriggerUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTriggerUDB.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "create trigger") || Token.startsWithString(statement, "CREATE TRIGGER")) {
            this.parseTrigger(statement);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseTrigger(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            this.trigger = this.storageDesign.getTriggerSet().createTrigger();
            if (this.trigger != null) {
                try {
                    this.initTriggerName();
                    this.initTriggeringTime();
                    this.initAction();
                    this.initOnTable();
                    this.initReferencing();
                    this.initScope();
                    this.initCondition();
                    this.initBody();
                    this.design.getRelationalDesign().stampModelObjectDDL(this.trigger);
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                    this.importLog.addFailedStatement(SHCreateTriggerUDB.FormatCR(this.line, "\n"));
                }
            }
        }
    }

    private void initTriggerName() {
        String name = Token.getTokenAfter(this.statement, "TRIGGER").trim();
        if (name.indexOf(46) > -1) {
            String schemaName = name.substring(0, name.indexOf(46));
            schemaName = Token.getValBetweenSquareBrackets(schemaName);
            SchemaUDB schema = (SchemaUDB)this.storageDesign.getSchemaSet().getByName(schemaName);
            if (schema != null) {
                this.trigger.setSchema(schema);
            }
            name = name.substring(name.indexOf(46) + 1);
        }
        this.trigger.setName(name);
    }

    private void initTriggeringTime() throws ParseException {
        if (Token.hasString(this.statement, "NO CASCADE BEFORE")) {
            this.trigger.setTriggerTime(TriggerUDB.TRIGGER_TIMES[0]);
        } else if (Token.hasString(this.statement, "AFTER")) {
            this.trigger.setTriggerTime(TriggerUDB.TRIGGER_TIMES[1]);
        } else {
            this.importLog.addError("Unknown triggering time for trigger " + this.trigger.getName());
            throw new ParseException("Error parsing triggering time for trigger " + this.trigger.getName() + "(UDB) ");
        }
    }

    private void initAction() {
        String trTime = this.trigger.getTriggerTime();
        if (trTime != null) {
            String of;
            String str = Token.getStringAfter(this.statement, trTime);
            String action = Token.getFirstToken(str);
            this.trigger.setActions(action);
            if (action.equalsIgnoreCase("UPDATE") && (of = Token.getFirstToken(str = Token.getStringAfter(str, "UPDATE").trim()).trim()).equalsIgnoreCase("OF")) {
                str = str.substring(2, str.indexOf(" ON "));
                this.trigger.setColumns(str);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initOnTable() throws ParseException {
        String str = this.statement.substring(this.statement.indexOf(" ON ") + 3).trim();
        str = Token.getFirstToken(str);
        String name = Token.getLastToken(str);
        String ownerName = "";
        if (name.indexOf(40) > -1) {
            name = Token.getStringBefore(name, "(").trim();
        }
        if (name.indexOf(46) > -1) {
            ownerName = name.substring(0, name.indexOf(46)).trim();
            name = name.substring(name.indexOf(46) + 1).trim();
        }
        if (!"".equals(ownerName)) {
            if (((TableProxySetUDB)this.storageDesign.getTableProxySet()).getByUserSchemaAndName(ownerName, name) != null) {
                this.trigger.setTable((TableProxyUDB)((TableProxySetUDB)this.storageDesign.getTableProxySet()).getByUserSchemaAndName(ownerName, name));
                return;
            }
            this.importLog.addError("Specified table on trigger " + this.trigger.getName() + "does not exist");
            throw new ParseException("Specified table or view on trigger " + this.trigger.getName() + "does not exist ");
        }
        if (((TableProxySetUDB)this.storageDesign.getTableProxySet()).getByName(name) != null) {
            this.trigger.setTable(((TableProxySetUDB)this.storageDesign.getTableProxySet()).getByName(name));
            return;
        }
        this.importLog.addError("Specified table on trigger " + this.trigger.getName() + "does not exist");
        throw new ParseException("Specified table on trigger " + this.trigger.getName() + "does not exist ");
    }

    private void initReferencing() {
        if (Token.hasString(this.statement, "REFERENCING")) {
            String str;
            String refer = Token.getStringAfter(this.statement, "REFERENCING");
            if (Token.hasString(refer, "OLD AS ")) {
                str = refer.substring(refer.indexOf("OLD AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(str));
            } else if (Token.hasString(refer, "OLD_AS ")) {
                str = refer.substring(refer.indexOf("OLD_AS ") + 6);
                this.trigger.setRef_OLD_AS(Token.getFirstToken(str));
            } else {
                str = Token.getStringAfter(refer, " OLD ").trim();
                if (!str.equalsIgnoreCase("") && !Token.getFirstToken(str).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_OLD_AS(Token.getFirstToken(str));
                }
            }
            if (Token.hasString(refer, "NEW AS ")) {
                str = refer.substring(refer.indexOf("NEW AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(str));
            } else if (Token.hasString(refer, "NEW_AS ")) {
                str = refer.substring(refer.indexOf("NEW_AS ") + 6);
                this.trigger.setRef_NEW_AS(Token.getFirstToken(str));
            } else {
                str = Token.getStringAfter(refer, " NEW ").trim();
                if (!str.equalsIgnoreCase("") && !Token.getFirstToken(str).equalsIgnoreCase("TABLE")) {
                    this.trigger.setRef_NEW_AS(Token.getFirstToken(str));
                }
            }
            if (Token.hasString(refer, "OLD TABLE AS ")) {
                str = refer.substring(refer.indexOf("OLD TABLE AS ") + 13);
                this.trigger.setOLD_TABLE_AS(Token.getFirstToken(str));
            }
            if (Token.hasString(refer, "NEW TABLE AS ")) {
                str = refer.substring(refer.indexOf("NEW TABLE AS ") + 13);
                this.trigger.setNEW_TABLE_AS(Token.getFirstToken(str));
            }
        }
    }

    private void initScope() throws ParseException {
        if (Token.hasString(this.statement, "FOR EACH ROW")) {
            this.trigger.setScope(TriggerUDB.SCOPE_TYPES[0]);
        } else if (Token.hasString(this.statement, "FOR EACH STATEMENT")) {
            this.trigger.setScope(TriggerUDB.SCOPE_TYPES[1]);
        } else {
            this.importLog.addError("Scope is not specified on trigger " + this.trigger.getName());
            throw new ParseException("Scope is not specified on trigger " + this.trigger.getName());
        }
    }

    private void initCondition() {
        if (Token.hasString(this.statement, "WHEN")) {
            String str = Token.getStringAfter(this.statement, "WHEN");
            this.trigger.setCondition(Token.getValBetweenBrackets(str, 1).trim());
        }
    }

    private void initBody() {
        String body = Token.getStringAfter(this.statement, "MODE DB2SQL").trim();
        if (!this.trigger.getCondition().trim().equalsIgnoreCase("")) {
            body = Token.getStringAfter(body, this.trigger.getCondition()).trim();
            body = body.substring(1);
        }
        this.trigger.setBody(body);
    }
}

