/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsUDBv81
implements StatementsConstants {
    private static final String ZERO = "0";
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private static final String NO_CACHE = "NO CACHE";
    private static final String NO_CYCLE = "NO CYCLE";
    private static final String NO_MAXVALUE = "NO MAXVALUE";
    private static final String NO_MINVALUE = "NO MINVALUE";
    private static final String NO_ORDER = "NO ORDER";
    private static final String INCREMENT_BY = "INCREMENT BY";
    private static final String NOT_ENFORCED = "NOT ENFORCED";
    private static final String DISABLE_QUERY_OPTIMIZATION = "DISABLE QUERY OPTIMIZATION";
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElementsUDBv81.class);
    private String tstatement = "";

    private void parseColumns(String columnStatement, boolean isSummary) {
        this.statement = columnStatement;
        this.mapElementsColumn = new HashMap();
        this.tstatement = this.statement.toUpperCase();
        try {
            if (this.initColumnName()) {
                if (!isSummary) {
                    this.initDatatype();
                }
                this.initNotNull();
                this.initWithDefault();
                this.initLobOptions();
                this.initDataLinkOptions();
                this.initIdentity();
                this.initCompressSystemDefault();
                this.initPrimaryKeyOrUnique();
                this.initFor();
                this.initReferences();
                this.initConstraintCheck();
            } else {
                this.initConstraints();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + this.statement + " for UDB failed!", e);
        }
    }

    private boolean initColumnName() {
        String value = Token.getFirstToken(this.statement);
        if (this.constraints.contains(value.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        String columnName = "";
        if (this.statement.indexOf("\"") > -1) {
            columnName = Token.getValBetweenDoubleQuotes(this.statement);
            this.statement = Token.getStringAfter(this.statement, columnName);
            this.statement = Token.cutFirstToken(this.statement);
        } else {
            columnName = Token.getFirstToken(this.statement).trim();
            this.statement = Token.getStringAfter(this.statement, columnName);
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", columnName);
        return true;
    }

    private void initDatatype() {
        if (!Token.hasString(this.statement, "USER GENERATED") && !this.statement.startsWith("FOREIGN")) {
            int index;
            String dtName = this.statement;
            String dtype = this.searchWhichDatatype(dtName);
            String type = null;
            String afterType = null;
            if (dtype != null) {
                type = dtype;
                afterType = Token.getStringAfter(this.statement, dtype).trim();
                if (afterType.startsWith("(") && (index = afterType.indexOf(")")) > -1) {
                    type = dtype + afterType.substring(0, index + 1);
                }
            }
            if (dtype == null) {
                dtype = this.searchNotStandartDatatypes(this.statement);
                if (dtype != null && !"".equalsIgnoreCase(this.statement.trim())) {
                    type = dtype;
                    afterType = Token.getStringAfter(this.statement, dtype).trim();
                    if (afterType.startsWith("(") && (index = afterType.indexOf(")")) > -1) {
                        type = dtype + afterType.substring(0, index + 1);
                    }
                    this.mapElementsColumn.put("typename", type);
                } else {
                    this.mapElementsColumn.put(NameElements.COL_STRUCTURED_TYPE, dtName);
                }
            }
            if (dtype != null) {
                String datatype = StandardDatatypeNames.getUsedDatatypeName(dtype);
                if (Token.hasCloseAndOpenBrackets(datatype)) {
                    type = datatype;
                    dtype = datatype = Token.getValBeforeBrackets(datatype).trim();
                }
                if (datatype != null) {
                    type = Token.cutTokenFromFront(type, dtype);
                    this.mapElementsColumn.put("datatype", datatype);
                    if (!type.equalsIgnoreCase("")) {
                        boolean hasBrackets = Token.hasCloseAndOpenBrackets(type);
                        if (hasBrackets) {
                            String parameters = Token.getValBetweenBrackets(type, 1);
                            int positionKomma = parameters.indexOf(",");
                            if (positionKomma != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                            } else if (datatype.equals("DECIMAL")) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", parameters.trim());
                            } else if (datatype.equalsIgnoreCase("NUMERIC")) {
                                if (positionKomma != -1) {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                    this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                                } else {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", parameters.trim());
                                    this.mapElementsColumn.put("scale", ZERO);
                                }
                            } else {
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", ZERO);
                                this.mapElementsColumn.put("size", parameters.trim());
                            }
                            this.statement = Token.cutFirstToken(this.statement);
                        }
                    } else {
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    StringBuffer message = new StringBuffer("datatype is unknown in SHColumnElements.initDatatype: ");
                    LOGGER.error(message.toString());
                }
            } else {
                this.statement = Token.cutFirstToken(this.statement);
            }
        }
    }

    protected String searchWhichDatatype(String statement) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("DB2/UDB 9");
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = statement.toUpperCase().startsWith(name);
            if (!isTrue) continue;
            try {
                char nextChar = statement.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t' || nextChar == ',' || nextChar == ')';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private String searchNotStandartDatatypes(String string) {
        String[] names = NotStandartDataTypeNames.getAllNewTypes();
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = string.startsWith(name);
            if (!isTrue) continue;
            try {
                char nextChar = string.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private void initNotNull() {
        String notNull;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValAfterBrackets(this.statement.trim(), 1);
        }
        if ((notNull = Token.getFirstToken(this.statement).trim()).equalsIgnoreCase("NOT")) {
            if ("NULL".equalsIgnoreCase(Token.getTokenAfter(this.statement, "NOT"))) {
                this.mapElementsColumn.put("NOT NULL", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "NOT NULL");
            } else {
                this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
            }
        } else {
            this.mapElementsColumn.put("NOT NULL", Boolean.FALSE);
        }
    }

    private void initIdentity() {
        String gen = Token.getFirstToken(this.statement).trim();
        if (gen.equalsIgnoreCase("GENERATED")) {
            this.statement = Token.cutTokenFromFront(this.statement, "GENERATED");
            String generate = Token.getFirstToken(this.statement).trim();
            if (generate.equalsIgnoreCase("ALWAYS")) {
                this.mapElementsColumn.put("GENERATED", "ALWAYS");
            } else if (generate.equalsIgnoreCase("BY")) {
                this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
            }
            if (Token.hasCloseAndOpenBrackets(this.statement) && this.statement.toUpperCase().indexOf("IDENTITY") > -1) {
                int pos = this.statement.indexOf(40);
                this.statement = this.statement.substring(pos).trim();
                String elements = Token.getValBetweenBrackets(this.statement);
                if (elements.indexOf("START") > -1) {
                    String startWith = Token.getTokenAfter(elements, "WITH");
                    this.mapElementsColumn.put("START", startWith);
                }
                if (elements.indexOf(INCREMENT_BY) > -1) {
                    String increment = Token.getTokenAfter(elements, "BY");
                    this.mapElementsColumn.put("INCREMENT", increment);
                }
                if (Token.hasToken(elements, "CACHE")) {
                    if (elements.indexOf(NO_CACHE) > -1) {
                        this.mapElementsColumn.put("CACHE", "NO");
                    } else {
                        String cache = Token.getTokenAfter(elements, "CACHE");
                        this.mapElementsColumn.put("CACHE", cache);
                    }
                }
                if (Token.hasToken(elements, "CYCLE")) {
                    if (elements.indexOf(NO_CYCLE) > -1) {
                        this.mapElementsColumn.put("CYCLE", "NO");
                    } else {
                        this.mapElementsColumn.put("CYCLE", "YES");
                    }
                }
                if (Token.hasToken(elements, "MAXVALUE")) {
                    if (elements.indexOf(NO_MAXVALUE) > -1) {
                        this.mapElementsColumn.put("MAXVALUE", "NO");
                    } else {
                        String maxValue = Token.getTokenAfter(elements, "MAXVALUE");
                        this.mapElementsColumn.put("MAXVALUE", maxValue);
                    }
                }
                if (Token.hasToken(elements, "MINVALUE")) {
                    if (elements.indexOf(NO_MINVALUE) > -1) {
                        this.mapElementsColumn.put("MINVALUE", "NO");
                    } else {
                        String minValue = Token.getTokenAfter(elements, "MINVALUE");
                        this.mapElementsColumn.put("MINVALUE", minValue);
                    }
                }
                if (Token.hasToken(elements, "ORDER")) {
                    if (elements.indexOf(NO_ORDER) > -1) {
                        this.mapElementsColumn.put("ORDER", "NO");
                    } else {
                        this.mapElementsColumn.put("ORDER", "YES");
                    }
                }
                pos = this.statement.indexOf(41);
                this.statement = this.statement.substring(pos + 1).trim();
            } else if (Token.hasCloseAndOpenBrackets(this.statement)) {
                int pos = this.statement.indexOf(40);
                this.statement = this.statement.substring(pos).trim();
                String generationExpression = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("GENERATION_EXPRESSION", generationExpression);
                pos = this.statement.indexOf(41);
                this.statement = this.statement.substring(pos + 1).trim();
            }
        }
    }

    private void initCompressSystemDefault() {
        if (this.statement.toUpperCase().indexOf("COMPRESS SYSTEM DEFAULT") > -1) {
            this.mapElementsColumn.put("COMPRESS SYSTEM DEFAULT", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("COMPRESS SYSTEM DEFAULT", Boolean.FALSE);
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean isPrimary = Token.isTokenEqualTo(this.statement, 1, "PRIMARY");
        boolean isKey = Token.isTokenEqualTo(this.statement, 2, "KEY");
        if (isPrimary && isKey) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "PRIMARY KEY");
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            boolean isUnique = Token.isTokenEqualTo(this.statement, 1, "UNIQUE");
            if (isUnique) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
                this.statement = Token.cutTokenFromFront(this.statement, "UNIQUE");
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initWithDefault() {
        int ind = this.statement.indexOf("WITH");
        if (ind > -1) {
            boolean isDefault;
            this.statement = this.statement.substring(ind);
            boolean isWith = Token.isTokenEqualTo(this.statement, 1, "WITH");
            if (isWith) {
                this.statement = Token.cutTokenFromFront(this.statement, "WITH");
            }
            if (isDefault = Token.isTokenEqualTo(this.statement, 1, "DEFAULT")) {
                this.statement = Token.cutTokenFromFront(this.statement, "DEFAULT");
                String withDefault = "";
                if (Token.getFirstToken(this.statement).startsWith("'")) {
                    withDefault = Token.getValBetweenQuotes(this.statement).trim();
                    this.statement = Token.getStringAfter(this.statement, withDefault);
                } else {
                    withDefault = Token.getFirstToken(this.statement);
                }
                this.statement = Token.cutFirstToken(this.statement);
                this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
                if (!(withDefault.equalsIgnoreCase("REFERENCES") || withDefault.equalsIgnoreCase("CONSTRAINT") || withDefault.equalsIgnoreCase("FIELDPROC"))) {
                    this.mapElementsColumn.put("DEFAULT", withDefault);
                }
            } else {
                this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
            }
        }
    }

    private void initConstraintCheck() {
        boolean isCheck;
        boolean isConstraint;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        if (isConstraint = Token.isTokenEqualTo(this.statement, 1, "CONSTRAINT")) {
            this.statement = Token.cutTokenFromFront(this.statement, "CONSTRAINT");
            String constraint = Token.getFirstToken(this.statement).trim();
            this.mapElementsColumn.put("CONSTRAINT", constraint);
            this.statement = Token.cutTokenFromFront(this.statement, constraint);
        }
        if (isCheck = Token.isTokenEqualTo(this.statement, 1, "CHECK")) {
            this.statement = Token.cutTokenFromFront(this.statement, "CHECK");
            String check = Token.getFirstToken(this.statement).trim();
            this.statement = Token.cutTokenFromFront(this.statement, check);
            if (Token.hasOpenBracketNoClose(check)) {
                String check2;
                StringBuffer checkSB = new StringBuffer(check);
                while (!Token.hasCloseBracket(Token.getFirstToken(this.statement)) && !(check2 = Token.getFirstToken(this.statement)).equals("")) {
                    checkSB.append(" ").append(check2);
                    this.statement = Token.cutTokenFromFront(this.statement, check2);
                }
                checkSB.append(" )");
                checkSB.append(" )");
                check = checkSB.toString();
                this.statement = Token.cutTokenFromFront(this.statement, ")");
            }
            check = Token.getValBetweenBrackets(check);
            this.mapElementsColumn.put("CHECK", check);
            if (this.statement.toUpperCase().indexOf(NOT_ENFORCED) > -1) {
                this.mapElementsColumn.put("VALIDATION", "NO");
            } else {
                this.mapElementsColumn.put("VALIDATION", "YES");
            }
            if (this.statement.toUpperCase().indexOf(DISABLE_QUERY_OPTIMIZATION) > -1) {
                this.mapElementsColumn.put("QUERY OPTIMIZATION", "DISABLE");
            } else {
                this.mapElementsColumn.put("QUERY OPTIMIZATION", "ENABLE");
            }
        }
    }

    public Map getElementsColumn(String statement, boolean isSummary) {
        this.parseColumns(statement.replaceAll("\"", ""), isSummary);
        return this.mapElementsColumn;
    }

    private void initLobOptions() {
        String notLogged = Token.getFirstToken(this.statement).trim();
        if (notLogged.equalsIgnoreCase("NOT")) {
            this.mapElementsColumn.put("NOT LOGGED", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "NOT LOGGED").trim();
        } else {
            this.mapElementsColumn.put("NOT LOGGED", Boolean.FALSE);
        }
        String compact = Token.getFirstToken(this.statement).trim();
        if (compact.equalsIgnoreCase("COMPACT")) {
            this.mapElementsColumn.put("COMPACT", Boolean.TRUE);
            this.statement = Token.cutTokenFromFront(this.statement, "COMPACT").trim();
        } else {
            this.mapElementsColumn.put("COMPACT", Boolean.FALSE);
        }
    }

    private void initDataLinkOptions() {
        String part = Token.getFirstToken(this.statement).trim();
        if (part.equalsIgnoreCase("LINKTYPE")) {
            if (Token.hasToken(this.statement, "INTEGRITY")) {
                this.mapElementsColumn.put("INTEGRITY", Boolean.TRUE);
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("READ")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                this.statement = Token.cutTokenFromFront(this.statement, "READ").trim();
                this.statement = Token.cutTokenFromFront(this.statement, "PERMISSION").trim();
                String readPermission = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("READ", readPermission);
                this.statement = Token.cutFirstToken(this.statement);
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("WRITE")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                this.statement = Token.cutTokenFromFront(this.statement, "WRITE").trim();
                this.statement = Token.cutTokenFromFront(this.statement, "PERMISSION").trim();
                String writePermission = Token.getStringAfter(this.statement, "WRITE PERMISSION").trim();
                if (writePermission.toUpperCase().startsWith("FS")) {
                    writePermission = "FS";
                } else if (writePermission.toUpperCase().startsWith("BLOCKED")) {
                    writePermission = "BLOCKED";
                } else if (writePermission.toUpperCase().startsWith("ADMIN REQUIRING TOKEN FOR UPDATE")) {
                    writePermission = "ADMIN REQUIRING TOKEN FOR UPDATE";
                } else if (writePermission.toUpperCase().startsWith("ADMIN NOT REQUIRING TOKEN FOR UPDATE")) {
                    writePermission = "ADMIN NOT REQUIRING TOKEN FOR UPDATE";
                }
                this.mapElementsColumn.put("WRITE", writePermission);
                this.statement = Token.cutFirstToken(this.statement);
                part = Token.getFirstToken(this.statement).trim();
                if (part.equalsIgnoreCase("RECOVERY")) {
                    this.statement = Token.cutTokenFromFront(this.statement, "RECOVERY").trim();
                    String recovery = Token.getFirstToken(this.statement).trim();
                    this.mapElementsColumn.put("RECOVERY", recovery);
                    this.statement = Token.cutFirstToken(this.statement);
                }
                if ((part = Token.getFirstToken(this.statement).trim()).equalsIgnoreCase("ON")) {
                    if ("UNLINK".equalsIgnoreCase(Token.getTokenAfter(this.statement, "ON"))) {
                        this.statement = Token.cutFirstToken(this.statement);
                        this.statement = Token.cutFirstToken(this.statement);
                        String onUnLink = Token.getFirstToken(this.statement).trim();
                        this.mapElementsColumn.put("UNLINK", onUnLink);
                        this.statement = Token.cutFirstToken(this.statement);
                    } else {
                        this.mapElementsColumn.put("UNLINK", "RESTORE");
                    }
                }
            } else {
                this.mapElementsColumn.put("INTEGRITY", Boolean.FALSE);
            }
        }
    }

    private void initConstraints() {
        String value = Token.getFirstToken(this.statement);
        if (value.equalsIgnoreCase("CONSTRAINT")) {
            String name = Token.getTokenAfter(this.statement, "CONSTRAINT").trim();
            this.statement = Token.getStringAfterToken(this.statement, name);
            this.mapElementsColumn.put("CONSTRAINT_NAME", name);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initTableConstraints() {
        boolean isCheck = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (isCheck) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String value = Token.getValBetweenBrackets(this.statement);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", value);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }

    private void initReferences() {
        boolean isReferences = Token.isTokenEqualTo(this.statement, 1, "REFERENCES");
        if (isReferences) {
            boolean isOn;
            this.statement = Token.cutTokenFromFront(this.statement, "REFERENCES");
            String references = Token.getFirstToken(this.statement);
            int ind = references.indexOf("(");
            if (ind > 0) {
                references = references.substring(0, ind);
            }
            this.mapElementsColumn.put("REFERENCES", references);
            this.statement = Token.cutTokenFromFront(this.statement, references);
            boolean hasBrackets = Token.hasString(this.statement, "(");
            if (hasBrackets) {
                String columnReferenced = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("REFERENCED_COLUMN", columnReferenced);
            }
            if (isOn = Token.isTokenEqualTo(this.statement, 1, "ON")) {
                this.statement = Token.cutTokenFromFront(this.statement, "ON DELETE");
                String onDelete = Token.getFirstToken(this.statement).trim();
                this.mapElementsColumn.put("ON DELETE", onDelete);
                this.statement = Token.cutTokenFromFront(this.statement, onDelete);
            }
        }
    }

    private void initFor() {
        boolean isFor;
        int ind = this.tstatement.indexOf("FOR");
        if (ind > -1 && (isFor = Token.isTokenEqualTo(this.statement, 1, "FOR"))) {
            this.statement = Token.cutTokenFromFront(this.statement, "FOR");
            String forElement = Token.getFirstToken(this.statement).trim();
            this.mapElementsColumn.put("FOR", forElement);
            this.statement = Token.cutTokenFromFront(this.statement, forElement);
        }
    }
}

