/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndexUDBv81
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private String indexName = "";
    private StorageDesignUDBv81 stoDesign;
    private String schemaName = null;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateIndexUDBv81.class);

    public SHCreateIndexUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndexUDBv81.clearCR(line);
        if (Token.startsWithString(statement, "create index") || Token.startsWithString(statement, "create unique index")) {
            this.line = line;
            this.createIndex(statement);
            this.index = null;
            this.table = null;
            this.indexName = "";
            this.stoDesign = null;
            this.schemaName = null;
            line = null;
        } else {
            this.nextHandler(line);
        }
    }

    private void createIndex(String statement) {
        this.statement = statement;
        try {
            this.indexName = this.initIndexName();
            this.constructIndex();
            if (this.index != null) {
                IndexProxyUDBv81 indexProxy;
                this.initUnique();
                this.setColumnForIndex();
                RDBMSSite site = this.design.getSelectedRDBMSSite();
                this.stoDesign = (StorageDesignUDBv81)this.design.getStorageDesign(site);
                if (this.stoDesign != null && (indexProxy = (IndexProxyUDBv81)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    this.initSchema(indexProxy, this.stoDesign);
                    this.initInclude(indexProxy);
                    this.initCluster(indexProxy);
                    this.initPctFree(indexProxy);
                    this.initMinPctUsed(indexProxy);
                    this.initReverseScans(indexProxy);
                    this.initCollectStatistics(indexProxy);
                }
            }
            this.importLog.incrementImportedStatements();
        }
        catch (ObjectDoesNotExistException e) {
            StringBuffer message = new StringBuffer(e.getMessage());
            message.append(" in SHCreateIndex.createIndex");
            LOGGER.error(message.toString());
            this.importLog.addFailedStatement(SHCreateIndexUDBv81.FormatCR(this.line, "\n"));
        }
    }

    private void constructIndex() throws ObjectDoesNotExistException {
        String tableName = this.getTableName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tableName);
        if (this.table != null) {
            Index[] indexes = (Index[])this.table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index ind = indexes[i];
                if (!ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                break;
            }
            if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
                this.index = this.table.createIndex();
                this.index.setName(this.indexName);
                this.design.getRelationalDesign().stampModelObjectDDL(this.index);
            }
        } else {
            this.importLog.addError("Specified table " + tableName + " for index " + this.indexName + " does not exist");
            throw new ObjectDoesNotExistException("Table");
        }
    }

    private void initUnique() {
        boolean unique;
        if (!this.index.isPK() && (unique = Token.hasToken(this.statement, "UNIQUE"))) {
            this.index.setIndexState("Unique Plain Index");
        }
    }

    private String initIndexName() {
        String name = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.schemaName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void setColumnForIndex() throws ObjectDoesNotExistException {
        Map columnCollection = this.getColumnsForTable();
        if (columnCollection.size() > 0) {
            String columnString = Token.getValBetweenBrackets(this.statement, 1).trim();
            columnString = Token.getNamesOnly(columnString);
            StringTokenizer columnToken = new StringTokenizer(columnString, ",");
            while (columnToken.hasMoreTokens()) {
                Column columnTable;
                String columnName = columnToken.nextToken().trim();
                String sortOrder = "ASC";
                if (Token.getLastToken(columnName).equalsIgnoreCase("ASC") || Token.getLastToken(columnName).equalsIgnoreCase("DESC")) {
                    if (Token.getLastToken(columnName).equalsIgnoreCase("DESC")) {
                        sortOrder = "DESC";
                    }
                    columnName = columnName.substring(0, columnName.lastIndexOf(32));
                }
                if ((columnTable = (Column)columnCollection.get(columnName)) != null) {
                    this.index.add(columnTable);
                    this.index.setColumnSortOrder(columnTable, sortOrder);
                    continue;
                }
                this.importLog.addError("Setting column " + columnName + " for index failed");
                throw new ObjectDoesNotExistException("Column");
            }
        }
    }

    private Map getColumnsForTable() {
        HashMap<String, Column> collectionColumns = new HashMap<String, Column>();
        if (this.table != null) {
            Column[] columns = (Column[])this.table.getElements();
            for (int i = 0; i < columns.length; ++i) {
                collectionColumns.put(columns[i].getName(), columns[i]);
            }
        }
        return collectionColumns;
    }

    private String getTableName() {
        int posPoint;
        String name = Token.getNameAfterToken(this.statement, "ON", '\"', '\"').trim();
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40));
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        name = Token.removeQuotes(name);
        return name;
    }

    private void initCluster(IndexProxyUDBv81 indexProxy) {
        if (Token.hasToken(this.statement, "CLUSTER")) {
            indexProxy.setCluster(true);
        }
    }

    private void initInclude(IndexProxyUDBv81 indexProxy) {
        if (Token.hasToken(this.statement, "INCLUDE")) {
            String part = this.statement.substring(this.statement.indexOf("INCLUDE") + "INCLUDE".length()).trim();
            String columns = Token.getValBetweenBrackets(part);
            indexProxy.setColumnList(columns);
        }
    }

    private void initPctFree(IndexProxyUDBv81 indexProxy) {
        if (Token.hasToken(this.statement, "PCTFREE")) {
            try {
                int pctFree = Integer.parseInt(Token.getTokenAfter(this.statement, "PCTFREE"));
                indexProxy.setPercentageFree(pctFree);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PCTFREE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexUDB.initPctFree : " + e.getMessage());
            }
        }
    }

    private void initMinPctUsed(IndexProxyUDBv81 indexProxy) {
        if (Token.hasToken(this.statement, "MINPCTUSED")) {
            try {
                int minPctUsed = Integer.parseInt(Token.getTokenAfter(this.statement, "MINPCTUSED"));
                indexProxy.setMinimumPercentageUsed(minPctUsed);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong MINPCTUSED format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateIndexUDB.initMinPctUsed : " + e.getMessage());
            }
        }
    }

    private void initReverseScans(IndexProxyUDBv81 indexProxy) {
        if (Token.hasToken(this.statement, "ALLOW")) {
            indexProxy.setReverseScanSupport(true);
        }
    }

    private void initCollectStatistics(IndexProxyUDBv81 indexProxy) {
        if (Token.hasToken(this.statement, "COLLECT") && Token.hasToken(this.statement, "STATISTICS")) {
            if (!Token.hasToken(this.statement, "SAMPLED") && Token.hasToken(this.statement, "DETAILED")) {
                indexProxy.setCollectStatistics("DETAILED");
            } else if (Token.hasToken(this.statement, "SAMPLED") && Token.hasToken(this.statement, "DETAILED")) {
                indexProxy.setCollectStatistics("SAMPLED DETAILED");
            } else if (!Token.hasToken(this.statement, "SAMPLED") && !Token.hasToken(this.statement, "DETAILED")) {
                indexProxy.setCollectStatistics("BASIC");
            }
        }
    }

    private void initSchema(IndexProxyUDBv81 indexProxy, StorageDesignUDBv81 storageDesign) {
        if (this.schemaName != null) {
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(this.schemaName);
            if (schema != null) {
                indexProxy.setSchema(schema);
            } else {
                OwnerUDB owner = (OwnerUDB)((StorageDesignUDB)indexProxy.getStorageDesign()).getOwnerSet().getByName(this.schemaName);
                if (owner == null) {
                    owner = (OwnerUDB)((StorageDesignUDB)indexProxy.getStorageDesign()).getOwnerSet().createElement(null);
                    owner.setName(this.schemaName);
                    this.design.getRelationalDesign().stampModelObjectDDL(owner);
                }
                indexProxy.setOwner(owner);
            }
        } else if (this.getOwner() != null) {
            indexProxy.setOwner((OwnerUDB)this.getOwner());
        }
    }
}

