/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableViewProxyUDBv81;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateViewUDBv81
extends DDLStatementHandler {
    private boolean allColumnsAreMade;
    private AbstractView view;
    private String schemaName = null;
    private String userDefined;
    private static final Logger LOGGER = new Logger(SHCreateViewUDBv81.class);

    public SHCreateViewUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateViewUDBv81.clearCR(line);
        if (Token.startsWithString(statement, "create view") || Token.startsWithString(statement, "create or replace view") || Token.startsWithString(statement, "create federated view")) {
            try {
                this.userDefined = SHCreateViewUDBv81.FormatCR(line, "\n");
                this.parseView(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateViewUDBv81.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseView(String statement) {
        this.statement = statement;
        this.allColumnsAreMade = true;
        if (this.allColumnsAreMade) {
            this.view = this.design.getRelationalDesign().getTableViewSet().createTableView(null);
            String nameView = this.initName();
            if (this.schemaName != null && !"".equals(this.schemaName)) {
                this.view.setSchema(this.schemaName);
            }
            this.view.setName(nameView);
            this.design.getRelationalDesign().stampModelObjectDDL(this.view);
            if (Token.getTokenAfter(statement, nameView).trim().equalsIgnoreCase("OF")) {
                TableViewProxyUDB viewProxy;
                RDBMSSite site = this.design.getSelectedRDBMSSite();
                StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
                if (storageDesign != null && (viewProxy = (TableViewProxyUDB)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                    StructuredType type;
                    String temp = Token.getStringAfterToken(statement, "OF").trim();
                    String stName = Token.getFirstToken(temp).trim();
                    int posPoint = stName.indexOf(46);
                    if (posPoint > 0) {
                        stName = Token.getValAfterCharacter(stName, '.');
                    }
                    if ((type = (StructuredType)this.design.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(stName)) != null) {
                        this.view.setBasedOnStructuredType(type);
                    } else {
                        LOGGER.error("Unable to find required Structured Type: " + stName);
                    }
                    if (Token.hasToken(statement, "UNDER")) {
                        AbstractView superView;
                        String superViewName = Token.getTokenAfter(statement, "UNDER").trim();
                        posPoint = superViewName.indexOf(46);
                        if (posPoint > 0) {
                            superViewName = Token.getValAfterCharacter(superViewName, '.');
                        }
                        if ((superView = (AbstractView)this.design.getRelationalDesign().getTableViewSet().getByName(superViewName)) != null) {
                            ContainerView parentTV = (ContainerView)superView.getTopView();
                            ContainerView childTV = (ContainerView)this.view.getTopView();
                            if (parentTV != null && childTV != null) {
                                TypeSubstitution ts = this.design.getRelationalDesign().createTypeSubstitution();
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                ts.setChildCV(childTV);
                                ts.setParentCV(parentTV);
                                ts.addToAllDPVs();
                            }
                        }
                    }
                    if (Token.hasString(statement, "REF IS")) {
                        String oidColumnName = Token.getStringAfter(statement, "REF IS").trim();
                        oidColumnName = Token.getFirstToken(oidColumnName).trim();
                        viewProxy.setOidColumnName(oidColumnName);
                        if (Token.hasToken(statement, "UNCHECKED")) {
                            viewProxy.setOidColumnUniqueness(false);
                        }
                    }
                }
            } else {
                TableViewProxyUDBv81 viewProxy;
                RDBMSSite site;
                StorageDesignUDB storageDesign;
                this.initUserDefinedSql();
                if (!this.initCols()) {
                    this.initCol();
                }
                if ((storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site = this.design.getSelectedRDBMSSite())) != null && (viewProxy = (TableViewProxyUDBv81)storageDesign.getTableViewProxySet().getProxy(this.view.getObjectID())) != null) {
                    viewProxy.setDefinition(this.userDefined);
                    this.initCheckOption(viewProxy);
                    this.initFederated(viewProxy);
                    this.initOwner(viewProxy, storageDesign);
                }
            }
        }
    }

    public boolean initCols() {
        String beforeSelect = Token.getStringBefore(this.statement, " as ");
        if (!Token.hasToken(beforeSelect, "OF") && Token.hasCloseAndOpenBrackets(beforeSelect)) {
            String cols = Token.getValBetweenBrackets(beforeSelect, 1);
            if (!"".equalsIgnoreCase(cols)) {
                StringTokenizer tokenizer = new StringTokenizer(cols, ",");
                String column = "";
                while (tokenizer.hasMoreTokens()) {
                    column = Token.removeQuotes(tokenizer.nextToken());
                    AbstractViewElement cvExp = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                    cvExp.setName(column);
                    cvExp.setDesign(this.design);
                    cvExp.setAlias(column);
                    cvExp.setContainer(this.view);
                    this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                    this.view.add(cvExp);
                }
            }
            return true;
        }
        return false;
    }

    private void initCheckOption(TableViewProxyUDBv81 viewProxy) {
        String check = Token.getTokenAfter(this.statement, "WITH");
        if (check.equalsIgnoreCase("LOCAL")) {
            viewProxy.setCheckOptionScope("LOCAL");
        } else {
            viewProxy.setCheckOptionScope("CASCADED");
        }
        if (!check.equalsIgnoreCase("")) {
            viewProxy.setCheckOption(true);
        } else {
            viewProxy.setCheckOption(false);
        }
    }

    private void initFederated(TableViewProxyUDBv81 viewProxy) {
        if (this.statement.toUpperCase().indexOf("FEDERATED") > -1) {
            viewProxy.setFederated("YES");
        }
    }

    private void initUserDefinedSql() {
        this.view.setUserDefinedSQL(this.userDefined);
        this.view.setUserDefined(true);
        this.view.setSyntaxProvider("DB2");
    }

    private void initOwner(TableViewProxyUDBv81 tableViewProxy, StorageDesignUDB storageDesign) {
        if (this.schemaName != null) {
            SchemaUDB schema = (SchemaUDB)storageDesign.getSchemaSet().getByName(this.schemaName);
            if (schema == null) {
                schema = storageDesign.getSchemaSet().createSchema();
                schema.setName(this.schemaName);
                this.design.getRelationalDesign().stampModelObjectDDL(schema);
            }
            if (schema != null) {
                tableViewProxy.setSchema(schema);
            }
        }
    }

    private String initName() {
        String name = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"').trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.schemaName = Token.getValBeforeCharacter(name, '.');
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    public void initCol() {
        String stmt = Token.getStringAfter(this.statement, "AS SELECT").trim();
        if (stmt.equalsIgnoreCase("") && !this.isAsSelectOnly()) {
            stmt = Token.getStringAfter(this.statement, "SELECT").trim();
        }
        if (!stmt.equalsIgnoreCase("")) {
            if (Token.hasToken(this.statement, "FROM")) {
                int fromInd = stmt.toUpperCase().indexOf("FROM");
                String beforeFrom = stmt.substring(0, fromInd);
                while (Token.tokenNumber(beforeFrom, "(") > Token.tokenNumber(beforeFrom, ")")) {
                    fromInd = stmt.toUpperCase().indexOf("FROM", fromInd + 1);
                    beforeFrom = stmt.substring(0, fromInd);
                }
                stmt = beforeFrom;
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("ALL")) {
                stmt = Token.getStringAfterToken(stmt, "ALL").trim();
            }
            if (Token.getFirstToken(stmt).equalsIgnoreCase("DISTINCT")) {
                stmt = Token.getStringAfterToken(stmt, "DISTINCT").trim();
            }
            StringTokenizer tokenizer = new StringTokenizer(stmt, ",");
            String column = null;
            String columnAlias = null;
            while (tokenizer.hasMoreTokens()) {
                column = tokenizer.nextToken().trim();
                columnAlias = null;
                StringBuffer oneColumnPast = new StringBuffer(column);
                while (Token.tokenNumber(column, "(") > Token.tokenNumber(column, ")") && tokenizer.hasMoreTokens()) {
                    oneColumnPast.append(",").append(tokenizer.nextToken().trim());
                    column = oneColumnPast.toString().trim();
                }
                if (Token.hasToken(column, "AS")) {
                    columnAlias = Token.getNameAfterToken(column, "AS", '\"', '\"');
                    column = Token.getStringBeforeToken(column, "AS");
                }
                if ((column = Token.encodeQuotedString(column)).indexOf(" ") > -1) {
                    if (column.charAt(column.length() - 1) == '\"') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(34);
                        columnAlias = columnAlias.substring(lastIndex) + "\"";
                        column = column.substring(0, lastIndex - 1);
                    } else if (column.charAt(column.length() - 1) == '\'') {
                        columnAlias = column.substring(0, column.length() - 1);
                        int lastIndex = columnAlias.lastIndexOf(39);
                        columnAlias = columnAlias.substring(lastIndex) + "'";
                        column = column.substring(0, lastIndex - 1);
                    } else {
                        String last = Token.getLastToken(column);
                        if (last.indexOf(41) == -1 && !last.equalsIgnoreCase("END")) {
                            columnAlias = last;
                            column = column.substring(0, column.lastIndexOf(last)).trim();
                        }
                    }
                }
                if (!Token.hasCloseAndOpenBrackets(column = Token.removeQuotes(Token.decodeQuotedString(column))) && column.indexOf(43) == -1 && column.indexOf(45) == -1 && column.indexOf(42) == -1 && column.indexOf(47) == -1 && column.indexOf(58) == -1 && column.indexOf("||") == -1 && !Token.hasToken(column, "CONCAT") && column.indexOf(46) > -1 && (column = column.substring(column.indexOf(46) + 1)).indexOf(46) > -1) {
                    column = column.substring(column.indexOf(46) + 1);
                }
                if (column.equalsIgnoreCase("") || column.equalsIgnoreCase("*")) continue;
                AbstractViewElement cvExp = this.view.createViewElement(this.design.getLogicalDesign().getMainDPVPlaceHolder().getDesignPart());
                cvExp.setName(column);
                cvExp.setDesign(this.design);
                cvExp.setExpression(column);
                cvExp.setContainer(this.view);
                this.design.getRelationalDesign().stampModelObjectDDL(cvExp);
                this.view.add(cvExp);
                if (columnAlias != null) {
                    columnAlias = Token.removeQuotes(Token.decodeQuotedString(columnAlias));
                    cvExp.setAlias(columnAlias);
                    cvExp.setHeaderAlias(columnAlias);
                    continue;
                }
                cvExp.setAlias(cvExp.getName());
            }
        }
    }

    public void setView(AbstractView view) {
        this.view = view;
    }
}

