/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.domains;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.domains.DomainPropertiesComparator;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.xml.standalone_domains.ReadStAlDomains;

public class DomainImportSelection
extends EngFilteredSelection {
    LogicalDesign ldes;
    private EngineeringObjectSelection rightRoot;
    private Map comparatorsMap = new TreeMap();
    private String fileName = "";
    private List impDomains;
    private List existingDomains = new ArrayList();

    public DomainImportSelection(LogicalDesign ldes, File domainFile) {
        super(ldes.getDesign().getName());
        this.setDesign(ldes.getDesign());
        this.ldes = ldes;
        this.fileName = domainFile.getName();
        this.setName(MessageFormat.format(Messages.getString("DomainImportSelection.DomainsInFile"), this.fileName));
        this.rightRoot = new EngFilteredSelection(ldes.getName());
        this.rightRoot.setName(MessageFormat.format(Messages.getString("DomainImportSelection.CorrespondingDomainsInDesign"), ldes.getDesign().getName()));
        this.setCorrespondentNode(this.rightRoot);
        this.rightRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRoot);
        RDBMSSite site = null;
        if (ldes.getDesign().getRelationalDesign() != null) {
            site = ldes.getDesign().getRelationalDesign().getSelectedRDBMSSite();
        }
        ReadStAlDomains readStAlDomains = new ReadStAlDomains(ldes.getDesign().getAppView(), site, this.getDesign());
        this.impDomains = readStAlDomains.readDomains(domainFile);
        ldes.getDesign().getDomainSet().addAllElementsTo(this.existingDomains);
        this.addDomains();
    }

    private void setEmptyComparator(EngineeringObjectSelection node) {
        node.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private Domain getDomainByImportedID(List existingDomains, String impID) {
        for (Domain domain : existingDomains) {
            String imp_id = domain.getImportedId();
            if (imp_id == null || !impID.equalsIgnoreCase(imp_id)) continue;
            return domain;
        }
        return null;
    }

    private Domain getDomainByID(List existingDomains, String id) {
        for (Domain domain : existingDomains) {
            if (!id.equalsIgnoreCase(domain.getObjectID())) continue;
            return domain;
        }
        return null;
    }

    private Domain getDomainByName(List existingDomains, String name) {
        for (Domain domain : existingDomains) {
            if (!name.equalsIgnoreCase(domain.getName())) continue;
            return domain;
        }
        return null;
    }

    private void addDomain(Domain domain, EngineeringObjectSelection allLeftSel, EngineeringObjectSelection allRightSel, boolean details) {
        EngineeringObjectSelection leftSel = new EngineeringObjectSelection(domain);
        leftSel.setSelected(true);
        Domain rightDomain = this.getDomainByImportedID(this.existingDomains, domain.getObjectID());
        if (rightDomain == null) {
            rightDomain = this.getDomainByID(this.existingDomains, domain.getObjectID());
        }
        if (rightDomain == null && domain.getImportedId() != null && !"".equals(domain.getImportedId()) && (rightDomain = this.getDomainByID(this.existingDomains, domain.getImportedId())) == null) {
            rightDomain = this.getDomainByImportedID(this.existingDomains, domain.getImportedId());
        }
        if (rightDomain == null) {
            rightDomain = this.getDomainByName(this.existingDomains, domain.getName());
        }
        EngineeringObjectSelection rightSel = null;
        if (rightDomain != null) {
            rightSel = new EngineeringObjectSelection(rightDomain);
            DomainPropertiesComparator comp = new DomainPropertiesComparator(domain, rightDomain);
            leftSel.setPropertiesComparator(comp);
            rightSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        } else {
            rightSel = new EngineeringObjectSelection(domain.getName());
            leftSel.setStatus(ModelIdObjectSelection.STATE_NEW);
            rightSel.setStatus(ModelIdObjectSelection.STATE_NEW);
            rightSel.setElementDescriptor(Domain.class);
            DomainPropertiesComparator comp = new DomainPropertiesComparator(domain, null);
            leftSel.setPropertiesComparator(comp);
            rightSel.setPropertiesComparator(comp);
        }
        rightSel.setCorrespondentNode(leftSel);
        leftSel.setCorrespondentNode(rightSel);
        allLeftSel.addChild(leftSel);
        allRightSel.addChild(rightSel);
    }

    private void addDomains() {
        for (Domain domain : this.impDomains) {
            this.addDomain(domain, this, this.rightRoot, true);
        }
    }

    public EngineeringObjectSelection getLeftRoot() {
        return this;
    }

    public EngineeringObjectSelection getRightRoot() {
        return this.rightRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }
}

