/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.erwin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.erwin.ERwinConstantsv7x;
import oracle.dbtools.crest.imports.erwin.ERwinHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.ImportLogger;
import org.w3c.dom.Element;

public class ERwinParserv7x
extends ERwinHandler
implements ERwinConstantsv7x {
    private Design design;
    private LogicalDesign logical;
    private RelationalDesign relational;
    private Map proxyObjects = new TreeMap();
    private Map transformScratchObjects = new TreeMap();
    private Map domains = new TreeMap();
    private Map logicalObjects = new TreeMap();
    private Map relationalObjects = new TreeMap();
    private Map fonts = new TreeMap();
    private boolean isMainLogical = true;
    private boolean isMainRelational = true;
    private String defaultNameFontID;
    private String defaultNameColor;
    private String defaultFillColor;
    private String defaultOutlineColor;
    private String defaultAttributeFontID;
    private String defaultAttributeColor;
    private List logicalViews = new ArrayList();
    private List relationalViews = new ArrayList();
    private List logicalFKElements = new ArrayList();
    private List relationalFKElements = new ArrayList();
    private List ihObjects = new ArrayList();
    private Map defaultValues = new TreeMap();
    private Map validationRules = new TreeMap();
    private List replacedAttributes = new ArrayList();

    public ERwinParserv7x(ApplicationView appView, boolean inExistingDesign) {
        super(appView, inExistingDesign);
        this.design = appView.getCurrentDesign();
        this.logical = this.design.getLogicalDesign();
        this.relational = this.design.getRelationalDesign();
    }

    public void parseModel(File file, ImportLogger importLog, ProgressDialog monitor, Element elmModel, Element elmProxy) {
        block33: {
            try {
                Element defaultFontsAndColorsObject;
                Element defaultFontsAndColorsGroups;
                String designName;
                if (elmModel == null) break block33;
                Element modelEnvProps = this.getElement(elmModel, "ModelEnvProps");
                String targetServer = this.getElementValue(modelEnvProps, "Target_Server");
                String targetVersion = this.getElementValue(modelEnvProps, "Target_Server_Version");
                RDBMSType rdbmsType = null;
                if (targetServer.equalsIgnoreCase("1075858978")) {
                    rdbmsType = targetVersion.equals("7") ? StorageDesignDB2v70.RDBMS_TYPE : (targetVersion.equals("8") ? StorageDesignDB2v80.RDBMS_TYPE : StorageDesignDB2v70.RDBMS_TYPE);
                } else if (targetServer.equalsIgnoreCase("1075858979")) {
                    rdbmsType = targetVersion.equals("9") ? StorageDesignOraclev9i.RDBMS_TYPE : (targetVersion.equals("10") ? StorageDesignOraclev10g.RDBMS_TYPE : (targetVersion.equals("11") ? StorageDesignOraclev11g.RDBMS_TYPE : (targetVersion.equals("12") ? StorageDesignOraclev12c.RDBMS_TYPE : StorageDesignOraclev11g.RDBMS_TYPE)));
                } else if (targetServer.equalsIgnoreCase("1075859016")) {
                    rdbmsType = targetVersion.equals("2000") ? StorageDesignSqlServerv2k.RDBMS_TYPE : (targetVersion.equals("2005") ? StorageDesignSqlServerv2k5.RDBMS_TYPE : (targetVersion.equals("2008") ? StorageDesignSqlServerv2k8.RDBMS_TYPE : StorageDesignSqlServerv2k.RDBMS_TYPE));
                } else if (targetServer.equalsIgnoreCase("1075858977")) {
                    rdbmsType = targetVersion.equals("7") ? StorageDesignUDBv71.RDBMS_TYPE : (targetVersion.equals("8") ? StorageDesignUDBv81.RDBMS_TYPE : (targetVersion.equals("9") ? StorageDesignUDBv9.RDBMS_TYPE : StorageDesignUDBv71.RDBMS_TYPE));
                }
                if (rdbmsType != null) {
                    this.design.setSelectedRDBMSSite(this.design.getFirstOfType(rdbmsType));
                }
                if ((designName = elmModel.getAttribute("name")) != null) {
                    this.setDesignName(designName);
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseModelProxies"));
                monitor.setProgress(5);
                if (elmProxy != null) {
                    this.parseProxyObjects(elmProxy);
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseDefaultValues"));
                monitor.setProgress(10);
                Element defaultValueGroups = this.getElement(elmModel, "Default_Groups");
                if (defaultValueGroups != null) {
                    this.parseDefaultValues(defaultValueGroups);
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseValidationRules"));
                monitor.setProgress(15);
                Element vrGroups = this.getElement(elmModel, "Validation_Rule_Groups");
                if (vrGroups != null) {
                    this.parseValidationRules(vrGroups);
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseDomains"));
                monitor.setProgress(20);
                TreeMap childDomains = new TreeMap();
                Element domainGroups = this.getElement(elmModel, "Domain_Groups");
                if (domainGroups != null) {
                    List domains = this.getElements(domainGroups, "Domain");
                    for (Element elmDomain : domains) {
                        this.parseDomain(elmDomain, childDomains, importLog);
                    }
                }
                Object[] keys = childDomains.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    Domain parent;
                    Object key = keys[i];
                    Object value = childDomains.get(key);
                    while (childDomains.get(value) != null) {
                        value = childDomains.get(value);
                    }
                    Domain child = (Domain)this.domains.get(key);
                    if (child == null || (parent = (Domain)this.domains.get(value)) == null) continue;
                    child.setLogicalDatatype(parent.getLogicalDatatype());
                    child.setDataTypeParameter("size", parent.getDataTypeParameter("size"));
                    child.setDataTypeParameter("precision", parent.getDataTypeParameter("precision"));
                    child.setDataTypeParameter("scale", parent.getDataTypeParameter("scale"));
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseFonts"));
                monitor.setProgress(25);
                Element fontGroups = this.getElement(elmModel, "Font_Groups");
                if (fontGroups != null) {
                    List lsfonts = this.getElements(fontGroups, "Font");
                    for (Element elmFont : lsfonts) {
                        String id = elmFont.getAttribute("id");
                        String fontName = elmFont.getAttribute("name");
                        Element fontProps = this.getElement(elmFont, "FontProps");
                        String fontSize = this.getElementValue(fontProps, "Font_Size");
                        String fontBold = this.getElementValue(fontProps, "Is_Font_Bold");
                        String fontItalic = this.getElementValue(fontProps, "Is_Font_Italic");
                        int size = 10;
                        try {
                            size = Integer.parseInt(fontSize);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        int style = 0;
                        if ("true".equalsIgnoreCase(fontBold)) {
                            style |= 1;
                        }
                        if ("true".equalsIgnoreCase(fontItalic)) {
                            style |= 2;
                        }
                        Font font = new Font(fontName, style, size);
                        this.fonts.put(id, font);
                    }
                }
                if ((defaultFontsAndColorsGroups = this.getElement(elmModel, "Default_Fonts_And_Colors_Groups")) != null && (defaultFontsAndColorsObject = this.getElement(defaultFontsAndColorsGroups, "Default_Fonts_And_Colors")) != null) {
                    Element defaultFontsAndColorsProps = this.getElement(defaultFontsAndColorsGroups, "Default_Fonts_And_ColorsProps");
                    this.defaultNameFontID = this.getElementValue(defaultFontsAndColorsProps, "Default_Entity_Name_Font_Ref");
                    this.defaultNameColor = this.getElementValue(defaultFontsAndColorsProps, "Default_Entity_Name_Color");
                    this.defaultFillColor = this.getElementValue(defaultFontsAndColorsProps, "Default_Entity_Fill_Color");
                    this.defaultOutlineColor = this.getElementValue(defaultFontsAndColorsProps, "Default_Entity_Outline_Color");
                    this.defaultAttributeFontID = this.getElementValue(defaultFontsAndColorsProps, "Default_Owned_Attribute_Font_Ref");
                    this.defaultAttributeColor = this.getElementValue(defaultFontsAndColorsProps, "Default_Owned_Attribute_Color");
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseEntitiesAndTables"));
                monitor.setProgress(30);
                Element entityGroups = this.getElement(elmModel, "Entity_Groups");
                if (entityGroups != null) {
                    List entities = this.getElements(entityGroups, "Entity");
                    for (Element elmEntity : entities) {
                        this.parseEntity(elmEntity);
                    }
                }
                monitor.setNote(Messages.getString("ERwinHandler.ParseViews"));
                monitor.setProgress(60);
                this.parseEntityViews();
                this.parseTableViews();
                monitor.setNote(Messages.getString("ERwinHandler.CreateMappings"));
                monitor.setProgress(75);
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
                monitor.setNote(Messages.getString("ERwinHandler.ParseRelationships"));
                monitor.setProgress(80);
                Element rsGroups = this.getElement(elmModel, "Relationship_Groups");
                if (rsGroups != null) {
                    List relationships = this.getElements(rsGroups, "Relationship");
                    for (Element elmRS : relationships) {
                        this.parseRelationship(elmRS);
                    }
                }
                this.createMappings(this.design, this.logicalObjects, this.relationalObjects);
                this.createMany2ManyMapping(this.getElement(elmModel, "Many_To_Many_Transform_Groups"));
                this.createSuperTypeSubTypeMapping(this.getElement(elmModel, "Supertype_Subtype_Roll_Up_Transform_Groups"));
                monitor.setNote(Messages.getString("ERwinHandler.RearrangeLayouts"));
                monitor.setProgress(90);
                Element subjectAreaGroups = this.getElement(elmModel, "Subject_Area_Groups");
                if (subjectAreaGroups != null) {
                    List areas = this.getElements(subjectAreaGroups, "Subject_Area");
                    for (Element area : areas) {
                        this.parseSubjectArea(area);
                    }
                }
                this.parseInheritanceRelations();
                if (this.isMainLogical) {
                    this.design.getLogicalDesign().rearrangeEntities();
                    this.design.getLogicalDesign().rearrangeViews();
                    this.design.getLogicalDesign().getMainView().setAutoRoute(true);
                    this.design.getLogicalDesign().getMainView().getWorkSpace().updateSettings();
                }
                if (this.isMainRelational) {
                    ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                    this.design.getRelationalDesign().rearrangeViews();
                    this.design.getRelationalDesign().getMainView().setAutoRoute(true);
                    this.design.getRelationalDesign().getMainView().getWorkSpace().updateSettings();
                }
            }
            catch (Exception e) {
                LOGGER.error("ERwinHandler - Unable to parse file: " + file.getAbsolutePath(), e);
                importLog.addError("Error parsing File...");
            }
        }
    }

    private void parseInheritanceRelations() {
        for (int i = this.ihObjects.size() - 1; i >= 0; --i) {
            ERwinHandler.IHObject ihObject = (ERwinHandler.IHObject)this.ihObjects.get(i);
            String parentID = ihObject.getParentID();
            String childID = ihObject.getChildID();
            Entity child = (Entity)this.logicalObjects.get(childID);
            if (child == null) continue;
            Entity parent = this.getParentEntity(parentID);
            if (parent != null) {
                child.setHierarchicalParent(parent);
                Relation relation = child.getInheritanceRelation();
                if (relation != null) {
                    relation.setComment(ihObject.getComment());
                }
            }
            this.ihObjects.remove(ihObject);
        }
    }

    private Entity getParentEntity(String parentID) {
        for (ERwinHandler.IHObject ihObject : this.ihObjects) {
            if (!ihObject.getChildID().equalsIgnoreCase(parentID)) continue;
            return (Entity)this.logicalObjects.get(ihObject.getParentID());
        }
        return null;
    }

    private Color reverseRGB(int rgb) {
        int r = rgb >> 0 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 16 & 0xFF;
        return new Color(r, g, b);
    }

    private Rectangle parseCoordinates(String coordinates) {
        Rectangle rec = new Rectangle();
        if (coordinates != null) {
            StringTokenizer st = new StringTokenizer(coordinates, " ");
            int[] values = new int[4];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int number;
                    values[i] = number = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("ERwinHandler.parseCoordinates(): Unable to parse coordinates", e);
                }
                ++i;
            }
            rec.x = values[0];
            rec.y = values[1];
            rec.width = values[2] - values[0];
            rec.height = values[3] - values[1];
        }
        return rec;
    }

    private void applyValidationRule(String validationRuleRef, ConstrainedObject constrainedObject) {
        ERwinHandler.ValidationRuleHolder vrh = (ERwinHandler.ValidationRuleHolder)this.validationRules.get(validationRuleRef);
        if (vrh != null) {
            switch (vrh.getType()) {
                case 0: {
                    CheckConstraint check = new CheckConstraint();
                    check.setDesign(this.design);
                    check.add(new GenericConstraint(), vrh.getRule());
                    constrainedObject.setCheck(check);
                    break;
                }
                case 1: {
                    AVT avt = new AVT();
                    avt.setBeginValue(vrh.getMinValue());
                    avt.setEndValue(vrh.getMaxValue());
                    avt.setDescription(vrh.getDefinition());
                    constrainedObject.addAVT(avt);
                    break;
                }
                case 2: {
                    for (Object key : vrh.getValueList().keySet()) {
                        Object value = vrh.getValueList().get(key);
                        if (constrainedObject.getValueList() == null) {
                            ConstraintEnumeration valueList = new ConstraintEnumeration();
                            constrainedObject.setValueList(valueList);
                        }
                        constrainedObject.getValueList().add(key, (String)value);
                    }
                    break;
                }
            }
        }
    }

    private void parseDataType(Domain domain, String datatype, ImportLogger importLog) {
        String dtName = datatype.trim();
        String size = "0";
        String precision = "0";
        String scale = "0";
        int pos = datatype.indexOf(40);
        if (pos > -1) {
            dtName = datatype.substring(0, pos).trim();
            String params = datatype.substring(pos + 1, datatype.trim().length() - 1).trim();
            int comma = params.indexOf(44);
            if (comma > -1) {
                precision = params.substring(0, comma).trim();
                scale = params.substring(comma + 1, params.trim().length() - 1);
            } else {
                size = params;
            }
        }
        String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(dtName);
        String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(nameDatatype);
        LogicalDatatype logDatatype = this.design.getLogicalDatatypeSet().getLogTypeByName(nameLogDT);
        if (logDatatype != null) {
            domain.setLogicalDatatype(logDatatype);
            if (!"0".equalsIgnoreCase(size)) {
                domain.setDataTypeParameter("size", size);
            } else if (!"0".equalsIgnoreCase(precision)) {
                domain.setDataTypeParameter("precision", precision);
                domain.setDataTypeParameter("scale", scale);
            }
        } else {
            importLog.addWarning("Unable to find Logical DataType for: " + nameDatatype);
        }
    }

    private void parseForeignKey(Element element, String rsID, String parentTable, String childTable, String name, String comment) {
        Index pk;
        DesignObject parent = (DesignObject)this.relationalObjects.get(parentTable);
        DesignObject child = (DesignObject)this.relationalObjects.get(childTable);
        if (parent != null && child != null && parent instanceof Table && child instanceof Table && (pk = this.getUniqueIndexForColumnNames((Table)parent, this.getFKColumnNames(this.relationalFKElements, rsID))) != null) {
            FKIndexAssociation fk = ((Table)child).addFK(pk);
            if (name != null && !"".equalsIgnoreCase(name)) {
                fk.setName(name);
            }
            if (comment != null) {
                fk.setComment(comment);
            }
            for (ERwinHandler.FKElement fkElement : this.relationalFKElements) {
                if (!fkElement.getParentRelationshipID().equalsIgnoreCase(rsID)) continue;
                Column column = (Column)this.relationalObjects.get(fkElement.getID());
                Column refColumn = (Column)this.relationalObjects.get(fkElement.getParentAttributeID());
                if (column == null || refColumn == null) continue;
                column.addFKAssociation(refColumn, fk);
                fk.getLocalFKIndex().add(column);
            }
            this.relationalObjects.put(rsID, fk);
        }
    }

    private List getFKColumnNames(List fkElements, String rsID) {
        ArrayList<String> list = new ArrayList<String>();
        for (ERwinHandler.FKElement fkElement : fkElements) {
            Column column;
            if (!fkElement.getParentRelationshipID().equalsIgnoreCase(rsID) || (column = (Column)this.relationalObjects.get(fkElement.getID())) == null) continue;
            list.add(column.getName());
        }
        return list;
    }

    private Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private void setFontAndColor(DesignObject designObject, String bgColorVal, String outlineColorVal, String nameFontID, String nameColorVal) {
        int bgColorInt = -1;
        try {
            if (bgColorVal != null) {
                bgColorInt = Integer.parseInt(bgColorVal);
            } else if (this.defaultFillColor != null) {
                bgColorInt = Integer.parseInt(this.defaultFillColor);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (bgColorInt >= 0) {
            Color bgColor = new Color(bgColorInt);
            designObject.setUseDefaultColor(false);
            designObject.setBackgroundColor(bgColor);
        }
        int outlineColorInt = -1;
        try {
            if (outlineColorVal != null) {
                outlineColorInt = Integer.parseInt(outlineColorVal);
            } else if (this.defaultOutlineColor != null) {
                outlineColorInt = Integer.parseInt(this.defaultOutlineColor);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (outlineColorInt >= 0) {
            Color outlineColor = new Color(outlineColorInt);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(outlineColor);
        }
        int nameColorInt = -1;
        try {
            if (nameColorVal != null) {
                nameColorInt = Integer.parseInt(nameColorVal);
            } else if (this.defaultNameColor != null) {
                nameColorInt = Integer.parseInt(this.defaultNameColor);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (nameColorInt >= 0) {
            Color nameColor = new Color(nameColorInt);
            designObject.setUseDefaultColor(false);
            designObject.setForegroundColor(nameColor);
        }
        if (!this.isUTFString(designObject.getName())) {
            Font font = null;
            if (nameFontID != null) {
                font = (Font)this.fonts.get(nameFontID);
            } else if (this.defaultNameFontID != null) {
                font = (Font)this.fonts.get(this.defaultNameFontID);
            }
            if (font != null && designObject instanceof EditableFonts) {
                TopView tv = designObject.getTopView();
                tv.setUseCustomFormat(true);
                FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
                fo.setFont(font);
            }
        } else if (designObject instanceof EditableFonts) {
            TopView tv = designObject.getTopView();
            tv.setUseCustomFormat(true);
            FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
            fo.setFont(new Font("Dialog", fo.getFont().getStyle(), fo.getFont().getSize()));
        }
    }

    private void setAttributeFontAndColor(DesignObject designObject, String attributeFontID, String attributeColorVal, boolean logicalDP) {
        FontObject fo;
        TopView tv;
        String type = logicalDP ? EditableFonts.FO_ATTRIBUTE : EditableFonts.FO_COLUMN;
        int attributeColorInt = -1;
        try {
            if (attributeColorVal != null) {
                attributeColorInt = Integer.parseInt(attributeColorVal);
            } else if (this.defaultAttributeColor != null) {
                attributeColorInt = Integer.parseInt(this.defaultAttributeColor);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (attributeColorInt >= 0 && designObject instanceof EditableFonts) {
            Color fontColor = new Color(attributeColorInt);
            tv = designObject.getTopView();
            tv.setUseCustomFormat(true);
            fo = tv.getFontObject(type);
            fo.setColor(fontColor);
        }
        if (!this.isUTFString(designObject.getName())) {
            Font font = null;
            if (attributeFontID != null) {
                font = (Font)this.fonts.get(attributeFontID);
            } else if (this.defaultAttributeFontID != null) {
                font = (Font)this.fonts.get(this.defaultAttributeFontID);
            }
            if (font != null && designObject instanceof EditableFonts) {
                tv = designObject.getTopView();
                tv.setUseCustomFormat(true);
                fo = tv.getFontObject(type);
                fo.setFont(font);
            }
        } else if (designObject instanceof EditableFonts) {
            TopView tv2 = designObject.getTopView();
            tv2.setUseCustomFormat(true);
            FontObject fo2 = tv2.getFontObject(EditableFonts.FO_TITLE);
            fo2.setFont(new Font("Dialog", fo2.getFont().getStyle(), fo2.getFont().getSize()));
        }
    }

    private void parseSubjectArea(Element element) {
        String saName = element.getAttribute("name");
        Element saProps = this.getElement(element, "Subject_AreaProps");
        String isMain = this.getElementValue(saProps, "Is_Main_Subject_Area");
        Element sdgGroups = this.getElement(element, "Stored_Display_Groups");
        if (sdgGroups != null) {
            List storageDisplays = this.getElements(sdgGroups, "Stored_Display");
            for (Element display : storageDisplays) {
                Element tsObjectGroups;
                String displayName = display.getAttribute("name");
                Element sdProps = this.getElement(display, "Stored_DisplayProps");
                String sdProxyID = this.getElementValue(sdProps, "Proxy_Short_Id");
                Element sdProxy = (Element)this.proxyObjects.get(sdProxyID);
                String displayLogicalLevel = null;
                String displayPhysicalLevel = null;
                if (sdProxy != null) {
                    displayLogicalLevel = this.getElementPropValue(sdProxy, "DisplayLevel_Logical");
                    displayPhysicalLevel = this.getElementPropValue(sdProxy, "DisplayLevel_Physical");
                }
                if (isMain != null && "true".equalsIgnoreCase(isMain)) {
                    DesignPartView dpv;
                    if (displayLogicalLevel != null && "1".equalsIgnoreCase(displayLogicalLevel)) {
                        if (this.isMainLogical) {
                            this.parseDisplay(display, this.logical.getMainView(), false);
                            this.isMainLogical = false;
                        } else {
                            dpv = this.logical.getMainView().addSubordinateView();
                            this.logical.getMainView().copyToDPV(dpv, false);
                            dpv.setName(displayName);
                            this.parseDisplay(display, dpv, false);
                        }
                    }
                    if (displayPhysicalLevel != null && "1".equalsIgnoreCase(displayPhysicalLevel)) {
                        if (this.isMainRelational) {
                            this.parseDisplay(display, this.relational.getMainView(), false);
                            this.isMainRelational = false;
                        } else {
                            dpv = this.relational.getMainView().addSubordinateView();
                            this.relational.getMainView().copyToDPV(dpv, false);
                            dpv.setName(displayName);
                            this.parseDisplay(display, dpv, false);
                        }
                    }
                } else {
                    DesignPartView dpv;
                    DesignPartView dpvSV;
                    if (displayLogicalLevel != null && "1".equalsIgnoreCase(displayLogicalLevel)) {
                        dpvSV = this.logical.getSubViewByName(saName);
                        if (dpvSV == null) {
                            dpvSV = this.logical.createDesignPartSubView();
                            dpvSV.setName(saName);
                            this.parseDisplay(display, dpvSV, true);
                        } else {
                            dpv = dpvSV.addSubordinateView();
                            dpvSV.copyToDPV(dpv, false);
                            dpv.setName(displayName);
                            this.parseDisplay(display, dpv, false);
                        }
                    }
                    if (displayPhysicalLevel != null && "1".equalsIgnoreCase(displayPhysicalLevel)) {
                        dpvSV = this.relational.getSubViewByName(saName);
                        if (dpvSV == null) {
                            dpvSV = this.relational.createDesignPartSubView();
                            dpvSV.setName(saName);
                            this.parseDisplay(display, dpvSV, true);
                        } else {
                            dpv = dpvSV.addSubordinateView();
                            dpvSV.copyToDPV(dpv, false);
                            dpv.setName(displayName);
                            this.parseDisplay(display, dpv, false);
                        }
                    }
                }
                if ((tsObjectGroups = this.getElement(display, "Transform_Scratch_Object_Groups")) == null) continue;
                List tsObjects = this.getElements(tsObjectGroups, "Transform_Scratch_Object");
                for (Element tsObject : tsObjects) {
                    String tsObjectID = tsObject.getAttribute("id");
                    this.transformScratchObjects.put(tsObjectID, tsObject);
                }
            }
        }
    }

    private void parseDisplay(Element element, DesignPartView dpv, boolean isSubView) {
        Element doelgGroups;
        List<Element> drawingObjects;
        dpv.setAutoRoute(false);
        dpv.setBoxInBox(false);
        dpv.getWorkSpace().updateSettings();
        Element doegGroups = this.getElement(element, "Drawing_Object_Entity_Groups");
        if (doegGroups != null) {
            List drawingObjects2 = this.getElements(doegGroups, "Drawing_Object_Entity");
            for (Element drawingObject : drawingObjects2) {
                Element drawingObjectProps = this.getElement(drawingObject, "Drawing_Object_EntityProps");
                String coordinates = this.getElementValue(drawingObjectProps, "Location_Rectangle");
                String refObject = this.getElementValue(drawingObjectProps, "Model_Object_Ref");
                Rectangle rec = this.parseCoordinates(coordinates);
                DesignObject designObject = null;
                designObject = dpv.getDesignPart() instanceof LogicalDesign ? (DesignObject)this.logicalObjects.get(refObject) : (DesignObject)this.relationalObjects.get(refObject);
                if (designObject == null) continue;
                this.parseFontsAndColors(drawingObject, designObject);
                ContainerView topView = null;
                if (isSubView) {
                    topView = ((ContainerView)designObject.getTopView()).createViewSynonim(dpv);
                    if (topView == null) continue;
                    if (topView != null && topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(rec);
                    } else if (topView != null) {
                        topView.setBounds(rec);
                    }
                    if (dpv.getDesignPart() instanceof LogicalDesign) {
                        if (topView instanceof TVEntity) {
                            ((TVEntity)topView).addTVRelations();
                        }
                        topView.addTVTypeSubstitutions();
                        dpv.synchronizeSynonymWithDisplays(topView);
                        continue;
                    }
                    if (topView instanceof TVTable) {
                        ((TVTable)topView).addTVFKRelations();
                    }
                    topView.addTVTypeSubstitutions();
                    dpv.synchronizeSynonymWithDisplays(topView);
                    continue;
                }
                topView = (ContainerView)designObject.getFirstViewForDPV(dpv);
                if (topView == null || topView.getCellView() == null) continue;
                topView.getCellView().setNewBounds(rec);
            }
        }
        dpv.setVisible(true);
        Element dorgGroups = this.getElement(element, "Drawing_Object_Relationship_Groups");
        if (dorgGroups != null) {
            drawingObjects = this.getElements(dorgGroups, "Drawing_Object_Relationship");
            for (Element drawingObject : drawingObjects) {
                TVConnector topView;
                Element drawingObjectProps = this.getElement(drawingObject, "Drawing_Object_RelationshipProps");
                String refObjectID = this.getElementValue(drawingObjectProps, "Model_Object_Ref");
                DesignObject designObject = null;
                designObject = dpv.getDesignPart() instanceof LogicalDesign ? (Relation)this.logicalObjects.get(refObjectID) : (FKIndexAssociation)this.relationalObjects.get(refObjectID);
                if (designObject == null || (topView = (TVConnector)designObject.getFirstViewForDPV(dpv)) == null) continue;
                try {
                    EdgeView edge = (EdgeView)topView.getCellView();
                    if (edge == null && topView.getEdge() != null) {
                        edge = (EdgeView)topView.getEdge().getCellView();
                    }
                    if (edge == null) continue;
                    List points = this.getPoints(drawingObjectProps);
                    for (Point p : points) {
                        topView.getEdgePoints().add(DiagramConstants.createPoint(p));
                    }
                    dpv.getWorkSpace().addPoints((DefaultEdge)edge.getCell(), topView.getEdgePoints());
                    edge.update();
                }
                catch (Exception e) {}
            }
        }
        drawingObjects = new ArrayList();
        Element dorecgGroups = this.getElement(element, "Drawing_Object_Rectangle_Groups");
        if (dorecgGroups != null) {
            List dorecgObjects = this.getElements(dorecgGroups, "Drawing_Object_Rectangle");
            for (Element dorecgObject : dorecgObjects) {
                drawingObjects.add(dorecgObject);
            }
        }
        if ((doelgGroups = this.getElement(element, "Drawing_Object_Ellipse_Groups")) != null) {
            List doelgObjects = this.getElements(doelgGroups, "Drawing_Object_Ellipse");
            for (Element doelgObject : doelgObjects) {
                drawingObjects.add(doelgObject);
            }
        }
        for (Element drawingObject : drawingObjects) {
            Font font;
            String text = this.getElementPropValue(drawingObject, "Text");
            String location = this.getElementPropValue(drawingObject, "Location_Rectangle");
            String objFontId = this.getElementPropValue(drawingObject, "Font_Ref");
            String objFontColorVal = this.getElementPropValue(drawingObject, "Font_Color");
            String objFillColorVal = this.getElementPropValue(drawingObject, "Fill_Color");
            String objOutlineColorVal = this.getElementPropValue(drawingObject, "Outline_Color");
            Note note = dpv.getDesignPart().createNote();
            note.setText(text);
            TopView topView = note.getFirstViewForDPV(dpv);
            if (topView == null) {
                topView = dpv.createTopViewFor(note);
            }
            Rectangle rec = this.parseCoordinates(location);
            if (topView != null) {
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(rec);
                } else {
                    topView.setBounds(rec);
                }
            }
            this.parseFontsAndColors(drawingObject, note);
            if (objFontId != null && (font = (Font)this.fonts.get(objFontId)) != null) {
                FontObject fo = note.getFontObject(EditableFonts.FO_TITLE);
                fo.setFont(font);
            }
            try {
                if (objFontColorVal != null) {
                    int objFontColorInt = Integer.parseInt(objFontColorVal);
                    Color fontColor = new Color(objFontColorInt);
                    FontObject fo = note.getFontObject(EditableFonts.FO_TITLE);
                    fo.setColor(fontColor);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (objFillColorVal != null) {
                    int objFillColorInt = Integer.parseInt(objFillColorVal);
                    Color fillColor = new Color(objFillColorInt);
                    note.setUseDefaultColor(false);
                    note.setBackgroundColor(fillColor);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (objOutlineColorVal != null) {
                    int objOutlineColorInt = Integer.parseInt(objOutlineColorVal);
                    Color outlineColor = new Color(objOutlineColorInt);
                    note.setUseDefaultColor(false);
                    note.setForegroundColor(outlineColor);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (topView == null || topView.getCellView() != null) continue;
            dpv.add(topView, topView.getBounds());
            dpv.synchronizeSynonymWithDisplays(topView);
        }
    }

    private void parseFontsAndColors(Element elementProp, DesignObject designObject) {
        String fontColorVal = this.getElementPropValue(elementProp, "Font_Color");
        String backgroundColorVal = this.getElementPropValue(elementProp, "Fill_Color");
        String outlineColorVal = this.getElementPropValue(elementProp, "Outline_Color");
        String objOutlineStyle = this.getElementPropValue(elementProp, "Outline_Style");
        String fontID = this.getElementPropValue(elementProp, "Font_Ref");
        Font refFont = null;
        String fontName = null;
        int fontSize = 10;
        Boolean fontBold = false;
        Boolean fontItalic = false;
        if (fontID != null) {
            refFont = (Font)this.fonts.get(fontID);
        } else if (this.defaultAttributeFontID != null) {
            refFont = (Font)this.fonts.get(this.defaultAttributeFontID);
        }
        if (refFont != null) {
            fontName = refFont.getName();
            fontSize = refFont.getSize();
            fontBold = refFont.isBold();
        }
        if (fontName != null) {
            int fStyle = 0;
            int fSize = fontSize;
            fStyle |= fontBold != false ? 1 : 0;
            Font font = new Font(fontName, fStyle |= fontItalic != false ? 1 : 0, fSize);
            if (designObject instanceof EditableFonts) {
                TopView tv = designObject.getTopView();
                tv.setUseCustomFormat(true);
                FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
                fo.setFont(font);
            }
        }
        if (fontColorVal != null) {
            try {
                int fColor = Integer.parseInt(fontColorVal);
                if (designObject instanceof EditableFonts) {
                    TopView tv = designObject.getTopView();
                    tv.setUseCustomFormat(true);
                    FontObject fo = tv.getFontObject(EditableFonts.FO_TITLE);
                    fo.setColor(this.reverseRGB(fColor));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (backgroundColorVal != null) {
            try {
                int bgColor = Integer.parseInt(backgroundColorVal);
                if (designObject instanceof EditableFonts) {
                    designObject.setUseDefaultColor(false);
                    designObject.setBackgroundColor(this.reverseRGB(bgColor));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (outlineColorVal != null) {
            try {
                int outColor = Integer.parseInt(outlineColorVal);
                if ("0".equalsIgnoreCase(objOutlineStyle)) {
                    designObject.setUseDefaultColor(false);
                    designObject.setForegroundColor(this.reverseRGB(outColor));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private List getPoints(Element elementProps) {
        ArrayList<Point> list = new ArrayList<Point>();
        Element pathArray = this.getElement(elementProps, "Relationship_Coordinates_Array");
        List coords = this.getElements(pathArray, "Relationship_Coordinates");
        String previous = "";
        for (int i = 1; i < coords.size() - 2; ++i) {
            Element coord = (Element)coords.get(i);
            String value = this.getValue(coord);
            if (previous.equalsIgnoreCase(value)) continue;
            previous = value;
            String xx = value.substring(0, value.indexOf(32));
            String yy = value.substring(value.indexOf(32) + 1);
            try {
                int x = Integer.parseInt(xx);
                int y = Integer.parseInt(yy);
                Point p = new Point(x, y);
                list.add(p);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return list;
    }

    private void parseDomain(Element element, Map childDomains, ImportLogger importLog) {
        String objectID = element.getAttribute("id");
        String domainName = element.getAttribute("name");
        Domain domain = null;
        if ("<unknown>".equalsIgnoreCase(domainName)) {
            domain = this.design.getDomainSet().getDefaultDomain();
        }
        if (domain == null) {
            domain = (Domain)this.design.getDomainSet().getByName(domainName);
        }
        if (domain == null) {
            domain = this.design.getDomainSet().createDomain();
            domain.setName(domainName);
            domain.setFileName("ERwin_domains");
        }
        this.domains.put(objectID, domain);
        Element domainProps = this.getElement(element, "DomainProps");
        String datatype = this.getElementValue(domainProps, "Logical_Data_Type");
        if (datatype != null) {
            this.parseDataType(domain, datatype, importLog);
        } else {
            String parentID = this.getElementValue(domainProps, "Parent_Domain_Ref");
            if (parentID != null) {
                childDomains.put(objectID, parentID);
            }
        }
        String validationRuleRef = this.getElementValue(domainProps, "Validation_Rule_Ref");
        if (validationRuleRef != null) {
            this.applyValidationRule(validationRuleRef, domain);
        }
    }

    private void parseRelationship(Element element) {
        String objectID = element.getAttribute("id");
        String rsName = element.getAttribute("name");
        Element rsProps = this.getElement(element, "RelationshipProps");
        String rsPhysicalName = this.getElementValue(rsProps, "Physical_Name");
        if (rsPhysicalName == null) {
            rsPhysicalName = rsName;
        }
        String comment = this.getElementValue(rsProps, "Comment");
        String rsParentEntity = this.getElementValue(rsProps, "Parent_Entity_Ref");
        String rsChildEntity = this.getElementValue(rsProps, "Child_Entity_Ref");
        String hideInLogical = this.getElementValue(rsProps, "Hide_In_Logical");
        String hideInPhysical = this.getElementValue(rsProps, "Hide_In_Physical");
        String rsType = this.getElementValue(rsProps, "Type");
        if ("9".equalsIgnoreCase(rsType)) {
            ERwinHandler.IHObject ihObject = new ERwinHandler.IHObject(rsParentEntity, rsChildEntity);
            if (comment != null) {
                ihObject.setComment(comment);
            }
            this.ihObjects.add(ihObject);
        } else {
            if (hideInLogical == null || !"true".equalsIgnoreCase(hideInLogical)) {
                this.parseRelation(element, objectID, rsParentEntity, rsChildEntity, rsName, comment);
            }
            if (!("4".equalsIgnoreCase(rsType) || hideInPhysical != null && "true".equalsIgnoreCase(hideInPhysical))) {
                this.parseForeignKey(element, objectID, rsParentEntity, rsChildEntity, rsPhysicalName, comment);
            }
        }
    }

    private void parseRelation(Element element, String rsID, String parentEntity, String childEntity, String name, String comment) {
        DesignObject parent = (DesignObject)this.logicalObjects.get(parentEntity);
        DesignObject child = (DesignObject)this.logicalObjects.get(childEntity);
        if (parent != null && child != null && parent instanceof Entity && child instanceof Entity) {
            TVRelation tvr;
            Relation relation = this.logical.createRelation();
            for (ERwinHandler.FKElement fkElement : this.logicalFKElements) {
                if (!fkElement.getParentRelationshipID().equalsIgnoreCase(rsID)) continue;
                Attribute attribute = (Attribute)this.logicalObjects.get(fkElement.getID());
                Attribute refAttribute = (Attribute)this.logicalObjects.get(fkElement.getParentAttributeID());
                if (attribute == null || refAttribute == null) continue;
                attribute.setReferedAttribute(refAttribute.getObjectID());
                attribute.setGeneratorID(relation.getObjectID());
                this.replacedAttributes.add(attribute);
            }
            if (name != null && !"".equalsIgnoreCase(name)) {
                relation.setName(name);
            }
            if (comment != null) {
                relation.setComment(comment);
            }
            relation.setSourceEntity((Entity)parent);
            relation.setTargetEntity((Entity)child);
            String relType = this.getElementPropValue(element, "Type");
            String relCardinality = this.getElementPropValue(element, "Cardinality");
            String relNullOptions = this.getElementValue(element, "Null_Option_Type");
            boolean identifying = false;
            boolean sourceOptional = true;
            boolean targetOptional = true;
            int sourceCardinality = 1;
            int targetCardinality = 1;
            if (relType != null && relCardinality != null) {
                if ("7".equalsIgnoreCase(relType)) {
                    identifying = false;
                    sourceOptional = !"101".equalsIgnoreCase(relNullOptions);
                    targetCardinality = "-1".equalsIgnoreCase(relCardinality) ? 1 : 0;
                    if ("-2".equalsIgnoreCase(relCardinality)) {
                        targetOptional = false;
                    }
                } else if ("2".equalsIgnoreCase(relType)) {
                    identifying = true;
                    sourceOptional = false;
                    targetCardinality = "-1".equalsIgnoreCase(relCardinality) ? 1 : 0;
                    if ("-2".equalsIgnoreCase(relCardinality)) {
                        targetOptional = false;
                    }
                } else if ("4".equalsIgnoreCase(relType)) {
                    sourceCardinality = 0;
                    targetCardinality = 0;
                }
                relation.setIdentifying(identifying);
                relation.setOptionalSource(sourceOptional);
                relation.setOptionalTarget(targetOptional);
                relation.setFireCardinalityChange(false);
                relation.setSourceCardinality(Relation.CARDINALITY_CHOICES[sourceCardinality]);
                relation.setFireCardinalityChange(true);
                relation.setTargetCardinality(Relation.CARDINALITY_CHOICES[targetCardinality]);
            }
            if ((tvr = (TVRelation)relation.getTopView()) != null) {
                tvr.addConnection();
                tvr.resetEdgeParams();
            }
            this.logicalObjects.put(rsID, relation);
        }
    }

    private void parseEntity(Element element) {
        String objectID = element.getAttribute("id");
        String entityName = element.getAttribute("name");
        Element elmEntityProps = this.getElement(element, "EntityProps");
        String entityType = this.getElementValue(elmEntityProps, "Type");
        String physicalName = this.getElementValue(elmEntityProps, "Physical_Name");
        String physicalOnly = this.getElementValue(elmEntityProps, "Is_Physical_Only");
        String logicalOnly = this.getElementValue(elmEntityProps, "Is_Logical_Only");
        String hideInLogical = this.getElementValue(elmEntityProps, "Hide_In_Logical");
        String hideInPhysical = this.getElementValue(elmEntityProps, "Hide_In_Physical");
        String definition = this.getElementValue(elmEntityProps, "Definition");
        String bgColorVal = this.getElementValue(elmEntityProps, "Fill_Color");
        String outlineColorVal = this.getElementValue(elmEntityProps, "Outline_Color");
        String nameFontID = this.getElementValue(elmEntityProps, "Default_Entity_Name_Font_Ref");
        String nameColorVal = this.getElementValue(elmEntityProps, "Default_Entity_Name_Color");
        String comment = this.getElementValue(elmEntityProps, "Comment");
        if (physicalName == null || "%EntityName()".equalsIgnoreCase(physicalName)) {
            physicalName = entityName;
        }
        if (!(physicalOnly != null && "true".equalsIgnoreCase(physicalOnly) || hideInLogical != null && "true".equalsIgnoreCase(hideInLogical) || "".equalsIgnoreCase(entityName))) {
            if ("17".equalsIgnoreCase(entityType)) {
                EntityView entityView = this.logical.createEntityView(entityName);
                this.logicalObjects.put(objectID, entityView);
                if (definition != null) {
                    entityView.setComment(definition);
                }
                if (comment != null) {
                    entityView.setNotes(comment);
                }
                this.setFontAndColor(entityView, bgColorVal, outlineColorVal, nameFontID, nameColorVal);
                this.logicalViews.add(element);
            } else {
                Entity entity = this.logical.createEntity(entityName);
                this.logicalObjects.put(objectID, entity);
                if (definition != null) {
                    entity.setComment(definition);
                }
                if (comment != null) {
                    entity.setNotes(comment);
                }
                this.parseAttributes(element, entity);
                this.parseKeys(element, entity);
                this.setFontAndColor(entity, bgColorVal, outlineColorVal, nameFontID, nameColorVal);
            }
        }
        if (!(logicalOnly != null && "true".equalsIgnoreCase(logicalOnly) || hideInPhysical != null && "true".equalsIgnoreCase(hideInPhysical) || "".equalsIgnoreCase(entityName))) {
            String name = entityName;
            if (physicalName != null && !"".equalsIgnoreCase(physicalName)) {
                name = physicalName;
            }
            if ("17".equalsIgnoreCase(entityType)) {
                TableView tableView = this.relational.createTableView(name);
                this.relationalObjects.put(objectID, tableView);
                if (definition != null) {
                    tableView.setComment(definition);
                }
                if (comment != null) {
                    tableView.setNotes(comment);
                }
                this.setFontAndColor(tableView, bgColorVal, outlineColorVal, nameFontID, nameColorVal);
                this.relationalViews.add(element);
            } else {
                Table table = this.relational.createTable(name);
                this.relationalObjects.put(objectID, table);
                if (definition != null) {
                    table.setComment(definition);
                }
                if (comment != null) {
                    table.setNotes(comment);
                }
                this.parseColumns(element, table);
                this.parseIndexes(element, table);
                List lsValidRules = this.getElements(elmEntityProps, "Validation_Rule_Ref");
                for (Element elmValidRule : lsValidRules) {
                    String vrID = this.getValue(elmValidRule);
                    ERwinHandler.ValidationRuleHolder vrh = (ERwinHandler.ValidationRuleHolder)this.validationRules.get(vrID);
                    if (vrh == null || vrh.getType() != 0) continue;
                    TableLevelConstraint constraint = table.createCheckConstraint(vrh.getName(), vrh.getRule());
                    table.addCheckConstraint(constraint);
                }
                this.setFontAndColor(table, bgColorVal, outlineColorVal, nameFontID, nameColorVal);
            }
        }
    }

    private void parseEntityViews() {
        for (Element element : this.logicalViews) {
            String objectID = element.getAttribute("id");
            EntityView view = (EntityView)this.logicalObjects.get(objectID);
            if (view == null) continue;
            this.parseViewAttributes(element, view);
        }
    }

    private void parseTableViews() {
        for (Element element : this.relationalViews) {
            String objectID = element.getAttribute("id");
            TableView view = (TableView)this.relationalObjects.get(objectID);
            if (view == null) continue;
            this.parseViewColumns(element, view);
        }
    }

    private void parseKeys(Element element, Entity entity) {
        Element elmKeyGroupGroups = this.getElement(element, "Key_Group_Groups");
        List keyGroups = this.getElements(elmKeyGroupGroups, "Key_Group");
        for (Element elmKeyGroup : keyGroups) {
            List elements;
            String keyID = elmKeyGroup.getAttribute("id");
            String keyGroupName = elmKeyGroup.getAttribute("name");
            Element elmKeyProps = this.getElement(elmKeyGroup, "Key_GroupProps");
            String type = this.getElementValue(elmKeyProps, "Key_Group_Type");
            String definition = this.getElementValue(elmKeyProps, "Definition");
            if (type.toUpperCase().startsWith("IF") || (elements = this.getAttributes(elmKeyGroup, true)).size() <= 0) continue;
            CandidateKey key = entity.createCandidateKey();
            key.setName(keyGroupName);
            this.logicalObjects.put(keyID, key);
            if (definition != null) {
                key.setComment(definition);
            }
            for (Attribute attribute : elements) {
                key.add(attribute);
            }
            if (!"PK".equalsIgnoreCase(type)) continue;
            key.makePK();
        }
    }

    private List getAttributes(Element element, boolean logical) {
        ArrayList<Object> list = new ArrayList<Object>();
        Element elmKeyGroupMembers = this.getElement(element, "Key_Group_Member_Groups");
        if (elmKeyGroupMembers != null) {
            List members = this.getElements(elmKeyGroupMembers, "Key_Group_Member");
            for (Element elmMember : members) {
                Element elmProps = this.getElement(elmMember, "Key_Group_MemberProps");
                String elementID = this.getElementValue(elmProps, "Attribute_Ref");
                Object attribute = null;
                attribute = logical ? (Object)this.logicalObjects.get(elementID) : (Object)this.relationalObjects.get(elementID);
                if (attribute == null) continue;
                list.add(attribute);
            }
        }
        return list;
    }

    private void parseAttributes(Element element, Entity entity) {
        Element elmAttributeGroups = this.getElement(element, "Attribute_Groups");
        if (elmAttributeGroups != null) {
            List attributes = this.getElements(elmAttributeGroups, "Attribute");
            for (Element elmAttribute : attributes) {
                String defaultValue;
                String defaultID;
                String validationRuleRef;
                Domain domain;
                String parentDomain;
                String nullOptions;
                String objectID = elmAttribute.getAttribute("id");
                String attributeName = elmAttribute.getAttribute("name");
                Element elmAttributeProps = this.getElement(elmAttribute, "AttributeProps");
                String hideInLogical = this.getElementValue(elmAttributeProps, "Hide_In_Logical");
                if (hideInLogical != null && "true".equalsIgnoreCase(hideInLogical)) continue;
                String parentAttribute = this.getElementValue(elmAttributeProps, "Parent_Attribute_Ref");
                String parentRelationship = this.getElementValue(elmAttributeProps, "Parent_Relationship_Ref");
                if (parentAttribute != null && parentRelationship != null) {
                    this.logicalFKElements.add(new ERwinHandler.FKElement(objectID, parentAttribute, parentRelationship));
                }
                Attribute attribute = entity.createAttribute(attributeName);
                this.logicalObjects.put(objectID, attribute);
                String definition = this.getElementValue(elmAttributeProps, "Definition");
                if (definition != null) {
                    attribute.setComment(definition);
                }
                if ((nullOptions = this.getElementValue(elmAttributeProps, "Null_Option_Type")) != null) {
                    if ("0".equalsIgnoreCase(nullOptions)) {
                        attribute.setNullsAllowed(true);
                    } else {
                        attribute.setNullsAllowed(false);
                    }
                }
                if ((parentDomain = this.getElementValue(elmAttributeProps, "Parent_Domain_Ref")) != null && (domain = (Domain)this.domains.get(parentDomain)) != null) {
                    attribute.setUse((short)0);
                    attribute.setDomain(domain);
                }
                if ((validationRuleRef = this.getElementValue(elmAttributeProps, "Validation_Rule_Ref")) != null) {
                    attribute.setUseDomainConstraints(false);
                    this.applyValidationRule(validationRuleRef, attribute);
                }
                if ((defaultID = this.getElementValue(elmAttributeProps, "Default")) != null && (defaultValue = (String)this.defaultValues.get(defaultID)) != null) {
                    attribute.setDefaultValue(defaultValue);
                }
                String nameFontID = this.getElementValue(elmAttributeProps, "Font_Ref");
                String nameColorVal = this.getElementValue(elmAttributeProps, "Font_Color");
                this.setAttributeFontAndColor(entity, nameFontID, nameColorVal, true);
            }
        }
    }

    private void parseViewAttributes(Element element, EntityView view) {
        Element elmAttributeGroups = this.getElement(element, "Attribute_Groups");
        if (elmAttributeGroups != null) {
            List attributes = this.getElements(elmAttributeGroups, "Attribute");
            for (Element elmAttribute : attributes) {
                String name = elmAttribute.getAttribute("name");
                Element elmAttributeProps = this.getElement(elmAttribute, "AttributeProps");
                String hideInLogical = this.getElementValue(elmAttributeProps, "Hide_In_Logical");
                if (hideInLogical != null && "true".equalsIgnoreCase(hideInLogical)) continue;
                String viewExpression = this.getElementValue(elmAttributeProps, "View_Expression");
                AttributeView attributeView = new AttributeView(this.logical);
                attributeView.setName(name);
                attributeView.setDesign(this.design);
                view.add(attributeView);
                attributeView.setContainer(view);
                if (viewExpression != null) {
                    attributeView.setExpression(viewExpression);
                    attributeView.setEntityAlias(view.getName());
                } else {
                    Attribute attribute;
                    String refAttributeID = this.getElementValue(elmAttributeProps, "Parent_Attribute_Ref");
                    if (refAttributeID != null && (attribute = (Attribute)this.logicalObjects.get(refAttributeID)) != null) {
                        attributeView.setReferencedAttribute(attribute);
                        attributeView.setDataType(attribute.getDataType().toString());
                        attributeView.setEntity((Entity)attribute.getContainer());
                        view.addToContainers(attribute.getContainer(), attribute.getContainer().getName());
                    }
                }
                String nameFontID = this.getElementValue(elmAttributeProps, "Font_Ref");
                String nameColorVal = this.getElementValue(elmAttributeProps, "Font_Color");
                this.setAttributeFontAndColor(view, nameFontID, nameColorVal, true);
            }
            view.setUserDefinedSQL(view.generateSQL());
        }
    }

    private void parseViewColumns(Element element, TableView view) {
        Element elmAttributeGroups = this.getElement(element, "Attribute_Groups");
        if (elmAttributeGroups != null) {
            List attributes = this.getElements(elmAttributeGroups, "Attribute");
            for (Element elmAttribute : attributes) {
                String name = elmAttribute.getAttribute("name");
                Element elmAttributeProps = this.getElement(elmAttribute, "AttributeProps");
                String hideInPhysical = this.getElementValue(elmAttributeProps, "Hide_In_Physical");
                if (hideInPhysical != null && "true".equalsIgnoreCase(hideInPhysical)) continue;
                String viewExpression = this.getElementValue(elmAttributeProps, "View_Expression");
                String physicalName = this.getElementValue(elmAttributeProps, "Physical_Name");
                if (physicalName == null || "%AttName".equalsIgnoreCase(physicalName)) {
                    physicalName = name;
                }
                ColumnView columnView = new ColumnView(this.relational);
                columnView.setName(physicalName);
                columnView.setDesign(this.design);
                view.add(columnView);
                columnView.setContainer(view);
                if (viewExpression != null) {
                    columnView.setExpression(viewExpression);
                    columnView.setTableAlias(view.getName());
                } else {
                    Column column;
                    String refAttributeID = this.getElementValue(elmAttributeProps, "Parent_Attribute_Ref");
                    if (refAttributeID != null && (column = (Column)this.relationalObjects.get(refAttributeID)) != null) {
                        columnView.setReferencedColumn(column);
                        columnView.setDataType(column.getDataType().toString());
                        columnView.setTable((Table)column.getContainer());
                        view.addToContainers(column.getContainer(), column.getContainer().getName());
                    }
                }
                String nameFontID = this.getElementValue(elmAttributeProps, "Font_Ref");
                String nameColorVal = this.getElementValue(elmAttributeProps, "Font_Color");
                this.setAttributeFontAndColor(view, nameFontID, nameColorVal, false);
            }
            view.setUserDefinedSQL(view.generateSQL());
        }
    }

    private void parseIndexes(Element element, Table table) {
        Element elmKeyGroupGroups = this.getElement(element, "Key_Group_Groups");
        if (elmKeyGroupGroups != null) {
            List keyGroups = this.getElements(elmKeyGroupGroups, "Key_Group");
            for (Element elmKeyGroup : keyGroups) {
                List elements;
                String keyID = elmKeyGroup.getAttribute("id");
                String keyGroupName = elmKeyGroup.getAttribute("name");
                Element elmKeyProps = this.getElement(elmKeyGroup, "Key_GroupProps");
                String type = this.getElementValue(elmKeyProps, "Key_Group_Type");
                String definition = this.getElementValue(elmKeyProps, "Definition");
                if (type.toUpperCase().startsWith("IF") || (elements = this.getAttributes(elmKeyGroup, false)).size() <= 0) continue;
                Index index = table.createIndex();
                index.setName(keyGroupName);
                this.relationalObjects.put(keyID, index);
                if (definition != null) {
                    index.setComment(definition);
                }
                for (Column column : elements) {
                    index.add(column);
                }
                if ("PK".equalsIgnoreCase(type)) {
                    index.makePK();
                    continue;
                }
                if (!type.toUpperCase().startsWith("AK")) continue;
                index.setIndexState("Unique Constraint");
            }
        }
    }

    private void parseColumns(Element element, Table table) {
        Element elmAttributeGroups = this.getElement(element, "Attribute_Groups");
        if (elmAttributeGroups != null) {
            List attributes = this.getElements(elmAttributeGroups, "Attribute");
            for (Element elmAttribute : attributes) {
                String defaultValue;
                String defaultID;
                String validationRuleRef;
                Domain domain;
                String parentDomain;
                String nullOptions;
                String objectID = elmAttribute.getAttribute("id");
                String attributeName = elmAttribute.getAttribute("name");
                Element elmAttributeProps = this.getElement(elmAttribute, "AttributeProps");
                String hideInPhysical = this.getElementValue(elmAttributeProps, "Hide_In_Physical");
                if (hideInPhysical != null && "true".equalsIgnoreCase(hideInPhysical)) continue;
                String physicalName = this.getElementValue(elmAttributeProps, "Physical_Name");
                if (physicalName != null && "%AttName".equalsIgnoreCase(physicalName)) {
                    physicalName = attributeName;
                }
                String name = attributeName;
                if (physicalName != null && !"".equalsIgnoreCase(physicalName)) {
                    name = physicalName;
                }
                String parentAttribute = this.getElementValue(elmAttributeProps, "Parent_Attribute_Ref");
                String parentRelationship = this.getElementValue(elmAttributeProps, "Parent_Relationship_Ref");
                if (parentAttribute != null && parentRelationship != null) {
                    this.relationalFKElements.add(new ERwinHandler.FKElement(objectID, parentAttribute, parentRelationship));
                }
                Column column = table.createColumn(name);
                this.relationalObjects.put(objectID, column);
                String definition = this.getElementValue(elmAttributeProps, "Definition");
                if (definition != null) {
                    column.setComment(definition);
                }
                if ((nullOptions = this.getElementValue(elmAttributeProps, "Null_Option_Type")) != null) {
                    if ("0".equalsIgnoreCase(nullOptions)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                }
                if ((parentDomain = this.getElementValue(elmAttributeProps, "Parent_Domain_Ref")) != null && (domain = (Domain)this.domains.get(parentDomain)) != null) {
                    column.setUse((short)0);
                    column.setDomain(domain);
                }
                if ((validationRuleRef = this.getElementValue(elmAttributeProps, "Validation_Rule_Ref")) != null) {
                    column.setUseDomainConstraints(false);
                    this.applyValidationRule(validationRuleRef, column);
                }
                if ((defaultID = this.getElementValue(elmAttributeProps, "Default")) != null && (defaultValue = (String)this.defaultValues.get(defaultID)) != null) {
                    column.setUsesDefaultValue(true);
                    column.setDefaultValue(defaultValue);
                }
                String nameFontID = this.getElementValue(elmAttributeProps, "Font_Ref");
                String nameColorVal = this.getElementValue(elmAttributeProps, "Font_Color");
                this.setAttributeFontAndColor(table, nameFontID, nameColorVal, false);
            }
        }
    }

    private void createMany2ManyMapping(Element m2mtGroups) {
        if (m2mtGroups != null) {
            List m2mt = this.getElements(m2mtGroups, "Many_To_Many_Transform");
            for (Element elmM2M : m2mt) {
                Element propsM2M = this.getElement(elmM2M, "Many_To_Many_TransformProps");
                String intermediateTableID = this.getElementValue(propsM2M, "Many_To_Many_Association_Table_Ref");
                Table table = (Table)this.relationalObjects.get(intermediateTableID);
                String relationID_1 = this.getElementValue(propsM2M, "Relationship_1_Ref");
                Relation relation_1 = (Relation)this.logicalObjects.get(relationID_1);
                String relationID_2 = this.getElementValue(propsM2M, "Relationship_2_Ref");
                Relation relation_2 = (Relation)this.logicalObjects.get(relationID_2);
                if (relation_1 != null && table != null) {
                    XtdMapping mapping_1 = this.design.getExtendedMap().createMapping(relation_1, table);
                    mapping_1.setRealSourceEntityID(relation_1.getSourceEntity().getObjectID());
                    mapping_1.setRealTargetEntityID(relation_1.getTargetEntity().getObjectID());
                    table.setGeneratorID(relation_1.getObjectID());
                    mapping_1.setCreationTime(System.currentTimeMillis());
                }
                if (relation_2 == null || table == null) continue;
                XtdMapping mapping_2 = this.design.getExtendedMap().createMapping(relation_2, table);
                mapping_2.setRealSourceEntityID(relation_2.getSourceEntity().getObjectID());
                mapping_2.setRealTargetEntityID(relation_2.getTargetEntity().getObjectID());
                table.setGeneratorID(relation_2.getObjectID());
                mapping_2.setCreationTime(System.currentTimeMillis());
            }
        }
    }

    private void createSuperTypeSubTypeMapping(Element ststGroups) {
        if (ststGroups != null) {
            List ststRollUp = this.getElements(ststGroups, "Supertype_Subtype_Roll_Up_Transform");
            for (Element elmStSt : ststRollUp) {
                Element subtransformGroup;
                Element propsStSt = this.getElement(elmStSt, "Supertype_Subtype_Roll_Up_TransformProps");
                String parentTableID = this.getElementValue(propsStSt, "Parent_Table_Ref");
                String denormalizedTableID = this.getElementValue(propsStSt, "Denormalized_Table_In_Roll_Up_Ref");
                if (parentTableID != null && denormalizedTableID != null) {
                    ContainerWithKeyObject parentEntity = null;
                    Table denormalizedTable = (Table)this.relationalObjects.get(denormalizedTableID);
                    if (parentEntity != null && denormalizedTable != null) {
                        if (this.design.getExtendedMap().getMapping(parentEntity, denormalizedTable) == null) {
                            XtdMapping mapping = this.design.getExtendedMap().createMapping(parentEntity, denormalizedTable);
                            denormalizedTable.setGeneratorID(parentEntity.getObjectID());
                            mapping.setCreationTime(System.currentTimeMillis());
                        }
                        KeyObject entityPK = parentEntity.getPK();
                        KeyObject tablePK = denormalizedTable.getPK();
                        if (entityPK != null && tablePK != null && this.design.getExtendedMap().getMapping(entityPK, tablePK) == null) {
                            XtdMapping mapping = this.design.getExtendedMap().createMapping(entityPK, tablePK);
                            tablePK.setGeneratorID(entityPK.getObjectID());
                            mapping.setCreationTime(System.currentTimeMillis());
                        }
                    }
                }
                if ((subtransformGroup = this.getElement(elmStSt, "Roll_Up_Subtransform_Groups")) == null) continue;
                List subtransforms = this.getElements(subtransformGroup, "Roll_Up_Subtransform");
                for (Element subtransform : subtransforms) {
                    Element associationGroup = this.getElement(subtransform, "Association_Groups");
                    if (associationGroup == null) continue;
                    List associations = this.getElements(associationGroup, "Association");
                    for (Element association : associations) {
                        Element associationProps = this.getElement(association, "AssociationProps");
                        String sourceID = this.getElementValue(associationProps, "Source_Object_Ref");
                        String targetID = this.getElementValue(associationProps, "Target_Object_Ref");
                        DesignObject sourceObj = (DesignObject)this.logicalObjects.get(sourceID);
                        DesignObject targetObj = (DesignObject)this.relationalObjects.get(targetID);
                        if (sourceObj == null || targetObj == null || this.design.getExtendedMap().getMapping(sourceObj, targetObj) != null || this.isDeleted(sourceObj) || this.isDeleted(targetObj)) continue;
                        XtdMapping mapping = this.design.getExtendedMap().createMapping(sourceObj, targetObj);
                        targetObj.setGeneratorID(sourceID);
                        mapping.setCreationTime(System.currentTimeMillis());
                    }
                }
            }
        }
    }

    private void parseDefaultValues(Element defaultValueGroups) {
        List lsDefaultValues = this.getElements(defaultValueGroups, "Default");
        for (Element elmDefaultValue : lsDefaultValues) {
            String value;
            String dfID = elmDefaultValue.getAttribute("id");
            Element dfProps = this.getElement(elmDefaultValue, "DefaultProps");
            String builtIn = this.getElementValue(dfProps, "Built_In_Id");
            if (builtIn != null && !"0".equalsIgnoreCase(builtIn) || (value = this.getElementValue(dfProps, "Server_Value")) == null) continue;
            this.defaultValues.put(dfID, value);
        }
    }

    private void parseValidationRules(Element vrGroups) {
        List lsValidationRules = this.getElements(vrGroups, "Validation_Rule");
        for (Element elmValidationRule : lsValidationRules) {
            Element elmValueGroups;
            ERwinHandler.ValidationRuleHolder vrh;
            String vrID = elmValidationRule.getAttribute("id");
            String vrName = elmValidationRule.getAttribute("name");
            Element vrProps = this.getElement(elmValidationRule, "Validation_RuleProps");
            String type = this.getElementValue(vrProps, "Type");
            String definition = this.getElementValue(elmValidationRule, "Definition");
            if (type == null || "0".equalsIgnoreCase(type)) {
                String rule = this.getElementValue(elmValidationRule, "Logical_User_Rule");
                if (rule == null) continue;
                vrh = new ERwinHandler.ValidationRuleHolder(0);
                vrh.setName(vrName);
                vrh.setRule(rule);
                this.validationRules.put(vrID, vrh);
                continue;
            }
            if ("1".equalsIgnoreCase(type)) {
                String minValue = this.getElementValue(elmValidationRule, "Min_Value");
                String maxValue = this.getElementValue(elmValidationRule, "Max_Value");
                if (minValue == null || maxValue == null) continue;
                ERwinHandler.ValidationRuleHolder vrh2 = new ERwinHandler.ValidationRuleHolder(1);
                vrh2.setName(vrName);
                vrh2.setMinValue(minValue);
                vrh2.setMaxValue(maxValue);
                if (definition != null) {
                    vrh2.setDefinition(definition);
                }
                this.validationRules.put(vrID, vrh2);
                continue;
            }
            if (!"2".equalsIgnoreCase(type) || (elmValueGroups = this.getElement(elmValidationRule, "Valid_Value_Groups")) == null) continue;
            vrh = new ERwinHandler.ValidationRuleHolder(2);
            vrh.setName(vrName);
            this.validationRules.put(vrID, vrh);
            List lsValidValues = this.getElements(elmValueGroups, "Valid_Value");
            for (Element elmValidValue : lsValidValues) {
                String vvName = elmValidValue.getAttribute("name");
                String vvDefinition = this.getElementValue(elmValidValue, "Definition");
                vrh.addValue(vvName, vvDefinition);
            }
        }
    }

    private void parseProxyObjects(Element modelProxy) {
        String modelProxyID = modelProxy.getAttribute("id");
        this.proxyObjects.put(modelProxyID, modelProxy);
        Element sdProxyGroups = this.getElement(modelProxy, "Stored_Display_Proxy_Object_Groups");
        if (sdProxyGroups != null) {
            List sdProxyList = this.getElements(sdProxyGroups, "Stored_Display_Proxy_Object");
            for (Element sdProxy : sdProxyList) {
                String sdProxyID = sdProxy.getAttribute("id");
                this.proxyObjects.put(sdProxyID, sdProxy);
            }
        }
    }
}

