/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractDBMExtractionHandler {
    protected String dbProductName = "";
    protected String dbProductVersion = "";
    protected int dbMajorVersion = -1;
    private boolean secondaryTables = false;
    private boolean spatialProperties;
    private boolean partitions = true;
    private boolean triggers = true;
    private boolean structuredTypesScan = false;
    private static boolean allSelected = false;
    private static boolean schemaBased = true;
    private static final Logger LOGGER = new Logger(AbstractDBMExtractionHandler.class);

    protected AbstractDBMExtractionHandler() {
    }

    public abstract RDBMSSite getRDBMSSite();

    public abstract List getMOHObjects();

    public String getDBProductVersion() {
        return this.dbProductVersion;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    public int getDBMajorVersion() {
        return this.dbMajorVersion;
    }

    public static boolean isAllSelected() {
        return allSelected;
    }

    public static void setAllSelected(boolean allSel) {
        allSelected = allSel;
    }

    public static boolean isSchemaBased() {
        return schemaBased;
    }

    public static void setSchemaBased(boolean schemaBase) {
        schemaBased = schemaBase;
    }

    protected void dumpResultSet(ResultSet rs) {
        try {
            while (rs.next()) {
                System.out.println("-----------------------------------------------");
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    System.out.println(rsmd.getColumnName(i) + " : " + rsmd.getColumnTypeName(i) + " = " + rs.getString(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getSchemas(Connection conn) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            boolean mvSet = false;
            DatabaseMetaData dbmd = conn.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                if (this.dbProductName.toUpperCase().indexOf("ORACLE") > -1) {
                    Statement st;
                    block14: {
                        st = conn.createStatement();
                        try {
                            ResultSet rs = st.executeQuery("select product, version from product_component_version where product like 'Oracle%'");
                            if (rs == null) break block14;
                            if (rs.next()) {
                                this.dbProductVersion = rs.getString(1);
                                String mv = rs.getString(2);
                                if (mv != null && mv.length() > 0) {
                                    try {
                                        mv = mv.substring(0, mv.indexOf("."));
                                        this.dbMajorVersion = Integer.parseInt(mv);
                                        mvSet = true;
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                            }
                            rs.close();
                        }
                        catch (Exception e) {
                            this.dbProductVersion = dbmd.getDatabaseProductVersion();
                        }
                    }
                    if (st != null) {
                        st.close();
                    }
                } else {
                    this.dbProductVersion = dbmd.getDatabaseProductVersion();
                }
                if (!mvSet) {
                    this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
                }
            }
            catch (Throwable e) {
                LOGGER.error(e);
                System.out.println(e.getMessage());
            }
            ResultSet resultSet = dbmd.getSchemas();
            while (resultSet.next()) {
                String schema = resultSet.getString(1);
                DBObject dbo = new DBObject(false, schema);
                list.add(dbo);
            }
            resultSet.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDBObjects(Connection conn, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects();
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    list.add((DBObject)obj);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDBObjects(Connection conn, List schemas, String type) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        List mhoList = this.getMOHObjects();
        if (mhoList.size() > 0 && conn != null) {
            for (AbstractMOHandler moHandler : mhoList) {
                if (!type.equalsIgnoreCase(moHandler.getType())) continue;
                moHandler.reset();
                List extracted = moHandler.extract(conn, schemas);
                for (Object obj : extracted) {
                    if (!(obj instanceof DBObject)) continue;
                    list.add((DBObject)obj);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        block16: {
            List mhoList = this.getMOHObjects();
            if (selectedObjects.size() <= 0 || mhoList.size() <= 0 || conn == null) break block16;
            try {
                int counter = 0;
                double step = 10.0;
                int size = mhoList.size();
                for (AbstractMOHandler moHandler : mhoList) {
                    System.out.println(moHandler.getType());
                    moHandler.setSupportInformation_Schema(true);
                    moHandler.generate(conn, selectedObjects, importLog);
                    moHandler.clearHandledObjects(selectedObjects);
                    ++counter;
                    monitor.setProgress((int)(step += 75.0 / (double)size));
                }
                for (AbstractMOHandler moHandler : mhoList) {
                    moHandler.postGenerateProcessing(conn);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error in database import:", e);
                MessageDialogs.showErrorMessage(ApplicationView.frame, e.getMessage() != null ? e.getMessage() : "An error occured while importing from database.\nSee the log file for more details.", true);
            }
            finally {
                try {
                    if (!conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception ec) {
                    LOGGER.error(ec.toString());
                }
            }
        }
    }

    public boolean isSecondaryTables() {
        return this.secondaryTables;
    }

    public void setSecondaryTables(boolean secondaryTables) {
        this.secondaryTables = secondaryTables;
    }

    public boolean isSpatialProperties() {
        return this.spatialProperties;
    }

    public void setSpatialProperties(boolean spatialProperties) {
        this.spatialProperties = spatialProperties;
    }

    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = dbmd.getDatabaseMajorVersion();
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean isPartitions() {
        return this.partitions;
    }

    public void setPartitions(boolean partitions) {
        this.partitions = partitions;
    }

    public boolean isTriggers() {
        return this.triggers;
    }

    public void setTriggers(boolean triggers) {
        this.triggers = triggers;
    }

    public boolean isStructuredTypesScan() {
        return this.structuredTypesScan;
    }

    public void setStructuredTypesScan(boolean structuredTypesScan) {
        this.structuredTypesScan = structuredTypesScan;
    }
}

