/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public class DBObject {
    private boolean selected;
    private String name;
    private String type;
    private String schema;
    private String catalog;
    private String specificName;
    private String status = "";
    private String comments = "";
    private boolean requiredSet = false;
    private List<DBObject> requiredBy = new Vector<DBObject>();
    private List<DBObject> requires = new Vector<DBObject>();
    private String typeName;
    private String superTypeName;
    private String typeCode;
    private String typeOwner;
    private String superTypeOwner;
    private boolean isFinal;
    private boolean instantiable = true;
    private TableProxy tableProxy;
    private String ID;
    private Table table;
    public boolean partitioned = false;
    public boolean hasLOBs = false;
    private Object descrptiveObject = null;
    private int localMethods = -1;
    private int localAttributes = -1;
    private boolean processed = false;
    public static final String NAME_EXIST = "Type name exist";

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    public DBObject(boolean selected, String name) {
        this(selected, name, "", "");
    }

    public DBObject(boolean selected, String name, String type) {
        this(selected, name, type, "");
    }

    public DBObject(boolean selected, String name, String type, String schema) {
        this(selected, name, type, schema, "");
    }

    public DBObject(boolean selected, String name, String type, String schema, String specificName) {
        this.selected = selected;
        this.name = name;
        this.type = type;
        this.schema = schema;
        this.specificName = specificName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.makeID();
    }

    private void makeID() {
        if (this.getSchema() != null && this.getName() != null) {
            this.ID = this.getSchema() + "." + this.getName();
        }
    }

    public boolean isSelected() {
        return this.selected || this.isRequired();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isRequired() {
        if (this.selected) {
            return true;
        }
        for (DBObject dbObj : this.requiredBy) {
            if (dbObj == null || !dbObj.isRequired()) continue;
            return true;
        }
        return false;
    }

    public void addRequiredBy(DBObject dbObj) {
        if (dbObj != null && !this.requiredBy.contains(dbObj)) {
            dbObj.requires.add(this);
            this.requiredBy.add(dbObj);
        }
    }

    public void removeRequiredBy(DBObject dbObj) {
        if (dbObj != null && this.requiredBy.contains(dbObj)) {
            dbObj.requires.remove(this);
            this.requiredBy.remove(dbObj);
        }
    }

    public List<DBObject> getRequiredBy() {
        return Collections.unmodifiableList(this.requiredBy);
    }

    public void addRequires(DBObject dbObj) {
        if (dbObj != null && !this.requires.contains(dbObj)) {
            this.requires.add(dbObj);
            dbObj.requiredBy.add(this);
        }
    }

    public void removeRequires(DBObject dbObj) {
        if (dbObj != null && this.requires.contains(dbObj)) {
            this.requires.remove(dbObj);
            dbObj.requiredBy.remove(this);
        }
    }

    public List<DBObject> getRequires() {
        return Collections.unmodifiableList(this.requires);
    }

    public void setRequiredSet(boolean requiredSet) {
        this.requiredSet = requiredSet;
    }

    public boolean isRequiredSet() {
        return this.requiredSet;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        this.makeID();
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public void setSuperTypeName(String superTypeName) {
        this.superTypeName = superTypeName;
    }

    public String getSuperTypeOwner() {
        return this.superTypeOwner;
    }

    public void setSuperTypeOwner(String superTypeOwner) {
        this.superTypeOwner = superTypeOwner;
    }

    public String toString() {
        if (this.getSchema() != null && !this.getSchema().equals("")) {
            return this.getSchema() + "." + this.getName() + "." + this.getType();
        }
        return this.getName();
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean instantiable) {
        this.instantiable = instantiable;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeOwner() {
        return this.typeOwner;
    }

    public void setTypeOwner(String typeOwner) {
        this.typeOwner = typeOwner;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public TableProxy getTableProxy() {
        return this.tableProxy;
    }

    public void setTableProxy(TableProxy tableProxy) {
        this.tableProxy = tableProxy;
    }

    public String getID() {
        if (this.ID == null && this.getSchema() != null && this.getName() != null) {
            this.makeID();
        }
        if (this.ID != null) {
            return this.ID;
        }
        throw new RuntimeException("Owner and name of the object are not set");
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Object getDescrptiveObject() {
        return this.descrptiveObject;
    }

    public void setDescrptiveObject(Object descrptiveObject) {
        this.descrptiveObject = descrptiveObject;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        if (comments != null) {
            this.comments = comments;
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public int getLocalMethods() {
        return this.localMethods;
    }

    public void setLocalMethods(int localMethods) {
        this.localMethods = localMethods;
    }

    public int getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(int localAttributes) {
        this.localAttributes = localAttributes;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }
}

