/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class MOHTable
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLE";
    protected static final String COL_OBJECT_TYPE = "COLUMN";
    protected static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private final String NOT_NULL_PATTERN = " IS NOT NULL";
    protected static final String SIZE = "size";
    protected static final String SCALE = "scale";
    protected static final String PRECISION = "precision";
    PreparedStatement checkSt;
    PreparedStatement nullSchemaSt;
    private static final Hashtable SYNONYM_TABLE = new Hashtable();

    public MOHTable(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getTables(DatabaseMetaData dbmd, DBObject dbo, boolean all) throws Exception {
        if (all) {
            return dbmd.getTables(null, dbo.getName(), "%", new String[]{OBJECT_TYPE});
        }
        return dbmd.getTables(null, dbo.getSchema(), dbo.getName(), new String[]{OBJECT_TYPE});
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        return dbmd.getColumns(null, dboTable.getSchema(), dboTable.getName(), "%");
    }

    protected ResultSet getPrimaryKeys(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        return dbmd.getPrimaryKeys(null, dboTable.getSchema(), dboTable.getName());
    }

    protected ResultSet getIndexInfo(DatabaseMetaData dbmd, DBObject dboTable) throws Exception {
        return dbmd.getIndexInfo(null, dboTable.getSchema(), dboTable.getName(), false, false);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            ResultSet rs = this.getTables(dbmd, dboNext, true);
            while (rs.next()) {
                String catalog = rs.getString(1);
                String schema = rs.getString(2);
                if (schema == null) {
                    schema = dboNext.getName();
                }
                String objName = rs.getString(3);
                String type = rs.getString(4);
                if (objName == null || !OBJECT_TYPE.equalsIgnoreCase(type)) continue;
                DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, OBJECT_TYPE, schema);
                list.add(dboTable);
            }
            rs.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        boolean first = true;
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dboTable = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dboTable.getType())) continue;
            Table table = this.getDesign().getRelationalDesign().createTable();
            table.setSchema(dboTable.getSchema());
            table.setName(dboTable.getName());
            this.stampModelObject(table, dboTable);
            this.handleColumns(dbmd, dboTable, table);
            this.handlePKS(dbmd, dboTable, table);
            this.handleIndexes(dbmd, dboTable, table);
            if (first || this.isSupportInformation_Schema()) {
                first = false;
                this.handleCheckConstraint(sqlConnection, dboTable, table);
            }
            table.resetIdentityColumn();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dboTable);
        }
    }

    protected void handleCheckConstraint(Connection sqlConnection, DBObject dbo, Table table) {
        try {
            String query;
            StringBuffer sql;
            ResultSet rs = null;
            if (dbo.getSchema() != null && !"".equals(dbo.getSchema())) {
                if (this.checkSt == null) {
                    sql = new StringBuffer();
                    sql.append("SELECT t.table_schema, \n");
                    sql.append("  t.table_name, \n");
                    sql.append("  t.constraint_name, \n");
                    sql.append("  t.constraint_type, \n");
                    sql.append("  t.is_deferrable, \n");
                    sql.append("  t.initially_deferred, \n");
                    sql.append("  c.check_clause \n");
                    sql.append("FROM information_schema.check_constraints c, \n");
                    sql.append("  information_schema.table_constraints t \n");
                    sql.append("WHERE t.table_schema    = ? \n");
                    sql.append("AND t.table_name        = ? \n");
                    sql.append("AND t.constraint_type   = 'CHECK' \n");
                    sql.append("AND c.constraint_name   = t.constraint_name \n");
                    sql.append("AND c.constraint_schema = t.constraint_schema");
                    query = sql.toString();
                    this.checkSt = sqlConnection.prepareStatement(query);
                }
                this.checkSt.setString(1, dbo.getSchema());
                this.checkSt.setString(2, dbo.getName());
                rs = this.checkSt.executeQuery();
            } else {
                if (this.nullSchemaSt == null) {
                    sql = new StringBuffer();
                    sql.append("SELECT t.table_schema, \n");
                    sql.append("  t.table_name, \n");
                    sql.append("  t.constraint_name, \n");
                    sql.append("  t.constraint_type, \n");
                    sql.append("  t.is_deferrable, \n");
                    sql.append("  t.initially_deferred, \n");
                    sql.append("  c.check_clause \n");
                    sql.append("FROM information_schema.check_constraints c, \n");
                    sql.append("  information_schema.table_constraints t \n");
                    sql.append("WHERE \n");
                    sql.append(" t.table_name        = ? \n");
                    sql.append("AND t.constraint_type   = 'CHECK' \n");
                    sql.append("AND c.constraint_name   = t.constraint_name \n");
                    sql.append("AND c.constraint_schema = t.constraint_schema");
                    query = sql.toString();
                    this.nullSchemaSt = sqlConnection.prepareStatement(query);
                }
                this.nullSchemaSt.setString(1, dbo.getName());
                rs = this.nullSchemaSt.executeQuery();
            }
            if (rs != null) {
                while (rs.next()) {
                    String constrName = rs.getString(3);
                    String checkClause = rs.getString(7);
                    if (checkClause == null || this.isNotNullCheck(checkClause, table)) continue;
                    TableLevelConstraint constraint = table.createCheckConstraint(constrName, checkClause);
                    table.addCheckConstraint(constraint);
                }
                rs.close();
            }
            this.setSupportInformation_Schema(true);
        }
        catch (SQLException e) {
            this.setSupportInformation_Schema(false);
        }
    }

    private boolean isNotNullCheck(String check, Table table) {
        String constr = check.toUpperCase();
        for (Column col : table.getElementsCollection()) {
            if (!col.isMandatory() || !constr.equalsIgnoreCase(col.getName() + " IS NOT NULL")) continue;
            return true;
        }
        return false;
    }

    protected void setLogicalTypeParams(Column column, LogicalDatatype logDatatype, int size, int decimalDigits) {
        try {
            Map m = logDatatype.getToPhysical();
            MDDataType datatype = logDatatype.createDataType(this.getDbmeHandler().getRDBMSSite().getType().getName(), m);
            if (!(datatype instanceof MDImplicitSized)) {
                if (datatype instanceof MDPackedSized) {
                    if (size > 0) {
                        column.setDataTypeParameter(PRECISION, String.valueOf(size));
                    }
                    if (decimalDigits > 0) {
                        column.setDataTypeParameter(SCALE, String.valueOf(decimalDigits));
                    }
                } else if (size > 0) {
                    column.setDataTypeParameter(SIZE, String.valueOf(size));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void handleColumns(DatabaseMetaData dbmd, DBObject dboTable, Table table) throws Exception {
        String dbProductName = dbmd.getDatabaseProductName();
        ResultSet rsColumns = this.getColumns(dbmd, dboTable);
        RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
        if (rsColumns != null) {
            while (rsColumns.next()) {
                String colName = rsColumns.getString("COLUMN_NAME");
                short datatype = rsColumns.getShort("DATA_TYPE");
                String colDatatype = MOHTable.getSQLDataType(datatype);
                String dataTypeName = rsColumns.getString("TYPE_NAME");
                if (colDatatype == null && dataTypeName != null) {
                    colDatatype = dataTypeName;
                }
                int colSize = 0;
                int colDecimalDigits = 0;
                String defaultValue = null;
                String colIsNullable = null;
                String colIsAutoIncrement = null;
                try {
                    colSize = rsColumns.getInt("COLUMN_SIZE");
                    if (colSize > 2000) {
                        colSize = 0;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    colDecimalDigits = rsColumns.getInt("DECIMAL_DIGITS");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    defaultValue = rsColumns.getString("COLUMN_DEF");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    colIsNullable = this.getColumn(rsColumns, "IS_NULLABLE");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    colIsAutoIncrement = this.getColumn(rsColumns, "IS_AUTOINCREMENT");
                }
                catch (Exception e) {
                    // empty catch block
                }
                String remarks = null;
                try {
                    remarks = this.getColumn(rsColumns, "REMARKS");
                }
                catch (Exception e) {
                    // empty catch block
                }
                Column column = new Column(table.getDesignPart());
                column.setName(colName);
                if (remarks != null) {
                    column.setCommentInRDBMS(remarks);
                }
                if (colDatatype != null) {
                    String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                    if ("MYSQL".equalsIgnoreCase(dbProductName)) {
                        int ind;
                        String dt = (String)SYNONYM_TABLE.get(colDatatype.toUpperCase());
                        if (dt == null) {
                            dt = (String)SYNONYM_TABLE.get(dataTypeName.toUpperCase());
                        }
                        if (dt == null && (ind = colDatatype.indexOf(32)) > 0) {
                            dt = colDatatype.substring(0, ind);
                            dt = (String)SYNONYM_TABLE.get(dt.toUpperCase());
                        }
                        if (dt != null) {
                            nameDatatype = dt;
                        }
                    }
                    LogicalDatatype logDatatype = null;
                    NativeDBType nt = null;
                    if (logDatatype == null && (nt = StandardDatatypeNames.getNativeDBType(dbtype, dataTypeName)) != null) {
                        logDatatype = nt.getLogicalDatatype();
                    }
                    if (logDatatype == null) {
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, nameDatatype);
                    }
                    if (logDatatype == null) {
                        logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, dbtype.getName());
                    }
                    if (logDatatype == null) {
                        String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(nameDatatype);
                        logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByName(nameLogDT);
                    }
                    if (logDatatype != null) {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        this.setLogicalTypeParams(column, logDatatype, colSize, colDecimalDigits);
                    } else {
                        System.out.println("Unable to find logical datatype for: " + colDatatype);
                    }
                }
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue);
                }
                if (colIsNullable != null) {
                    if ("YES".equalsIgnoreCase(colIsNullable)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                }
                if (colIsAutoIncrement != null && "YES".equalsIgnoreCase(colIsAutoIncrement)) {
                    column.setAutoIncrementColumn(true);
                }
                table.addColumn(column);
                this.stampModelObject((ModelObject)column, table.getName(), colName);
            }
            rsColumns.close();
        }
    }

    protected void handlePKS(DatabaseMetaData dbmd, DBObject dboTable, Table table) throws Exception {
        ResultSet rsPKs = this.getPrimaryKeys(dbmd, dboTable);
        TreeMap<String, String> map = new TreeMap<String, String>();
        String name = null;
        boolean hasPK = false;
        if (rsPKs != null) {
            while (rsPKs.next()) {
                String columnName = this.getColumn(rsPKs, "COLUMN_NAME");
                String seq = rsPKs.getString("KEY_SEQ");
                name = this.getColumn(rsPKs, "PK_NAME");
                map.put(seq, columnName);
                hasPK = true;
            }
            rsPKs.close();
            if (hasPK) {
                Index index;
                if (name != null) {
                    index = (Index)table.getKeySet().getByName(name);
                    if (index == null) {
                        index = table.createIndex();
                        index.setName(name);
                        this.stampModelObject((ModelObject)index, table.getSchema(), name);
                    }
                } else {
                    index = table.createIndex();
                }
                for (String columnName : map.values()) {
                    Column column;
                    if (columnName == null || (column = (Column)table.getElementByName(columnName)) == null) continue;
                    index.add(column);
                }
                index.setIndexState("Primary Constraint");
            }
        }
    }

    protected void handleIndexes(DatabaseMetaData dbmd, DBObject dboTable, Table table) throws Exception {
        ResultSet rsIndexes = this.getIndexInfo(dbmd, dboTable);
        if (rsIndexes != null) {
            while (rsIndexes.next()) {
                Index index;
                String pkTABLE_CAT = rsIndexes.getString(1);
                String pkTABLE_SCHEM = rsIndexes.getString(2);
                String pkTABLE_NAME = rsIndexes.getString(3);
                boolean indNON_UNIQUE = rsIndexes.getBoolean(4);
                String ind_QUALIFIER = rsIndexes.getString(5);
                String ind_NAME = rsIndexes.getString(6);
                int ind_TYPE = rsIndexes.getInt(7);
                String colORDINAL_POSITION = rsIndexes.getString(8);
                String col_NAME = rsIndexes.getString(9);
                String colASC_OR_DESC = rsIndexes.getString(10);
                String rowCARDINALITY = rsIndexes.getString(11);
                String numPAGES = rsIndexes.getString(12);
                String indFILTER_CONDITION = rsIndexes.getString(13);
                if (ind_TYPE <= 0) continue;
                String name = ind_NAME;
                if (name != null) {
                    index = (Index)table.getKeySet().getByName(name);
                    if (index == null) {
                        index = table.createIndex();
                        index.setName(name);
                        this.stampModelObject((ModelObject)index, table.getSchema(), index.getName());
                    } else if (index.isPK()) {
                        continue;
                    }
                } else {
                    index = table.createIndex();
                }
                String columnName = col_NAME;
                Column column = (Column)table.getElementByName(columnName);
                if (column != null) {
                    index.add(column);
                    String sortOrder = colASC_OR_DESC;
                    if ("D".equalsIgnoreCase(sortOrder)) {
                        index.setColumnSortOrder(column, "DESC");
                    }
                } else {
                    System.out.println("Unable to find column: " + columnName);
                }
                if (indNON_UNIQUE) continue;
                index.setIndexState("Unique Constraint");
            }
            rsIndexes.close();
        }
    }

    static {
        SYNONYM_TABLE.put("TEXT", "CLOB");
        SYNONYM_TABLE.put("MEDIUMTEXT", "CLOB");
        SYNONYM_TABLE.put("TINYTEXT", "CLOB");
        SYNONYM_TABLE.put("LONGTEXT", "CLOB");
        SYNONYM_TABLE.put("LONG", "CLOB");
        SYNONYM_TABLE.put("BLOB", "BLOB");
        SYNONYM_TABLE.put("TINYBLOB", "BLOB");
        SYNONYM_TABLE.put("MEDIUMBLOB", "BLOB");
        SYNONYM_TABLE.put("LONGBLOB", "BLOB");
        SYNONYM_TABLE.put("TINYINT", "SMALLINT");
        SYNONYM_TABLE.put("MEDIUMINT", "SMALLINT");
        SYNONYM_TABLE.put("DATETIME", "DATE");
        SYNONYM_TABLE.put("YEAR", "DATE");
        SYNONYM_TABLE.put("TIME", "DATE");
    }
}

