/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatabaseDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATABASE";
    private static final Logger LOGGER = new Logger(MOHDatabaseDB2.class);
    protected static final String DBADM = "DBADM";
    protected static final String DBCTRL = "DBCTRL";
    protected static final String DBMAINT = "DBMAINT";
    protected static final String CREATETAB = "CREATETAB";
    protected static final String CREATETS = "CREATETS";
    protected static final String DISPLAYDB = "DISPLAYDB";
    protected static final String DROP = "DROP";
    protected static final String IMAGCOMPY = "IMAGCOMPY";
    protected static final String LOAD = "LOAD";
    protected static final String RECOVERDB = "RECOVERDB";
    protected static final String REORG = "REORG";
    protected static final String REPAIR = "REPAIR";
    protected static final String STARTDB = "STARTDB";
    protected static final String STATS = "STATS";
    protected static final String STOPDB = "STOPDB";
    protected static final String Y = "Y";
    protected static final String G = "G";

    public MOHDatabaseDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT BPOOL, INDEXBP, TYPE, GROUP_MEMBER, STGROUP, ENCODING_SCHEME").append(' ');
                buffer.append("from SYSIBM.SYSDATABASE").append(' ');
                buffer.append("WHERE NAME = '").append(name).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatabaseDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        String bpName = rs.getString(1);
                        String indexBp = rs.getString(2);
                        String type = rs.getString(3);
                        String member = rs.getString(4);
                        String stoGroupName = rs.getString(5);
                        String ccsid = rs.getString(6);
                        DataBaseDB2 database = storage.getDataBaseSet().createDataBase();
                        database.setName(name);
                        this.stampModelObject(database, dbo);
                        BufferPoolDB2 bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(bpName);
                        if (bp != null) {
                            database.setBufferPool(bp);
                        }
                        if ((bp = (BufferPoolDB2)storage.getBufferPoolSet().getByName(indexBp)) != null) {
                            database.setIndexBufferPool(bp);
                        }
                        if (type.trim().equalsIgnoreCase("T")) {
                            database.setType("TEMP");
                        } else if (type.trim().equalsIgnoreCase("W")) {
                            database.setType("WORKFILE");
                        }
                        database.setMember(member);
                        if (!"".equalsIgnoreCase(stoGroupName.trim())) {
                            StorageGroupDB2 stoGroup = (StorageGroupDB2)storage.getStorageGroupSet().getByName(stoGroupName);
                            if (stoGroup == null) {
                                stoGroup = storage.getStorageGroupSet().createStorageGroup();
                                stoGroup.setName(stoGroupName);
                                this.stampModelObject((ModelObject)stoGroup, dbo.getSchema(), stoGroupName);
                            }
                            database.setStorageGroup(stoGroup);
                        }
                        if (ccsid.trim().equalsIgnoreCase("E")) {
                            database.setCcsid("EBCDIC");
                        } else if (ccsid.trim().equalsIgnoreCase("A")) {
                            database.setCcsid("ASCII");
                        } else if (ccsid.trim().equalsIgnoreCase("U")) {
                            database.setCcsid("UNICODE");
                        }
                        this.initPrivileges(sqlConnection, database, storage);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initPrivileges(Connection sqlConnection, DataBaseDB2 database, AbstractStorageDesignDB2 storage) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT GRANTOR, CREATETABAUTH, CREATETSAUTH, ");
            buffer.append("DBADMAUTH, DBCTRLAUTH, DBMAINTAUTH, DISPLAYDBAUTH, ");
            buffer.append("DROPAUTH, IMAGCOPYAUTH, LOADAUTH, REORGAUTH, ");
            buffer.append("RECOVERDBAUTH, REPAIRAUTH, STARTDBAUTH, STATSAUTH, STOPAUTH ");
            buffer.append("from SYSIBM.SYSDBAUTH ");
            buffer.append("WHERE NAME = '");
            buffer.append(database.getName()).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatabaseDB2.initPrivileges():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String user = rs.getString(1).trim();
                String createtab = rs.getString(2);
                String createts = rs.getString(3);
                String dbaadm = rs.getString(4);
                String dbctrl = rs.getString(5);
                String dbmaint = rs.getString(6);
                String displaydb = rs.getString(7);
                String drop = rs.getString(8);
                String imagcopy = rs.getString(9);
                String load = rs.getString(10);
                String reorg = rs.getString(11);
                String recoverdb = rs.getString(12);
                String repair = rs.getString(13);
                String startdb = rs.getString(14);
                String stats = rs.getString(15);
                String stopdb = rs.getString(16);
                StringBuffer buffer = new StringBuffer();
                boolean grant = false;
                boolean first = true;
                if (createtab.equalsIgnoreCase(Y)) {
                    buffer.append(CREATETAB);
                    first = false;
                } else if (createtab.equalsIgnoreCase(G)) {
                    buffer.append(CREATETAB);
                    first = false;
                    grant = true;
                }
                if (createts.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATETS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATETS);
                    }
                } else if (createts.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATETS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATETS);
                    }
                    grant = true;
                }
                if (dbaadm.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DBADM);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBADM);
                    }
                } else if (dbaadm.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DBADM);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBADM);
                    }
                    grant = true;
                }
                if (dbctrl.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DBCTRL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBCTRL);
                    }
                } else if (dbctrl.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DBCTRL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBCTRL);
                    }
                    grant = true;
                }
                if (dbmaint.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DBMAINT);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBMAINT);
                    }
                } else if (dbmaint.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DBMAINT);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DBMAINT);
                    }
                    grant = true;
                }
                if (displaydb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DISPLAYDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DISPLAYDB);
                    }
                } else if (displaydb.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DISPLAYDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DISPLAYDB);
                    }
                    grant = true;
                }
                if (drop.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DROP);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DROP);
                    }
                } else if (drop.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DROP);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DROP);
                    }
                    grant = true;
                }
                if (imagcopy.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(IMAGCOMPY);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(IMAGCOMPY);
                    }
                } else if (imagcopy.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(IMAGCOMPY);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(IMAGCOMPY);
                    }
                    grant = true;
                }
                if (load.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(LOAD);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(LOAD);
                    }
                } else if (load.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(LOAD);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(LOAD);
                    }
                    grant = true;
                }
                if (recoverdb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(RECOVERDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(RECOVERDB);
                    }
                } else if (recoverdb.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(RECOVERDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(RECOVERDB);
                    }
                    grant = true;
                }
                if (reorg.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(REORG);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REORG);
                    }
                } else if (reorg.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(REORG);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REORG);
                    }
                    grant = true;
                }
                if (repair.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(REPAIR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REPAIR);
                    }
                } else if (repair.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(REPAIR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(REPAIR);
                    }
                    grant = true;
                }
                if (startdb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STARTDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STARTDB);
                    }
                } else if (repair.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STARTDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STARTDB);
                    }
                    grant = true;
                }
                if (stats.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STATS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STATS);
                    }
                } else if (stats.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STATS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STATS);
                    }
                    grant = true;
                }
                if (stopdb.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STOPDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOPDB);
                    }
                } else if (stopdb.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STOPDB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOPDB);
                    }
                    grant = true;
                }
                PrivilegesDB2 priv = storage.getPrivilegesSet().createPriv();
                priv.setDb(database);
                Owner owner = (Owner)storage.getOwnerSet().getByName(user);
                if (owner == null) {
                    owner = (Owner)storage.getOwnerSet().createElement(user);
                    owner.setName(user);
                    this.stampModelObject((ModelObject)owner, "", user);
                }
                priv.setUser(owner);
                priv.setSystemPrivileges(buffer.toString());
                if (grant) {
                    priv.setGrantOption("YES");
                    continue;
                }
                priv.setGrantOption("NO");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSDATABASE").append(' ');
                buffer.append("WHERE CREATOR = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatabaseDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String dbname = rs.getString(1);
                    DBObject dboDb = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dbname, OBJECT_TYPE, dboNext.getName());
                    list.add(dboDb);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

