/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHStorageGroupDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "STORAGE GROUP";
    private static final Logger LOGGER = new Logger(MOHStorageGroupDB2.class);

    public MOHStorageGroupDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT VCATNAME").append(' ');
                buffer.append("from SYSIBM.SYSSTOGROUP").append(' ');
                buffer.append("WHERE NAME = '").append(name).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHStorageGroupDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        String vcatName = rs.getString(1);
                        VCatDB2 vcat = (VCatDB2)storage.getVCatSet().getByName(vcatName);
                        if (vcat == null) {
                            vcat = storage.getVCatSet().createVCat();
                            vcat.setName(vcatName);
                            this.stampModelObject((ModelObject)vcat, dbo.getSchema(), vcatName);
                        }
                        StorageGroupDB2 stoGroup = storage.getStorageGroupSet().createStorageGroup();
                        stoGroup.setName(name);
                        this.stampModelObject(stoGroup, dbo);
                        stoGroup.setVCat(vcat);
                        this.initVolumes(sqlConnection, stoGroup, storage);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initVolumes(Connection sqlConnection, StorageGroupDB2 stoGroup, AbstractStorageDesignDB2 storage) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT VOLID").append(' ');
            buffer.append("from SYSIBM.SYSVOLUMES").append(' ');
            buffer.append("WHERE SGNAME = '").append(stoGroup.getName()).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHStorageGroupDB2.initVolumes():", e);
        }
        if (rs != null) {
            int smsVolumes = 0;
            StringBuffer volumes = new StringBuffer();
            boolean firstVol = true;
            while (rs.next()) {
                String vol = rs.getString(1).trim();
                if ("*".equals(vol)) {
                    ++smsVolumes;
                    stoGroup.setSMSManaged(true);
                    continue;
                }
                if (firstVol) {
                    firstVol = false;
                } else {
                    volumes.append(", ");
                }
                volumes.append(vol);
                VolumesDB2 volume = (VolumesDB2)storage.getVolumesSet().getByName(vol);
                if (volume != null) continue;
                volume = storage.getVolumesSet().createVolumes();
                volume.setName(vol);
            }
            if (smsVolumes > 0) {
                stoGroup.setSMSManaged(true);
                stoGroup.setSMSVolumes(smsVolumes);
            }
            stoGroup.setVolumes(volumes.toString());
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSSTOGROUP").append(' ');
                buffer.append("WHERE CREATOR = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHStorageGroupDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, OBJECT_TYPE, dboNext.getName());
                    list.add(dbo);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

