/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHView;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHViewDB2
extends MOHView {
    private static final Logger LOGGER = new Logger(MOHViewDB2.class);

    public MOHViewDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSTABLES").append(' ');
                buffer.append("WHERE TYPE = 'V' and CREATOR = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, "VIEW", dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!"VIEW".equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT CHECK from SYSIBM.SYSVIEWS").append(' ');
                buffer.append("WHERE NAME = '").append(dbo.getName()).append("'");
                buffer.append(" AND CREATOR = '").append(ownerName).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewDB2.generate():", e);
                LOGGER.error("MOHViewDB2: name: " + name);
            }
            if (rs != null) {
                if (rs.next()) {
                    TableView view = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                    view.setName(name);
                    view.setSchema(ownerName);
                    this.stampModelObject(view, dbo);
                    view.setSyntaxProvider("DB2");
                    String check = rs.getString(1);
                    this.initViewBody(sqlConnection, view, ownerName);
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                        TableViewProxyDB2 proxy = (TableViewProxyDB2)storage.getTableViewProxySet().getProxy(view.getObjectID());
                        if ("N".equalsIgnoreCase(check)) {
                            proxy.setCheckOption(false);
                        } else {
                            proxy.setCheckOption(true);
                        }
                        Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                        if (owner == null) {
                            owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                            owner.setName(ownerName);
                            this.stampModelObject((ModelObject)owner, "", ownerName);
                        }
                        if (owner != null) {
                            proxy.setOwner(owner);
                        }
                        this.initSynonyms(sqlConnection, proxy);
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initViewBody(Connection sqlConnection, TableView view, String ownerName) throws Exception {
        int version = sqlConnection.getMetaData().getDatabaseMajorVersion();
        if (version < 10) {
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TEXT ");
                buffer.append("FROM SYSIBM.SYSVIEWS ");
                buffer.append("WHERE NAME = '");
                buffer.append(view.getName()).append("'");
                buffer.append(" AND CREATOR = '").append(ownerName).append("'");
                buffer.append(" ORDER BY SEQNO ");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewDB2.initViewBody():", e);
            }
            StringBuffer body = new StringBuffer();
            if (rs != null) {
                while (rs.next()) {
                    String text = rs.getString(1);
                    body.append(text);
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            view.setUserDefinedSQL(body.toString());
            view.setUserDefined(true);
            view.getColumns(body.toString().replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
        } else {
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT statement ");
                buffer.append("FROM SYSIBM.SYSVIEWS ");
                buffer.append("WHERE NAME = '");
                buffer.append(view.getName()).append("'");
                buffer.append(" AND CREATOR = '").append(ownerName).append("'");
                buffer.append(" ORDER BY SEQNO ");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHViewDB2.initViewBody():", e);
            }
            StringBuffer body = new StringBuffer();
            if (rs != null) {
                while (rs.next()) {
                    String text = rs.getString(1);
                    body.append(text);
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            view.setUserDefinedSQL(body.toString());
            view.setUserDefined(true);
            view.getColumns(body.toString().replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("   ", " ").replaceAll("  ", " "));
        }
    }

    private void initSynonyms(Connection sqlConnection, TableViewProxyDB2 view) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT NAME, CREATOR ");
            buffer.append("from SYSIBM.SYSSYNONYMS ");
            buffer.append("WHERE TBNAME = '");
            buffer.append(view.getName()).append("'");
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHViewDB2.initSynonyms():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String ownerName = rs.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                AbstractStorageDesignDB2 storage = null;
                if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                    storage = (AbstractStorageDesignDB2)storageDesign;
                }
                if (storage != null) {
                    SynonymDB2 synonym = storage.getSynonymSet().createSynonym();
                    synonym.setName(name);
                    synonym.setView(view);
                    this.stampModelObject((ModelObject)synonym, ownerName, name);
                    Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                    if (owner == null) continue;
                    synonym.setOwner(owner);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }
}

