/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.oracle.MOHClusterOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHCollectionTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDatafileOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDimensionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHDirectoryOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHFunctionOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHObjectColumnsOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPackageOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHProcedureOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSensitiveTypeOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSequenceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHSynonymOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTSDPPolicyOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTempTableSpaceOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHUserOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHViewOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHBitmapIndexesv10g;
import oracle.dbtools.crest.imports.metadata.oracle.v10g.MOHUndoTableSpaceOraclev10g;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHBitmapIndexesv9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHContextOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHExternalTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHRoleOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTableOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeOraclev9i;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHUndoTableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;

public class DBMExtractionHandlerOracle
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static DBMExtractionHandlerOracle dbmExtractionHandler;
    private List mohObjectsv9i = null;
    private List mohObjectsv10g = null;
    private boolean dbaUser = false;
    private ApplicationView view;

    private DBMExtractionHandlerOracle(ApplicationView view) {
        this.view = view;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView view) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerOracle(view);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    public void setDBAUser(Connection conn) {
        if (conn != null) {
            try {
                try {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                    buffer.append(' ').append("FROM").append(' ').append("dba_users");
                    PreparedStatement statment = conn.prepareStatement(buffer.toString());
                    ResultSet rs = statment.executeQuery();
                    buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("COUNT").append('(').append('*').append(')');
                    buffer.append(' ').append("FROM").append(' ').append("dba_all_tables");
                    statment = conn.prepareStatement(buffer.toString());
                    rs = statment.executeQuery();
                    this.dbaUser = true;
                    rs.close();
                    statment.close();
                }
                catch (SQLException se) {
                    this.dbaUser = false;
                }
            }
            catch (Exception ex) {
                this.dbaUser = false;
            }
        }
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        List list = super.getSchemas(conn);
        this.setDBAUser(conn);
        return list;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return this.getMOHObjectsv9i();
            }
        }
        return this.getMOHObjectsv10g();
    }

    private List getMOHObjectsv9i() {
        if (this.mohObjectsv9i == null) {
            this.mohObjectsv9i = new ArrayList();
            this.mohObjectsv9i.add(new MOHTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTempTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUndoTableSpaceOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDatafileOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHRoleOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHUserOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTypeIncompleteOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTypeOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHCollectionTypeOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDirectoryOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHExternalTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHContextOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHClusterOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHBitmapIndexesv9i(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHObjectColumnsOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHViewOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHProcedureOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHDimensionOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHSequenceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHSynonymOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHPackageOracle(this, this.view, this.dbaUser));
            this.mohObjectsv9i.add(new MOHFunctionOracle(this, this.view, this.dbaUser));
        }
        return this.mohObjectsv9i;
    }

    private List getMOHObjectsv10g() {
        if (this.mohObjectsv10g == null) {
            this.mohObjectsv10g = new ArrayList();
            this.mohObjectsv10g.add(new MOHTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTempTableSpaceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUndoTableSpaceOraclev10g(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDatafileOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHRoleOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHUserOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTypeIncompleteOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTypeOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHCollectionTypeOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDirectoryOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHExternalTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHContextOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHClusterOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTableOraclev9i(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHBitmapIndexesv10g(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHObjectColumnsOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHViewOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHProcedureOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHDimensionOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSequenceOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSynonymOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHPackageOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHFunctionOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHSensitiveTypeOracle(this, this.view, this.dbaUser));
            this.mohObjectsv10g.add(new MOHTSDPPolicyOracle(this, this.view, this.dbaUser));
        }
        return this.mohObjectsv10g;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        RDBMSSiteSet rdbmsSiteSet = this.view.getCurrentDesign().getRDBMSSiteSet();
        switch (this.dbMajorVersion) {
            case 8: 
            case 9: {
                return rdbmsSiteSet.get(StorageDesignOraclev9i.RDBMS_TYPE);
            }
            case 10: {
                return rdbmsSiteSet.get(StorageDesignOraclev10g.RDBMS_TYPE);
            }
            case 11: {
                return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
            }
            case 12: {
                return rdbmsSiteSet.get(StorageDesignOraclev12c.RDBMS_TYPE);
            }
        }
        return rdbmsSiteSet.get(StorageDesignOraclev11g.RDBMS_TYPE);
    }
}

