/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHObjectColumnsOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OBJECT_COLUMN";
    private static final Logger LOGGER = new Logger(MOHObjectColumnsOracle.class);
    protected boolean dbaUser;

    public MOHObjectColumnsOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHObjectColumnsOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Object Columns begin");
        ArrayList<String> tableNameList = new ArrayList<String>();
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        TableProxyOracle t = null;
        int count = 0;
        while (it.hasNext()) {
            t = (TableProxyOracle)it.next();
            tableNameList.add(t.getName());
            if (count == 990) {
                this.initSubstitutable(sqlConnection, tableNameList);
                this.initCollectionSubstitutable(sqlConnection, tableNameList);
                this.initScope(sqlConnection, tableNameList);
                tableNameList.clear();
                count = -1;
            }
            ++count;
        }
        if (count > 0) {
            this.initSubstitutable(sqlConnection, tableNameList);
            this.initCollectionSubstitutable(sqlConnection, tableNameList);
            this.initScope(sqlConnection, tableNameList);
            tableNameList.clear();
        }
        TimeLog.log("Object Columns end");
    }

    private void initCollectionSubstitutable(Connection sqlConnection, List tableNameList) throws Exception {
        int tableNameCount = tableNameList.size();
        Statement statement = null;
        ResultSet rs = null;
        try {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
            buffer.append("PARENT_TABLE_NAME").append(',').append(' ');
            buffer.append("PARENT_TABLE_COLUMN").append(',').append(' ');
            buffer.append("ELEMENT_SUBSTITUTABLE").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "DBA_NESTED_TABLES" : "ALL_NESTED_TABLES").append(' ');
            buffer.append("WHERE").append(' ').append("PARENT_TABLE_NAME").append(' ').append("IN").append(' ');
            buffer.append('(').append('?');
            for (i = 1; i < tableNameCount; ++i) {
                buffer.append(',').append('?');
            }
            buffer.append(')');
            statement = sqlConnection.prepareStatement(buffer.toString());
            for (i = 0; i < tableNameCount; ++i) {
                statement.setString(i + 1, (String)tableNameList.get(i));
            }
            rs = statement.executeQuery();
        }
        catch (Exception e) {
            System.out.println("MOHObjectColumnsOracle.initCollectionSubstitutable(): " + e.getMessage());
            LOGGER.error("MOHObjectColumnsOracle.initCollectionSubstitutable():", e);
        }
        if (rs != null) {
            TableSet tableSet = this.getDesign().getRelationalDesign().getTableSet();
            while (rs.next()) {
                Column col;
                Table table;
                String ownerName = rs.getString(1);
                String tableName = rs.getString(2);
                String colName = rs.getString(3);
                String substitutable = rs.getString(4).trim();
                if (!"N".equalsIgnoreCase(substitutable) || (table = tableSet.getBySchemaAndName(ownerName, tableName)) == null || (col = (Column)table.getElementByName(colName)) == null) continue;
                col.setAllowSubtypeSubstitution(false);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initSubstitutable(Connection sqlConnection, List tableNameList) throws Exception {
        int tableNameCount = tableNameList.size();
        Statement statement = null;
        ResultSet rs = null;
        try {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
            buffer.append("TABLE_NAME").append(',').append(' ');
            buffer.append("COLUMN_NAME").append(',').append(' ');
            buffer.append("SUBSTITUTABLE").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "DBA_OBJ_COLATTRS" : "ALL_OBJ_COLATTRS").append(' ');
            buffer.append("WHERE").append(' ').append("TABLE_NAME").append(' ').append("IN").append(' ');
            buffer.append('(').append('?');
            for (i = 1; i < tableNameCount; ++i) {
                buffer.append(',').append('?');
            }
            buffer.append(')');
            statement = sqlConnection.prepareStatement(buffer.toString());
            for (i = 0; i < tableNameCount; ++i) {
                statement.setString(i + 1, (String)tableNameList.get(i));
            }
            rs = statement.executeQuery();
        }
        catch (Exception e) {
            System.out.println("MOHObjectColumnsOracle.initSubstitutable(): " + e.getMessage());
            LOGGER.error("MOHObjectColumnsOracle.initSubstitutable():", e);
        }
        if (rs != null) {
            TableSet tableSet = this.getDesign().getRelationalDesign().getTableSet();
            while (rs.next()) {
                Column col;
                Table table;
                String ownerName = rs.getString(1);
                String tableName = rs.getString(2);
                String colName = rs.getString(3);
                String substitutable = rs.getString(4).trim();
                if (!"N".equalsIgnoreCase(substitutable) || (table = tableSet.getBySchemaAndName(ownerName, tableName)) == null || colName.equalsIgnoreCase("SYS_NC_ROWINFO$") || (col = (Column)table.getElementByName(colName)) == null) continue;
                col.setAllowSubtypeSubstitution(false);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initScope(Connection sqlConnection, List tableNameList) throws Exception {
        int tableNameCount = tableNameList.size();
        Statement statement = null;
        ResultSet rs = null;
        try {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
            buffer.append("TABLE_NAME").append(',').append(' ');
            buffer.append("COLUMN_NAME").append(',').append(' ');
            buffer.append("WITH_ROWID").append(',').append(' ');
            buffer.append("SCOPE_TABLE_OWNER").append(',').append(' ');
            buffer.append("SCOPE_TABLE_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_refs" : "all_refs").append(' ');
            buffer.append("WHERE").append(' ').append("TABLE_NAME").append(' ').append("IN").append(' ');
            buffer.append('(').append('?');
            for (i = 1; i < tableNameCount; ++i) {
                buffer.append(',').append('?');
            }
            buffer.append(')');
            statement = sqlConnection.prepareStatement(buffer.toString());
            for (i = 0; i < tableNameCount; ++i) {
                statement.setString(i + 1, (String)tableNameList.get(i));
            }
            rs = statement.executeQuery();
        }
        catch (Exception e) {
            System.out.println("MOHObjectColumnsOracle.initScope(): " + e.getMessage());
            LOGGER.error("MOHObjectColumnsOracle.initScope():", e);
        }
        if (rs != null) {
            TableSet tableSet = this.getDesign().getRelationalDesign().getTableSet();
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            while (rs.next()) {
                ColumnProxyOracle colProxy;
                Column col;
                Table table;
                String ownerName = rs.getString(1);
                String tableName = rs.getString(2);
                String colName = rs.getString(3);
                String rowid = rs.getString(4);
                String scopeTableOwner = rs.getString(5);
                String scopeTableName = rs.getString(6);
                Table scopeTable = scopeTableName == null ? null : tableSet.getBySchemaAndName(scopeTableOwner, scopeTableName);
                if (scopeTable == null && !rowid.equals("YES") || (table = tableSet.getBySchemaAndName(ownerName, tableName)) == null || (col = (Column)table.getElementByName(colName)) == null) continue;
                if (scopeTable != null) {
                    col.setScopeId(scopeTable.getObjectID());
                }
                if (!rowid.equals("YES") || (colProxy = (ColumnProxyOracle)storage.getColumnProxySet().getProxy(col.getObjectID())) == null) continue;
                colProxy.setWithRowId("YES");
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }
}

