/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPlSqlStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPackageBodyOracle
extends MOHPlSqlStorageObjectOracle<PackageBodyOracle> {
    static final String OBJECT_TYPE = "PACKAGE BODY";
    private static final Logger LOGGER = new Logger(MOHPackageBodyOracle.class);
    private PackageOracle parent;

    MOHPackageBodyOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    MOHPackageBodyOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view, dbaUser);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public PackageBodyOracle generateObject(StorageDesignOracle storageDesignOracle, DBObject dbObject, String source) {
        return new PackageBodyOracle(this.parent, "CREATE OR REPLACE " + source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PackageBodyOracle generate(PackageOracle parent, Connection sqlConnection, DBObject dbObject, ImportLogger importLog) throws Exception {
        this.parent = parent;
        PackageBodyOracle result = null;
        PreparedStatement statement = this.prepareStatement(sqlConnection);
        try {
            result = (PackageBodyOracle)this.generate(statement, dbObject, importLog);
            if (result != null) {
                this.stampModelObject(result, dbObject);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    @Override
    protected boolean canBeGenerated(DBObject dbObject) {
        return "PACKAGE".equalsIgnoreCase(dbObject.getType());
    }

    @Override
    protected void incrementImported(DBObject dbObject, ImportLogger importLog) {
    }
}

