/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class MOHPlSqlStorageObjectOracle<T>
extends AbstractMOHandler {
    protected boolean dbaUser;
    public static String WRAPPED = "WRAPPED";
    public static String SPACE_WRAPPED = " WRAPPED";

    public MOHPlSqlStorageObjectOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHPlSqlStorageObjectOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    public abstract Logger getLogger();

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract " + this.getType() + " begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("DISTINCT").append(' ');
                buffer.append("NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_source" : "all_source").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TYPE").append('=').append(' ').append('?').append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                statement.setString(2, this.getType());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                this.getLogger().error("extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String name = rs.getString("NAME");
                DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, this.getType(), dboNext.getName());
                list.add(dbo);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract " + this.getType() + " end");
        return list;
    }

    public boolean removeName() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        PreparedStatement statement = this.prepareStatement(sqlConnection);
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                this.generate(statement, (DBObject)selectedObjects.get(i), importLog);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection sqlConnection) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TEXT").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_source" : "all_source").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TYPE").append('=').append('\'');
        buffer.append(this.getType()).append('\'').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("line");
        String sql = buffer.toString();
        return sqlConnection.prepareStatement(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T generate(PreparedStatement statement, DBObject dbObject, ImportLogger importLog) throws Exception {
        T result = null;
        if (this.canBeGenerated(dbObject)) {
            ResultSet rs = null;
            try {
                statement.setString(1, dbObject.getSchema());
                statement.setString(2, dbObject.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                this.getLogger().error("generate():", e);
            }
            if (rs != null) {
                boolean wrapped = false;
                StringBuilder sourceStringBuilder = new StringBuilder();
                try {
                    int count = 0;
                    while (rs.next() && !wrapped) {
                        String text = rs.getString("TEXT");
                        if (count == 0 && text.toUpperCase().indexOf(WRAPPED) > -1) {
                            wrapped = true;
                        }
                        ++count;
                        sourceStringBuilder.append(text);
                    }
                }
                finally {
                    rs.close();
                }
                String source = sourceStringBuilder.toString();
                if (wrapped) {
                    source = dbObject.getName() + SPACE_WRAPPED;
                } else {
                    if (this.removeName() && source.toUpperCase().startsWith(this.getType())) {
                        source = source.substring(this.getType().length());
                        int nameLength = dbObject.getName().length();
                        if (source.length() >= nameLength) {
                            source = source.substring(nameLength);
                        }
                    }
                    source = source.trim();
                }
                if (source.length() > 0) {
                    StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
                    if (storageDesign != null) {
                        result = this.generateObject(storageDesign, dbObject, source);
                    } else {
                        this.getLogger().error("Unable to find Storage Design!");
                    }
                }
            }
            this.incrementImported(dbObject, importLog);
        }
        return result;
    }

    protected boolean canBeGenerated(DBObject dbObject) {
        return this.getType().equalsIgnoreCase(dbObject.getType());
    }

    protected void incrementImported(DBObject dbObject, ImportLogger importLog) {
        importLog.incrementImportedStatements();
        this.addToHandledObjects(dbObject);
    }

    public abstract T generateObject(StorageDesignOracle var1, DBObject var2, String var3);
}

