/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMExtractionController;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.LobStorageOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public abstract class MOHTableOracle
extends MOHTable {
    private boolean isPartitioned;
    private boolean containsClusterRefs;
    private boolean containsXMLTypeTables;
    private boolean maskTemplatesAdded = false;
    private static final Logger LOGGER;
    private final String NOT_NULL_PATTERN = " IS NOT NULL";
    private final Map ukMap = new TreeMap();
    private final List fkTempList = new ArrayList();
    private PreparedStatement reg_mview_statement = null;
    public static final String NEW_AS = "NEW AS";
    public static final String OLD_AS = "OLD AS";
    public static final String PARENT_AS = "PARENT AS";
    public final String DESC = "DESC";
    protected static String SYSTEM_NAME_PREFIX;
    protected boolean dbaUser;
    private PreparedStatement indexp_st = null;
    private PreparedStatement indspat_st = null;
    private PreparedStatement indpartype_st = null;
    private PreparedStatement indglobpartcols_st = null;
    private PreparedStatement indpart_st = null;
    PreparedStatement part_statement = null;
    PreparedStatement partLS_statement = null;
    PreparedStatement subpartCol_statement = null;
    PreparedStatement subpartTemplate_statement = null;
    PreparedStatement subPart_statement = null;
    PreparedStatement subPartLS_statement = null;
    PreparedStatement subPartListLS_statement = null;
    String CWD_TS_TAB_META = "<cwd_ts_tab ";
    String CWD_TS_COLUMN_META = "<cwd_ts_column ";

    public MOHTableOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHTableOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Tables begin");
        this.maskTemplatesAdded = false;
        this.containsClusterRefs = false;
        this.containsXMLTypeTables = false;
        this.ukMap.clear();
        this.fkTempList.clear();
        StorageDesign storageDesign = this.getStorageDesign();
        ArrayList<DBObject> dbos = new ArrayList<DBObject>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("a.").append("OWNER").append(',');
        buffer.append("a.").append("TABLE_NAME").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("CLUSTER_NAME").append(',');
        buffer.append("IOT_NAME").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("PCT_USED").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("DEGREE").append(',');
        buffer.append("INSTANCES").append(',');
        buffer.append("CACHE").append(',');
        buffer.append("TABLE_LOCK").append(',');
        buffer.append("PARTITIONED").append(',');
        buffer.append("IOT_TYPE").append(',');
        buffer.append("OBJECT_ID_TYPE").append(',');
        buffer.append("TABLE_TYPE_OWNER").append(',');
        buffer.append("a.").append("TABLE_TYPE").append(',');
        buffer.append("TEMPORARY").append(',');
        buffer.append("DURATION").append(',');
        buffer.append("SECONDARY").append(',');
        buffer.append("NESTED").append(',');
        buffer.append("BUFFER_POOL").append(',');
        buffer.append("ROW_MOVEMENT").append(',');
        if (storageDesign instanceof StorageDesignOraclev9i) {
            buffer.append("MONITORING").append(',');
        } else {
            buffer.append("DEPENDENCIES").append(',');
            buffer.append("COMPRESSION").append(',');
            if (storageDesign instanceof StorageDesignOraclev11g) {
                buffer.append("COMPRESS_FOR").append(',');
            }
        }
        buffer.append("COMMENTS").append(',');
        buffer.append("QUERY").append(',');
        buffer.append("UPDATABLE").append(',');
        buffer.append("MASTER_ROLLBACK_SEG").append(',');
        buffer.append("REWRITE_ENABLED").append(',');
        buffer.append("REFRESH_MODE").append(',');
        buffer.append("REFRESH_METHOD").append(',');
        buffer.append("BUILD_MODE").append(',');
        buffer.append("USE_NO_INDEX").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ').append("a").append(',');
        buffer.append(this.dbaUser ? "dba_mviews" : "all_mviews").append(' ').append("b").append(',');
        buffer.append(this.dbaUser ? "dba_tab_comments" : "all_tab_comments").append(' ').append("c").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("OWNER").append('=');
        buffer.append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=');
        buffer.append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=').append("b.").append("MVIEW_NAME").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=').append("c.").append("OWNER").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=').append("c.").append("TABLE_NAME").append(' ').append("(+)").append(' ');
        buffer.append("ORDER BY").append(' ').append("OWNER").append(',');
        buffer.append("TABLE_NAME");
        String stat = buffer.toString();
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String ownerName = dbo.getSchema();
            String tableName = dbo.getName();
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            this.isPartitioned = false;
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(stat);
                }
                statement.setString(1, ownerName);
                statement.setString(2, tableName);
                rs = statement.executeQuery();
                Table table = null;
                TableProxyOracle tableProxy = null;
                if (rs == null) continue;
                while (rs.next()) {
                    String comments;
                    table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(dbo.getSchema());
                    if (!dbo.getSchema().equals(dbo.getSchema().toUpperCase()) && table.getSchemaObject() != null) {
                        table.getSchemaObject().setNameHasQuotes(true);
                    }
                    table.setName(dbo.getName());
                    if (!dbo.getName().equals(dbo.getName().toUpperCase())) {
                        table.setNameHasQuotes(true);
                    }
                    if ((comments = rs.getString("COMMENTS")) != null) {
                        table.setCommentInRDBMS(comments);
                    }
                    dbo.setTable(table);
                    dbos.add(dbo);
                    this.stampModelObject(table, dbo);
                    this.initObjectType(table, rs.getString("TABLE_TYPE_OWNER"), rs.getString("TABLE_TYPE"), rs.getString("OBJECT_ID_TYPE"), dbo);
                    if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
                        tableProxy = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                        dbo.setTableProxy(tableProxy);
                        if (tableProxy != null) {
                            tableProxy.setName(dbo.getName());
                            if (table.getSchemaObject() == null) {
                                this.setUser(tableProxy, (StorageDesignOracle)storageDesign, dbo.getSchema());
                            }
                            this.setCluster(tableProxy, (StorageDesignOracle)storageDesign, rs);
                            this.setProperties(tableProxy, (StorageDesignOracle)storageDesign, rs);
                            this.setTableSpace(tableProxy, (StorageDesignOracle)storageDesign, rs.getString("TABLESPACE_NAME"));
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    if (this.isPartitioned && tableProxy != null) {
                        dbo.partitioned = true;
                    }
                    this.initSnapshot(sqlConnection, rs, tableProxy, dbo);
                    importLog.incrementImportedStatements();
                    this.addToHandledObjects(dbo);
                }
                rs.close();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.generate():", e);
            }
        }
        if (this.reg_mview_statement != null) {
            this.reg_mview_statement.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("End Tables");
        if (dbos.size() == 0) {
            return;
        }
        if (this.containsXMLTypeTables) {
            this.initXMLTypeTables(sqlConnection, dbos);
            TimeLog.log("End XMLType Tables");
        }
        this.initColumns(sqlConnection, dbos);
        TimeLog.log("End Columns");
        if (this.containsClusterRefs) {
            this.initClusterColumns(sqlConnection, dbos);
            TimeLog.log("End Cluster Columns");
        }
        if (this.getDbmeHandler().isSpatialProperties()) {
            this.initSpatialTable(sqlConnection, dbos);
            TimeLog.log("End Spatial");
        }
        this.initIndexes(sqlConnection, dbos);
        TimeLog.log("End Indexes");
        this.initUK_PK_FK_CHECK_Constraints(sqlConnection, dbos, this.ukMap, this.fkTempList);
        TimeLog.log("End Constraints");
        if (this.getDbmeHandler().isTriggers()) {
            this.initTableTriggers(sqlConnection, dbos);
            TimeLog.log("End Triggers");
        }
        this.createFKeys(sqlConnection, this.fkTempList, this.ukMap);
        this.fkTempList.clear();
        this.ukMap.clear();
        TimeLog.log("End FKeys");
        if (this.getDbmeHandler().isPartitions()) {
            this.setPartitionInfo(sqlConnection, (StorageDesignOracle)storageDesign, dbos);
            this.setIndexPartitioning(sqlConnection, (StorageDesignOracle)storageDesign, dbos);
            TimeLog.log("End Partitions");
        }
        this.setTableLobStorage((StorageDesignOracle)storageDesign, sqlConnection, dbos);
        if (this.getDbmeHandler().isPartitions()) {
            this.setTablePartLobStorage((StorageDesignOracle)storageDesign, sqlConnection, dbos);
        }
        TimeLog.log("End Lob Storage");
        if (this.dbaUser) {
            this.addRedactionPolicies(sqlConnection, dbos);
        }
        if (this.maskTemplatesAdded) {
            this.getDesign().getAppView().saveMaskTemplates();
        }
        TimeLog.log("End Redaction Policies");
        TimeLog.log("Tables end");
    }

    private void initSnapshot(Connection sqlConnection, ResultSet rs, TableProxyOracle tableProxy, DBObject dbo) throws SQLException {
        String query = rs.getString("QUERY");
        if (query != null) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
            SnapshotOracle sn = storageDesign.getSnapshotSet().createSnapshot();
            sn.setUser(tableProxy.getUser());
            sn.setName(tableProxy.getName());
            sn.setNameHasQuotes(tableProxy.getNameHasQuotes());
            tableProxy.setSnapshot(sn);
            this.stampModelObject((ModelObject)sn, dbo.getSchema(), tableProxy.getName());
            ((Table)tableProxy.getObject()).setTypeID("4");
            String updatable = rs.getString("UPDATABLE");
            String rollback_seg = rs.getString("MASTER_ROLLBACK_SEG");
            String rewrite = rs.getString("REWRITE_ENABLED");
            String refresh_mode = rs.getString("REFRESH_MODE");
            String refresh_method = rs.getString("REFRESH_METHOD");
            String build_mode = rs.getString("BUILD_MODE");
            String no_index = rs.getString("USE_NO_INDEX");
            sn.setSubquery(query);
            Table table = (Table)tableProxy.getObject();
            if (table != null && table.getPK() == null) {
                KeyObject[] keys = table.getKeys();
                KeyObject key = null;
                for (int k = 0; k < keys.length; ++k) {
                    Index ind = (Index)keys[k];
                    if ("".equals(ind.getIndexExpression()) || !"M_ROW$$".equalsIgnoreCase(ind.getIndexExpression().trim())) continue;
                    key = keys[k];
                    break;
                }
                if (key != null) {
                    sn.setWith("ROWID");
                    key.remove();
                }
            }
            if ("N".equals(updatable)) {
                sn.setForUpdate("NO");
            } else {
                sn.setForUpdate("YES");
            }
            if (rollback_seg != null && "".equals(rollback_seg)) {
                RollbackSegmentOracle rb = (RollbackSegmentOracle)storageDesign.getRollbackSegmentSet().getByName(rollback_seg);
                if (rb == null) {
                    rb = storageDesign.getRollbackSegmentSet().createRollbackSegment();
                    rb.setName(rollback_seg);
                    this.stampModelObject((ModelObject)rb, dbo.getSchema(), rollback_seg);
                }
                if (rb != null) {
                    sn.setRollbackSegment(rb);
                }
            }
            if ("N".equalsIgnoreCase(rewrite)) {
                sn.setQueryRewrite("DISABLE");
            } else {
                sn.setQueryRewrite("ENABLE");
            }
            if ("N".equals(no_index)) {
                sn.setUseIndex("YES");
            } else {
                sn.setUseIndex("NO");
            }
            if ("NEVER".equalsIgnoreCase(refresh_mode)) {
                sn.setRefresh("NEVER");
            } else {
                sn.setRefresh("YES");
                sn.setRefreshType(refresh_method);
                sn.setAction("ON " + refresh_mode);
            }
            if (build_mode.equalsIgnoreCase("PREBUILT")) {
                tableProxy.setSnapshot(null);
                sn.setOnPrebuildTable(tableProxy);
            } else {
                sn.setBuild(build_mode);
                sn.setTablespace(tableProxy.getTableSpace());
                sn.setParalelClause(tableProxy.getParallel());
                try {
                    sn.setDegree(Integer.parseInt(tableProxy.getDegree()));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (sn.getOnPrebuildTable() == null) {
                if (this.reg_mview_statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("REFRESH_METHOD").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_registered_mviews" : "all_registered_mviews").append(' ');
                    buffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                    buffer.append("AND").append(' ').append("NAME").append(' ').append('=').append(' ').append('?');
                    this.reg_mview_statement = sqlConnection.prepareStatement(buffer.toString());
                }
                this.addRefreshMethod(this.reg_mview_statement, dbo.getSchema(), sn);
            }
        }
    }

    private void addRefreshMethod(PreparedStatement reg_mview_statement, String owner, SnapshotOracle snapshot) throws SQLException {
        ResultSet rs = null;
        try {
            reg_mview_statement.setString(1, owner);
            reg_mview_statement.setString(2, snapshot.getName());
            rs = reg_mview_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.addRefreshMethod():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String refreshMethod = rs.getString("REFRESH_METHOD");
                if (refreshMethod == null) continue;
                if (refreshMethod.equalsIgnoreCase("PRIMARY KEY")) {
                    snapshot.setWith("PRIMARY KEY");
                    continue;
                }
                if (!refreshMethod.equalsIgnoreCase("ROWID")) continue;
                snapshot.setWith("ROWID");
            }
            rs.close();
        }
    }

    private void initSpatialTable(Connection sqlConnection, List dbos) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
        buffer.append("TABLE_NAME").append(',').append(' ');
        buffer.append("COLUMN_NAME").append(',').append(' ');
        buffer.append("DIMINFO").append(',').append(' ');
        buffer.append("SRID").append(' ');
        buffer.append("FROM").append(' ').append("all_sdo_geom_metadata").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        String sql = buffer.toString();
        Statement statement = null;
        for (DBObject dbo : dbos) {
            Table table = dbo.getTable();
            String ownerName = dbo.getSchema();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, ownerName);
                statement.setString(2, table.getName());
                rs = statement.executeQuery();
                if (rs == null) continue;
                while (rs.next()) {
                    Column column;
                    String table_name = rs.getString("TABLE_NAME");
                    String column_name = rs.getString("COLUMN_NAME");
                    if (table_name.equals("")) continue;
                    table.setSpatialTable(true);
                    SpatialColumnDefObject spaObject = new SpatialColumnDefObject(table);
                    table.addSpatialDefinition(spaObject);
                    ARRAY diminfo = (ARRAY)rs.getObject("DIMINFO");
                    Datum[] datum = diminfo.getOracleArray();
                    for (int i = 0; i < datum.length; ++i) {
                        STRUCT str = (STRUCT)datum[i];
                        Object[] elems = str.getAttributes();
                        SpatialColumnDefObject.TableDimension dimension = new SpatialColumnDefObject.TableDimension(spaObject);
                        dimension.setName(elems[0].toString());
                        dimension.setLowBoundary(elems[1].toString());
                        dimension.setUpperBoundary(elems[2].toString());
                        dimension.setTolerance(elems[3].toString());
                    }
                    String srid = rs.getString("SRID");
                    if (srid != null) {
                        spaObject.setSystemID(srid);
                    }
                    if ((column = (Column)table.getElementByName(column_name)) != null) {
                        spaObject.setSpatialColumn(column);
                        continue;
                    }
                    spaObject.setFunction(true);
                    spaObject.setFuncExpression(column_name);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.initSpatialTable():", e);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initObjectType(Table table, String typeOwner, String typeName, String objectIDType, DBObject dbo) {
        StructuredTypeProxyOracle stp;
        if (typeName != null && (stp = ((StructuredTypeProxySetOracle)this.getStorageDesign().getStructuredTypeProxySet()).getByLongName(typeName, typeOwner)) != null && stp.getStructuredType() != null) {
            table.setBasedOnStructuredType(stp.getStructuredType());
            table.setOidIsPK("USER-DEFINED".equals(objectIDType));
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.containsXMLTypeTables = true;
            }
        }
    }

    protected void initXMLTypeTables(Connection sqlConnection, List dbos) throws Exception {
        boolean oraclev11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("XMLSCHEMA").append(',');
        buffer.append("ELEMENT_NAME").append(',');
        buffer.append("STORAGE_TYPE");
        if (oraclev11g) {
            buffer.append(',');
            buffer.append("ANYSCHEMA").append(',');
            buffer.append("NONSCHEMA");
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_xml_tables" : "all_xml_tables").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        String sql = buffer.toString();
        Statement statement = null;
        for (DBObject dbo : dbos) {
            TableProxyOracle tableProxy;
            Table table = dbo.getTable();
            StructuredType basedOnType = table.getBasedOnStructuredType();
            if (basedOnType == null || !basedOnType.getName().equalsIgnoreCase("XMLTYPE") || (tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID())) == null) continue;
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, table.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOraclev9i.initXMLTypeTables():", e);
            }
            if (rs == null) continue;
            if (rs.next()) {
                String xmlSchema = rs.getString("XMLSCHEMA");
                String xmlElementName = rs.getString("ELEMENT_NAME");
                String xmlStorageType = rs.getString("STORAGE_TYPE");
                String anySchema = null;
                String nonSchema = null;
                if (oraclev11g) {
                    anySchema = rs.getString("ANYSCHEMA");
                    nonSchema = rs.getString("NONSCHEMA");
                }
                if (xmlSchema != null) {
                    tableProxy.setXmlSchemaUrl(xmlSchema);
                }
                if (xmlElementName != null) {
                    tableProxy.setXmlSchemaElement(xmlElementName);
                }
                if (xmlStorageType != null) {
                    if (xmlStorageType.equals("BINARY")) {
                        xmlStorageType = "BINARY XML";
                    } else if (xmlStorageType.equals("OBJECT-RELATIONAL")) {
                        xmlStorageType = "OBJECT RELATIONAL";
                    }
                    tableProxy.setStoreAs(xmlStorageType);
                }
                if (anySchema != null) {
                    ((TableProxyOraclev11g)tableProxy).setAllowAnySchema(anySchema);
                }
                if (nonSchema != null) {
                    ((TableProxyOraclev11g)tableProxy).setAllowNonSchema(nonSchema);
                }
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void initUK_PK_FK_CHECK_Constraints(Connection sqlConnection, List dbos, Map ukMap, List fkTempList) throws Exception {
        StringBuffer buffer = new StringBuffer();
        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("POSITION").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME").append(',').append("POSITION").append(',').append("COLUMN_NAME");
        String ncol_sql = buffer.toString();
        Statement ncol_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CONSTRAINT_NAME").append(',').append(' ');
        buffer.append("CONSTRAINT_TYPE").append(',').append(' ');
        buffer.append("DEFERRED").append(',').append(' ');
        buffer.append("STATUS").append(',').append(' ');
        buffer.append("DEFERRABLE").append(',').append(' ');
        buffer.append("VALIDATED").append(',').append(' ');
        buffer.append("SEARCH_CONDITION").append(',').append(' ');
        buffer.append("R_OWNER").append(',').append(' ');
        buffer.append("R_CONSTRAINT_NAME").append(',').append(' ');
        buffer.append("DELETE_RULE").append(',').append(' ');
        buffer.append("INDEX_NAME").append(',').append(' ');
        buffer.append("GENERATED").append(',').append(' ');
        buffer.append("RELY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append("IN").append(' ');
        buffer.append('(').append("'P','U','C','R'").append(')').append(' ');
        buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
        String sql = buffer.toString();
        Statement statement = null;
        Iterator it = dbos.iterator();
        boolean first = true;
        TreeMap<String, ArrayList<String>> map = new TreeMap<String, ArrayList<String>>();
        while (it.hasNext()) {
            DBObject dbo = (DBObject)it.next();
            Table table = dbo.getTable();
            TableProxyOracle tableProxy = (TableProxyOracle)storage.getTableProxySet().getObjectByID(table.getObjectID());
            int uk_count = 0;
            String ownerName = dbo.getSchema();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                first = true;
                if (rs == null) continue;
                while (rs.next()) {
                    String constrName = rs.getString(1);
                    String constrType = rs.getString(2);
                    String deferred = rs.getString(3);
                    String status = rs.getString(4);
                    String deferrable = rs.getString(5);
                    String validated = rs.getString(6);
                    String condition = rs.getString(7);
                    String rely = rs.getString(13);
                    if (first) {
                        ResultSet nrs = null;
                        first = false;
                        map.clear();
                        if (ncol_st == null) {
                            ncol_st = sqlConnection.prepareStatement(ncol_sql);
                        }
                        try {
                            ncol_st.setString(1, dbo.getSchema());
                            ncol_st.setString(2, dbo.getName());
                            nrs = ncol_st.executeQuery();
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", e);
                        }
                        if (nrs != null) {
                            while (nrs.next()) {
                                String cName = nrs.getString(1);
                                String colName = Token.removeQuotes(nrs.getString(2));
                                ArrayList<String> list = (ArrayList<String>)map.get(cName);
                                if (list == null) {
                                    list = new ArrayList<String>();
                                    map.put(cName, list);
                                }
                                list.add(colName);
                            }
                        }
                    }
                    if ("R".equalsIgnoreCase(constrType)) {
                        FKTemp fktemp = new FKTemp();
                        fkTempList.add(fktemp);
                        fktemp.name = constrName;
                        fktemp.UK_Owner = rs.getString(8);
                        fktemp.UK_Name = rs.getString(9);
                        fktemp.delete_rule = rs.getString(10);
                        fktemp.table = dbo.getTable();
                        this.initFK_Columns(map, constrName, fktemp.columns);
                        fktemp.deferred = deferred;
                        fktemp.status = status;
                        fktemp.deferrable = deferrable;
                        fktemp.validated = validated;
                        fktemp.rely = rely;
                        continue;
                    }
                    if ("C".equalsIgnoreCase(constrType)) {
                        this.processCheckConstr(map, dbo, constrName, deferred, status, deferrable, validated, condition);
                        continue;
                    }
                    String ind_name = rs.getString(11);
                    String generated = rs.getString(12);
                    Index index = null;
                    Index supportInd = null;
                    if (ind_name != null) {
                        supportInd = table.getIndexByName(ind_name);
                        if (!generated.equalsIgnoreCase("USER NAME")) {
                            if (constrName.equals(ind_name)) {
                                index = table.getIndexByName(ind_name);
                            }
                        } else if (!constrName.equals(ind_name) || "INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "P".equalsIgnoreCase(constrType)) {
                            index = table.getIndexByName(constrName);
                        }
                        if ("INDEX".equalsIgnoreCase(tableProxy.getOrganization()) && "P".equalsIgnoreCase(constrType)) {
                            if (index == null) {
                                index = supportInd;
                            }
                            supportInd = null;
                        }
                    }
                    boolean newIndexCreated = false;
                    if ("P".equalsIgnoreCase(constrType) && table.isBST()) {
                        if (index != null) {
                            Index existingPK = (Index)table.getPK();
                            if (existingPK != null) {
                                existingPK.getElementsCollection().clear();
                                if (index != existingPK) {
                                    index.remove();
                                    index = existingPK;
                                }
                            }
                            if (generated.equalsIgnoreCase("USER NAME")) {
                                index.setName(constrName);
                            } else {
                                index.setName(ind_name);
                            }
                        } else {
                            Index pk = (Index)table.getPK();
                            if (pk == null) {
                                pk = table.createIndex();
                            }
                            String pkName = generated.equalsIgnoreCase("USER NAME") ? constrName : ind_name;
                            pk.setName(pkName);
                            if (!pkName.equals(pkName.toUpperCase())) {
                                pk.setNameHasQuotes(true);
                            }
                            this.stampModelObject((ModelObject)pk, table.getSchema(), pk.getName());
                            this.initPK_UK_Columns(pk, map, constrName);
                            if ("".equals(pk.getIndexExpression())) {
                                Column col = (Column)table.getOidElement();
                                if (col != null) {
                                    pk.remove(col);
                                }
                                ArrayList<String> colNames = new ArrayList<String>();
                                for (Column column : pk.getElementsCollection()) {
                                    colNames.add(column.getName());
                                }
                                Index idx = this.getIndexForColumnNames(table, colNames, pk);
                                if (idx != null) {
                                    idx.remove();
                                }
                            }
                        }
                    } else if (index == null) {
                        index = table.createIndex();
                        newIndexCreated = true;
                    }
                    if (index == null) continue;
                    ukMap.put(ownerName + constrName, index);
                    TableSpaceOracle tableSpace = null;
                    SegmentOracle segment = null;
                    String logging = "";
                    UserOracle user = null;
                    int compress = 0;
                    boolean partitioned = false;
                    IndexProxyOracle indexProxy = null;
                    IndexProxyOracle supIndProxy = null;
                    if (supportInd != null) {
                        indexProxy = (IndexProxyOracle)storage.getIndexProxySet().getProxy(supportInd.getObjectID());
                    } else {
                        supIndProxy = indexProxy = (IndexProxyOracle)storage.getIndexProxySet().getProxy(index.getObjectID());
                    }
                    if (indexProxy != null) {
                        tableSpace = indexProxy.getTableSpace();
                        segment = indexProxy.getSegment();
                        logging = indexProxy.getLogging();
                        user = indexProxy.getUser();
                        compress = indexProxy.getCompress();
                        partitioned = indexProxy.isPartitioned();
                    }
                    PKProxyOracle pkProxy = null;
                    UniqueOracle ukProxy = null;
                    IndexProxyOracle PKorUKProxy = null;
                    if ("U".equalsIgnoreCase(constrType)) {
                        index.setIndexState("Unique Constraint");
                        ukProxy = (UniqueOracle)storage.getUniqueSet().getProxy(index.getObjectID());
                        PKorUKProxy = ukProxy;
                        ++uk_count;
                    } else if ("P".equalsIgnoreCase(constrType) && !table.isBST()) {
                        index.setIndexState("Primary Constraint");
                        pkProxy = (PKProxyOracle)storage.getPKProxySet().getProxy(index.getObjectID());
                        PKorUKProxy = pkProxy;
                    }
                    if (PKorUKProxy != null) {
                        PKorUKProxy.setTableSpace(tableSpace);
                        PKorUKProxy.setLogging(logging);
                        PKorUKProxy.setUser(user);
                        PKorUKProxy.setCompress(compress);
                        PKorUKProxy.setPartitioned(partitioned);
                        if (pkProxy != null) {
                            pkProxy.setIndexSegment(segment);
                            if (status.equals("ENABLED")) {
                                pkProxy.setEnable("YES");
                            } else {
                                pkProxy.setEnable("NO");
                            }
                            if (deferrable.equals("DEFERRABLE")) {
                                pkProxy.setDeferrable("YES");
                            } else {
                                pkProxy.setDeferrable("NO");
                            }
                            if (deferred.equals("DEFERRED")) {
                                pkProxy.setInitially("DEFERRED");
                            } else {
                                pkProxy.setInitially("IMMEDIATE");
                            }
                            if (validated.equals("VALIDATED")) {
                                pkProxy.setValidate("YES");
                            } else {
                                pkProxy.setValidate("NO");
                                if ("RELY".equals(rely)) {
                                    pkProxy.setRely("YES");
                                }
                            }
                        } else if (ukProxy != null) {
                            ukProxy.setIndexSegment(segment);
                            if (status.equals("ENABLED")) {
                                ukProxy.setEnable("YES");
                            } else {
                                ukProxy.setEnable("NO");
                            }
                            if (deferrable.equals("DEFERRABLE")) {
                                ukProxy.setDeferrable("YES");
                            } else {
                                ukProxy.setDeferrable("NO");
                            }
                            if (deferred.equals("DEFERRED")) {
                                ukProxy.setInitially("DEFERRED");
                            } else {
                                ukProxy.setInitially("IMMEDIATE");
                            }
                            if (validated.equals("VALIDATED")) {
                                ukProxy.setValidate("YES");
                            } else {
                                ukProxy.setValidate("NO");
                                if ("RELY".equals(rely)) {
                                    ukProxy.setRely("YES");
                                }
                            }
                        }
                    }
                    boolean valid = true;
                    if (index.getElementsCollection().size() == 0) {
                        valid = this.initPK_UK_Columns(index, map, constrName);
                    }
                    if (!valid || table.isBST() && !"".equals(index.getIndexExpression())) {
                        ukMap.put(ownerName + constrName, index.getTable());
                        index.remove();
                    } else if (PKorUKProxy != null) {
                        IndexProxyOracle idxProxy = null;
                        if (supIndProxy != null) {
                            idxProxy = supIndProxy;
                        } else {
                            Index idx = null;
                            idx = user != null ? table.getIndexByNameAndSchema(user.getName(), ind_name) : table.getIndexByName(ind_name);
                            if (idx == null) {
                                ArrayList<String> colNames = new ArrayList<String>();
                                for (Column column : index.getElementsCollection()) {
                                    colNames.add(column.getName());
                                }
                                idx = this.getIndexForColumnNames(table, colNames, index);
                            }
                            if (idx != null) {
                                idxProxy = (IndexProxyOracle)storage.getIndexProxySet().getProxy(idx.getObjectID());
                            }
                        }
                        if (!newIndexCreated || supportInd != null) {
                            if (pkProxy != null) {
                                if (!"INDEX".equalsIgnoreCase(tableProxy.getOrganization())) {
                                    pkProxy.setUsingIndex("BY INDEX NAME");
                                    pkProxy.setExistingIndex(idxProxy);
                                }
                            } else if (ukProxy != null) {
                                ukProxy.setUsingIndex("BY INDEX NAME");
                                ukProxy.setExistingIndex(idxProxy);
                            }
                        }
                    }
                    if (index.isRemoved()) continue;
                    if (generated.equalsIgnoreCase("USER NAME")) {
                        index.setName(constrName);
                        if (!constrName.equals(constrName.toUpperCase())) {
                            index.setNameHasQuotes(true);
                        }
                        this.stampModelObject((ModelObject)index, table.getSchema(), index.getName());
                        continue;
                    }
                    if (DBMExtractionController.swapTargetModel) {
                        index.setName(constrName);
                        this.stampModelObject((ModelObject)index, table.getSchema(), constrName);
                        continue;
                    }
                    NamingStandardRule nsr = table.getDesign().getDesignLevelSettings().getNamingStandardRule();
                    String tname = table.getName();
                    String abbrname = table.getAbbreviation();
                    if (abbrname == null || "".equals(abbrname)) {
                        abbrname = tname;
                    }
                    if (constrName.toUpperCase().startsWith(SYSTEM_NAME_PREFIX) && !table.getAppView().getSettings().isReplaceSystemNamesDuringImport()) {
                        index.setName(constrName);
                    } else {
                        String constName = "P".equalsIgnoreCase(constrType) ? ApplyNamingStandards.applyToPK(index, nsr, tname, abbrname) : ApplyNamingStandards.createUK_Name(index, uk_count, nsr, table.getDesignPart().getName(), tname, abbrname);
                        index.setName(constName);
                    }
                    this.stampModelObject((ModelObject)index, table.getSchema(), constrName);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.initUK_PK_FK_CHECK_Constraints():", e);
            }
        }
        if (ncol_st != null) {
            ncol_st.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void processCheckConstr(Map map, DBObject dbo, String constrName, String deferred, String status, String deferrable, String validated, String condition) {
        String colName;
        Column column;
        List columns = (List)map.get(constrName);
        TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
        Table table = dbo.getTable();
        if (columns != null && columns.size() == 1 && (column = (Column)table.getElementByName(colName = (String)columns.get(0))) != null) {
            String nn_pat = colName + " IS NOT NULL";
            if (nn_pat.equalsIgnoreCase(condition.trim().replaceAll("\"", ""))) {
                ColumnProxyOracle cp;
                column.setNullsAllowed(false);
                Column colOrNestedCol = (Column)table.getElementByName(colName);
                if (colOrNestedCol != null && (cp = (ColumnProxyOracle)tableProxy.getColumnProxy(colOrNestedCol.getObjectID())) != null) {
                    if ("ENABLED".equalsIgnoreCase(status)) {
                        cp.setNncEnable("YES");
                    } else {
                        cp.setNncEnable("NO");
                    }
                    if (deferrable.equals("DEFERRABLE")) {
                        cp.setNncDeferrable("YES");
                    } else {
                        cp.setNncDeferrable("NO");
                    }
                    if (deferred.equals("DEFERRED")) {
                        cp.setNncInitially("DEFERRED");
                    } else {
                        cp.setNncInitially("IMMEDIATE");
                    }
                    if (validated.equals("VALIDATED")) {
                        cp.setNncValidate("YES");
                    } else {
                        cp.setNncValidate("NO");
                    }
                    if (!constrName.startsWith("SYS_C") || !column.getAppView().getSettings().isReplaceSystemNamesDuringImport()) {
                        column.setNotNullConstraintName(constrName);
                    }
                }
                return;
            }
            if (column.getCheck() == null) {
                ColumnProxyOracle cp;
                String checkPart = condition;
                boolean separated = column.setSeparatedConstraints(condition);
                if (separated) {
                    checkPart = column.getSeparatedCheckConstraint();
                }
                if (!"".equals(checkPart)) {
                    CheckConstraint cconstraint = new CheckConstraint();
                    cconstraint.setDesign(table.getDesign());
                    cconstraint.setName(constrName);
                    this.stampModelObject((ModelObject)cconstraint, table.getName(), constrName);
                    RDBMSType rdbmsType = StorageDesignOraclev11g.RDBMS_TYPE;
                    if (this.getStorageDesign() != null) {
                        rdbmsType = this.getStorageDesign().getRDBMSType();
                    }
                    cconstraint.add(rdbmsType, checkPart);
                    column.setUseDomainConstraints(false);
                    column.setCheck(cconstraint);
                    column.setConstraintName(constrName);
                }
                if (separated) {
                    String valueList;
                    String rangeList = column.getSeparatedRangeConstraint();
                    if (!"".equals(rangeList)) {
                        String[] rangeParts = rangeList.split(",");
                        int i = 0;
                        while (i < rangeParts.length) {
                            String rangeFrom = rangeParts[i++];
                            String rangeTo = rangeParts[i++];
                            AVT avt = new AVT(rangeFrom.trim(), rangeTo.trim(), "");
                            column.setUseDomainConstraints(false);
                            column.addAVT(avt);
                            column.setConstraintName(constrName);
                        }
                    }
                    if (!"".equals(valueList = column.getSeparatedValueConstraint())) {
                        String[] valueParts = valueList.split(",");
                        ConstraintEnumeration lov = new ConstraintEnumeration();
                        for (int i = 0; i < valueParts.length; ++i) {
                            lov.add(valueParts[i].trim());
                        }
                        column.setUseDomainConstraints(false);
                        column.setValueList(lov);
                        column.setConstraintName(constrName);
                    }
                }
                if ((cp = (ColumnProxyOracle)tableProxy.getColumnProxyByName(colName)) != null) {
                    if ("ENABLED".equalsIgnoreCase(status)) {
                        cp.setEnable("YES");
                    } else {
                        cp.setEnable("NO");
                    }
                    if (deferrable.equals("DEFERRABLE")) {
                        cp.setDeferrable("YES");
                    } else {
                        cp.setDeferrable("NO");
                    }
                    if (deferred.equals("DEFERRED")) {
                        cp.setInitially("DEFERRED");
                    } else {
                        cp.setInitially("IMMEDIATE");
                    }
                    if (validated.equals("VALIDATED")) {
                        cp.setValidate("YES");
                    } else {
                        cp.setValidate("NO");
                    }
                }
                return;
            }
        }
        if (columns != null && columns.size() > 1) {
            for (ValidTimeDimension validTimeDimension : table.getValidTimeDimensions()) {
                int lessThanIndex;
                String vdtName = validTimeDimension.getName();
                if (!constrName.startsWith(vdtName)) continue;
                boolean hasVDTRef = false;
                boolean hasOtherRef = false;
                for (String colName2 : columns) {
                    if (colName2.equals(vdtName)) {
                        hasVDTRef = true;
                        continue;
                    }
                    if (colName2.startsWith(vdtName + '_')) continue;
                    hasOtherRef = true;
                }
                if (!hasVDTRef && hasOtherRef) continue;
                String text = condition;
                if (text.startsWith("(")) {
                    text = Token.getValBetweenBrackets(text, 1);
                }
                if ((lessThanIndex = text.indexOf(60)) > -1) {
                    String startColName = Token.getFirstName(text.substring(0, lessThanIndex), '\"', '\"');
                    String endColName = Token.getFirstName(text.substring(lessThanIndex + 1), '\"', '\"');
                    Column startCol = (Column)table.getElementByName(startColName);
                    Column endCol = (Column)table.getElementByName(endColName);
                    if (startCol != null && endCol != null) {
                        validTimeDimension.setStartTimeColumn(startCol);
                        validTimeDimension.setEndTimeColumn(endCol);
                    }
                }
                return;
            }
        }
        TableLevelConstraint constraint = table.createCheckConstraint(constrName, condition);
        if (!constrName.equals(constrName.toUpperCase())) {
            constraint.setNameHasQuotes(true);
        }
        table.addCheckConstraint(constraint);
        this.stampModelObject((ModelObject)constraint, table.getSchema(), constrName);
        TableCheckConstraintOracle proxy = tableProxy.getTableConstraint(constraint);
        if (proxy != null) {
            if (status.equals("ENABLED")) {
                proxy.setEnable("YES");
            } else {
                proxy.setEnable("NO");
            }
            if (deferrable.equals("DEFERRABLE")) {
                proxy.setDeferrable("YES");
            } else {
                proxy.setDeferrable("NO");
            }
            if (deferred.equals("DEFERRED")) {
                proxy.setInitially("DEFERRED");
            } else {
                proxy.setInitially("IMMEDIATE");
            }
            if (validated.equals("VALIDATED")) {
                proxy.setValidate("YES");
            } else {
                proxy.setValidate("NO");
            }
        }
    }

    private boolean initPK_UK_Columns(Index index, Map map, String constrName) throws Exception {
        boolean valid = true;
        List list = (List)map.get(constrName);
        if (list != null) {
            String ind_expr = "";
            boolean expr = false;
            boolean first = true;
            Table table = (Table)index.getContainerWithKeyObject();
            for (int i = 0; i < list.size(); ++i) {
                String colName = (String)list.get(i);
                if (first) {
                    ind_expr = colName;
                    first = false;
                } else {
                    ind_expr = ind_expr + "," + colName;
                }
                Column column = (Column)table.getElementByName(colName);
                if (column != null) {
                    if (column.getCollectionType() != null || column.getStructuredType() != null) {
                        valid = false;
                    }
                    index.add(column);
                    continue;
                }
                if (colName.startsWith("SYS_NC")) {
                    valid = false;
                }
                expr = true;
            }
            if (expr) {
                index.getElementsCollection().clear();
                index.setIndexExpression(ind_expr);
            }
        }
        return valid;
    }

    private void initFK_Columns(Map map, String constrName, List columns) throws Exception {
        List list = (List)map.get(constrName);
        if (list != null) {
            columns.addAll(list);
        }
    }

    protected abstract void initColumns(Connection var1, List var2) throws Exception;

    protected void setParameter(Column column, String param, int value) {
        if (value != 0) {
            column.setDataTypeParameter(param, String.valueOf(value));
        }
    }

    protected void initClusterColumns(Connection sqlConnection, List dbos) throws Exception {
        String viewName = this.dbaUser ? "dba_clu_columns" : "user_clu_columns";
        String sql = this.getClusterColumnSql(viewName);
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        for (DBObject dbo : dbos) {
            Table table = dbo.getTable();
            TableProxyOracle tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            ClusterOracle cluster = tableProxy.getCluster();
            if (cluster == null) continue;
            String tableName = table.getName();
            String clusterName = cluster.getName();
            ResultSet rs = null;
            try {
                statement.setString(1, tableName);
                statement.setString(2, clusterName);
                if (viewName.equals("dba_clu_columns")) {
                    statement.setString(3, dbo.getSchema());
                }
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.initClusterColumns():", e);
            }
            if (rs == null) continue;
            HashMap<ClusterColumnOracle, ColumnProxy> map = new HashMap<ClusterColumnOracle, ColumnProxy>();
            while (rs.next()) {
                String tableColName = rs.getString("TAB_COLUMN_NAME");
                String clusterColName = rs.getString("CLU_COLUMN_NAME");
                ClusterColumnOracle clusterColumn = (ClusterColumnOracle)cluster.getColumnsCollection().getByName(clusterColName);
                if (clusterColumn == null) continue;
                map.put(clusterColumn, tableProxy.getColumnProxyByName(tableColName));
            }
            rs.close();
            Iterator clusterColIt = cluster.getColumnsCollection().iterator();
            while (clusterColIt.hasNext()) {
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)map.get(clusterColIt.next());
                if (columnProxy == null) continue;
                tableProxy.setClusterColumns(columnProxy.getObjectID());
            }
        }
        statement.close();
    }

    private String getClusterColumnSql(String viewName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("CLU_COLUMN_NAME").append(',');
        buffer.append("TAB_COLUMN_NAME").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(viewName).append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("CLUSTER_NAME").append('=').append(' ').append('?').append(' ');
        if (viewName.equals("dba_clu_columns")) {
            buffer.append("AND").append(' ');
            buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        }
        return buffer.toString();
    }

    private List getIndexColumns(PreparedStatement pstatement, String indexName, String owner) throws Exception {
        ArrayList<SimpleColumn> list = new ArrayList<SimpleColumn>();
        ResultSet rs = null;
        try {
            pstatement.setString(1, owner);
            pstatement.setString(2, indexName);
            rs = pstatement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.getIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                String sortOrder = rs.getString("DESCEND");
                SimpleColumn sc = new SimpleColumn(colName, sortOrder);
                list.add(sc);
            }
            rs.close();
        }
        return list;
    }

    private void initIndexes(Connection sqlConnection, List dbos) throws Exception {
        this.indexp_st = null;
        this.indspat_st = null;
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("COLUMN_POSITION").append(',');
        buffer.append("DESCEND").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_ind_columns" : "all_ind_columns").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("INDEX_OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("COLUMN_POSITION");
        String colsql = buffer.toString();
        Statement col_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COLUMN_NAME").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_tab_columns" : "all_tab_columns").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("COLUMN_ID").append('=').append(' ').append('?');
        String colNamesql = buffer.toString();
        Statement colName_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("PCT_USED").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("IOT_TYPE").append(',');
        buffer.append("BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_all_tables" : "all_all_tables").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("IOT_NAME").append('=').append(' ').append('?');
        String overflowsql = buffer.toString();
        Statement overflow_st = null;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("OWNER").append(',');
        buffer.append("INDEX_NAME").append(',');
        buffer.append("INDEX_TYPE").append(',');
        buffer.append("UNIQUENESS").append(',');
        buffer.append("PREFIX_LENGTH").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("INI_TRANS").append(',');
        buffer.append("MAX_TRANS").append(',');
        buffer.append("INITIAL_EXTENT").append(',');
        buffer.append("NEXT_EXTENT").append(',');
        buffer.append("MIN_EXTENTS").append(',');
        buffer.append("MAX_EXTENTS").append(',');
        buffer.append("PCT_INCREASE").append(',');
        buffer.append("PCT_THRESHOLD").append(',');
        buffer.append("INCLUDE_COLUMN").append(',');
        buffer.append("FREELISTS").append(',');
        buffer.append("FREELIST_GROUPS").append(',');
        buffer.append("PCT_FREE").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("DEGREE").append(',');
        buffer.append("PARTITIONED").append(',');
        buffer.append("BUFFER_POOL").append(',');
        buffer.append("ITYP_OWNER").append(',');
        buffer.append("ITYP_NAME").append(',');
        buffer.append("PARAMETERS");
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append(',').append("VISIBILITY");
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_indexes" : "all_indexes").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("JOIN_INDEX").append('=').append('\'');
        buffer.append("NO").append('\'');
        String sql = buffer.toString();
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        for (DBObject dbo : dbos) {
            Table table = dbo.getTable();
            ResultSet rs = null;
            try {
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null) continue;
                while (rs.next()) {
                    IndexProxyOracle indexProxy;
                    String indexName = rs.getString("INDEX_NAME");
                    String owner = rs.getString("OWNER");
                    String indexType = rs.getString("INDEX_TYPE");
                    Index index = table.createIndex();
                    index.setName(indexName);
                    index.setSchemaObject(table.getSchemaObject());
                    if (!indexName.equals(indexName.toUpperCase())) {
                        index.setNameHasQuotes(true);
                    }
                    this.stampModelObject((ModelObject)index, table.getSchema(), indexName);
                    String uniquness = rs.getString("UNIQUENESS");
                    if ("UNIQUE".equalsIgnoreCase(uniquness)) {
                        index.setIndexState("Unique Plain Index");
                    }
                    if ((indexProxy = (IndexProxyOracle)storageDesign.getIndexProxySet().getProxy(index.getObjectID())) == null) continue;
                    List expressions = null;
                    boolean toremove = false;
                    if (indexType != null) {
                        if (indexType.indexOf("FUNCTION") > -1 || indexType.indexOf("DOMAIN") > -1) {
                            expressions = this.setIndexExpression(sqlConnection, index, owner, indexName);
                        } else if ("BITMAP".equalsIgnoreCase(indexType)) {
                            indexProxy.setBitmapIndex(true);
                        }
                    }
                    boolean is_expr = false;
                    String expres = index.getIndexExpression();
                    if (!"".equals(expres)) {
                        is_expr = true;
                    }
                    String ind_expr = "";
                    boolean hasUnrecognizedCol = false;
                    boolean first = true;
                    if (col_st == null) {
                        col_st = sqlConnection.prepareStatement(colsql);
                    }
                    int col_pos = 1;
                    List indexCols = this.getIndexColumns((PreparedStatement)col_st, indexName, owner);
                    for (SimpleColumn sc : indexCols) {
                        ExprHelp eh;
                        String cname = sc.getName();
                        Column column = (Column)table.getElementByName(cname);
                        String ciname = null;
                        if (column == null && (eh = this.getExprByColPos(expressions, col_pos)) != null && (ciname = Token.getName(eh.expr)) != null) {
                            column = (Column)table.getElementByName(ciname);
                        }
                        if (ciname != null) {
                            cname = ciname;
                            if (column == null && "DESC".equalsIgnoreCase(sc.sortOrder)) {
                                cname = cname + " " + "DESC";
                            }
                        }
                        if (column != null) {
                            if (column.getCollectionType() != null || column.getStructuredType() != null) {
                                toremove = true;
                            }
                            index.add(column);
                            index.setColumnSortOrder(column, sc.getSortOrder());
                            if (is_expr) {
                                index.setIndexExpression("");
                            }
                        } else {
                            if (!is_expr && cname.indexOf("SYS_NC") > -1) {
                                toremove = true;
                            }
                            hasUnrecognizedCol = true;
                        }
                        if (first) {
                            ind_expr = cname;
                            first = false;
                        } else {
                            ind_expr = ind_expr + "," + cname;
                        }
                        ++col_pos;
                    }
                    if (!is_expr && first) {
                        toremove = true;
                    }
                    if (hasUnrecognizedCol) {
                        index.getElementsCollection().clear();
                        index.setIndexExpression(ind_expr);
                    }
                    TableProxyOracle tp = (TableProxyOracle)storageDesign.getTableProxySet().getObjectByID(table.getObjectID());
                    SnapshotOracle sn = tp.getSnapshot();
                    this.setIndexTableSpace(indexProxy, storageDesign, rs.getString("TABLESPACE_NAME"));
                    if (sn != null) {
                        if (!"".equals(expres) && expres.indexOf("SYS_OP_MAP_NONNULL") > -1) {
                            toremove = true;
                        } else if (!"".equals(index.getIndexExpression()) && "M_ROW$$".equalsIgnoreCase(index.getIndexExpression().trim())) {
                            toremove = true;
                            sn.setWith("ROWID");
                        }
                        if (toremove) {
                            sn.setIndexTablespace(indexProxy.getTableSpace());
                        }
                    }
                    if (toremove) {
                        index.remove();
                        continue;
                    }
                    this.setIndexUser(indexProxy, storageDesign, owner);
                    this.setIndexProperties(sqlConnection, table, indexProxy, storageDesign, rs);
                    if (indexType == null || !indexType.startsWith("IOT") || tp == null || !"INDEX".equals(tp.getOrganization())) continue;
                    if (tp.getTableSpace() == null) {
                        tp.setTableSpace(indexProxy.getTableSpace());
                    }
                    tp.setLogging(indexProxy.getLogging());
                    tp.setSegment(indexProxy.getSegment());
                    tp.setIotCompress(indexProxy.getCompress());
                    tp.setIotPctThreshold(rs.getInt("PCT_THRESHOLD"));
                    int includeColumn = rs.getInt("INCLUDE_COLUMN");
                    if (includeColumn > 0) {
                        if (colName_st == null) {
                            colName_st = sqlConnection.prepareStatement(colNamesql);
                        }
                        try {
                            colName_st.setString(1, dbo.getSchema());
                            colName_st.setString(2, dbo.getName());
                            colName_st.setInt(3, includeColumn);
                            ResultSet colNameRS = colName_st.executeQuery();
                            if (colNameRS != null) {
                                String includeColName;
                                if (colNameRS.next() && (includeColName = colNameRS.getString("COLUMN_NAME")) != null) {
                                    tp.setIotIncluding(tp.getColumnProxyByName(includeColName));
                                }
                                colNameRS.close();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("MOHTableOracle.initIndexes():", e);
                        }
                    }
                    if (overflow_st == null) {
                        overflow_st = sqlConnection.prepareStatement(overflowsql);
                    }
                    try {
                        overflow_st.setString(1, dbo.getSchema());
                        overflow_st.setString(2, dbo.getName());
                        ResultSet overflowRS = overflow_st.executeQuery();
                        if (overflowRS == null) continue;
                        while (overflowRS.next()) {
                            String iotType = overflowRS.getString("IOT_TYPE");
                            if (iotType == null) continue;
                            if (iotType.equals("IOT_OVERFLOW")) {
                                this.setOverflowProperties(tp, storageDesign, overflowRS);
                                continue;
                            }
                            if (!iotType.equals("IOT_MAPPING")) continue;
                            tp.setIOTMappingTable("YES");
                        }
                        overflowRS.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("MOHTableOracle.initIndexes():", e);
                    }
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.initIndexes():", e);
            }
        }
        if (col_st != null) {
            col_st.close();
        }
        if (colName_st != null) {
            colName_st.close();
        }
        if (overflow_st != null) {
            overflow_st.close();
        }
        if (this.indexp_st != null) {
            this.indexp_st.close();
        }
        if (this.indspat_st != null) {
            this.indspat_st.close();
        }
        statement.close();
    }

    private ExprHelp getExprByColPos(List expressions, int pos) {
        if (expressions != null) {
            for (ExprHelp eh : expressions) {
                if (eh.col_pos != pos) continue;
                return eh;
            }
        }
        return null;
    }

    private List setIndexExpression(Connection sqlConnection, Index index, String indexOwner, String indexName) throws SQLException {
        ArrayList<ExprHelp> list = new ArrayList<ExprHelp>();
        if (this.indexp_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_EXPRESSION").append(',').append("COLUMN_POSITION").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_ind_expressions" : "all_ind_expressions").append(' ');
            buffer.append("WHERE").append(' ').append("INDEX_OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
            String sql = buffer.toString();
            this.indexp_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.indexp_st.setString(1, indexOwner);
            this.indexp_st.setString(2, indexName);
            rs = this.indexp_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setIndexExpression():", e);
        }
        if (rs != null) {
            String funct_expr = "";
            boolean first = true;
            while (rs.next()) {
                String col_expr = rs.getString("COLUMN_EXPRESSION");
                int col_pos = rs.getInt("COLUMN_POSITION");
                if (first) {
                    funct_expr = col_expr;
                    first = false;
                } else {
                    funct_expr = funct_expr + "," + col_expr;
                }
                ExprHelp eh = new ExprHelp();
                eh.expr = col_expr;
                eh.col_pos = col_pos;
                list.add(eh);
            }
            if (!"".equals(funct_expr)) {
                index.setIndexExpression(funct_expr);
            }
            rs.close();
        }
        return list;
    }

    private void setIndexUser(IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, String userName) {
        SchemaObjectSet schemaSet;
        SchemaObject so;
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        if (user == null) {
            user = storageDesign.getUserSet().createUser();
            user.setName(userName);
            this.stampModelObject((ModelObject)user, "", userName);
        }
        if ((so = (SchemaObject)(schemaSet = ((RelationalDesign)indexProxy.getIndex().getDesignPart()).getSchemaObjectSet()).getByName(userName)) == null) {
            so = schemaSet.createSchemaObject(null);
            so.setName(userName);
            this.stampModelObject((ModelObject)so, "", userName);
        }
        if (user.getSchemaObject() == null) {
            user.setSchemaObject(so);
        }
        if (user.getSchemaObject() != so) {
            indexProxy.setUser(user);
        }
        indexProxy.getIndex().setSchemaObject(so);
    }

    private void setIndexTableSpace(IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, String tsName) {
        if (tsName != null && !"".equalsIgnoreCase(tsName)) {
            TableProxyOracle tableProxy;
            TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
            if (tableSpace == null && (tableProxy = (TableProxyOracle)indexProxy.getTableProxy()) != null && tableProxy.getTemporary().equals("NO")) {
                tableSpace = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                tableSpace.setName(tsName);
                this.stampModelObject((ModelObject)tableSpace, indexProxy, tsName);
            }
            indexProxy.setTableSpace(tableSpace);
        }
    }

    private void setIndexProperties(Connection sqlConnection, Table table, IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        SegmentOracle tsegment;
        String compression;
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        int iniTrans = resultSet.getInt("INI_TRANS");
        int maxTrans = resultSet.getInt("MAX_TRANS");
        long initialExtent = resultSet.getLong("INITIAL_EXTENT");
        long nextExtent = resultSet.getLong("NEXT_EXTENT");
        int minExtents = Integer.MAX_VALUE;
        String maxExtents = "";
        try {
            minExtents = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in min_extent", e);
        }
        try {
            maxExtents = resultSet.getString("MAX_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in max_extent", e);
        }
        int pctIncrease = resultSet.getInt("PCT_INCREASE");
        int freeLists = resultSet.getInt("FREELISTS");
        int freeListGroups = resultSet.getInt("FREELIST_GROUPS");
        int pctFree = resultSet.getInt("PCT_FREE");
        String logging = resultSet.getString("LOGGING");
        String parallel = resultSet.getString("DEGREE");
        String partitioned = resultSet.getString("PARTITIONED");
        String bufferPool = resultSet.getString("BUFFER_POOL");
        String itypeOwner = resultSet.getString("ITYP_OWNER");
        String itypeName = resultSet.getString("ITYP_NAME");
        String parameters = resultSet.getString("PARAMETERS");
        String visibility = "";
        if (storageDesign instanceof StorageDesignOraclev11g) {
            visibility = resultSet.getString("VISIBILITY");
        }
        if ((compression = resultSet.getString("PREFIX_LENGTH")) != null) {
            try {
                indexProxy.setCompress(Integer.parseInt(compression));
            }
            catch (NumberFormatException e) {
                LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value for KeyCompression", e);
            }
        }
        if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            segment.setSCInitialExtent(initialExtent);
        }
        if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            segment.setSCNextExtent(nextExtent);
        }
        if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            segment.setSCMinExtents(minExtents);
        }
        if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(String.valueOf(maxExtents));
        }
        if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            segment.setSCPctIncrease(pctIncrease);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("PCT_FREE") != null) && segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (logging != null) {
            indexProxy.setLogging(logging.trim().toUpperCase());
        }
        if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim());
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        indexProxy.setSegment(segment);
        if ("1".equals(parallel.trim())) {
            indexProxy.setParallel("NO");
        } else {
            indexProxy.setParallel("YES");
            indexProxy.setDegree(parallel.trim());
        }
        if ("INVISIBLE".equalsIgnoreCase(visibility)) {
            ((IndexProxyOraclev10g)indexProxy).setInvisible("YES");
        }
        if (itypeOwner != null && itypeName != null && itypeOwner.equalsIgnoreCase("MDSYS") && itypeName.equals("SPATIAL_INDEX")) {
            String name = this.getSpatialColumnName(sqlConnection, table, indexProxy);
            Index index = indexProxy.getIndex();
            index.setSpatialIndex(true);
            Column spaColumn = (Column)table.getElementByName(name);
            Iterator it = table.getSpatialDefinitions().iterator();
            SpatialColumnDefObject spaColumnDef2 = null;
            boolean funcind = false;
            if (spaColumn != null) {
                while (it.hasNext() && (spaColumnDef2 = (SpatialColumnDefObject)it.next()).getSpatialColumn() != spaColumn) {
                    spaColumnDef2 = null;
                }
            } else {
                while (it.hasNext()) {
                    spaColumnDef2 = (SpatialColumnDefObject)it.next();
                    if (spaColumnDef2.getFuncExpression().equals(name)) {
                        funcind = true;
                        break;
                    }
                    spaColumnDef2 = null;
                }
                if (spaColumnDef2 == null && index.hasIndexExpression()) {
                    for (SpatialColumnDefObject spaColumnDef2 : table.getSpatialDefinitions()) {
                        if (spaColumnDef2.isFunction()) {
                            funcind = true;
                            break;
                        }
                        spaColumnDef2 = null;
                    }
                }
            }
            if (spaColumnDef2 != null && !funcind) {
                indexProxy.getIndex().setSpatialColumnDefiniton(spaColumnDef2);
                spaColumnDef2.setSpatialIndex(index);
                if (spaColumn != null) {
                    spaColumnDef2.setFunction(false);
                    spaColumnDef2.setFuncExpression("");
                    if (indexProxy.getIndex().getElementsCollection().size() == 0) {
                        indexProxy.getIndex().add(spaColumn);
                    }
                } else if (spaColumnDef2.isFunction()) {
                    indexProxy.getIndex().setIndexExpression(name);
                }
                if (spaColumnDef2.getSpatialColumn() != null) {
                    indexProxy.getIndex().add(spaColumnDef2.getSpatialColumn());
                }
            } else {
                if (spaColumnDef2 == null) {
                    spaColumnDef2 = new SpatialColumnDefObject(table);
                    table.addSpatialDefinition(spaColumnDef2);
                }
                spaColumnDef2.setSpatialIndex(index);
                if (index.hasIndexExpression()) {
                    index.setSpatialColumnDefiniton(spaColumnDef2);
                    if (!spaColumnDef2.isFunction()) {
                        spaColumnDef2.setFunction(true);
                        spaColumnDef2.setFuncExpression(index.getIndexExpression());
                    }
                }
            }
            if (parameters != null) {
                parameters = Token.replaceAll(parameters, "\n", "");
                StringTokenizer tokens = new StringTokenizer(parameters, " ");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    String[] param = token.split("=");
                    if (param.length != 2) continue;
                    String paramName = param[0];
                    String paramValue = param[1];
                    if (paramValue.equals("")) continue;
                    if (paramName.equalsIgnoreCase("tablespace")) {
                        TableSpaceOracle tablespace = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(paramValue);
                        if (tablespace == null) {
                            tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                            tablespace.setName(paramValue);
                            this.stampModelObject((ModelObject)tablespace, indexProxy, paramValue);
                        }
                        indexProxy.setTableSpace(tablespace);
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("work_tablespace")) {
                        TableSpaceOracle tbSpace = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getByName(paramValue);
                        if (tbSpace == null) {
                            tbSpace = storageDesign.getTableSpaceSet().createTableSpace();
                            tbSpace.setName(paramValue);
                            this.stampModelObject((ModelObject)tbSpace, indexProxy, paramValue);
                        }
                        if (storageDesign instanceof StorageDesignOraclev9i) {
                            ((IndexProxyOraclev9i)indexProxy).setWorkTablespace(tbSpace);
                            continue;
                        }
                        ((IndexProxyOraclev10g)indexProxy).setWorkTablespace(tbSpace);
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("layer_gtype")) {
                        indexProxy.getIndex().setLayerType(paramValue);
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("sdo_indx_dims")) {
                        try {
                            indexProxy.getIndex().setDimensionsNumber(Integer.parseInt(paramValue));
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value.", e);
                        }
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("geodetic")) {
                        indexProxy.getIndex().setGeodetic("NO");
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("sdo_non_leaf_tbl") && paramValue.equalsIgnoreCase("TRUE")) {
                        if (storageDesign instanceof StorageDesignOraclev9i) {
                            ((IndexProxyOraclev9i)indexProxy).setNonLeaf("YES");
                            continue;
                        }
                        ((IndexProxyOraclev10g)indexProxy).setNonLeaf("YES");
                        continue;
                    }
                    try {
                        if (paramName.equalsIgnoreCase("initial") && segment.getAppView().getSettings().isIncludeInitransInDDL()) {
                            segment.setInitrans(Integer.parseInt(paramValue));
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("next") && segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                            segment.setSCNextExtent(Long.parseLong(paramValue));
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("minextents") && segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                            segment.setSCMinExtents(Integer.parseInt(paramValue));
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("maxextents") && segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                            segment.setSCMaxExtents(paramValue);
                            continue;
                        }
                        if (paramName.equalsIgnoreCase("pctincrease") && segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                            segment.setSCPctIncrease(Integer.parseInt(paramValue));
                            continue;
                        }
                        if (!paramName.equalsIgnoreCase("sdo_rdr_pctfree") || !segment.getAppView().getSettings().isIncludePctFreeInDDL()) continue;
                        segment.setPCTFree(Integer.parseInt(paramValue));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("MOHTableOracle.setIndexProperties(): Can not parse string value.", e);
                    }
                }
            }
        } else if (itypeOwner != null && itypeName != null) {
            indexProxy.setIndexType(itypeOwner + "." + itypeName);
            if (parameters != null) {
                indexProxy.setIndexDomainParameters(parameters);
            }
        }
        if ("YES".equalsIgnoreCase(partitioned.trim())) {
            indexProxy.setPartitioned(true);
        } else {
            indexProxy.setPartitioned(false);
        }
    }

    private void setDefIndexProperties(IndexProxyOracle indexProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws SQLException {
        SegmentOracle tsegment;
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        int iniTrans = resultSet.getInt("DEF_INI_TRANS");
        int maxTrans = resultSet.getInt("DEF_MAX_TRANS");
        String initialExtent = resultSet.getString("DEF_INITIAL_EXTENT");
        String nextExtent = resultSet.getString("DEF_NEXT_EXTENT");
        String minExtents = resultSet.getString("DEF_MIN_EXTENTS");
        String maxExtents = resultSet.getString("DEF_MAX_EXTENTS");
        String pctIncrease = resultSet.getString("DEF_PCT_INCREASE");
        int freeLists = resultSet.getInt("DEF_FREELISTS");
        int freeListGroups = resultSet.getInt("DEF_FREELIST_GROUPS");
        int pctFree = resultSet.getInt("DEF_PCT_FREE");
        String bufferPool = resultSet.getString("DEF_BUFFER_POOL");
        String logging = resultSet.getString("DEF_LOGGING");
        if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        try {
            if (!initialExtent.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                segment.setSCInitialExtent(Long.parseLong(initialExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_INITIAL_EXTENT", e);
        }
        try {
            if (!nextExtent.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                segment.setSCNextExtent(Long.parseLong(nextExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_NEXT_EXTENT", e);
        }
        try {
            if (!minExtents.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                segment.setSCMinExtents(Integer.parseInt(minExtents.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_MIN_EXTENTS", e);
        }
        if (maxExtents != null && !maxExtents.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(maxExtents.trim());
        }
        try {
            if (!pctIncrease.equals("DEFAULT") && segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                segment.setSCPctIncrease(Integer.parseInt(pctIncrease.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_PCT_INCREASE", e);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("DEF_PCT_FREE") != null) && segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim().toUpperCase());
        }
        if (logging != null) {
            indexProxy.setLogging(logging.trim().toUpperCase());
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        indexProxy.setSegment(segment);
    }

    private String getSpatialColumnName(Connection sqlConnection, Table table, IndexProxyOracle indexProxy) throws SQLException {
        if (this.indspat_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(' ');
            buffer.append("FROM").append(' ').append("all_sdo_index_info").append(' ');
            buffer.append("WHERE").append(' ').append("SDO_INDEX_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("INDEX_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            String sql = buffer.toString();
            this.indspat_st = sqlConnection.prepareStatement(sql);
        }
        String spaColumnName = null;
        String tableOwner = table.getSchema();
        String indexOwner = "";
        if (indexProxy.getUser() != null) {
            indexOwner = indexProxy.getUser().getName();
        }
        ResultSet rs = null;
        try {
            this.indspat_st.setString(1, indexOwner);
            this.indspat_st.setString(2, indexProxy.getName());
            this.indspat_st.setString(3, tableOwner);
            rs = this.indspat_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.getSpatialColumnName():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                spaColumnName = rs.getString("COLUMN_NAME");
            }
            rs.close();
        }
        return spaColumnName;
    }

    private void initIndexPartitioning(Connection sqlConnection, IndexProxyOracle indexProxy, String partitionType) throws SQLException {
        StorageDesignOracle storageDesign = (StorageDesignOracle)this.getStorageDesign();
        if (this.indpart_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("PARTITION_NAME").append(',');
            buffer.append("HIGH_VALUE").append(',');
            buffer.append("PARTITION_POSITION").append(',');
            buffer.append("TABLESPACE_NAME").append(',');
            buffer.append("PCT_FREE").append(',');
            buffer.append("INI_TRANS").append(',');
            buffer.append("MAX_TRANS").append(',');
            buffer.append("INITIAL_EXTENT").append(',');
            buffer.append("NEXT_EXTENT").append(',');
            buffer.append("MIN_EXTENT").append(',');
            buffer.append("MAX_EXTENT").append(',');
            buffer.append("PCT_INCREASE").append(',');
            buffer.append("FREELISTS").append(',');
            buffer.append("FREELIST_GROUPS").append(',');
            buffer.append("LOGGING").append(',');
            buffer.append("COMPRESSION").append(',');
            buffer.append("BUFFER_POOL").append(',');
            buffer.append("PARAMETERS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_ind_partitions" : "all_ind_partitions").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("INDEX_OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("PARTITION_POSITION");
            String sql = buffer.toString();
            this.indpart_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            UserOracle user = indexProxy.getUser();
            String ownerName = "";
            if (user != null) {
                ownerName = user.getName();
            } else {
                SchemaObject schema = indexProxy.getIndex().getSchemaObject();
                if (schema != null) {
                    ownerName = schema.getName();
                }
            }
            this.indpart_st.setString(1, ownerName);
            this.indpart_st.setString(2, indexProxy.getName());
            rs = this.indpart_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.initIndexPartitioning():", e);
        }
        if (rs != null) {
            String parameters;
            if (partitionType.equals("LOCAL")) {
                TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
                while (rs.next()) {
                    SegmentOracle segment;
                    StorageObject partition;
                    int partitionPos = rs.getInt("PARTITION_POSITION") - 1;
                    parameters = rs.getString("PARAMETERS");
                    String partitionName = rs.getString("PARTITION_NAME");
                    String compression = rs.getString("COMPRESSION");
                    if (partitionPos < 0 || partitionPos >= tableProxy.getPartitions().size() || (partition = (StorageObject)tableProxy.getPartitions().getElement(partitionPos)) == null) continue;
                    LocalIndexProperties lip = storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, indexProxy);
                    if (lip == null) {
                        lip = storageDesign.getLocalIndexPropertiesSet().createLocalIndexProperties();
                        lip.setIndex(indexProxy);
                        lip.setPartition(partition);
                        lip.setLogging(indexProxy.getLogging());
                    }
                    lip.setPartitionName(partitionName);
                    if (compression != null && indexProxy.getCompress() > 0 && compression.equalsIgnoreCase("DISABLED")) {
                        lip.setKeyCompress("NO");
                    }
                    if (parameters != null) {
                        StringTokenizer tokens = new StringTokenizer(parameters, " ");
                        while (tokens.hasMoreTokens()) {
                            String token = tokens.nextToken();
                            String[] param = token.split("=");
                            if (param.length != 2) continue;
                            String paramName = param[0];
                            String paramValue = param[1];
                            if (paramValue.equals("")) continue;
                            if (paramName.equalsIgnoreCase("tablespace")) {
                                TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(paramValue);
                                if (tablespace == null) {
                                    tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                                    tablespace.setName(paramValue);
                                    this.stampModelObject((ModelObject)tablespace, indexProxy, paramValue);
                                }
                                lip.setTableSpace(tablespace);
                                continue;
                            }
                            if (paramName.equalsIgnoreCase("work_tablespace")) {
                                TableSpaceOracle tempTBSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(paramValue);
                                if (tempTBSpace == null) {
                                    tempTBSpace = storageDesign.getTableSpaceSet().createTableSpace();
                                    tempTBSpace.setName(paramValue);
                                    this.stampModelObject((ModelObject)tempTBSpace, indexProxy, paramValue);
                                }
                                lip.setWorkTablespace(tempTBSpace);
                                continue;
                            }
                            if (paramName.equalsIgnoreCase("layer_gtype")) {
                                lip.setLayerType(paramValue);
                                continue;
                            }
                            if (paramName.equalsIgnoreCase("sdo_non_leaf_tbl") && paramValue.equalsIgnoreCase("TRUE")) {
                                if (storageDesign instanceof StorageDesignOraclev9i) {
                                    ((IndexProxyOraclev9i)indexProxy).setNonLeaf("YES");
                                    continue;
                                }
                                if (!(storageDesign instanceof StorageDesignOraclev10g)) continue;
                                ((IndexProxyOraclev10g)indexProxy).setNonLeaf("YES");
                                continue;
                            }
                            SegmentOracle segment2 = lip.getSegment();
                            if (segment2 == null) {
                                segment2 = storageDesign.getSegmentSet().createSegment();
                                lip.setSegment(segment2);
                            }
                            try {
                                if (paramName.equalsIgnoreCase("initial") && segment2.getAppView().getSettings().isIncludeInitransInDDL()) {
                                    segment2.setInitrans(Integer.parseInt(paramValue));
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("next") && segment2.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                    segment2.setSCNextExtent(Long.parseLong(paramValue));
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("minextents") && segment2.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                    segment2.setSCMinExtents(Integer.parseInt(paramValue));
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("maxextents") && segment2.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                    segment2.setSCMaxExtents(paramValue);
                                    continue;
                                }
                                if (paramName.equalsIgnoreCase("pctincrease") && segment2.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                    segment2.setSCPctIncrease(Integer.parseInt(paramValue));
                                    continue;
                                }
                                if (!paramName.equalsIgnoreCase("sdo_rdr_pctfree") || !segment2.getAppView().getSettings().isIncludePctFreeInDDL()) continue;
                                segment2.setPCTFree(Integer.parseInt(paramValue));
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("MOHTableOracle.initIndexPartitioning(): Can not parse string value", e);
                            }
                        }
                        continue;
                    }
                    String tablespaceName = rs.getString("TABLESPACE_NAME");
                    int iniTrans = rs.getInt("INI_TRANS");
                    int maxTrans = rs.getInt("MAX_TRANS");
                    long initialExtent = rs.getLong("INITIAL_EXTENT");
                    long nextExtent = rs.getLong("NEXT_EXTENT");
                    int minExtents = Integer.MAX_VALUE;
                    int maxExtents = Integer.MAX_VALUE;
                    try {
                        minExtents = rs.getInt("MIN_EXTENT");
                    }
                    catch (Exception e) {
                        LOGGER.error("error in min_extent", e);
                    }
                    try {
                        maxExtents = rs.getInt("MAX_EXTENT");
                    }
                    catch (Exception e) {
                        LOGGER.error("error in max_extent", e);
                    }
                    int pctIncrease = rs.getInt("PCT_INCREASE");
                    int freeLists = rs.getInt("FREELISTS");
                    int freeListGroups = rs.getInt("FREELIST_GROUPS");
                    int pctFree = rs.getInt("PCT_FREE");
                    String logging = rs.getString("LOGGING");
                    String bufferPool = rs.getString("BUFFER_POOL");
                    if (tablespaceName != null && tablespaceName.length() > 0) {
                        TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName);
                        if (tablespace == null) {
                            tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                            tablespace.setName(tablespaceName);
                            this.stampModelObject((ModelObject)tablespace, indexProxy, tablespaceName);
                        }
                        lip.setTableSpace(tablespace);
                    }
                    if ((segment = storageDesign.getSegmentSet().createSegment()).getAppView().getSettings().isIncludeInitransInDDL()) {
                        segment.setInitrans(iniTrans);
                        segment.setMaxTrans(maxTrans);
                    }
                    if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                        segment.setSCInitialExtent(initialExtent);
                    }
                    if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                        segment.setSCNextExtent(nextExtent);
                    }
                    if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                        segment.setSCMinExtents(minExtents);
                    }
                    if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                        segment.setSCMaxExtents(String.valueOf(maxExtents));
                    }
                    if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                        segment.setSCPctIncrease(pctIncrease);
                    }
                    if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                        segment.setSCFreeLists(freeLists);
                    }
                    if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                        segment.setSCFreelistGroups(freeListGroups);
                    }
                    if (segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
                        segment.setPCTFree(pctFree);
                    }
                    if (logging != null) {
                        lip.setLogging(logging.trim().toUpperCase());
                    }
                    if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                        segment.setSCBufferPool(bufferPool.trim());
                    }
                    SegmentOracle tsegment = storageDesign.getSegmentSet().findEqual(segment);
                    lip.setSegment(tsegment);
                    if (tsegment == segment) continue;
                    segment.remove(true);
                }
            } else {
                IndexGlobalPartitionsListOracle globalPartList = indexProxy.getIndexGlobalPartitionsList();
                if (globalPartList != null) {
                    while (rs.next()) {
                        SegmentOracle tsegment;
                        SegmentOracle segment;
                        String high_value = rs.getString("HIGH_VALUE");
                        parameters = rs.getString("PARAMETERS");
                        if (parameters != null) continue;
                        String partitionName = rs.getString("PARTITION_NAME");
                        int position = rs.getInt("PARTITION_POSITION");
                        String tablespaceName = rs.getString("TABLESPACE_NAME");
                        int pctFree = rs.getInt("PCT_FREE");
                        int iniTrans = rs.getInt("INI_TRANS");
                        int maxTrans = rs.getInt("MAX_TRANS");
                        long initialExtent = rs.getLong("INITIAL_EXTENT");
                        long nextExtent = rs.getLong("NEXT_EXTENT");
                        int minExtents = Integer.MAX_VALUE;
                        int maxExtents = Integer.MAX_VALUE;
                        try {
                            minExtents = rs.getInt("MIN_EXTENT");
                        }
                        catch (Exception e) {
                            LOGGER.error("error in min_extent", e);
                        }
                        try {
                            maxExtents = rs.getInt("MAX_EXTENT");
                        }
                        catch (Exception e) {
                            LOGGER.error("error in max_extent", e);
                        }
                        int pctIncrease = rs.getInt("PCT_INCREASE");
                        int freeLists = rs.getInt("FREELISTS");
                        int freeListGroups = rs.getInt("FREELIST_GROUPS");
                        String logging = rs.getString("LOGGING");
                        String bufferPool = rs.getString("BUFFER_POOL");
                        TableSpaceOracle tablespace = null;
                        if (tablespaceName != null && !"".equalsIgnoreCase(tablespaceName) && (tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName)) == null) {
                            tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                            tablespace.setName(tablespaceName);
                            this.stampModelObject((ModelObject)tablespace, indexProxy, tablespaceName);
                        }
                        if ((segment = storageDesign.getSegmentSet().createSegment()).getAppView().getSettings().isIncludePctFreeInDDL()) {
                            segment.setPCTFree(pctFree);
                        }
                        if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
                            segment.setInitrans(iniTrans);
                            segment.setMaxTrans(maxTrans);
                        }
                        if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                            segment.setSCInitialExtent(initialExtent);
                        }
                        if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                            segment.setSCNextExtent(nextExtent);
                        }
                        if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                            segment.setSCMinExtents(minExtents);
                        }
                        if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                            segment.setSCMaxExtents(String.valueOf(maxExtents));
                        }
                        if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                            segment.setSCPctIncrease(pctIncrease);
                        }
                        if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                            segment.setSCFreeLists(freeLists);
                        }
                        if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                            segment.setSCFreelistGroups(freeListGroups);
                        }
                        if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                            segment.setSCBufferPool(bufferPool.trim());
                        }
                        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                            segment.remove(true);
                        }
                        segment = tsegment;
                        IndexGlobalPartitionOracle partition = storageDesign.getIndexGlobalPartitionSet().createIndexGlobalPartition();
                        partition.setName(partitionName);
                        partition.setIndexGlobalPartList(globalPartList);
                        this.stampModelObject((ModelObject)partition, indexProxy, partitionName);
                        partition.setPosition(position);
                        if (high_value != null) {
                            partition.setValueList(high_value);
                        }
                        if (tablespace != null) {
                            partition.setTableSpace(tablespace);
                        }
                        if (!"NONE".equalsIgnoreCase(logging)) {
                            partition.setLogging(logging);
                        }
                        partition.setSegment(segment);
                    }
                }
            }
            rs.close();
        }
    }

    private void setIndexPartitioning(Connection sqlConnection, StorageDesignOracle storageDesign, List dbos) throws Exception {
        this.indpartype_st = null;
        this.indglobpartcols_st = null;
        this.indpart_st = null;
        for (DBObject dbo : dbos) {
            TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
            Iterator pkIt = tableProxy.getPrimaryKeys().iterator();
            while (pkIt.hasNext()) {
                PKProxyOracle pkProxy = (PKProxyOracle)pkIt.next();
                if (!pkProxy.isPartitioned()) continue;
                this.setIndexPartitioningInfo(sqlConnection, pkProxy, storageDesign);
            }
            Iterator ukIt = tableProxy.getUniqueKeys().iterator();
            while (ukIt.hasNext()) {
                UniqueOracle ukProxy = (UniqueOracle)ukIt.next();
                if (!ukProxy.isPartitioned()) continue;
                this.setIndexPartitioningInfo(sqlConnection, ukProxy, storageDesign);
            }
            Iterator indexIt = tableProxy.getIndexes().iterator();
            while (indexIt.hasNext()) {
                IndexProxyOracle indexProxy = (IndexProxyOracle)indexIt.next();
                if (!indexProxy.isPartitioned()) continue;
                this.setIndexPartitioningInfo(sqlConnection, indexProxy, storageDesign);
            }
        }
        if (this.indpartype_st != null) {
            this.indpartype_st.close();
        }
        if (this.indglobpartcols_st != null) {
            this.indglobpartcols_st.close();
        }
        if (this.indpart_st != null) {
            this.indpart_st.close();
        }
    }

    private void setIndexPartitioningInfo(Connection sqlConnection, IndexProxyOracle indexProxy, StorageDesignOracle storageDesign) throws SQLException {
        UserOracle user = indexProxy.getUser();
        String ownerName = "";
        if (user != null) {
            ownerName = user.getName();
        } else {
            SchemaObject schema = indexProxy.getIndex().getSchemaObject();
            if (schema != null) {
                ownerName = schema.getName();
            }
        }
        if (this.indpartype_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("LOCALITY").append(',');
            buffer.append("PARTITIONING_TYPE").append(',');
            buffer.append("PARTITION_COUNT").append(',');
            buffer.append("DEF_TABLESPACE_NAME").append(',');
            buffer.append("DEF_PCT_FREE").append(',');
            buffer.append("DEF_INI_TRANS").append(',');
            buffer.append("DEF_MAX_TRANS").append(',');
            buffer.append("DEF_INITIAL_EXTENT").append(',');
            buffer.append("DEF_NEXT_EXTENT").append(',');
            buffer.append("DEF_MIN_EXTENTS").append(',');
            buffer.append("DEF_MAX_EXTENTS").append(',');
            buffer.append("DEF_PCT_INCREASE").append(',');
            buffer.append("DEF_FREELISTS").append(',');
            buffer.append("DEF_FREELIST_GROUPS").append(',');
            buffer.append("DEF_LOGGING").append(',');
            buffer.append("DEF_BUFFER_POOL").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_part_indexes" : "all_part_indexes").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("INDEX_NAME").append('=').append(' ').append('?').append(' ');
            String sql = buffer.toString();
            this.indpartype_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.indpartype_st.setString(1, ownerName);
            this.indpartype_st.setString(2, indexProxy.getName());
            rs = this.indpartype_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setIndexPartitioningInfo():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                String partitionType = "";
                String locality = rs.getString("LOCALITY");
                if ("LOCAL".equalsIgnoreCase(locality)) {
                    partitionType = "LOCAL";
                    this.setPartitionType(indexProxy, partitionType);
                    this.setIndexTableSpace(indexProxy, storageDesign, rs.getString("DEF_TABLESPACE_NAME"));
                    this.setDefIndexProperties(indexProxy, storageDesign, rs);
                } else if ("GLOBAL".equalsIgnoreCase(locality)) {
                    IndexGlobalPartitionsListOracle igpl = storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    indexProxy.setIndexGlobalPartitionsList(igpl);
                    igpl.setIndex(indexProxy);
                    if (storageDesign instanceof StorageDesignOraclev10g) {
                        String partitioningType = rs.getString("PARTITIONING_TYPE");
                        if (partitioningType.equalsIgnoreCase("RANGE")) {
                            partitionType = "GLOBAL BY RANGE";
                        } else {
                            partitionType = "GLOBAL HASH PARTITIONED BY QUANTITY";
                            ((IndexGlobalPartitionsListOraclev10g)igpl).setHashPQuantity(rs.getInt("PARTITION_COUNT"));
                        }
                    } else {
                        partitionType = "GLOBAL";
                    }
                    this.setPartitionType(indexProxy, partitionType);
                    if (this.indglobpartcols_st == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("COLUMN_NAME").append(',');
                        buffer.append("COLUMN_POSITION").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_part_key_columns" : "all_part_key_columns").append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
                        buffer.append("AND").append(' ');
                        buffer.append("NAME").append('=').append(' ').append('?').append(' ');
                        buffer.append("AND").append(' ');
                        buffer.append("OBJECT_TYPE").append('=').append('\'');
                        buffer.append("INDEX").append('\'').append(' ');
                        buffer.append("ORDER BY").append(' ');
                        buffer.append("COLUMN_POSITION");
                        String sql = buffer.toString();
                        this.indglobpartcols_st = sqlConnection.prepareStatement(sql);
                    }
                    ResultSet indglobpartcols_rs = null;
                    try {
                        this.indglobpartcols_st.setString(1, ownerName);
                        this.indglobpartcols_st.setString(2, indexProxy.getName());
                        indglobpartcols_rs = this.indglobpartcols_st.executeQuery();
                    }
                    catch (Exception e) {
                        LOGGER.error("MOHTableOracle.setIndexPartitioningInfo():", e);
                    }
                    if (indglobpartcols_rs != null) {
                        while (indglobpartcols_rs.next()) {
                            String name = indglobpartcols_rs.getString("COLUMN_NAME");
                            igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(name));
                        }
                        indglobpartcols_rs.close();
                    }
                }
                if (partitionType.equals("LOCAL") || partitionType.equals("GLOBAL BY RANGE") || partitionType.equals("GLOBAL")) {
                    this.initIndexPartitioning(sqlConnection, indexProxy, partitionType);
                }
            }
            rs.close();
        }
    }

    private void setPartitionType(IndexProxyOracle indexProxy, String partitionType) {
        boolean pk = indexProxy instanceof PKProxyOracle;
        boolean uk = indexProxy instanceof UniqueOracle;
        if (pk || uk) {
            if (indexProxy instanceof PKProxyOraclev9i || indexProxy instanceof UniqueOraclev9i) {
                if (partitionType.equals("LOCAL")) {
                    partitionType = "LOCAL PARTITIONED";
                } else if (partitionType.startsWith("GLOBAL")) {
                    partitionType = "GLOBAL PARTITIONED";
                }
            }
            if (pk) {
                ((PKProxyOracle)indexProxy).setUsingIndex(partitionType);
            } else {
                ((UniqueOracle)indexProxy).setUsingIndex(partitionType);
            }
        } else {
            indexProxy.setIndexPartitioned(partitionType);
        }
    }

    private void setUser(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, String userName) {
        UserOracle user = (UserOracle)storageDesign.getUserSet().getByName(userName);
        tableProxy.setUser(user);
    }

    private void setTableSpace(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, String tsName) throws Exception {
        if (tsName != null && !"".equalsIgnoreCase(tsName)) {
            if (tableProxy.getTemporary().equals("NO")) {
                TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                if (tableSpace == null) {
                    tableSpace = storageDesign.getTableSpaceSet().createTableSpace();
                    tableSpace.setName(tsName);
                    this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                }
                tableProxy.setTableSpace(tableSpace);
            } else {
                TemporaryTablespaceOracle tableSpace = (TemporaryTablespaceOracle)storageDesign.getTemporaryTablespaceSet().getByName(tsName);
                if (tableSpace == null) {
                    tableSpace = storageDesign.getTemporaryTablespaceSet().createTemporaryTablespace();
                    tableSpace.setName(tsName);
                    this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                }
                tableProxy.setTemporaryTablespace(tableSpace);
            }
        }
    }

    private void setCluster(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        ClusterOracle cluster;
        String clusterName = resultSet.getString("CLUSTER_NAME");
        if (clusterName != null && !"".equalsIgnoreCase(clusterName) && (cluster = (ClusterOracle)storageDesign.getClusterSet().getByName(clusterName)) != null) {
            tableProxy.setCluster(cluster);
            this.containsClusterRefs = true;
        }
    }

    private void setProperties(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        String logging = resultSet.getString("LOGGING");
        String parallel = resultSet.getString("DEGREE");
        String partitioned = resultSet.getString("PARTITIONED");
        String temporary = resultSet.getString("TEMPORARY");
        String duration = resultSet.getString("DURATION");
        String cache = resultSet.getString("CACHE");
        String rowMovement = resultSet.getString("ROW_MOVEMENT");
        String monitoring = null;
        String compression = null;
        String dependencies = null;
        if (storageDesign instanceof StorageDesignOraclev9i) {
            monitoring = resultSet.getString("MONITORING");
        } else {
            compression = resultSet.getString("COMPRESSION");
            dependencies = resultSet.getString("DEPENDENCIES");
        }
        String iotType = resultSet.getString("IOT_TYPE");
        if (iotType != null) {
            tableProxy.setOrganization("INDEX");
        }
        if ("YES".equalsIgnoreCase(partitioned.trim())) {
            this.isPartitioned = true;
            tableProxy.setPartitioned("YES");
        } else {
            tableProxy.setPartitioned("NO");
            if (iotType == null) {
                SegmentOracle tsegment;
                SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
                int iniTrans = resultSet.getInt("INI_TRANS");
                int maxTrans = resultSet.getInt("MAX_TRANS");
                long initialExtent = resultSet.getLong("INITIAL_EXTENT");
                long nextExtent = resultSet.getLong("NEXT_EXTENT");
                int minExtents = Integer.MAX_VALUE;
                String maxExtents = "";
                try {
                    minExtents = resultSet.getInt("MIN_EXTENTS");
                }
                catch (Exception e) {
                    LOGGER.error("error in min_extent", e);
                }
                try {
                    maxExtents = resultSet.getString("MAX_EXTENTS");
                }
                catch (Exception e) {
                    LOGGER.error("error in max_extent", e);
                }
                int pctIncrease = resultSet.getInt("PCT_INCREASE");
                int freeLists = resultSet.getInt("FREELISTS");
                int freeListGroups = resultSet.getInt("FREELIST_GROUPS");
                int pctFree = resultSet.getInt("PCT_FREE");
                int pctUsed = resultSet.getInt("PCT_USED");
                String bufferPool = resultSet.getString("BUFFER_POOL");
                if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
                    segment.setInitrans(iniTrans);
                    segment.setMaxTrans(maxTrans);
                }
                if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                    segment.setSCInitialExtent(initialExtent);
                }
                if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                    segment.setSCNextExtent(nextExtent);
                }
                if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                    segment.setSCMinExtents(minExtents);
                }
                if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                    segment.setSCMaxExtents(String.valueOf(maxExtents));
                }
                if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                    segment.setSCPctIncrease(pctIncrease);
                }
                if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                    segment.setSCFreeLists(freeLists);
                }
                if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                    segment.setSCFreelistGroups(freeListGroups);
                }
                if ((pctFree > 0 || resultSet.getObject("PCT_FREE") != null) && segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
                    segment.setPCTFree(pctFree);
                }
                if (pctUsed > 0 && segment.getAppView().getSettings().isIncludePctUsedInDDL()) {
                    segment.setPCTUsed(pctUsed);
                }
                if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                    segment.setSCBufferPool(bufferPool.trim().toUpperCase());
                }
                if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                    segment.remove(true);
                }
                segment = tsegment;
                tableProxy.setSegment(segment);
            }
        }
        if (logging != null) {
            tableProxy.setLogging(logging.trim().toUpperCase());
        }
        if ("ENABLED".equalsIgnoreCase(compression)) {
            String compressFor;
            tableProxy.setDataSegmentCompression("YES");
            if (storageDesign instanceof StorageDesignOraclev11g && (compressFor = resultSet.getString("COMPRESS_FOR")) != null) {
                ((TableProxyOraclev11g)tableProxy).setCompressionType(compressFor);
            }
        }
        if ("ENABLED".equalsIgnoreCase(dependencies)) {
            tableProxy.setRowDependency("YES");
        }
        if ("1".equals(parallel.trim())) {
            tableProxy.setParallel("NO");
        } else {
            tableProxy.setParallel("YES");
            tableProxy.setDegree(parallel.trim());
        }
        if ("Y".equalsIgnoreCase(temporary.trim())) {
            tableProxy.setTemporary("YES");
            if ("SYS$TRANSACTION".equalsIgnoreCase(duration)) {
                tableProxy.setTempPreserveRows("NO");
            } else {
                tableProxy.setTempPreserveRows("YES");
            }
        } else {
            tableProxy.setTemporary("NO");
        }
        if ("YES".equalsIgnoreCase(monitoring)) {
            tableProxy.setMonitoring("YES");
        } else {
            tableProxy.setMonitoring("NO");
        }
        if ("DISABLED".equalsIgnoreCase(rowMovement)) {
            tableProxy.setParttitionedRowMovement("DISABLE");
        } else {
            tableProxy.setParttitionedRowMovement("ENABLE");
        }
        if (cache != null && "Y".equalsIgnoreCase(cache.trim())) {
            tableProxy.setCache("YES");
        } else {
            tableProxy.setCache("NO");
        }
    }

    private void setOverflowProperties(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        SegmentOracle tsegment;
        String tablespaceName = resultSet.getString("TABLESPACE_NAME");
        if (tablespaceName != null && !"".equalsIgnoreCase(tablespaceName)) {
            TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName);
            if (tablespace == null) {
                tablespace = storageDesign.getTableSpaceSet().createTableSpace();
                tablespace.setName(tablespaceName);
                this.stampModelObject((ModelObject)tablespace, tableProxy, tablespaceName);
            }
            tableProxy.setIotOverflowTablespace(tablespace);
        }
        int iniTrans = resultSet.getInt("INI_TRANS");
        int maxTrans = resultSet.getInt("MAX_TRANS");
        long initialExtent = resultSet.getLong("INITIAL_EXTENT");
        long nextExtent = resultSet.getLong("NEXT_EXTENT");
        int minExtents = Integer.MAX_VALUE;
        String maxExtents = "";
        try {
            minExtents = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in min_extent", e);
        }
        try {
            maxExtents = resultSet.getString("MAX_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in max_extent", e);
        }
        int pctIncrease = resultSet.getInt("PCT_INCREASE");
        int freeLists = resultSet.getInt("FREELISTS");
        int freeListGroups = resultSet.getInt("FREELIST_GROUPS");
        int pctFree = resultSet.getInt("PCT_FREE");
        int pctUsed = resultSet.getInt("PCT_USED");
        String bufferPool = resultSet.getString("BUFFER_POOL");
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
            segment.setSCInitialExtent(initialExtent);
        }
        if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
            segment.setSCNextExtent(nextExtent);
        }
        if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
            segment.setSCMinExtents(minExtents);
        }
        if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(String.valueOf(maxExtents));
        }
        if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
            segment.setSCPctIncrease(pctIncrease);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("PCT_FREE") != null) && segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (pctUsed > 0 && segment.getAppView().getSettings().isIncludePctUsedInDDL()) {
            segment.setPCTUsed(pctUsed);
        }
        if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim().toUpperCase());
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        tableProxy.setIotOverflowSegment(segment);
        String logging = resultSet.getString("LOGGING");
        if (logging != null) {
            tableProxy.setIotOverflowLogging(logging.trim());
        }
    }

    private void setDefProperties(TableProxyOracle tableProxy, StorageDesignOracle storageDesign, ResultSet resultSet) throws Exception {
        SegmentOracle tsegment;
        SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
        int iniTrans = resultSet.getInt("DEF_INI_TRANS");
        int maxTrans = resultSet.getInt("DEF_MAX_TRANS");
        String initialExtent = resultSet.getString("DEF_INITIAL_EXTENT");
        String nextExtent = resultSet.getString("DEF_NEXT_EXTENT");
        String minExtents = resultSet.getString("DEF_MIN_EXTENTS");
        String maxExtents = resultSet.getString("DEF_MAX_EXTENTS");
        String pctIncrease = resultSet.getString("DEF_PCT_INCREASE");
        int freeLists = resultSet.getInt("DEF_FREELISTS");
        int freeListGroups = resultSet.getInt("DEF_FREELIST_GROUPS");
        int pctFree = resultSet.getInt("DEF_PCT_FREE");
        int pctUsed = resultSet.getInt("DEF_PCT_USED");
        String bufferPool = resultSet.getString("DEF_BUFFER_POOL");
        String logging = resultSet.getString("DEF_LOGGING");
        String compression = null;
        if (!(storageDesign instanceof StorageDesignOraclev9i)) {
            compression = resultSet.getString("DEF_COMPRESSION");
        }
        if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
            segment.setInitrans(iniTrans);
            segment.setMaxTrans(maxTrans);
        }
        try {
            if (initialExtent != null && !initialExtent.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                segment.setSCInitialExtent(Long.parseLong(initialExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_INITIAL_EXTENT", e);
        }
        try {
            if (nextExtent != null && !nextExtent.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                segment.setSCNextExtent(Long.parseLong(nextExtent.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_NEXT_EXTENT", e);
        }
        try {
            if (minExtents != null && !minExtents.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                segment.setSCMinExtents(Integer.parseInt(minExtents.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_MIN_EXTENTS", e);
        }
        if (maxExtents != null && !maxExtents.equals("DEFAULT") && segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
            segment.setSCMaxExtents(maxExtents.trim());
        }
        try {
            if (pctIncrease != null && !pctIncrease.equals("DEFAULT") && segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                segment.setSCPctIncrease(Integer.parseInt(pctIncrease.trim()));
            }
        }
        catch (Exception e) {
            LOGGER.error("error in DEF_PCT_INCREASE", e);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
            segment.setSCFreeLists(freeLists);
        }
        if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
            segment.setSCFreelistGroups(freeListGroups);
        }
        if ((pctFree > 0 || resultSet.getObject("DEF_PCT_FREE") != null) && segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
            segment.setPCTFree(pctFree);
        }
        if (pctUsed > 0 && segment.getAppView().getSettings().isIncludePctUsedInDDL()) {
            segment.setPCTUsed(pctUsed);
        }
        if (bufferPool != null && segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
            segment.setSCBufferPool(bufferPool.trim().toUpperCase());
        }
        if (logging != null) {
            tableProxy.setLogging(logging.trim().toUpperCase());
        }
        if ("ENABLED".equalsIgnoreCase(compression)) {
            String compressFor;
            tableProxy.setDataSegmentCompression("YES");
            if (storageDesign instanceof StorageDesignOraclev11g && (compressFor = resultSet.getString("DEF_COMPRESS_FOR")) != null) {
                ((TableProxyOraclev11g)tableProxy).setCompressionType(compressFor);
            }
        }
        if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
            segment.remove(true);
        }
        segment = tsegment;
        tableProxy.setSegment(segment);
    }

    private void setPartitionInfo(Connection sqlConnection, StorageDesignOracle storageDesign, List dbos) throws Exception {
        this.part_statement = null;
        this.partLS_statement = null;
        this.subpartCol_statement = null;
        this.subpartTemplate_statement = null;
        this.subPart_statement = null;
        this.subPartLS_statement = null;
        this.subPartListLS_statement = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("COLUMN_POSITION").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_part_key_columns" : "all_part_key_columns").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("OBJECT_TYPE").append('=').append('\'');
        buffer.append("TABLE").append('\'').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("COLUMN_POSITION");
        String col_sql = buffer.toString();
        Statement col_statement = null;
        boolean oraclev9i = storageDesign instanceof StorageDesignOraclev9i;
        boolean oraclev11g = storageDesign instanceof StorageDesignOraclev11g;
        buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("PARTITIONING_TYPE").append(',');
        buffer.append("SUBPARTITIONING_TYPE").append(',');
        buffer.append("PARTITION_COUNT").append(',');
        buffer.append("DEF_SUBPARTITION_COUNT").append(',');
        buffer.append("DEF_TABLESPACE_NAME").append(',');
        buffer.append("DEF_PCT_FREE").append(',');
        buffer.append("DEF_PCT_USED").append(',');
        buffer.append("DEF_INI_TRANS").append(',');
        buffer.append("DEF_MAX_TRANS").append(',');
        buffer.append("DEF_INITIAL_EXTENT").append(',');
        buffer.append("DEF_NEXT_EXTENT").append(',');
        buffer.append("DEF_MIN_EXTENTS").append(',');
        buffer.append("DEF_MAX_EXTENTS").append(',');
        buffer.append("DEF_PCT_INCREASE").append(',');
        buffer.append("DEF_FREELISTS").append(',');
        buffer.append("DEF_FREELIST_GROUPS").append(',');
        buffer.append("DEF_LOGGING").append(',');
        if (!oraclev9i) {
            buffer.append("DEF_COMPRESSION").append(',');
            if (oraclev11g) {
                buffer.append("DEF_COMPRESS_FOR").append(',');
                buffer.append("REF_PTN_CONSTRAINT_NAME").append(',');
                buffer.append("INTERVAL").append(',');
            }
        }
        buffer.append("DEF_BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_part_tables" : "all_part_tables").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("TABLE_NAME");
        String sql = buffer.toString();
        PreparedStatement statement = null;
        for (DBObject dbo : dbos) {
            if (!dbo.partitioned) continue;
            TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
            String owner = dbo.getSchema();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, tableProxy.getName());
                rs = statement.executeQuery();
                if (rs == null) continue;
                while (rs.next()) {
                    this.setTableSpace(tableProxy, storageDesign, rs.getString("DEF_TABLESPACE_NAME"));
                    if (tableProxy.getSnapshot() != null) {
                        tableProxy.getSnapshot().setTablespace(tableProxy.getTableSpace());
                    }
                    this.setDefProperties(tableProxy, storageDesign, rs);
                    String part_type = rs.getString("PARTITIONING_TYPE").trim();
                    String subPartType = rs.getString("SUBPARTITIONING_TYPE").trim();
                    int partCount = rs.getInt("PARTITION_COUNT");
                    PartitionListOracle partitionList = storageDesign.getPartitionListSet().createPartitionList();
                    if ("HASH".equalsIgnoreCase(part_type)) {
                        partitionList.setPartitionType("HASH BY LIST OF PARTITIONS");
                        partitionList.setHashPQuantity(partCount);
                    } else if ("HASH".equalsIgnoreCase(subPartType) && !oraclev11g) {
                        partitionList.setPartitionType("COMPOSITE BY HASH");
                    } else if ("LIST".equalsIgnoreCase(subPartType) && !oraclev11g) {
                        partitionList.setPartitionType("COMPOSITE BY LIST");
                    } else {
                        partitionList.setPartitionType(part_type);
                    }
                    if ("HASH".equalsIgnoreCase(subPartType)) {
                        int subpartCount = rs.getInt("DEF_SUBPARTITION_COUNT");
                        partitionList.setSubPartitionsQuantity(subpartCount);
                    }
                    if (oraclev11g) {
                        String refConstraint;
                        partitionList.setSubpartitionType(subPartType);
                        String intervalExp = rs.getString("INTERVAL");
                        if (intervalExp != null) {
                            ((PartitionListOraclev11g)partitionList).setIntervalExpression(intervalExp);
                        }
                        if ((refConstraint = rs.getString("REF_PTN_CONSTRAINT_NAME")) != null) {
                            partitionList.setTable(tableProxy);
                            ((PartitionListOraclev11g)partitionList).setRefConstraint(refConstraint);
                        }
                    }
                    tableProxy.setPartitionList(partitionList);
                    if (col_statement == null) {
                        col_statement = sqlConnection.prepareStatement(col_sql);
                    }
                    this.setPartitioningColumns(tableProxy.getName(), owner, partitionList, (PreparedStatement)col_statement);
                    if (!"NONE".equalsIgnoreCase(subPartType) && !"SYSTEM".equalsIgnoreCase(subPartType)) {
                        this.setSubPartitioningColumns(tableProxy, tableProxy.getName(), owner, partitionList, sqlConnection);
                    }
                    if (partCount <= 0) continue;
                    this.setPartitions(tableProxy, owner, storageDesign, partitionList, sqlConnection, part_type);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.setPartitionInfo():", e);
            }
        }
        if (this.subPart_statement != null) {
            this.subPart_statement.close();
        }
        if (this.subpartCol_statement != null) {
            this.subpartCol_statement.close();
        }
        if (this.subpartTemplate_statement != null) {
            this.subpartTemplate_statement.close();
        }
        if (this.partLS_statement != null) {
            this.partLS_statement.close();
        }
        if (this.subPartLS_statement != null) {
            this.subPartLS_statement.close();
        }
        if (this.subPartListLS_statement != null) {
            this.subPartListLS_statement.close();
        }
        if (this.part_statement != null) {
            this.part_statement.close();
        }
        if (col_statement != null) {
            col_statement.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setPartitioningColumns(String tbName, String owner, PartitionListOracle partitionList, PreparedStatement statement) throws Exception {
        ResultSet rs = null;
        try {
            statement.setString(1, owner);
            statement.setString(2, tbName);
            rs = statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setPartitioningColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                partitionList.setColumnList(name);
            }
            rs.close();
        }
    }

    private void setSubPartitioningColumns(TableProxyOracle tableProxy, String tbName, String owner, PartitionListOracle partitionList, Connection sqlConnection) throws Exception {
        if (this.subpartCol_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("COLUMN_POSITION").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_subpart_key_columns" : "all_subpart_key_columns").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("OBJECT_TYPE").append('=').append('\'');
            buffer.append("TABLE").append('\'').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("COLUMN_POSITION");
            String sql = buffer.toString();
            this.subpartCol_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.subpartCol_statement.setString(1, owner);
            this.subpartCol_statement.setString(2, tbName);
            rs = this.subpartCol_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitioningColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                partitionList.setSubPartitionsColumnList(name);
            }
            rs.close();
            this.setSubPartitionTemplate(tableProxy, tbName, owner, partitionList, sqlConnection);
        }
    }

    private void setSubPartitionTemplate(TableProxyOracle tableProxy, String tbName, String owner, PartitionListOracle partitionList, Connection sqlConnection) throws Exception {
        if (this.subpartTemplate_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("SUBPARTITION_NAME").append(',').append(' ');
            buffer.append("SUBPARTITION_POSITION").append(',').append(' ');
            buffer.append("TABLESPACE_NAME").append(',').append(' ');
            buffer.append("HIGH_BOUND").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_subpartition_templates" : "all_subpartition_templates").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("USER_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("SUBPARTITION_POSITION");
            String sql = buffer.toString();
            this.subpartTemplate_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.subpartTemplate_statement.setString(1, owner);
            this.subpartTemplate_statement.setString(2, tbName);
            rs = this.subpartTemplate_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitionTemplate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                AbstractStorageObjectOracle template;
                String partName = rs.getString(1);
                String tsName = rs.getString(3);
                StorageDesignOracle stdes = (StorageDesignOracle)tableProxy.getStorageDesign();
                TableSpaceOracle tableSpace = null;
                if (tsName != null && (tableSpace = (TableSpaceOracle)stdes.getTableSpaceSet().getByName(tsName)) == null) {
                    tableSpace = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                    tableSpace.setName(tsName);
                    this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                }
                String highBound = rs.getString(4);
                String subpartitionType = partitionList.getSubpartitionType();
                if (subpartitionType.equals("HASH")) {
                    HashPartitionOracle partition = stdes.getHashPartitionSet().createHashPartition();
                    partition.setName(partName);
                    partition.setPartOfStorageTable(tableProxy);
                    if (tableSpace != null) {
                        partition.setTableSpace(tableSpace);
                    }
                } else if (subpartitionType.equals("LIST")) {
                    template = stdes.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    template.setName(partName);
                    ((ListStorageTemplatePartitionOracle)template).setPartOfStorageTable(tableProxy);
                    if (highBound != null) {
                        ((ListStorageTemplatePartitionOracle)template).setValueList(highBound);
                    }
                    if (tableSpace != null) {
                        ((ListStorageTemplatePartitionOracle)template).setTablespace(tableSpace);
                    }
                } else if (subpartitionType.equals("RANGE")) {
                    template = (PartitionOraclev11g)stdes.getPartitionSet().createPartition();
                    template.setName(partName);
                    ((PartitionOraclev11g)template).setPartOfStorageTable(tableProxy);
                    if (highBound != null) {
                        ((PartitionOracle)template).setValueList(highBound);
                    }
                    if (tableSpace != null) {
                        ((PartitionOracle)template).setTableSpace(tableSpace);
                    }
                }
                ((PartitionListOraclev9i)partitionList).setUseSubpartStorageTemplate("YES");
            }
            rs.close();
        }
    }

    private void setPartitions(TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, PartitionListOracle partitionList, Connection sqlConnection, String part_type) throws Exception {
        block42: {
            boolean list = "LIST".equals(part_type);
            boolean partTypeHash = "HASH".equals(part_type);
            if (this.part_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("PARTITION_NAME").append(',');
                buffer.append("SUBPARTITION_COUNT").append(',');
                buffer.append("HIGH_VALUE").append(',');
                buffer.append("TABLESPACE_NAME").append(',');
                buffer.append("PCT_FREE").append(',');
                buffer.append("PCT_USED").append(',');
                buffer.append("INI_TRANS").append(',');
                buffer.append("MAX_TRANS").append(',');
                buffer.append("INITIAL_EXTENT").append(',');
                buffer.append("NEXT_EXTENT").append(',');
                buffer.append("MIN_EXTENT").append(',');
                buffer.append("MAX_EXTENT").append(',');
                buffer.append("PCT_INCREASE").append(',');
                buffer.append("FREELISTS").append(',');
                buffer.append("FREELIST_GROUPS").append(',');
                buffer.append("LOGGING").append(',');
                buffer.append("COMPRESSION").append(',');
                buffer.append("BUFFER_POOL").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_tab_partitions" : "all_tab_partitions").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("PARTITION_POSITION");
                String sql = buffer.toString();
                this.part_statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                this.part_statement.setString(1, owner);
                this.part_statement.setString(2, tableProxy.getName());
                rs = this.part_statement.executeQuery();
                if (rs == null) break block42;
                boolean hasLobColumns = this.hasLobColumns(tableProxy);
                boolean potentialHashByQuantity = false;
                StorageObject hashPartTablespace = null;
                int position = 0;
                while (rs.next()) {
                    SegmentOracle tsegment;
                    ++position;
                    String name = rs.getString("PARTITION_NAME");
                    int subPartCount = rs.getInt("SUBPARTITION_COUNT");
                    String high_value = rs.getString("HIGH_VALUE");
                    String tsName = rs.getString("TABLESPACE_NAME");
                    int pct_free = rs.getInt("PCT_FREE");
                    String pctUsed = rs.getString("PCT_USED");
                    int pct_used = 40;
                    if (pctUsed != null) {
                        try {
                            pct_used = Integer.parseInt(pctUsed);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    int ini_trans = rs.getInt("INI_TRANS");
                    int max_trans = rs.getInt("MAX_TRANS");
                    long initial_extent = rs.getLong("INITIAL_EXTENT");
                    long next_extent = rs.getLong("NEXT_EXTENT");
                    int min_extent = rs.getInt("MIN_EXTENT");
                    int max_extent = rs.getInt("MAX_EXTENT");
                    int pct_increase = rs.getInt("PCT_INCREASE");
                    int freeLists = rs.getInt("FREELISTS");
                    int freeListGroups = rs.getInt("FREELIST_GROUPS");
                    String logging = rs.getString("LOGGING");
                    String compression = rs.getString("COMPRESSION");
                    String buffer_pool = rs.getString("BUFFER_POOL");
                    TableSpaceOracle tableSpace = null;
                    if (tsName != null && !"".equalsIgnoreCase(tsName) && (tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName)) == null) {
                        tableSpace = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                        tableSpace.setName(tsName);
                        this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                    }
                    if (partTypeHash) {
                        HashPartitionOracle hashPartition = storageDesign.getHashPartitionSet().createHashPartition();
                        hashPartition.setName(name);
                        hashPartition.setPartitionList(partitionList);
                        hashPartition.setTableSpace(tableSpace);
                        if (hasLobColumns) {
                            this.setPartitionLobStorage(hashPartition, tableProxy, owner, storageDesign, sqlConnection);
                        }
                        if (name.startsWith("SYS_P")) {
                            if (position == 1) {
                                hashPartTablespace = tableSpace;
                                potentialHashByQuantity = true;
                                continue;
                            }
                            if (hashPartTablespace == tableSpace) continue;
                            potentialHashByQuantity = false;
                            continue;
                        }
                        potentialHashByQuantity = false;
                        continue;
                    }
                    SegmentOracle segment = storageDesign.getSegmentSet().createSegment();
                    if (segment.getAppView().getSettings().isIncludePctFreeInDDL()) {
                        segment.setPCTFree(pct_free);
                    }
                    if (segment.getAppView().getSettings().isIncludePctUsedInDDL()) {
                        segment.setPCTUsed(pct_used);
                    }
                    if (segment.getAppView().getSettings().isIncludeInitransInDDL()) {
                        segment.setInitrans(ini_trans);
                        segment.setMaxTrans(max_trans);
                    }
                    if (segment.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                        segment.setSCInitialExtent(initial_extent);
                    }
                    if (segment.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                        segment.setSCNextExtent(next_extent);
                    }
                    if (segment.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                        segment.setSCMinExtents(min_extent);
                    }
                    if (segment.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                        segment.setSCMaxExtents(String.valueOf(max_extent));
                    }
                    if (segment.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                        segment.setSCPctIncrease(pct_increase);
                    }
                    if (segment.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                        segment.setSCFreeLists(freeLists);
                    }
                    if (segment.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                        segment.setSCFreelistGroups(freeListGroups);
                    }
                    if (segment.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                        segment.setSCBufferPool(buffer_pool);
                    }
                    if ((tsegment = storageDesign.getSegmentSet().findEqual(segment)) != segment) {
                        segment.remove(true);
                    }
                    segment = tsegment;
                    if (list) {
                        ListPartitionOracle lpart = storageDesign.getListPartitionSet().createListPartition();
                        lpart.setName(name);
                        lpart.setPartitionList(partitionList);
                        lpart.setPosition(position);
                        lpart.setColumns(high_value);
                        if (tableSpace != null) {
                            lpart.setTablespace(tableSpace);
                        }
                        if (!"NONE".equalsIgnoreCase(logging)) {
                            lpart.setLogging(logging);
                        }
                        if ("ENABLED".equalsIgnoreCase(compression)) {
                            lpart.setDataSegmentCompression("YES");
                        } else if ("DISABLED".equalsIgnoreCase(compression)) {
                            lpart.setDataSegmentCompression("NO");
                        }
                        lpart.setSegment(segment);
                        if (hasLobColumns) {
                            this.setPartitionLobStorage(lpart, tableProxy, owner, storageDesign, sqlConnection);
                        }
                        if (subPartCount <= 0) continue;
                        if (partitionList.getSubpartitionType().equals("HASH") && lpart instanceof ListPartitionOraclev11g) {
                            ((ListPartitionOraclev11g)lpart).setSubPartitionsQuantity(subPartCount);
                        }
                        this.setSubPartitions(lpart, tableProxy, owner, storageDesign, partitionList, sqlConnection, hasLobColumns);
                        continue;
                    }
                    PartitionOracle partition = storageDesign.getPartitionSet().createPartition();
                    partition.setName(name);
                    partition.setPartitionList(partitionList);
                    partition.setPosition(position);
                    if (high_value != null) {
                        partition.setValueList(high_value);
                    }
                    if (tableSpace != null) {
                        partition.setTableSpace(tableSpace);
                    }
                    if (!"NONE".equalsIgnoreCase(logging)) {
                        partition.setLogging(logging);
                    }
                    if ("ENABLED".equalsIgnoreCase(compression)) {
                        partition.setDataSegmentCompression("YES");
                    } else if ("DISABLED".equalsIgnoreCase(compression)) {
                        partition.setDataSegmentCompression("NO");
                    }
                    partition.setSegment(segment);
                    if (hasLobColumns) {
                        this.setPartitionLobStorage(partition, tableProxy, owner, storageDesign, sqlConnection);
                    }
                    if (subPartCount <= 0) continue;
                    if (partitionList.getSubpartitionType().equals("HASH")) {
                        partition.setSubPartitionsQuantity(subPartCount);
                    }
                    this.setSubPartitions(partition, tableProxy, owner, storageDesign, partitionList, sqlConnection, hasLobColumns);
                }
                rs.close();
                if (potentialHashByQuantity) {
                    partitionList.setPartitionType("HASH BY QUANTITY");
                    if (hashPartTablespace != tableProxy.getTableSpace()) {
                        partitionList.setHashPTableSpaces(hashPartTablespace.getName());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.setPartitions():", e);
            }
        }
    }

    private boolean hasLobColumns(TableProxy tableProxy) {
        Table table = (Table)tableProxy.getObject();
        for (Column column : table.getElementsCollection()) {
            String type = column.getDatatypeString(tableProxy.getRDBMSType().getName()).toUpperCase();
            if (type.indexOf("BLOB") <= -1 && type.indexOf("CLOB") <= -1 && type.indexOf("BFILE") <= -1) continue;
            return true;
        }
        return false;
    }

    private void setSubPartitions(AbstractStorageObjectOracle partition, TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, PartitionListOracle partitionList, Connection sqlConnection, boolean hasLobColumns) throws Exception {
        boolean oraclev11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        if (this.subPart_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("SUBPARTITION_NAME").append(',');
            buffer.append("HIGH_VALUE").append(',');
            if (oraclev11g) {
                buffer.append("COMPRESSION").append(',');
            }
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_tab_subpartitions" : "all_tab_subpartitions").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("PARTITION_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("SUBPARTITION_POSITION");
            String sql = buffer.toString();
            this.subPart_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.subPart_statement.setString(1, owner);
            this.subPart_statement.setString(2, tableProxy.getName());
            this.subPart_statement.setString(3, partition.getName());
            rs = this.subPart_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitions():", e);
        }
        if (rs != null) {
            String subpartitionType = partitionList.getSubpartitionType();
            boolean potentialHashByQuantity = false;
            StorageObject hashPartTablespace = null;
            int position = 0;
            while (rs.next()) {
                ++position;
                String name = rs.getString("SUBPARTITION_NAME");
                String highValue = rs.getString("HIGH_VALUE");
                String compression = "";
                if (oraclev11g) {
                    compression = rs.getString("COMPRESSION");
                }
                String tsName = rs.getString("TABLESPACE_NAME");
                TableSpaceOracle tableSpace = null;
                if (tsName != null && !"".equalsIgnoreCase(tsName) && (tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName)) == null) {
                    tableSpace = ((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().createTableSpace();
                    tableSpace.setName(tsName);
                    this.stampModelObject((ModelObject)tableSpace, tableProxy, tsName);
                }
                if (subpartitionType.equals("HASH")) {
                    HashPartitionOracle hashPartition = storageDesign.getHashPartitionSet().createHashPartition();
                    hashPartition.setName(name);
                    hashPartition.setSubPartitionOf(partition);
                    hashPartition.setTableSpace(tableSpace);
                    if (hasLobColumns) {
                        this.setSubPartitionLobStorage(hashPartition, tableProxy, owner, storageDesign, sqlConnection);
                    }
                    if (name.startsWith("SYS_SUBP")) {
                        if (position == 1) {
                            hashPartTablespace = tableSpace;
                            potentialHashByQuantity = true;
                            continue;
                        }
                        if (hashPartTablespace == tableSpace) continue;
                        potentialHashByQuantity = false;
                        continue;
                    }
                    potentialHashByQuantity = false;
                    continue;
                }
                if (subpartitionType.equals("LIST")) {
                    ListStorageTemplatePartitionOracle listPartition = storageDesign.getListStorageTemplatePartitionSet().createListStorageTemplatePartition();
                    listPartition.setName(name);
                    listPartition.setSubPartitionOf(partition);
                    listPartition.setTablespace(tableSpace);
                    if (highValue != null) {
                        listPartition.setValueList(highValue);
                    }
                    if (oraclev11g) {
                        if ("ENABLED".equalsIgnoreCase(compression)) {
                            listPartition.setDataSegmentCompression("YES");
                        } else if ("DISABLED".equalsIgnoreCase(compression)) {
                            listPartition.setDataSegmentCompression("NO");
                        }
                    }
                    if (!hasLobColumns) continue;
                    this.setSubPartitionLobStorage(listPartition, tableProxy, owner, storageDesign, sqlConnection);
                    continue;
                }
                if (!subpartitionType.equals("RANGE")) continue;
                PartitionOraclev11g rangeSubpartition = (PartitionOraclev11g)storageDesign.getPartitionSet().createPartition();
                rangeSubpartition.setName(name);
                rangeSubpartition.setSubPartitionOf(partition);
                rangeSubpartition.setTableSpace(tableSpace);
                if (highValue != null) {
                    rangeSubpartition.setValueList(highValue);
                }
                if (oraclev11g) {
                    if ("ENABLED".equalsIgnoreCase(compression)) {
                        rangeSubpartition.setDataSegmentCompression("YES");
                    } else if ("DISABLED".equalsIgnoreCase(compression)) {
                        rangeSubpartition.setDataSegmentCompression("NO");
                    }
                }
                if (!hasLobColumns) continue;
                this.setSubPartitionLobStorage(rangeSubpartition, tableProxy, owner, storageDesign, sqlConnection);
            }
            rs.close();
            if (potentialHashByQuantity) {
                if (partition instanceof PartitionOracle) {
                    PartitionOracle rangePartition = (PartitionOracle)partition;
                    rangePartition.getPartitions().removeAll();
                    if (hashPartTablespace != rangePartition.getTableSpace()) {
                        rangePartition.setSubPartitionsTableSpaces(hashPartTablespace.getName());
                    }
                } else if (partition instanceof ListPartitionOraclev11g) {
                    ListPartitionOraclev11g listPartition = (ListPartitionOraclev11g)partition;
                    listPartition.getHashSubpartitions().removeAll();
                    if (hashPartTablespace != listPartition.getTablespace()) {
                        listPartition.setSubPartitionsTableSpaces(hashPartTablespace.getName());
                    }
                }
            }
        }
    }

    private void setTableLobStorage(StorageDesignOracle storageDesign, Connection sqlConnection, List dbos) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',');
        buffer.append("SEGMENT_NAME").append(',');
        buffer.append("TABLESPACE_NAME").append(',');
        buffer.append("CHUNK").append(',');
        buffer.append("PCTVERSION").append(',');
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append("SECUREFILE").append(',');
            buffer.append("COMPRESSION").append(',');
            buffer.append("DEDUPLICATION").append(',');
        }
        buffer.append("FREEPOOLS").append(',');
        buffer.append("CACHE").append(',');
        buffer.append("LOGGING").append(',');
        buffer.append("IN_ROW").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lobs" : "all_lobs").append(' ');
        buffer.append("WHERE").append(' ').append("PARTITIONED").append(' ').append('=').append(' ');
        buffer.append('\'').append("NO").append('\'').append(' ');
        buffer.append("AND").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?');
        String sql = buffer.toString();
        if (storageDesign instanceof StorageDesignOraclev9i) {
            buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',');
            buffer.append("SEGMENT_NAME").append(',');
            buffer.append("NULL").append(' ').append("AS").append(' ').append("TABLESPACE_NAME").append(',');
            buffer.append("CHUNK").append(',');
            buffer.append("PCTVERSION").append(',');
            buffer.append("CACHE").append(',');
            buffer.append("LOGGING").append(',');
            buffer.append("IN_ROW").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lobs" : "all_lobs").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?');
            sql = buffer.toString();
        }
        Statement statement = null;
        for (DBObject dbo : dbos) {
            if (!dbo.hasLOBs) continue;
            TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, tableProxy.getName());
                rs = statement.executeQuery();
                if (rs == null) continue;
                while (rs.next()) {
                    String columnName = Token.removeQuotes(rs.getString("COLUMN_NAME"));
                    if (columnName.startsWith("SYS_NC")) continue;
                    String name = rs.getString("SEGMENT_NAME");
                    if (columnName.indexOf(46) > -1 && name.startsWith("SYS_LOB")) continue;
                    String tsName = rs.getString("TABLESPACE_NAME");
                    int chunk = rs.getInt("CHUNK");
                    int pctVersion = rs.getInt("PCTVERSION");
                    String securefile = "";
                    if (storageDesign instanceof StorageDesignOraclev11g) {
                        securefile = rs.getString("SECUREFILE");
                    }
                    String cache = rs.getString("CACHE");
                    String logging = rs.getString("LOGGING");
                    String inrow = rs.getString("IN_ROW");
                    LobStorageOracle lobStorage = storageDesign.getLobStorageSet().createLobStorage();
                    lobStorage.setName(name);
                    if (!name.startsWith("SYS_LOB")) {
                        lobStorage.setLobSegmentName(name);
                    }
                    lobStorage.setTable(tableProxy);
                    lobStorage.setColumn(columnName);
                    lobStorage.setChunk(chunk);
                    lobStorage.setPCTVersion(pctVersion);
                    if (storageDesign instanceof StorageDesignOraclev10g) {
                        lobStorage.setFreepools(rs.getInt("FREEPOOLS"));
                    }
                    if ("YES".equalsIgnoreCase(securefile)) {
                        lobStorage.setLobStorageType("SECUREFILE");
                        String compression = rs.getString("COMPRESSION");
                        if (compression.equals("HIGH") || compression.equals("MEDIUM") || compression.equals("LOW")) {
                            lobStorage.setCompression("YES");
                            lobStorage.setCompressionType(compression);
                        } else if (compression.equals("NO")) {
                            lobStorage.setCompression("NO");
                        }
                        String deduplication = rs.getString("DEDUPLICATION");
                        if (deduplication.equals("LOB")) {
                            lobStorage.setDuplication("DEDUPLICATE");
                        } else if (deduplication.equals("NO")) {
                            lobStorage.setDuplication("KEEP_DUPLICATES");
                        }
                    }
                    if ("YES".equalsIgnoreCase(cache = cache.trim())) {
                        lobStorage.setCache("CACHE");
                    } else if ("CACHEREADS".equalsIgnoreCase(cache)) {
                        lobStorage.setCache("CACHE READS");
                    } else {
                        lobStorage.setCache("NOCACHE");
                    }
                    if ("YES".equalsIgnoreCase(inrow.trim())) {
                        lobStorage.setStorageInRow("ENABLE");
                    } else {
                        lobStorage.setStorageInRow("DISABLE");
                    }
                    if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                        TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                        lobStorage.setTableSpace(tableSpace);
                    }
                    if ("NONE".equalsIgnoreCase(logging = logging.trim())) continue;
                    if ("YES".equalsIgnoreCase(securefile) && "NO".equalsIgnoreCase(logging)) {
                        lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
                        continue;
                    }
                    lobStorage.setLogging(logging);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.setTableLobStorage():", e);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setTablePartLobStorage(StorageDesignOracle storageDesign, Connection sqlConnection, List dbos) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("LOB_NAME").append(',');
        buffer.append("DEF_CHUNK").append(',');
        buffer.append("DEF_PCTVERSION").append(',');
        if (storageDesign instanceof StorageDesignOraclev11g) {
            buffer.append("DEF_SECUREFILE").append(',').append(' ');
        }
        buffer.append("DEF_CACHE").append(',');
        buffer.append("DEF_IN_ROW").append(',');
        buffer.append("DEF_TABLESPACE_NAME").append(',');
        buffer.append("DEF_INITIAL_EXTENT").append(',');
        buffer.append("DEF_NEXT_EXTENT").append(',');
        buffer.append("DEF_MIN_EXTENTS").append(',');
        buffer.append("DEF_MAX_EXTENTS").append(',');
        buffer.append("DEF_PCT_INCREASE").append(',');
        buffer.append("DEF_FREELISTS").append(',');
        buffer.append("DEF_FREELIST_GROUPS").append(',');
        buffer.append("DEF_LOGGING").append(',');
        buffer.append("DEF_BUFFER_POOL").append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? "dba_part_lobs" : "all_part_lobs").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
        buffer.append("ORDER BY").append(' ');
        buffer.append("LOB_NAME");
        String sql = buffer.toString();
        Statement statement = null;
        for (DBObject dbo : dbos) {
            if (!dbo.partitioned || !dbo.hasLOBs) continue;
            TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, tableProxy.getName());
                rs = statement.executeQuery();
                if (rs == null) continue;
                while (rs.next()) {
                    String name = rs.getString("LOB_NAME");
                    String columnName = rs.getString("COLUMN_NAME");
                    int chunk = rs.getInt("DEF_CHUNK");
                    int pctVersion = rs.getInt("DEF_PCTVERSION");
                    String securefile = "";
                    if (storageDesign instanceof StorageDesignOraclev11g) {
                        securefile = rs.getString("DEF_SECUREFILE");
                    }
                    String cache = rs.getString("DEF_CACHE");
                    String inrow = rs.getString("DEF_IN_ROW");
                    String tsName = rs.getString("DEF_TABLESPACE_NAME");
                    String initial_extent = rs.getString("DEF_INITIAL_EXTENT");
                    String next_extent = rs.getString("DEF_NEXT_EXTENT");
                    String min_extents = rs.getString("DEF_MIN_EXTENTS");
                    String max_extents = rs.getString("DEF_MAX_EXTENTS");
                    String pctIncrease = rs.getString("DEF_PCT_INCREASE");
                    String free_lists = rs.getString("DEF_FREELISTS");
                    String freelist_groups = rs.getString("DEF_FREELIST_GROUPS");
                    String logging = rs.getString("DEF_LOGGING");
                    String bufferPool = rs.getString("DEF_BUFFER_POOL");
                    LobStorageOracle lobStorage = storageDesign.getLobStorageSet().createLobStorage();
                    lobStorage.setName(name);
                    lobStorage.setTable(tableProxy);
                    lobStorage.setColumn(columnName);
                    lobStorage.setChunk(chunk);
                    lobStorage.setPCTVersion(pctVersion);
                    if (lobStorage instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(securefile)) {
                        ((LobStorageOraclev11g)lobStorage).setLobStorageType("SECUREFILE");
                    }
                    if ("YES".equalsIgnoreCase(cache = cache.trim())) {
                        lobStorage.setCache("CACHE");
                    } else if ("CACHEREADS".equalsIgnoreCase(cache)) {
                        lobStorage.setCache("CACHE READS");
                    } else {
                        lobStorage.setCache("NOCACHE");
                    }
                    if ("YES".equalsIgnoreCase(inrow.trim())) {
                        lobStorage.setStorageInRow("ENABLE");
                    } else {
                        lobStorage.setStorageInRow("DISABLE");
                    }
                    if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                        TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                        lobStorage.setTableSpace(tableSpace);
                    }
                    if (initial_extent != null && lobStorage.getAppView().getSettings().isIncludeInitialExtentInDDL() && !"DEFAULT".equalsIgnoreCase(initial_extent.trim())) {
                        try {
                            long value = Long.parseLong(initial_extent.trim());
                            lobStorage.setSCInitialExtent(value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (next_extent != null && lobStorage.getAppView().getSettings().isIncludeNextExtentInDDL() && !"DEFAULT".equalsIgnoreCase(next_extent.trim())) {
                        try {
                            long value = Long.parseLong(next_extent.trim());
                            lobStorage.setSCNextExtent(value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (min_extents != null && lobStorage.getAppView().getSettings().isIncludeMinExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(min_extents.trim())) {
                        try {
                            int value = Integer.parseInt(min_extents.trim());
                            lobStorage.setSCMinExtents(value);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (max_extents != null && lobStorage.getAppView().getSettings().isIncludeMaxExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(max_extents.trim())) {
                        try {
                            int value = Integer.parseInt(max_extents.trim());
                            lobStorage.setSCMaxExtents(String.valueOf(value));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (pctIncrease != null && lobStorage.getAppView().getSettings().isIncludePctIncreaseInDDL() && !"DEFAULT".equalsIgnoreCase(pctIncrease.trim())) {
                        try {
                            int value = Integer.parseInt(pctIncrease.trim());
                            lobStorage.setSCPctIncrease(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (free_lists != null && lobStorage.getAppView().getSettings().isIncludeFreeListsInDDL() && !"DEFAULT".equalsIgnoreCase(free_lists.trim())) {
                        try {
                            int value = Integer.parseInt(free_lists.trim());
                            lobStorage.setSCFreeLists(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (freelist_groups != null && lobStorage.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && !"DEFAULT".equalsIgnoreCase(freelist_groups.trim())) {
                        try {
                            int value = Integer.parseInt(freelist_groups.trim());
                            lobStorage.setSCFreelistGroups(value);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (!"NONE".equalsIgnoreCase(logging = logging.trim())) {
                        if ("YES".equalsIgnoreCase(securefile) && "NO".equalsIgnoreCase(logging)) {
                            lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
                        } else {
                            lobStorage.setLogging(logging);
                        }
                    }
                    if (!lobStorage.getAppView().getSettings().isIncludeBufferPoolInDDL()) continue;
                    lobStorage.setSCBufferPool(bufferPool);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.setTablePartLobStorage():", e);
            }
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setPartitionLobStorage(AbstractStorageObjectOracle partition, TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, Connection sqlConnection) throws Exception {
        if (this.partLS_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("LOB_NAME").append(',');
            buffer.append("CHUNK").append(',');
            buffer.append("PCTVERSION").append(',');
            if (storageDesign instanceof StorageDesignOraclev11g) {
                buffer.append("SECUREFILE").append(',').append(' ');
            }
            buffer.append("CACHE").append(',');
            buffer.append("IN_ROW").append(',');
            buffer.append("TABLESPACE_NAME").append(',');
            buffer.append("INITIAL_EXTENT").append(',');
            buffer.append("NEXT_EXTENT").append(',');
            buffer.append("MIN_EXTENTS").append(',');
            buffer.append("MAX_EXTENTS").append(',');
            buffer.append("PCT_INCREASE").append(',');
            buffer.append("FREELISTS").append(',');
            buffer.append("FREELIST_GROUPS").append(',');
            buffer.append("LOGGING").append(',');
            buffer.append("BUFFER_POOL").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_lob_partitions" : "all_lob_partitions").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("PARTITION_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("LOB_NAME");
            String sql = buffer.toString();
            this.partLS_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.partLS_statement.setString(1, owner);
            this.partLS_statement.setString(2, tableProxy.getName());
            this.partLS_statement.setString(3, partition.getName());
            rs = this.partLS_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setPartitionLobStorage():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("LOB_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                int chunk = rs.getInt("CHUNK");
                int pctVersion = rs.getInt("PCTVERSION");
                String securefile = "";
                if (storageDesign instanceof StorageDesignOraclev11g) {
                    securefile = rs.getString("SECUREFILE");
                }
                String cache = rs.getString("CACHE");
                String inrow = rs.getString("IN_ROW");
                String tsName = rs.getString("TABLESPACE_NAME");
                String initial_extent = rs.getString("INITIAL_EXTENT");
                String next_extent = rs.getString("NEXT_EXTENT");
                String min_extents = rs.getString("MIN_EXTENTS");
                String max_extents = rs.getString("MAX_EXTENTS");
                String pctIncrease = rs.getString("PCT_INCREASE");
                String free_lists = rs.getString("FREELISTS");
                String freelist_groups = rs.getString("FREELIST_GROUPS");
                String logging = rs.getString("LOGGING");
                String bufferPool = rs.getString("BUFFER_POOL");
                if (partition instanceof HashPartitionOracle) {
                    HashPartitionLobItemOracle lobItem = storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                    lobItem.setName(name);
                    lobItem.setHashPartition((HashPartitionOracle)partition);
                    if (columnName != null && !"".equalsIgnoreCase(columnName)) {
                        ColumnProxy column = tableProxy.getColumnProxyByName(columnName);
                        lobItem.setLobColumn(column);
                    }
                    if (tsName == null || "".equalsIgnoreCase(tsName)) continue;
                    TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                    lobItem.setTableSpace(tableSpace);
                    continue;
                }
                LobStorageOracle lobStorage = storageDesign.getLobStorageSet().createLobStorage();
                lobStorage.setName(name);
                if (partition instanceof PartitionOracle) {
                    lobStorage.setPartition((PartitionOracle)partition);
                } else if (partition instanceof ListPartitionOracle) {
                    lobStorage.setListPartition((ListPartitionOracle)partition);
                }
                lobStorage.setColumn(columnName);
                lobStorage.setChunk(chunk);
                lobStorage.setPCTVersion(pctVersion);
                if (lobStorage instanceof LobStorageOraclev11g && "YES".equalsIgnoreCase(securefile)) {
                    ((LobStorageOraclev11g)lobStorage).setLobStorageType("SECUREFILE");
                }
                if ("YES".equalsIgnoreCase(cache = cache.trim())) {
                    lobStorage.setCache("CACHE");
                } else if ("CACHEREADS".equalsIgnoreCase(cache)) {
                    lobStorage.setCache("CACHE READS");
                } else {
                    lobStorage.setCache("NOCACHE");
                }
                if ("YES".equalsIgnoreCase(inrow.trim())) {
                    lobStorage.setStorageInRow("ENABLE");
                } else {
                    lobStorage.setStorageInRow("DISABLE");
                }
                if (tsName != null && !"".equalsIgnoreCase(tsName)) {
                    TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                    lobStorage.setTableSpace(tableSpace);
                }
                if (initial_extent != null && lobStorage.getAppView().getSettings().isIncludeInitialExtentInDDL() && !"DEFAULT".equalsIgnoreCase(initial_extent.trim())) {
                    try {
                        long value = Long.parseLong(initial_extent.trim());
                        lobStorage.setSCInitialExtent(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (next_extent != null && lobStorage.getAppView().getSettings().isIncludeNextExtentInDDL() && !"DEFAULT".equalsIgnoreCase(next_extent.trim())) {
                    try {
                        long value = Long.parseLong(next_extent.trim());
                        lobStorage.setSCNextExtent(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (min_extents != null && lobStorage.getAppView().getSettings().isIncludeMinExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(min_extents.trim())) {
                    try {
                        int value = Integer.parseInt(min_extents.trim());
                        lobStorage.setSCMinExtents(value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (max_extents != null && lobStorage.getAppView().getSettings().isIncludeMaxExtentsInDDL() && !"DEFAULT".equalsIgnoreCase(max_extents.trim())) {
                    try {
                        lobStorage.setSCMaxExtents(max_extents);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (pctIncrease != null && lobStorage.getAppView().getSettings().isIncludePctIncreaseInDDL() && !"DEFAULT".equalsIgnoreCase(pctIncrease.trim())) {
                    try {
                        int value = Integer.parseInt(pctIncrease.trim());
                        lobStorage.setSCPctIncrease(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (free_lists != null && lobStorage.getAppView().getSettings().isIncludeFreeListsInDDL() && !"DEFAULT".equalsIgnoreCase(free_lists.trim())) {
                    try {
                        int value = Integer.parseInt(free_lists.trim());
                        lobStorage.setSCFreeLists(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (freelist_groups != null && lobStorage.getAppView().getSettings().isIncludeFreeListGroupsInDDL() && !"DEFAULT".equalsIgnoreCase(freelist_groups.trim())) {
                    try {
                        int value = Integer.parseInt(freelist_groups.trim());
                        lobStorage.setSCFreelistGroups(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (!"NONE".equalsIgnoreCase(logging = logging.trim())) {
                    if ("YES".equalsIgnoreCase(securefile) && "NO".equalsIgnoreCase(logging)) {
                        lobStorage.setLogging("FILESYSTEM_LIKE_LOGGING");
                    } else {
                        lobStorage.setLogging(logging);
                    }
                }
                if (!lobStorage.getAppView().getSettings().isIncludeBufferPoolInDDL()) continue;
                lobStorage.setSCBufferPool(bufferPool);
            }
            rs.close();
        }
    }

    private void setSubPartitionLobStorage(AbstractStorageObjectOracle partition, TableProxyOracle tableProxy, String owner, StorageDesignOracle storageDesign, Connection sqlConnection) throws Exception {
        if (this.subPartLS_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',');
            buffer.append("LOB_NAME").append(',');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_lob_subpartitions" : "all_lob_subpartitions").append(' ');
            buffer.append("WHERE").append(' ').append("TABLE_OWNER").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("SUBPARTITION_NAME").append('=').append(' ').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("LOB_NAME");
            String sql = buffer.toString();
            this.subPartLS_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.subPartLS_statement.setString(1, owner);
            this.subPartLS_statement.setString(2, tableProxy.getName());
            this.subPartLS_statement.setString(3, partition.getName());
            rs = this.subPartLS_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.setSubPartitionLobStorage():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("LOB_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String tsName = rs.getString("TABLESPACE_NAME");
                HashPartitionLobItemOracle lobItem = storageDesign.getHashPartitionLobItemSet().createHashPartitionLobItem();
                lobItem.setName(name);
                if (partition instanceof HashPartitionOracle) {
                    lobItem.setHashPartition((HashPartitionOracle)partition);
                } else if (partition instanceof ListStorageTemplatePartitionOracle) {
                    lobItem.setListTemplatePartition((ListStorageTemplatePartitionOracle)partition);
                } else if (partition instanceof PartitionOracle) {
                    lobItem.setRangePartition((PartitionOracle)partition);
                }
                if (columnName != null && !"".equalsIgnoreCase(columnName)) {
                    ColumnProxy column = tableProxy.getColumnProxyByName(columnName);
                    lobItem.setLobColumn(column);
                }
                if (tsName == null || "".equalsIgnoreCase(tsName)) continue;
                TableSpaceOracle tableSpace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tsName);
                lobItem.setTableSpace(tableSpace);
            }
            rs.close();
        }
    }

    private Index getIndexForColumnNames(Table table, List names, Index notThis) {
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (inds[i] == notThis || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private void initTableTriggers(Connection sqlConnection, List dbos) throws Exception {
        ArrayList<TriggerOracle> up_list = new ArrayList<TriggerOracle>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ').append("OWNER").append(',').append(' ');
        buffer.append("TRIGGER_NAME").append(',').append(' ');
        buffer.append("TRIGGER_TYPE").append(',').append(' ');
        buffer.append("TRIGGERING_EVENT").append(',').append(' ');
        buffer.append("REFERENCING_NAMES").append(',').append(' ');
        buffer.append("WHEN_CLAUSE").append(',').append(' ');
        buffer.append("STATUS").append(',').append(' ');
        buffer.append("DESCRIPTION").append(',').append(' ');
        buffer.append("TRIGGER_BODY").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_triggers" : "all_triggers").append(' ');
        buffer.append("WHERE").append(' ').append("TABLE_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("TABLE_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        String sql = buffer.toString();
        Statement statement = null;
        for (DBObject dbo : dbos) {
            Table table = dbo.getTable();
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(sql);
                }
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
                if (rs == null) continue;
                StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                while (rs.next()) {
                    String trigOwner = rs.getString(1);
                    String trigName = rs.getString(2);
                    String type = rs.getString(3);
                    String event = rs.getString(4);
                    String refNames = rs.getString(5);
                    String whenClause = rs.getString(6);
                    String trBody = rs.getString(9);
                    TriggerOracle trigger = storage.getTriggerSet().createTrigger();
                    UserOracle user = (UserOracle)storage.getUserSet().getByName(trigOwner);
                    if (user == null) {
                        user = storage.getUserSet().createUser();
                        user.setName(trigOwner);
                        this.stampModelObject((ModelObject)user, "", trigOwner);
                    }
                    trigger.setOwner(user);
                    trigger.setName(trigName);
                    trigger.setTempTableOwner(dbo.getSchema());
                    if (!trigName.equals(trigName.toUpperCase())) {
                        trigger.setNameHasQuotes(true);
                    }
                    trigger.setTable(tableProxy);
                    this.stampModelObject((ModelObject)trigger, tableProxy, trigName);
                    if (type.indexOf("STATEMENT") > -1) {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[1]);
                    } else {
                        trigger.setScope(TriggerOracle.SCOPE_TYPES[0]);
                    }
                    if (type.indexOf("BEFORE") > -1) {
                        trigger.setTriggerTime("BEFORE");
                    } else {
                        trigger.setTriggerTime("AFTER");
                    }
                    if (event.indexOf("INSERT") > -1) {
                        trigger.setActions(Trigger.ACTION_TYPES[0]);
                    }
                    if (event.indexOf("UPDATE") > -1) {
                        trigger.setActions(Trigger.ACTION_TYPES[1]);
                        up_list.add(trigger);
                    }
                    if (event.indexOf("DELETE") > -1) {
                        trigger.setActions(Trigger.ACTION_TYPES[2]);
                    }
                    String newref = "NEW";
                    String oldref = "OLD";
                    String parentref = "PARENT";
                    if (refNames.indexOf(NEW_AS) > -1 && !"NEW".equalsIgnoreCase(newref = Token.getFirstToken(Token.getStringAfter(refNames, NEW_AS)))) {
                        trigger.setRef_NEW_AS(newref);
                    }
                    if (refNames.indexOf(OLD_AS) > -1 && !"OLD".equalsIgnoreCase(oldref = Token.getFirstToken(Token.getStringAfter(refNames, OLD_AS)))) {
                        trigger.setRef_OLD_AS(oldref);
                    }
                    if (refNames.indexOf(PARENT_AS) > -1 && !"PARENT".equalsIgnoreCase(parentref = Token.getFirstToken(Token.getStringAfter(refNames, PARENT_AS)))) {
                        trigger.setRef_PARENT_AS(parentref);
                    }
                    if (whenClause != null) {
                        trigger.setCondition(whenClause);
                    }
                    trigger.setBody(trBody);
                    if (trBody.indexOf(this.CWD_TS_TAB_META) > -1) {
                        this.initTriggerTypeSubstitution(table, trigger, trBody);
                        trigger.setCWDGenerated(true);
                    }
                    if (trBody.indexOf(this.CWD_TS_COLUMN_META) <= -1) continue;
                    this.initTriggerColumnTypeSubstitution(table, trigger, trBody);
                    trigger.setCWDGenerated(true);
                }
                rs.close();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.initTableTriggers():", e);
            }
        }
        if (statement != null) {
            statement.close();
        }
        if (up_list.size() > 0) {
            TimeLog.log("Trigger columns begin");
            buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("COLUMN_NAME").append(',').append(' ');
            buffer.append("COLUMN_LIST").append(',').append(' ');
            buffer.append("COLUMN_USAGE").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_trigger_cols" : "all_trigger_cols").append(' ');
            buffer.append("WHERE").append(" column_list = 'YES' AND table_owner = ? AND table_name = ? AND ").append(' ').append("TRIGGER_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
            buffer.append("AND").append(' ').append("TRIGGER_NAME").append(' ').append('=').append(' ').append('?').append(' ');
            String colsql = buffer.toString();
            PreparedStatement col_statement = sqlConnection.prepareStatement(colsql);
            for (TriggerOracle trigger : up_list) {
                this.initTriggerColumns(col_statement, trigger);
            }
            col_statement.close();
            TimeLog.log("Trigger columns end");
        }
    }

    private void initTriggerColumns(PreparedStatement pstatement, TriggerOracle trigger) throws Exception {
        ResultSet rs = null;
        try {
            pstatement.setString(1, trigger.getTempTableOwner());
            pstatement.setString(2, trigger.getTable().getName());
            pstatement.setString(3, trigger.getOwner().getName());
            pstatement.setString(4, trigger.getName());
            rs = pstatement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.initTriggerColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                TableProxyOracle table;
                ColumnProxy cp;
                String colName = rs.getString(1);
                String colList = rs.getString(2);
                if (!"YES".equalsIgnoreCase(colList) || (cp = (table = trigger.getTable()).getColumnProxyByName(colName)) == null) continue;
                trigger.setColumns(cp.getObjectID());
            }
            rs.close();
        }
    }

    private void initTriggerTypeSubstitution(Table table, TriggerOracle trigger, String trBody) {
        ArrayList<Temp> list = new ArrayList<Temp>();
        String body = trBody;
        int l = this.CWD_TS_TAB_META.length();
        int ind = body.indexOf(this.CWD_TS_TAB_META);
        try {
            while (ind > -1) {
                body = body.substring(ind + l);
                String tableName = Token.getFirstToken(Token.getStringAfter(body, "table="));
                String typeName = Token.getFirstToken(Token.getStringAfter(body, "type="));
                String parenTypeName = Token.getFirstToken(Token.getStringAfter(body, "parent_type="));
                Temp temp = new Temp();
                temp.tableName = Token.removeQuotes(tableName);
                temp.typeName = Token.removeQuotes(typeName);
                temp.parenTypeName = Token.removeQuotes(parenTypeName);
                list.add(temp);
                ind = body.indexOf(this.CWD_TS_TAB_META);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("MOHTableOracle.initTriggerTypeSubstitution():", e);
        }
        ArrayList<Temp> rlist = new ArrayList<Temp>();
        for (Temp temp : list) {
            Table tab = (Table)table.getDesign().getRelationalDesign().getTableSet().getByName(temp.tableName);
            if (tab != null) continue;
            StructuredType st = this.getStructuredType(temp.typeName, table.getDesign(), trigger.getStorageDesign());
            StructuredType stPar = this.getStructuredType(temp.parenTypeName, table.getDesign(), trigger.getStorageDesign());
            if (st == null || stPar == null) continue;
            temp.st = st;
            temp.stPar = stPar;
            rlist.add(temp);
        }
        this.createSubTables(table, rlist);
    }

    private void initTriggerColumnTypeSubstitution(Table table, Trigger trigger, String trBody) {
        ArrayList<Temp> list = new ArrayList<Temp>();
        String body = trBody;
        int l = this.CWD_TS_COLUMN_META.length();
        int ind = body.indexOf(this.CWD_TS_COLUMN_META);
        try {
            while (ind > -1) {
                body = body.substring(ind + l);
                String columnName = Token.getFirstToken(Token.getStringAfter(body, "column="));
                String typeName = Token.getFirstToken(Token.getStringAfter(body, "type="));
                Temp temp = new Temp();
                temp.tableName = Token.removeQuotes(columnName);
                temp.typeName = Token.removeQuotes(typeName);
                list.add(temp);
                ind = body.indexOf(this.CWD_TS_COLUMN_META);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("MOHTableOracle.initTriggerColumnTypeSubstitution():", e);
        }
        for (Temp temp : list) {
            StructuredType st;
            Column column = (Column)table.getElementByName(temp.tableName);
            if (column == null || (st = this.getStructuredType(temp.typeName, table.getDesign(), trigger.getStorageDesign())) == null) continue;
            List types = column.getPermittedSubTypes();
            if (!types.contains(st)) {
                types.add(st);
            }
            column.setAllowSubtypeSubstitution(true);
            column.setRestrictedTypeSubstitution(true);
        }
    }

    private void createSubTables(Table table, List list) {
        RelationalDesign pd = (RelationalDesign)table.getDesignPart();
        DesignPartView dpv = pd.getMainView();
        List subtypes = this.getElementsForType(table.getBasedOnStructuredType(), list);
        list.removeAll(subtypes);
        for (Temp temp : subtypes) {
            Table newTab = pd.createTable();
            newTab.setName(temp.tableName);
            newTab.setBasedOnStructuredType(temp.st);
            if (!temp.tableName.equals(temp.tableName.toUpperCase())) {
                newTab.setNameHasQuotes(true);
            }
            this.stampModelObject((ModelObject)newTab, table.getSchema(), temp.tableName);
            TypeSubstitution ts = pd.createTypeSubstitution();
            ts.setChildCV((ContainerView)newTab.getFirstViewForDPV(dpv));
            ts.setParentCV((ContainerView)table.getFirstViewForDPV(dpv));
            if (list.size() <= 0) continue;
            this.createSubTables(newTab, list);
        }
    }

    private List getElementsForType(StructuredType parent, List list) {
        ArrayList<Temp> elems = new ArrayList<Temp>();
        for (Temp temp : list) {
            if (temp.stPar != parent) continue;
            elems.add(temp);
        }
        return elems;
    }

    private StructuredType getStructuredType(String longName, Design design, StorageDesign sd) {
        int ind = longName.indexOf(46);
        if (ind > -1) {
            String user = longName.substring(0, ind);
            String name = longName.substring(ind + 1);
            StructuredTypeProxyOracle stp = ((StructuredTypeProxySetOracle)sd.getStructuredTypeProxySet()).getByLongName(name, user);
            if (stp != null) {
                return stp.getStructuredType();
            }
            return null;
        }
        return (StructuredType)design.getDataTypesDesign().getStructuredTypeSet().getByName(longName);
    }

    private void createFKeys(Connection sqlConnection, List fkTempList, Map ukMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("TABLE_NAME").append(',');
        buffer.append("COLUMN_NAME").append(',');
        buffer.append("POSITION").append(' ');
        buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_cons_columns" : "all_cons_columns").append(' ');
        buffer.append("WHERE").append(' ').append("OWNER").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("AND").append(' ').append("CONSTRAINT_NAME").append(' ').append('=').append(' ').append('?').append(' ');
        buffer.append("ORDER BY").append(' ').append("POSITION").append(',').append("COLUMN_NAME");
        String fk_sql = buffer.toString();
        Statement fk_statement = null;
        for (FKTemp fkt : fkTempList) {
            try {
                DesignObject ukMapObject = (DesignObject)ukMap.get(fkt.UK_Owner + fkt.UK_Name);
                KeyObject index = ukMapObject instanceof Table ? ((Table)ukMapObject).getPK() : (Index)ukMapObject;
                if (index == null) {
                    index = (Index)((RelationalDesign)fkt.table.getDesignPart()).getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                    RelationalDesign rd = ((RelationalDesign)fkt.table.getDesignPart()).getRelatedSyncModel();
                    if (index == null && rd != null) {
                        index = (Index)rd.getGlobalIndexSet().getBySchemaAndName(fkt.UK_Owner, fkt.UK_Name);
                    }
                    if (index == null) {
                        ResultSet fk_rs = null;
                        if (fk_statement == null) {
                            fk_statement = sqlConnection.prepareStatement(fk_sql);
                        }
                        fk_statement.setString(1, fkt.UK_Owner);
                        fk_statement.setString(2, fkt.UK_Name);
                        fk_rs = fk_statement.executeQuery();
                        String refTable = null;
                        ArrayList<String> refColumns = new ArrayList<String>();
                        if (fk_rs != null) {
                            while (fk_rs.next()) {
                                refTable = fk_rs.getString(1);
                                refColumns.add(fk_rs.getString(2));
                            }
                        }
                        if ((index = (Index)((RelationalDesign)fkt.table.getDesignPart()).getGlobalIndexSet().getByMatchingColumns(fkt.UK_Owner, refTable, refColumns)) == null && rd != null) {
                            index = (Index)rd.getGlobalIndexSet().getByMatchingColumns(fkt.UK_Owner, refTable, refColumns);
                        }
                    }
                }
                if (index == null) continue;
                FKIndexAssociation fk = fkt.table.addFK(index);
                fk.setName(fkt.name);
                this.stampModelObject((ModelObject)fk, fkt.table.getSchema(), fkt.name);
                Index localFKIndex = fk.getLocalFKIndex();
                localFKIndex.setName(fkt.name);
                if (!fkt.name.equals(fkt.name.toUpperCase())) {
                    localFKIndex.setNameHasQuotes(true);
                }
                fk.setDeleteRule(fkt.delete_rule);
                for (int i = 0; i < fkt.columns.size(); ++i) {
                    String colName = (String)fkt.columns.get(i);
                    Column column = (Column)fkt.table.getElementByName(colName);
                    Column refCol = null;
                    try {
                        refCol = (Column)index.getElement(i);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (column == null || refCol == null) continue;
                    column.addFKAssociation(refCol, fk);
                    localFKIndex.add(column);
                }
                fk.resetMandatoryUsingColumns();
                FKProxyOracle fkProxy = (FKProxyOracle)this.getStorageDesign().getStorageObject(localFKIndex.getObjectID());
                if (fkProxy == null) continue;
                if (fkt.status.equals("ENABLED")) {
                    fkProxy.setEnable("YES");
                } else {
                    fkProxy.setEnable("NO");
                }
                if (fkt.deferrable.equals("DEFERRABLE")) {
                    fkProxy.setDeferrable("YES");
                } else {
                    fkProxy.setDeferrable("NO");
                }
                if (fkt.deferred.equals("DEFERRED")) {
                    fkProxy.setInitially("DEFERRED");
                } else {
                    fkProxy.setInitially("IMMEDIATE");
                }
                if (fkt.validated.equals("VALIDATED")) {
                    fkProxy.setValidate("YES");
                    continue;
                }
                fkProxy.setValidate("NO");
                if (fkt.rely != null && fkt.rely.equals("RELY")) {
                    fkProxy.setRely("YES");
                    continue;
                }
                fkProxy.setRely("NO");
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOracle.createFKeys(): " + fkt.name, e);
            }
        }
        if (fk_statement != null) {
            try {
                fk_statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    private void addRedactionPolicies(Connection sqlConnection, List dbos) throws SQLException {
        if (this.getStorageDesign() instanceof StorageDesignOraclev11g) {
            Statement column_statement = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("OBJECT_OWNER").append(',');
            buffer.append("OBJECT_NAME").append(',');
            buffer.append("POLICY_NAME").append(',');
            buffer.append("EXPRESSION").append(',');
            buffer.append("ENABLE").append(' ');
            buffer.append("FROM").append(' ').append("REDACTION_POLICIES rp").append(' ');
            buffer.append("WHERE").append(' ').append("OBJECT_OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("OBJECT_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("NOT").append(' ').append("EXISTS").append(' ').append('(');
            buffer.append("SELECT").append(' ').append("1").append(' ').append("FROM").append(' ').append("DBA_TSDP_POLICY_PROTECTION").append(' ');
            buffer.append("WHERE").append(' ').append("security_feature_policy").append('=').append("rp.policy_name").append(')');
            String sql = buffer.toString();
            Statement statement = null;
            for (DBObject dbo : dbos) {
                Table table = dbo.getTable();
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        statement = sqlConnection.prepareStatement(sql);
                    }
                    statement.setString(1, dbo.getSchema());
                    statement.setString(2, table.getName());
                    try {
                        rs = statement.executeQuery();
                    }
                    catch (SQLSyntaxErrorException e) {
                        break;
                    }
                    if (rs == null) continue;
                    if (rs.next()) {
                        String policyName = rs.getString(3);
                        String expression = rs.getString(4);
                        String enabled = rs.getString(5);
                        table.setRedactionPolicyName(policyName.trim());
                        table.setRedactionPolicyDefaultExpression(expression);
                        if ("YES".equalsIgnoreCase(enabled.trim())) {
                            table.setRedactionPolicyEnabled(true);
                        } else {
                            table.setRedactionPolicyEnabled(false);
                        }
                        table.setRedactionPolicyGenerateInDDL(true);
                        if (column_statement == null) {
                            buffer = new StringBuffer();
                            buffer.append("SELECT").append(' ').append("OBJECT_OWNER").append(',').append(' ');
                            buffer.append("OBJECT_NAME").append(',').append(' ');
                            buffer.append("COLUMN_NAME").append(',').append(' ');
                            buffer.append("FUNCTION_TYPE").append(',').append(' ');
                            buffer.append("FUNCTION_PARAMETERS").append(',').append(' ');
                            buffer.append("REGEXP_PATTERN").append(',').append(' ');
                            buffer.append("REGEXP_REPLACE_STRING").append(',').append(' ');
                            buffer.append("REGEXP_POSITION").append(',').append(' ');
                            buffer.append("REGEXP_OCCURRENCE").append(',').append(' ');
                            buffer.append("REGEXP_MATCH_PARAMETER").append(' ');
                            buffer.append("FROM").append(' ').append("REDACTION_COLUMNS").append(' ');
                            buffer.append("WHERE").append(' ').append("OBJECT_OWNER").append(' ').append('=').append(' ').append('?').append(' ');
                            buffer.append("AND").append(' ').append("OBJECT_NAME").append(' ').append('=').append(' ').append('?').append(' ');
                            String csql = buffer.toString();
                            column_statement = sqlConnection.prepareStatement(csql);
                        }
                        this.addColumnRedactionPolicies((PreparedStatement)column_statement, table);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("MOHTableOracle.addRedactionPolicies():", e);
                }
            }
            if (column_statement != null) {
                column_statement.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void addColumnRedactionPolicies(PreparedStatement column_statement, Table table) throws SQLException {
        ResultSet rs = null;
        try {
            column_statement.setString(1, table.getSchema());
            column_statement.setString(2, table.getName());
            rs = column_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    MaskTemplate existingMT;
                    MaskTemplate mt;
                    String columnName = rs.getString(3);
                    String functionType = rs.getString(4);
                    String functionParameters = rs.getString(5);
                    String pattern = rs.getString(6);
                    String replaceString = rs.getString(7);
                    int position = rs.getInt(8);
                    int occurrence = rs.getInt(9);
                    String matchParameter = rs.getString(10);
                    Column column = (Column)table.getElementByName(columnName.trim());
                    if (column == null) continue;
                    if ((functionType = functionType.trim()).startsWith("FULL")) {
                        column.setMaskingType("FULL");
                        continue;
                    }
                    if (functionType.startsWith("NONE")) {
                        column.setMaskingType("TEST");
                        continue;
                    }
                    if (functionType.startsWith("PARTIAL")) {
                        column.setMaskingType("PARTIAL");
                        mt = new MaskTemplate(this.getDesign().getAppView());
                        mt.setFunctionType(0);
                        mt.setDataType(this.getMaskTemplateDataType(column.getDataTypeName()));
                        mt.parseFunctionParameters(functionParameters);
                        existingMT = this.getDesign().getAppView().getMaskTemplateSet().getEqual(mt);
                        if (existingMT != null) {
                            column.setMaskTemplate(existingMT);
                        } else {
                            this.getDesign().getAppView().getMaskTemplateSet().add(mt);
                            column.setMaskTemplate(mt);
                        }
                        this.maskTemplatesAdded = true;
                        continue;
                    }
                    if (functionType.startsWith("REGEXP")) {
                        column.setMaskingType("REGEXP");
                        mt = new MaskTemplate(this.getDesign().getAppView());
                        mt.setFunctionType(1);
                        if (pattern != null) {
                            mt.setPattern(pattern);
                        }
                        if (replaceString != null) {
                            mt.setReplaceString(replaceString);
                        }
                        mt.setPosition(position);
                        mt.setOccurrence(occurrence);
                        if (matchParameter != null) {
                            mt.setMatchParameter(matchParameter);
                        }
                        if ((existingMT = this.getDesign().getAppView().getMaskTemplateSet().getEqual(mt)) != null) {
                            column.setMaskTemplate(existingMT);
                        } else {
                            this.getDesign().getAppView().getMaskTemplateSet().add(mt);
                            column.setMaskTemplate(mt);
                        }
                        this.maskTemplatesAdded = true;
                        continue;
                    }
                    if (!functionType.startsWith("RANDOM")) continue;
                    column.setMaskingType("RANDOM");
                }
                rs.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOracle.addColumnRedactionPolicies():", e);
        }
    }

    private int getMaskTemplateDataType(String datatype) {
        if ("CHAR".equalsIgnoreCase(datatype) || "VARCHAR".equalsIgnoreCase(datatype) || "VARCHAR2".equalsIgnoreCase(datatype) || "NVARCHAR".equalsIgnoreCase(datatype) || "NVARCHAR2".equalsIgnoreCase(datatype)) {
            return 0;
        }
        if ("NUMBER".equalsIgnoreCase(datatype) || "INTEGER".equalsIgnoreCase(datatype)) {
            return 1;
        }
        if ("DATE".equalsIgnoreCase(datatype)) {
            return 2;
        }
        return 0;
    }

    static {
        SYSTEM_NAME_PREFIX = "SYS_";
        LOGGER = new Logger(MOHTableOracle.class);
    }

    class FKTemp {
        String name;
        String UK_Owner;
        String UK_Name;
        String delete_rule;
        List columns = new ArrayList();
        Table table;
        String status;
        String deferrable;
        String deferred;
        String validated;
        String rely;

        FKTemp() {
        }
    }

    class Temp {
        String tableName;
        String typeName;
        String parenTypeName;
        StructuredType st;
        StructuredType stPar;

        Temp() {
        }
    }

    private class SimpleColumn {
        private final String name;
        private final String sortOrder;

        public SimpleColumn(String name, String sortOrder) {
            this.name = name;
            this.sortOrder = sortOrder;
        }

        public String getName() {
            return this.name;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }
    }

    class ExprHelp {
        String expr;
        int col_pos;

        ExprHelp() {
        }
    }
}

