/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableSpaceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTableSpaceOracle.class);
    protected boolean dbaUser;

    public MOHTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("NOT").append(' ').append("IN").append(' ');
            buffer.append('(').append('\'');
            buffer.append("SYSTEM").append('\'').append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("CONTENTS").append(' ').append("<>").append(' ');
            buffer.append('\'').append("UNDO").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("NOT").append(' ').append('(');
            buffer.append("CONTENTS").append('=').append('\'');
            buffer.append("TEMPORARY").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
            buffer.append("LOCAL").append('\'').append(')').append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("TABLESPACE_NAME");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            System.out.println("MOHTableSpaceOracle.extract(): " + e.getMessage());
            LOGGER.error("MOHTableSpaceOracle.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tsName = rs.getString(1);
                DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tsName, OBJECT_TYPE);
                list.add(dboTs);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLESPACE_NAME").append(',');
                buffer.append("INITIAL_EXTENT").append(',');
                buffer.append("NEXT_EXTENT").append(',');
                buffer.append("MIN_EXTENTS").append(',');
                buffer.append("MAX_EXTENTS").append(',');
                buffer.append("PCT_INCREASE").append(',');
                buffer.append("MIN_EXTLEN").append(',');
                buffer.append("STATUS").append(',');
                buffer.append("CONTENTS").append(',');
                buffer.append("LOGGING").append(',');
                buffer.append("EXTENT_MANAGEMENT").append(',');
                buffer.append("ALLOCATION_TYPE");
                if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
                    buffer.append(',');
                    buffer.append("BIGFILE").append(',');
                    buffer.append("DEF_TAB_COMPRESSION");
                }
                buffer.append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("TABLESPACE_NAME").append('=').append(' ').append('?').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("CONTENTS").append(' ').append("<>").append(' ');
                buffer.append('\'').append("UNDO").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("NOT").append(' ').append('(');
                buffer.append("CONTENTS").append('=').append('\'');
                buffer.append("TEMPORARY").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
                buffer.append("LOCAL").append('\'').append(')').append(' ');
                buffer.append("ORDER BY").append(' ');
                buffer.append("TABLESPACE_NAME");
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dbo.getName());
                rs = statement.executeQuery();
                if (rs != null) {
                    if (rs.next()) {
                        StorageDesign storageDesign = this.getStorageDesign();
                        if (storageDesign instanceof StorageDesignOracle) {
                            TableSpaceOracle tableSpace = ((StorageDesignOracle)storageDesign).getTableSpaceSet().createTableSpace();
                            tableSpace.setName(dbo.getName());
                            this.setProperties(tableSpace, rs);
                            this.stampModelObject(tableSpace, dbo);
                        } else {
                            LOGGER.error("Unable to find Storage Design!");
                        }
                    }
                    rs.close();
                }
            }
            catch (Exception e) {
                System.out.println("MOHTableSpaceOracle.generate(): " + e.getMessage());
                LOGGER.error("MOHTableSpaceOracle.generate():", e);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setProperties(TableSpaceOracle tableSpace, ResultSet resultSet) throws Exception {
        long initialExtent = resultSet.getLong("INITIAL_EXTENT");
        long nextExtent = resultSet.getLong("NEXT_EXTENT");
        int minExtents = Integer.MAX_VALUE;
        int maxExtents = Integer.MAX_VALUE;
        try {
            minExtents = resultSet.getInt("MIN_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in min_extent", e);
        }
        try {
            maxExtents = resultSet.getInt("MAX_EXTENTS");
        }
        catch (Exception e) {
            LOGGER.error("error in max_extent", e);
        }
        int pctIncrease = resultSet.getInt("PCT_INCREASE");
        int minExtLen = resultSet.getInt("MIN_EXTLEN");
        String status = resultSet.getString("STATUS");
        String contents = resultSet.getString("CONTENTS");
        String logging = resultSet.getString("LOGGING");
        String extentManagement = resultSet.getString("EXTENT_MANAGEMENT");
        String allocationType = resultSet.getString("ALLOCATION_TYPE");
        tableSpace.setDSInitialExtent(initialExtent);
        tableSpace.setDSNextExtent(nextExtent);
        tableSpace.setDSMinExtents(minExtents);
        tableSpace.setDSMaxExtents(String.valueOf(maxExtents));
        tableSpace.setDSPctIncrease(pctIncrease);
        tableSpace.setMinExtLen(minExtLen);
        tableSpace.setStatus(status.trim());
        tableSpace.setContents(contents.trim());
        tableSpace.setLogging(logging.trim());
        tableSpace.setExtentManagement(extentManagement.trim());
        if ("UNIFORM".equalsIgnoreCase(allocationType.trim())) {
            tableSpace.setEMLocalSubtype("UNIFORM");
            try {
                tableSpace.setEMUniformSize(resultSet.getInt("NEXT_EXTENT"));
            }
            catch (Exception e) {
                LOGGER.error("error in next_extent", e);
            }
        }
        if (tableSpace instanceof TableSpaceOraclev10g) {
            TableSpaceOraclev10g tableSpacev10g = (TableSpaceOraclev10g)tableSpace;
            String bigfile = resultSet.getString("BIGFILE");
            if ("YES".equals(bigfile)) {
                tableSpacev10g.setFileType("BIGFILE");
            } else if ("NO".equals(bigfile)) {
                tableSpacev10g.setFileType("SMALLFILE");
            }
            String compression = resultSet.getString("DEF_TAB_COMPRESSION");
            if ("ENABLED".equals(compression)) {
                tableSpacev10g.setDSCompression("COMPRESS");
            } else if ("DISABLED".equals(compression)) {
                tableSpacev10g.setDSCompression("NOCOMPRESS");
            }
        }
    }
}

